# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server import util


class TapiTopologySignalPropertyRule(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, number_of_signal_values: int=None, applicable_signal_value: List[str]=None, signal_property_value_rule: str=None, signal_property_name: str=None):  # noqa: E501
        """TapiTopologySignalPropertyRule - a model defined in Swagger

        :param number_of_signal_values: The number_of_signal_values of this TapiTopologySignalPropertyRule.  # noqa: E501
        :type number_of_signal_values: int
        :param applicable_signal_value: The applicable_signal_value of this TapiTopologySignalPropertyRule.  # noqa: E501
        :type applicable_signal_value: List[str]
        :param signal_property_value_rule: The signal_property_value_rule of this TapiTopologySignalPropertyRule.  # noqa: E501
        :type signal_property_value_rule: str
        :param signal_property_name: The signal_property_name of this TapiTopologySignalPropertyRule.  # noqa: E501
        :type signal_property_name: str
        """
        self.swagger_types = {
            'number_of_signal_values': int,
            'applicable_signal_value': List[str],
            'signal_property_value_rule': str,
            'signal_property_name': str
        }

        self.attribute_map = {
            'number_of_signal_values': 'number-of-signal-values',
            'applicable_signal_value': 'applicable-signal-value',
            'signal_property_value_rule': 'signal-property-value-rule',
            'signal_property_name': 'signal-property-name'
        }
        self._number_of_signal_values = number_of_signal_values
        self._applicable_signal_value = applicable_signal_value
        self._signal_property_value_rule = signal_property_value_rule
        self._signal_property_name = signal_property_name

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologySignalPropertyRule':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.SignalPropertyRule of this TapiTopologySignalPropertyRule.  # noqa: E501
        :rtype: TapiTopologySignalPropertyRule
        """
        return util.deserialize_model(dikt, cls)

    @property
    def number_of_signal_values(self) -> int:
        """Gets the number_of_signal_values of this TapiTopologySignalPropertyRule.

        The number of instances of this specific property that can be supported by the group.  # noqa: E501

        :return: The number_of_signal_values of this TapiTopologySignalPropertyRule.
        :rtype: int
        """
        return self._number_of_signal_values

    @number_of_signal_values.setter
    def number_of_signal_values(self, number_of_signal_values: int):
        """Sets the number_of_signal_values of this TapiTopologySignalPropertyRule.

        The number of instances of this specific property that can be supported by the group.  # noqa: E501

        :param number_of_signal_values: The number_of_signal_values of this TapiTopologySignalPropertyRule.
        :type number_of_signal_values: int
        """

        self._number_of_signal_values = number_of_signal_values

    @property
    def applicable_signal_value(self) -> List[str]:
        """Gets the applicable_signal_value of this TapiTopologySignalPropertyRule.

        Specific values of the signal property to which the rule applies.  # noqa: E501

        :return: The applicable_signal_value of this TapiTopologySignalPropertyRule.
        :rtype: List[str]
        """
        return self._applicable_signal_value

    @applicable_signal_value.setter
    def applicable_signal_value(self, applicable_signal_value: List[str]):
        """Sets the applicable_signal_value of this TapiTopologySignalPropertyRule.

        Specific values of the signal property to which the rule applies.  # noqa: E501

        :param applicable_signal_value: The applicable_signal_value of this TapiTopologySignalPropertyRule.
        :type applicable_signal_value: List[str]
        """

        self._applicable_signal_value = applicable_signal_value

    @property
    def signal_property_value_rule(self) -> str:
        """Gets the signal_property_value_rule of this TapiTopologySignalPropertyRule.

        Indicates how the signal properties should be accounted for.  # noqa: E501

        :return: The signal_property_value_rule of this TapiTopologySignalPropertyRule.
        :rtype: str
        """
        return self._signal_property_value_rule

    @signal_property_value_rule.setter
    def signal_property_value_rule(self, signal_property_value_rule: str):
        """Sets the signal_property_value_rule of this TapiTopologySignalPropertyRule.

        Indicates how the signal properties should be accounted for.  # noqa: E501

        :param signal_property_value_rule: The signal_property_value_rule of this TapiTopologySignalPropertyRule.
        :type signal_property_value_rule: str
        """

        self._signal_property_value_rule = signal_property_value_rule

    @property
    def signal_property_name(self) -> str:
        """Gets the signal_property_name of this TapiTopologySignalPropertyRule.

        The name of the signal property to which the rule applies.  # noqa: E501

        :return: The signal_property_name of this TapiTopologySignalPropertyRule.
        :rtype: str
        """
        return self._signal_property_name

    @signal_property_name.setter
    def signal_property_name(self, signal_property_name: str):
        """Sets the signal_property_name of this TapiTopologySignalPropertyRule.

        The name of the signal property to which the rule applies.  # noqa: E501

        :param signal_property_name: The signal_property_name of this TapiTopologySignalPropertyRule.
        :type signal_property_name: str
        """

        self._signal_property_name = signal_property_name
