# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server import util


class TapiTopologyRiskCharacteristic(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, risk_characteristic_name: str=None, risk_identifier_list: List[str]=None):  # noqa: E501
        """TapiTopologyRiskCharacteristic - a model defined in Swagger

        :param risk_characteristic_name: The risk_characteristic_name of this TapiTopologyRiskCharacteristic.  # noqa: E501
        :type risk_characteristic_name: str
        :param risk_identifier_list: The risk_identifier_list of this TapiTopologyRiskCharacteristic.  # noqa: E501
        :type risk_identifier_list: List[str]
        """
        self.swagger_types = {
            'risk_characteristic_name': str,
            'risk_identifier_list': List[str]
        }

        self.attribute_map = {
            'risk_characteristic_name': 'risk-characteristic-name',
            'risk_identifier_list': 'risk-identifier-list'
        }
        self._risk_characteristic_name = risk_characteristic_name
        self._risk_identifier_list = risk_identifier_list

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyRiskCharacteristic':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.RiskCharacteristic of this TapiTopologyRiskCharacteristic.  # noqa: E501
        :rtype: TapiTopologyRiskCharacteristic
        """
        return util.deserialize_model(dikt, cls)

    @property
    def risk_characteristic_name(self) -> str:
        """Gets the risk_characteristic_name of this TapiTopologyRiskCharacteristic.

        The name of the risk characteristic. The characteristic may be related to a specific degree of closeness.                  For example a particular characteristic may apply to failures that are localized (e.g. to one side of a road) where as another characteristic may relate to failures that have a broader impact (e.g. both sides of a road that crosses a bridge).                  Depending upon the importance of the traffic being routed different risk characteristics will be evaluated.  # noqa: E501

        :return: The risk_characteristic_name of this TapiTopologyRiskCharacteristic.
        :rtype: str
        """
        return self._risk_characteristic_name

    @risk_characteristic_name.setter
    def risk_characteristic_name(self, risk_characteristic_name: str):
        """Sets the risk_characteristic_name of this TapiTopologyRiskCharacteristic.

        The name of the risk characteristic. The characteristic may be related to a specific degree of closeness.                  For example a particular characteristic may apply to failures that are localized (e.g. to one side of a road) where as another characteristic may relate to failures that have a broader impact (e.g. both sides of a road that crosses a bridge).                  Depending upon the importance of the traffic being routed different risk characteristics will be evaluated.  # noqa: E501

        :param risk_characteristic_name: The risk_characteristic_name of this TapiTopologyRiskCharacteristic.
        :type risk_characteristic_name: str
        """

        self._risk_characteristic_name = risk_characteristic_name

    @property
    def risk_identifier_list(self) -> List[str]:
        """Gets the risk_identifier_list of this TapiTopologyRiskCharacteristic.

        A list of the identifiers of each physical/geographic unit (with the specific risk characteristic) that is related to a segment of the TopologicalEntity.  # noqa: E501

        :return: The risk_identifier_list of this TapiTopologyRiskCharacteristic.
        :rtype: List[str]
        """
        return self._risk_identifier_list

    @risk_identifier_list.setter
    def risk_identifier_list(self, risk_identifier_list: List[str]):
        """Sets the risk_identifier_list of this TapiTopologyRiskCharacteristic.

        A list of the identifiers of each physical/geographic unit (with the specific risk characteristic) that is related to a segment of the TopologicalEntity.  # noqa: E501

        :param risk_identifier_list: The risk_identifier_list of this TapiTopologyRiskCharacteristic.
        :type risk_identifier_list: List[str]
        """

        self._risk_identifier_list = risk_identifier_list
