# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_local_class import TapiCommonLocalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_port_direction import TapiCommonPortDirection  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connection_end_point_ref import TapiConnectivityConnectionEndPointRef  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_route_ref import TapiConnectivityRouteRef  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_selection_control import TapiConnectivitySelectionControl  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_selection_reason import TapiConnectivitySelectionReason  # noqa: F401,E501
from tapi_server import util


class TapiConnectivitySwitch(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, local_id: str=None, selected_connection_end_point: List[TapiConnectivityConnectionEndPointRef]=None, selected_route: List[TapiConnectivityRouteRef]=None, selection_control: TapiConnectivitySelectionControl=None, selection_reason: TapiConnectivitySelectionReason=None, switch_direction: TapiCommonPortDirection=None):  # noqa: E501
        """TapiConnectivitySwitch - a model defined in Swagger

        :param name: The name of this TapiConnectivitySwitch.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param local_id: The local_id of this TapiConnectivitySwitch.  # noqa: E501
        :type local_id: str
        :param selected_connection_end_point: The selected_connection_end_point of this TapiConnectivitySwitch.  # noqa: E501
        :type selected_connection_end_point: List[TapiConnectivityConnectionEndPointRef]
        :param selected_route: The selected_route of this TapiConnectivitySwitch.  # noqa: E501
        :type selected_route: List[TapiConnectivityRouteRef]
        :param selection_control: The selection_control of this TapiConnectivitySwitch.  # noqa: E501
        :type selection_control: TapiConnectivitySelectionControl
        :param selection_reason: The selection_reason of this TapiConnectivitySwitch.  # noqa: E501
        :type selection_reason: TapiConnectivitySelectionReason
        :param switch_direction: The switch_direction of this TapiConnectivitySwitch.  # noqa: E501
        :type switch_direction: TapiCommonPortDirection
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'local_id': str,
            'selected_connection_end_point': List[TapiConnectivityConnectionEndPointRef],
            'selected_route': List[TapiConnectivityRouteRef],
            'selection_control': TapiConnectivitySelectionControl,
            'selection_reason': TapiConnectivitySelectionReason,
            'switch_direction': TapiCommonPortDirection
        }

        self.attribute_map = {
            'name': 'name',
            'local_id': 'local-id',
            'selected_connection_end_point': 'selected-connection-end-point',
            'selected_route': 'selected-route',
            'selection_control': 'selection-control',
            'selection_reason': 'selection-reason',
            'switch_direction': 'switch-direction'
        }
        self._name = name
        self._local_id = local_id
        self._selected_connection_end_point = selected_connection_end_point
        self._selected_route = selected_route
        self._selection_control = selection_control
        self._selection_reason = selection_reason
        self._switch_direction = switch_direction

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivitySwitch':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.Switch of this TapiConnectivitySwitch.  # noqa: E501
        :rtype: TapiConnectivitySwitch
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiConnectivitySwitch.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiConnectivitySwitch.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiConnectivitySwitch.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiConnectivitySwitch.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def local_id(self) -> str:
        """Gets the local_id of this TapiConnectivitySwitch.

        none  # noqa: E501

        :return: The local_id of this TapiConnectivitySwitch.
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id: str):
        """Sets the local_id of this TapiConnectivitySwitch.

        none  # noqa: E501

        :param local_id: The local_id of this TapiConnectivitySwitch.
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def selected_connection_end_point(self) -> List[TapiConnectivityConnectionEndPointRef]:
        """Gets the selected_connection_end_point of this TapiConnectivitySwitch.

        none  # noqa: E501

        :return: The selected_connection_end_point of this TapiConnectivitySwitch.
        :rtype: List[TapiConnectivityConnectionEndPointRef]
        """
        return self._selected_connection_end_point

    @selected_connection_end_point.setter
    def selected_connection_end_point(self, selected_connection_end_point: List[TapiConnectivityConnectionEndPointRef]):
        """Sets the selected_connection_end_point of this TapiConnectivitySwitch.

        none  # noqa: E501

        :param selected_connection_end_point: The selected_connection_end_point of this TapiConnectivitySwitch.
        :type selected_connection_end_point: List[TapiConnectivityConnectionEndPointRef]
        """

        self._selected_connection_end_point = selected_connection_end_point

    @property
    def selected_route(self) -> List[TapiConnectivityRouteRef]:
        """Gets the selected_route of this TapiConnectivitySwitch.

        none  # noqa: E501

        :return: The selected_route of this TapiConnectivitySwitch.
        :rtype: List[TapiConnectivityRouteRef]
        """
        return self._selected_route

    @selected_route.setter
    def selected_route(self, selected_route: List[TapiConnectivityRouteRef]):
        """Sets the selected_route of this TapiConnectivitySwitch.

        none  # noqa: E501

        :param selected_route: The selected_route of this TapiConnectivitySwitch.
        :type selected_route: List[TapiConnectivityRouteRef]
        """

        self._selected_route = selected_route

    @property
    def selection_control(self) -> TapiConnectivitySelectionControl:
        """Gets the selection_control of this TapiConnectivitySwitch.


        :return: The selection_control of this TapiConnectivitySwitch.
        :rtype: TapiConnectivitySelectionControl
        """
        return self._selection_control

    @selection_control.setter
    def selection_control(self, selection_control: TapiConnectivitySelectionControl):
        """Sets the selection_control of this TapiConnectivitySwitch.


        :param selection_control: The selection_control of this TapiConnectivitySwitch.
        :type selection_control: TapiConnectivitySelectionControl
        """

        self._selection_control = selection_control

    @property
    def selection_reason(self) -> TapiConnectivitySelectionReason:
        """Gets the selection_reason of this TapiConnectivitySwitch.


        :return: The selection_reason of this TapiConnectivitySwitch.
        :rtype: TapiConnectivitySelectionReason
        """
        return self._selection_reason

    @selection_reason.setter
    def selection_reason(self, selection_reason: TapiConnectivitySelectionReason):
        """Sets the selection_reason of this TapiConnectivitySwitch.


        :param selection_reason: The selection_reason of this TapiConnectivitySwitch.
        :type selection_reason: TapiConnectivitySelectionReason
        """

        self._selection_reason = selection_reason

    @property
    def switch_direction(self) -> TapiCommonPortDirection:
        """Gets the switch_direction of this TapiConnectivitySwitch.


        :return: The switch_direction of this TapiConnectivitySwitch.
        :rtype: TapiCommonPortDirection
        """
        return self._switch_direction

    @switch_direction.setter
    def switch_direction(self, switch_direction: TapiCommonPortDirection):
        """Sets the switch_direction of this TapiConnectivitySwitch.


        :param switch_direction: The switch_direction of this TapiConnectivitySwitch.
        :type switch_direction: TapiCommonPortDirection
        """

        self._switch_direction = switch_direction
