#!/bin/bash

# Delete old namespaces
kubectl delete namespace tfs-dom1 tfs-dom2 tfs-dom3 tfs-dom4

# Delete secondary ingress controllers
kubectl delete -f nfvsdn22/nginx-ingress-controller-dom1.yaml
kubectl delete -f nfvsdn22/nginx-ingress-controller-dom2.yaml
kubectl delete -f nfvsdn22/nginx-ingress-controller-dom3.yaml
kubectl delete -f nfvsdn22/nginx-ingress-controller-dom4.yaml

# Delete MockBlockchain
kubectl delete namespace tfs-bchain

# Create secondary ingress controllers
kubectl apply -f nfvsdn22/nginx-ingress-controller-dom1.yaml
kubectl apply -f nfvsdn22/nginx-ingress-controller-dom2.yaml
kubectl apply -f nfvsdn22/nginx-ingress-controller-dom3.yaml
kubectl apply -f nfvsdn22/nginx-ingress-controller-dom4.yaml

# Create MockBlockchain
./deploy_mock_blockchain.sh

# Deploy TFS for Domain 1
source nfvsdn22/deploy_specs_dom1.sh
./deploy.sh

# Deploy TFS for Domain 2
source nfvsdn22/deploy_specs_dom2.sh
./deploy.sh

# Deploy TFS for Domain 3
source nfvsdn22/deploy_specs_dom3.sh
./deploy.sh

# Deploy TFS for Domain 4
source nfvsdn22/deploy_specs_dom4.sh
./deploy.sh
