# 1.2. Install MicroK8s Kubernetes platform

This section describes how to deploy the MicroK8s Kubernetes platform and configure it to be used with ETSI TeraFlowSDN
controller. Besides, Docker is installed to build docker images for the ETSI TeraFlowSDN controller.

The steps described in this section might take some minutes depending on your internet connection speed and the
resources assigned to your VM, or the specifications of your physical server.


## 1.2.1. Upgrade the Ubuntu distribution
Skip this step if you already did it during the creation of the VM.
```bash
sudo apt-get update -y
sudo apt-get dist-upgrade -y
```


## 1.2.2. Install prerequisites
```bash
sudo apt-get install -y ca-certificates curl gnupg lsb-release snapd jq
```


## 1.2.3. Install Docker CE
Install Docker CE
```bash
sudo apt-get install -y docker.io
```

Add key "insecure-registries" with the private repository to the daemon configuration. It is done in two commands since
sometimes read from and write to same file might cause trouble.

```bash
if [ -s /etc/docker/daemon.json ]; then cat /etc/docker/daemon.json; else echo '{}'; fi \
    | jq 'if has("insecure-registries") then . else .+ {"insecure-registries": []} end' -- \
    | jq '."insecure-registries" |= (.+ ["localhost:32000"] | unique)' -- \
    | tee tmp.daemon.json
sudo mv tmp.daemon.json /etc/docker/daemon.json
sudo chown root:root /etc/docker/daemon.json
sudo chmod 600 /etc/docker/daemon.json
```

Restart the Docker daemon
```bash
sudo systemctl restart docker
```


## 1.2.4. Install MicroK8s
Ref: https://ubuntu.com/tutorials/install-a-local-kubernetes-with-microk8s
Ref: https://microk8s.io/#install-microk8s

```bash
# Install MicroK8s
sudo snap install microk8s --classic --channel=1.24/stable

# Create alias for command "microk8s.kubectl" to be usable as "kubectl"
sudo snap alias microk8s.kubectl kubectl

# Verify status of ufw firewall
sudo ufw status

# If ufw is active, install following rules to enable access pod-to-pod and pod-to-internet
sudo ufw allow in on cni0 && sudo ufw allow out on cni0
sudo ufw default allow routed
```


## 1.2.5. Add user to the docker and microk8s groups
```bash
sudo usermod -a -G docker $USER
sudo usermod -a -G microk8s $USER
sudo chown -f -R $USER $HOME/.kube
sudo reboot
```

In case that the .kube file is not automatically provisioned into your home folder, you may follow the steps below:

```bash
mkdir -p $HOME/.kube
sudo chown -f -R $USER $HOME/.kube
microk8s config > $HOME/.kube/config
sudo reboot
```

## 1.2.6. Check status of Kubernetes
```bash
microk8s.status --wait-ready
```


## 1.2.7. Check all resources in Kubernetes
```bash
microk8s.kubectl get all --all-namespaces
```


## 1.2.8. Enable addons
The Addons enabled are:
- `dns`: enables resolving the pods and services by name
- `hostpath-storage`: enables providing storage for the pods (required by `registry`)
- `ingress`: deploys an ingress controller to expose the microservices outside Kubernetes
- `registry`: deploys a private registry for the TFS controller images

```bash
microk8s.enable dns hostpath-storage ingress registry
```

__Note__: enabling some of the addons might take few minutes.
          [Check status](./1-2-install-microk8s.md#124-check-status-of-kubernetes) periodically until all addons are
          shown as enabled. Then [Check resources](./1-2-install-microk8s.md#125-check-all-resources-in-kubernetes)
          periodically until all pods are Ready and Running.


## 1.2.9. Stop, Restart, and Redeploy
Find below some additional commands you might need while you work with MicroK8s:
```bash
microk8s.stop  # stop MicroK8s cluster (for instance, before power off your computer)
microk8s.start # start MicroK8s cluster
microk8s.reset # reset infrastructure to a clean state
```

If the following commands does not work to recover the MicroK8s cluster, you can redeploy it.
First remove the current deployment as follows:
```bash
sudo snap remove microk8s
sudo apt-get remove --purge docker.io
```

Then, redeploy as it is described in this section.
