# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import otn
class label_step(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry/connectivity-matrices/label-restrictions/label-restriction/label-step. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The step increment between labels in the label range.
The label start/end values will have to be consistent
with the sign of label step.  For example,
'label-start' < 'label-end' enforces 'label-step' > 0
'label-start' > 'label-end' enforces 'label-step' < 0.
  """
  __slots__ = ('_path_helper', '_extmethods', '__generic','__otn','__eth_step',)

  _yang_name = 'label-step'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__generic = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32)(1), is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='int32', is_config=False)
    self.__otn = YANGDynClass(base=otn.otn, is_container='container', yang_name="otn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)
    self.__eth_step = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1), is_leaf=True, yang_name="eth-step", parent=self, choice=('technology', 'eth'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry', 'connectivity-matrices', 'label-restrictions', 'label-restriction', 'label-step']

  def _get_generic(self):
    """
    Getter method for generic, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/label_restrictions/label_restriction/label_step/generic (int32)

    YANG Description: Label range step.
    """
    return self.__generic
      
  def _set_generic(self, v, load=False):
    """
    Setter method for generic, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/label_restrictions/label_restriction/label_step/generic (int32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_generic is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_generic() directly.

    YANG Description: Label range step.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32)(1), is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='int32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """generic must be of a type compatible with int32""",
          'defined-type': "int32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32)(1), is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='int32', is_config=False)""",
        })

    self.__generic = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_generic(self):
    self.__generic = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32)(1), is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='int32', is_config=False)


  def _get_otn(self):
    """
    Getter method for otn, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/label_restrictions/label_restriction/label_step/otn (container)

    YANG Description: Label step for OTN
    """
    return self.__otn
      
  def _set_otn(self, v, load=False):
    """
    Setter method for otn, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/label_restrictions/label_restriction/label_step/otn (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_otn is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_otn() directly.

    YANG Description: Label step for OTN
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=otn.otn, is_container='container', yang_name="otn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """otn must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=otn.otn, is_container='container', yang_name="otn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)""",
        })

    self.__otn = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_otn(self):
    self.__otn = YANGDynClass(base=otn.otn, is_container='container', yang_name="otn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)


  def _get_eth_step(self):
    """
    Getter method for eth_step, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/label_restrictions/label_restriction/label_step/eth_step (uint16)

    YANG Description: Label step which represent possible increments for
an Ethernet VLAN tag.
    """
    return self.__eth_step
      
  def _set_eth_step(self, v, load=False):
    """
    Setter method for eth_step, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/label_restrictions/label_restriction/label_step/eth_step (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_eth_step is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_eth_step() directly.

    YANG Description: Label step which represent possible increments for
an Ethernet VLAN tag.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1), is_leaf=True, yang_name="eth-step", parent=self, choice=('technology', 'eth'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """eth_step must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1), is_leaf=True, yang_name="eth-step", parent=self, choice=('technology', 'eth'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint16', is_config=False)""",
        })

    self.__eth_step = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_eth_step(self):
    self.__eth_step = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1), is_leaf=True, yang_name="eth-step", parent=self, choice=('technology', 'eth'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint16', is_config=False)

  generic = __builtin__.property(_get_generic)
  otn = __builtin__.property(_get_otn)
  eth_step = __builtin__.property(_get_eth_step)

  __choices__ = {'technology': {'generic': ['generic'], 'otn': ['otn'], 'eth': ['eth_step']}}
  _pyangbind_elements = OrderedDict([('generic', generic), ('otn', otn), ('eth_step', eth_step), ])


