# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class bundled_link(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/bundled-links/bundled-link. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Specifies a bundled interface that is
further partitioned.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence','__src_tp_ref','__des_tp_ref',)

  _yang_name = 'bundled-link'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    self.__src_tp_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-tp-ref", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)
    self.__des_tp_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="des-tp-ref", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'bundled-links', 'bundled-link']

  def _get_sequence(self):
    """
    Getter method for sequence, mapped from YANG variable /networks/network/link/te/bundled_links/bundled_link/sequence (uint32)

    YANG Description: Identifies the sequence in the bundle.
    """
    return self.__sequence
      
  def _set_sequence(self, v, load=False):
    """
    Setter method for sequence, mapped from YANG variable /networks/network/link/te/bundled_links/bundled_link/sequence (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence() directly.

    YANG Description: Identifies the sequence in the bundle.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)""",
        })

    self.__sequence = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence(self):
    self.__sequence = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)


  def _get_src_tp_ref(self):
    """
    Getter method for src_tp_ref, mapped from YANG variable /networks/network/link/te/bundled_links/bundled_link/src_tp_ref (leafref)

    YANG Description: Reference to another TE termination point on the
same source node.
    """
    return self.__src_tp_ref
      
  def _set_src_tp_ref(self, v, load=False):
    """
    Setter method for src_tp_ref, mapped from YANG variable /networks/network/link/te/bundled_links/bundled_link/src_tp_ref (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_tp_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_tp_ref() directly.

    YANG Description: Reference to another TE termination point on the
same source node.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="src-tp-ref", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_tp_ref must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-tp-ref", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)""",
        })

    self.__src_tp_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_tp_ref(self):
    self.__src_tp_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-tp-ref", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)


  def _get_des_tp_ref(self):
    """
    Getter method for des_tp_ref, mapped from YANG variable /networks/network/link/te/bundled_links/bundled_link/des_tp_ref (leafref)

    YANG Description: Reference to another TE termination point on the
same destination node.
    """
    return self.__des_tp_ref
      
  def _set_des_tp_ref(self, v, load=False):
    """
    Setter method for des_tp_ref, mapped from YANG variable /networks/network/link/te/bundled_links/bundled_link/des_tp_ref (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_des_tp_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_des_tp_ref() directly.

    YANG Description: Reference to another TE termination point on the
same destination node.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="des-tp-ref", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """des_tp_ref must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="des-tp-ref", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)""",
        })

    self.__des_tp_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_des_tp_ref(self):
    self.__des_tp_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="des-tp-ref", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)

  sequence = __builtin__.property(_get_sequence, _set_sequence)
  src_tp_ref = __builtin__.property(_get_src_tp_ref, _set_src_tp_ref)
  des_tp_ref = __builtin__.property(_get_des_tp_ref, _set_des_tp_ref)

  __choices__ = {'bundle-stack-level': {'bundle': ['sequence', 'src_tp_ref', 'des_tp_ref']}}
  _pyangbind_elements = OrderedDict([('sequence', sequence), ('src_tp_ref', src_tp_ref), ('des_tp_ref', des_tp_ref), ])


