# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class supporting_node(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/supporting-node. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Represents another node that is in an underlay network
and that supports this node.  Used to represent layering
structure.
  """
  __slots__ = ('_path_helper', '_extmethods', '__network_ref','__node_ref',)

  _yang_name = 'supporting-node'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__network_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='leafref', is_config=True)
    self.__node_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="node-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'supporting-node']

  def _get_network_ref(self):
    """
    Getter method for network_ref, mapped from YANG variable /networks/network/node/supporting_node/network_ref (leafref)

    YANG Description: References the underlay network of which the
underlay node is a part.
    """
    return self.__network_ref
      
  def _set_network_ref(self, v, load=False):
    """
    Setter method for network_ref, mapped from YANG variable /networks/network/node/supporting_node/network_ref (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_network_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_network_ref() directly.

    YANG Description: References the underlay network of which the
underlay node is a part.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="network-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """network_ref must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='leafref', is_config=True)""",
        })

    self.__network_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_network_ref(self):
    self.__network_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='leafref', is_config=True)


  def _get_node_ref(self):
    """
    Getter method for node_ref, mapped from YANG variable /networks/network/node/supporting_node/node_ref (leafref)

    YANG Description: References the underlay node itself.
    """
    return self.__node_ref
      
  def _set_node_ref(self, v, load=False):
    """
    Setter method for node_ref, mapped from YANG variable /networks/network/node/supporting_node/node_ref (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_node_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_node_ref() directly.

    YANG Description: References the underlay node itself.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="node-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """node_ref must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="node-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='leafref', is_config=True)""",
        })

    self.__node_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_node_ref(self):
    self.__node_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="node-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='leafref', is_config=True)

  network_ref = __builtin__.property(_get_network_ref, _set_network_ref)
  node_ref = __builtin__.property(_get_node_ref, _set_node_ref)


  _pyangbind_elements = OrderedDict([('network_ref', network_ref), ('node_ref', node_ref), ])


