# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server import util


class TapiTopologyLatencyCharacteristic(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, traffic_property_name: str=None, jitter_characteristic: str=None, fixed_latency_characteristic: str=None, wander_characteristic: str=None, queing_latency_characteristic: str=None):  # noqa: E501
        """TapiTopologyLatencyCharacteristic - a model defined in Swagger

        :param traffic_property_name: The traffic_property_name of this TapiTopologyLatencyCharacteristic.  # noqa: E501
        :type traffic_property_name: str
        :param jitter_characteristic: The jitter_characteristic of this TapiTopologyLatencyCharacteristic.  # noqa: E501
        :type jitter_characteristic: str
        :param fixed_latency_characteristic: The fixed_latency_characteristic of this TapiTopologyLatencyCharacteristic.  # noqa: E501
        :type fixed_latency_characteristic: str
        :param wander_characteristic: The wander_characteristic of this TapiTopologyLatencyCharacteristic.  # noqa: E501
        :type wander_characteristic: str
        :param queing_latency_characteristic: The queing_latency_characteristic of this TapiTopologyLatencyCharacteristic.  # noqa: E501
        :type queing_latency_characteristic: str
        """
        self.swagger_types = {
            'traffic_property_name': str,
            'jitter_characteristic': str,
            'fixed_latency_characteristic': str,
            'wander_characteristic': str,
            'queing_latency_characteristic': str
        }

        self.attribute_map = {
            'traffic_property_name': 'traffic-property-name',
            'jitter_characteristic': 'jitter-characteristic',
            'fixed_latency_characteristic': 'fixed-latency-characteristic',
            'wander_characteristic': 'wander-characteristic',
            'queing_latency_characteristic': 'queing-latency-characteristic'
        }
        self._traffic_property_name = traffic_property_name
        self._jitter_characteristic = jitter_characteristic
        self._fixed_latency_characteristic = fixed_latency_characteristic
        self._wander_characteristic = wander_characteristic
        self._queing_latency_characteristic = queing_latency_characteristic

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyLatencyCharacteristic':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.LatencyCharacteristic of this TapiTopologyLatencyCharacteristic.  # noqa: E501
        :rtype: TapiTopologyLatencyCharacteristic
        """
        return util.deserialize_model(dikt, cls)

    @property
    def traffic_property_name(self) -> str:
        """Gets the traffic_property_name of this TapiTopologyLatencyCharacteristic.

        The identifier of the specific traffic property to which the queuing latency applies.  # noqa: E501

        :return: The traffic_property_name of this TapiTopologyLatencyCharacteristic.
        :rtype: str
        """
        return self._traffic_property_name

    @traffic_property_name.setter
    def traffic_property_name(self, traffic_property_name: str):
        """Sets the traffic_property_name of this TapiTopologyLatencyCharacteristic.

        The identifier of the specific traffic property to which the queuing latency applies.  # noqa: E501

        :param traffic_property_name: The traffic_property_name of this TapiTopologyLatencyCharacteristic.
        :type traffic_property_name: str
        """

        self._traffic_property_name = traffic_property_name

    @property
    def jitter_characteristic(self) -> str:
        """Gets the jitter_characteristic of this TapiTopologyLatencyCharacteristic.

        High frequency deviation from true periodicity of a signal and therefore a small high rate of change of transfer latency.                  Applies to TDM systems (and not packet).  # noqa: E501

        :return: The jitter_characteristic of this TapiTopologyLatencyCharacteristic.
        :rtype: str
        """
        return self._jitter_characteristic

    @jitter_characteristic.setter
    def jitter_characteristic(self, jitter_characteristic: str):
        """Sets the jitter_characteristic of this TapiTopologyLatencyCharacteristic.

        High frequency deviation from true periodicity of a signal and therefore a small high rate of change of transfer latency.                  Applies to TDM systems (and not packet).  # noqa: E501

        :param jitter_characteristic: The jitter_characteristic of this TapiTopologyLatencyCharacteristic.
        :type jitter_characteristic: str
        """

        self._jitter_characteristic = jitter_characteristic

    @property
    def fixed_latency_characteristic(self) -> str:
        """Gets the fixed_latency_characteristic of this TapiTopologyLatencyCharacteristic.

        A TopologicalEntity suffers delay caused by the realization of the servers (e.g. distance related; FEC encoding etc.) along with some client specific processing. This is the total average latency effect of the TopologicalEntity  # noqa: E501

        :return: The fixed_latency_characteristic of this TapiTopologyLatencyCharacteristic.
        :rtype: str
        """
        return self._fixed_latency_characteristic

    @fixed_latency_characteristic.setter
    def fixed_latency_characteristic(self, fixed_latency_characteristic: str):
        """Sets the fixed_latency_characteristic of this TapiTopologyLatencyCharacteristic.

        A TopologicalEntity suffers delay caused by the realization of the servers (e.g. distance related; FEC encoding etc.) along with some client specific processing. This is the total average latency effect of the TopologicalEntity  # noqa: E501

        :param fixed_latency_characteristic: The fixed_latency_characteristic of this TapiTopologyLatencyCharacteristic.
        :type fixed_latency_characteristic: str
        """

        self._fixed_latency_characteristic = fixed_latency_characteristic

    @property
    def wander_characteristic(self) -> str:
        """Gets the wander_characteristic of this TapiTopologyLatencyCharacteristic.

        Low frequency deviation from true periodicity of a signal and therefore a small low rate of change of transfer latency.                  Applies to TDM systems (and not packet).  # noqa: E501

        :return: The wander_characteristic of this TapiTopologyLatencyCharacteristic.
        :rtype: str
        """
        return self._wander_characteristic

    @wander_characteristic.setter
    def wander_characteristic(self, wander_characteristic: str):
        """Sets the wander_characteristic of this TapiTopologyLatencyCharacteristic.

        Low frequency deviation from true periodicity of a signal and therefore a small low rate of change of transfer latency.                  Applies to TDM systems (and not packet).  # noqa: E501

        :param wander_characteristic: The wander_characteristic of this TapiTopologyLatencyCharacteristic.
        :type wander_characteristic: str
        """

        self._wander_characteristic = wander_characteristic

    @property
    def queing_latency_characteristic(self) -> str:
        """Gets the queing_latency_characteristic of this TapiTopologyLatencyCharacteristic.

        The specific queuing latency for the traffic property.  # noqa: E501

        :return: The queing_latency_characteristic of this TapiTopologyLatencyCharacteristic.
        :rtype: str
        """
        return self._queing_latency_characteristic

    @queing_latency_characteristic.setter
    def queing_latency_characteristic(self, queing_latency_characteristic: str):
        """Sets the queing_latency_characteristic of this TapiTopologyLatencyCharacteristic.

        The specific queuing latency for the traffic property.  # noqa: E501

        :param queing_latency_characteristic: The queing_latency_characteristic of this TapiTopologyLatencyCharacteristic.
        :type queing_latency_characteristic: str
        """

        self._queing_latency_characteristic = queing_latency_characteristic
