# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_notification_perceived_tca_severity import TapiNotificationPerceivedTcaSeverity  # noqa: F401,E501
from tapi_server.models.tapi_notification_threshold_crossing_type import TapiNotificationThresholdCrossingType  # noqa: F401,E501
from tapi_server import util


class TapiNotificationTcaInfo(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, threshold_crossing: TapiNotificationThresholdCrossingType=None, threshold_parameter: str=None, is_transient: bool=False, threshold_value: int=None, perceived_severity: TapiNotificationPerceivedTcaSeverity=None, suspect_interval_flag: bool=False, measurement_interval: str=None):  # noqa: E501
        """TapiNotificationTcaInfo - a model defined in Swagger

        :param threshold_crossing: The threshold_crossing of this TapiNotificationTcaInfo.  # noqa: E501
        :type threshold_crossing: TapiNotificationThresholdCrossingType
        :param threshold_parameter: The threshold_parameter of this TapiNotificationTcaInfo.  # noqa: E501
        :type threshold_parameter: str
        :param is_transient: The is_transient of this TapiNotificationTcaInfo.  # noqa: E501
        :type is_transient: bool
        :param threshold_value: The threshold_value of this TapiNotificationTcaInfo.  # noqa: E501
        :type threshold_value: int
        :param perceived_severity: The perceived_severity of this TapiNotificationTcaInfo.  # noqa: E501
        :type perceived_severity: TapiNotificationPerceivedTcaSeverity
        :param suspect_interval_flag: The suspect_interval_flag of this TapiNotificationTcaInfo.  # noqa: E501
        :type suspect_interval_flag: bool
        :param measurement_interval: The measurement_interval of this TapiNotificationTcaInfo.  # noqa: E501
        :type measurement_interval: str
        """
        self.swagger_types = {
            'threshold_crossing': TapiNotificationThresholdCrossingType,
            'threshold_parameter': str,
            'is_transient': bool,
            'threshold_value': int,
            'perceived_severity': TapiNotificationPerceivedTcaSeverity,
            'suspect_interval_flag': bool,
            'measurement_interval': str
        }

        self.attribute_map = {
            'threshold_crossing': 'threshold-crossing',
            'threshold_parameter': 'threshold-parameter',
            'is_transient': 'is-transient',
            'threshold_value': 'threshold-value',
            'perceived_severity': 'perceived-severity',
            'suspect_interval_flag': 'suspect-interval-flag',
            'measurement_interval': 'measurement-interval'
        }
        self._threshold_crossing = threshold_crossing
        self._threshold_parameter = threshold_parameter
        self._is_transient = is_transient
        self._threshold_value = threshold_value
        self._perceived_severity = perceived_severity
        self._suspect_interval_flag = suspect_interval_flag
        self._measurement_interval = measurement_interval

    @classmethod
    def from_dict(cls, dikt) -> 'TapiNotificationTcaInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.notification.TcaInfo of this TapiNotificationTcaInfo.  # noqa: E501
        :rtype: TapiNotificationTcaInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def threshold_crossing(self) -> TapiNotificationThresholdCrossingType:
        """Gets the threshold_crossing of this TapiNotificationTcaInfo.


        :return: The threshold_crossing of this TapiNotificationTcaInfo.
        :rtype: TapiNotificationThresholdCrossingType
        """
        return self._threshold_crossing

    @threshold_crossing.setter
    def threshold_crossing(self, threshold_crossing: TapiNotificationThresholdCrossingType):
        """Sets the threshold_crossing of this TapiNotificationTcaInfo.


        :param threshold_crossing: The threshold_crossing of this TapiNotificationTcaInfo.
        :type threshold_crossing: TapiNotificationThresholdCrossingType
        """

        self._threshold_crossing = threshold_crossing

    @property
    def threshold_parameter(self) -> str:
        """Gets the threshold_parameter of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :return: The threshold_parameter of this TapiNotificationTcaInfo.
        :rtype: str
        """
        return self._threshold_parameter

    @threshold_parameter.setter
    def threshold_parameter(self, threshold_parameter: str):
        """Sets the threshold_parameter of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :param threshold_parameter: The threshold_parameter of this TapiNotificationTcaInfo.
        :type threshold_parameter: str
        """

        self._threshold_parameter = threshold_parameter

    @property
    def is_transient(self) -> bool:
        """Gets the is_transient of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :return: The is_transient of this TapiNotificationTcaInfo.
        :rtype: bool
        """
        return self._is_transient

    @is_transient.setter
    def is_transient(self, is_transient: bool):
        """Sets the is_transient of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :param is_transient: The is_transient of this TapiNotificationTcaInfo.
        :type is_transient: bool
        """

        self._is_transient = is_transient

    @property
    def threshold_value(self) -> int:
        """Gets the threshold_value of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :return: The threshold_value of this TapiNotificationTcaInfo.
        :rtype: int
        """
        return self._threshold_value

    @threshold_value.setter
    def threshold_value(self, threshold_value: int):
        """Sets the threshold_value of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :param threshold_value: The threshold_value of this TapiNotificationTcaInfo.
        :type threshold_value: int
        """

        self._threshold_value = threshold_value

    @property
    def perceived_severity(self) -> TapiNotificationPerceivedTcaSeverity:
        """Gets the perceived_severity of this TapiNotificationTcaInfo.


        :return: The perceived_severity of this TapiNotificationTcaInfo.
        :rtype: TapiNotificationPerceivedTcaSeverity
        """
        return self._perceived_severity

    @perceived_severity.setter
    def perceived_severity(self, perceived_severity: TapiNotificationPerceivedTcaSeverity):
        """Sets the perceived_severity of this TapiNotificationTcaInfo.


        :param perceived_severity: The perceived_severity of this TapiNotificationTcaInfo.
        :type perceived_severity: TapiNotificationPerceivedTcaSeverity
        """

        self._perceived_severity = perceived_severity

    @property
    def suspect_interval_flag(self) -> bool:
        """Gets the suspect_interval_flag of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :return: The suspect_interval_flag of this TapiNotificationTcaInfo.
        :rtype: bool
        """
        return self._suspect_interval_flag

    @suspect_interval_flag.setter
    def suspect_interval_flag(self, suspect_interval_flag: bool):
        """Sets the suspect_interval_flag of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :param suspect_interval_flag: The suspect_interval_flag of this TapiNotificationTcaInfo.
        :type suspect_interval_flag: bool
        """

        self._suspect_interval_flag = suspect_interval_flag

    @property
    def measurement_interval(self) -> str:
        """Gets the measurement_interval of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :return: The measurement_interval of this TapiNotificationTcaInfo.
        :rtype: str
        """
        return self._measurement_interval

    @measurement_interval.setter
    def measurement_interval(self, measurement_interval: str):
        """Sets the measurement_interval of this TapiNotificationTcaInfo.

        none  # noqa: E501

        :param measurement_interval: The measurement_interval of this TapiNotificationTcaInfo.
        :type measurement_interval: str
        """

        self._measurement_interval = measurement_interval
