# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class numbered_link_hop(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities/local-link-connectivity/underlay/primary-path/path-element/numbered-link-hop. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Numbered link explicit route hop.
  """
  __slots__ = ('_path_helper', '_extmethods', '__link_tp_id','__hop_type','__direction',)

  _yang_name = 'numbered-link-hop'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__link_tp_id = YANGDynClass(base=[RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),], is_leaf=True, yang_name="link-tp-id", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-tp-id', is_config=True)
    self.__hop_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=True)
    self.__direction = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'incoming': {}, 'outgoing': {}},), default=six.text_type("outgoing"), is_leaf=True, yang_name="direction", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-link-direction', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities', 'local-link-connectivity', 'underlay', 'primary-path', 'path-element', 'numbered-link-hop']

  def _get_link_tp_id(self):
    """
    Getter method for link_tp_id, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/underlay/primary_path/path_element/numbered_link_hop/link_tp_id (te-tp-id)

    YANG Description: TE Link Termination Point (LTP) identifier.
    """
    return self.__link_tp_id
      
  def _set_link_tp_id(self, v, load=False):
    """
    Setter method for link_tp_id, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/underlay/primary_path/path_element/numbered_link_hop/link_tp_id (te-tp-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_tp_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_tp_id() directly.

    YANG Description: TE Link Termination Point (LTP) identifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),], is_leaf=True, yang_name="link-tp-id", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-tp-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_tp_id must be of a type compatible with te-tp-id""",
          'defined-type': "ietf-te-topology:te-tp-id",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),], is_leaf=True, yang_name="link-tp-id", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-tp-id', is_config=True)""",
        })

    self.__link_tp_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_tp_id(self):
    self.__link_tp_id = YANGDynClass(base=[RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),], is_leaf=True, yang_name="link-tp-id", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-tp-id', is_config=True)


  def _get_hop_type(self):
    """
    Getter method for hop_type, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/underlay/primary_path/path_element/numbered_link_hop/hop_type (te-hop-type)

    YANG Description: Strict or loose hop.
    """
    return self.__hop_type
      
  def _set_hop_type(self, v, load=False):
    """
    Setter method for hop_type, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/underlay/primary_path/path_element/numbered_link_hop/hop_type (te-hop-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_type() directly.

    YANG Description: Strict or loose hop.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_type must be of a type compatible with te-hop-type""",
          'defined-type': "ietf-te-topology:te-hop-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=True)""",
        })

    self.__hop_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_type(self):
    self.__hop_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=True)


  def _get_direction(self):
    """
    Getter method for direction, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/underlay/primary_path/path_element/numbered_link_hop/direction (te-link-direction)

    YANG Description: Link route object direction.
    """
    return self.__direction
      
  def _set_direction(self, v, load=False):
    """
    Setter method for direction, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/underlay/primary_path/path_element/numbered_link_hop/direction (te-link-direction)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_direction is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_direction() directly.

    YANG Description: Link route object direction.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'incoming': {}, 'outgoing': {}},), default=six.text_type("outgoing"), is_leaf=True, yang_name="direction", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-link-direction', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """direction must be of a type compatible with te-link-direction""",
          'defined-type': "ietf-te-topology:te-link-direction",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'incoming': {}, 'outgoing': {}},), default=six.text_type("outgoing"), is_leaf=True, yang_name="direction", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-link-direction', is_config=True)""",
        })

    self.__direction = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_direction(self):
    self.__direction = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'incoming': {}, 'outgoing': {}},), default=six.text_type("outgoing"), is_leaf=True, yang_name="direction", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-link-direction', is_config=True)

  link_tp_id = __builtin__.property(_get_link_tp_id, _set_link_tp_id)
  hop_type = __builtin__.property(_get_hop_type, _set_hop_type)
  direction = __builtin__.property(_get_direction, _set_direction)

  __choices__ = {'type': {'numbered-link-hop': ['link_tp_id', 'hop_type', 'direction']}}
  _pyangbind_elements = OrderedDict([('link_tp_id', link_tp_id), ('hop_type', hop_type), ('direction', direction), ])


