# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import path_affinities_value
class path_affinities_values(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry/connectivity-matrices/connectivity-matrix/path-properties/path-affinities-values. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Path affinities represented as values.
  """
  __slots__ = ('_path_helper', '_extmethods', '__path_affinities_value',)

  _yang_name = 'path-affinities-values'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__path_affinities_value = YANGDynClass(base=YANGListType("usage",path_affinities_value.path_affinities_value, yang_name="path-affinities-value", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='usage', extensions=None), is_container='list', yang_name="path-affinities-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry', 'connectivity-matrices', 'connectivity-matrix', 'path-properties', 'path-affinities-values']

  def _get_path_affinities_value(self):
    """
    Getter method for path_affinities_value, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/path_properties/path_affinities_values/path_affinities_value (list)

    YANG Description: List of named affinity constraints.
    """
    return self.__path_affinities_value
      
  def _set_path_affinities_value(self, v, load=False):
    """
    Setter method for path_affinities_value, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/path_properties/path_affinities_values/path_affinities_value (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_affinities_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_affinities_value() directly.

    YANG Description: List of named affinity constraints.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("usage",path_affinities_value.path_affinities_value, yang_name="path-affinities-value", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='usage', extensions=None), is_container='list', yang_name="path-affinities-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_affinities_value must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("usage",path_affinities_value.path_affinities_value, yang_name="path-affinities-value", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='usage', extensions=None), is_container='list', yang_name="path-affinities-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)""",
        })

    self.__path_affinities_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_affinities_value(self):
    self.__path_affinities_value = YANGDynClass(base=YANGListType("usage",path_affinities_value.path_affinities_value, yang_name="path-affinities-value", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='usage', extensions=None), is_container='list', yang_name="path-affinities-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

  path_affinities_value = __builtin__.property(_get_path_affinities_value)


  _pyangbind_elements = OrderedDict([('path_affinities_value', path_affinities_value), ])


