# 2.4. ECOC'22 Demo - Disjoint DC-2-DC L3VPN Service (WORK IN PROGRESS)

This functional test reproduces the experimental assessment of "Experimental Demonstration of Transport Network Slicing
with SLA Using the TeraFlowSDN Controller" presented at [ECOC'22](https://www.ecoc2022.org/).

## 2.4.1. Functional test folder

This functional test can be found in folder `./src/tests/ecoc22/`. A convenience alias `./ecoc22/` pointing to that
folder has been defined.

## 2.4.2. Execute with real devices

This functional test has only been tested with emulated devices; however, if you have access to real devices, you can
modify the files `./ecoc22/tests/Objects.py` and `./ecoc22/tests/Credentials.py` to point to your devices, and map to
your network topology.

__Important__: The device drivers operating with real devices, e.g., OpenConfigDriver, P4Driver, and TransportApiDriver,
               have to be considered as experimental. The configuration and monitoring capabilities they support are
               limited or partially implemented/tested. Use them with care.


## 2.4.3. Deployment and Dependencies

To run this functional test, it is assumed you have deployed a MicroK8s-based Kubernetes environment and a TeraFlowSDN
controller instance as described in the [Tutorial: Deployment Guide](./1-0-deployment.md), and you configured the
Python environment as described in
[Tutorial: Run Experiments Guide > 2.1. Configure Python Environment](./2-1-python-environment.md).
Remember to source the scenario settings appropriately, e.g., `cd ~/tfs-ctrl && source my_deploy.sh` in each terminal
you open.


## 2.4.4. Access to the WebUI and Dashboard

When the deployment completes, you can connect to the TeraFlowSDN WebUI and Dashboards as described in
[Tutorial: Deployment Guide > 1.4. Access TeraFlowSDN WebUI and Grafana Dashboards](./1-4-access-webui.md)

Notes:
- the default credentials for the Grafana Dashboiard is user/pass: `admin`/`admin123+`.
- this functional test does not involve the Monitoring component, so no monitoring data is plotted in Grafana.


## 2.4.5. Test execution

To execute this functional test, four main steps needs to be carried out:
1. Device bootstrapping
2. L3VPN Service creation
3. L3VPN Service removal
4. Cleanup

Upon the execution of each test progresses, a report will be generated indicating PASSED / FAILED / SKIPPED. If there
is some error during the execution, you should see a detailed report on the error. See the troubleshooting section if
needed.

You can check the logs of the different components using the appropriate `scripts/show_logs_[component].sh` scripts
after you execute each step.


### 2.4.5.1. Device bootstrapping

This step configures some basic entities (Context and Topology), the devices, and the links in the topology. The
expected results are:
- The devices to be added into the Topology.
- The devices to be pre-configured and initialized as ENABLED by the Automation component.
- The monitoring for the device ports (named as endpoints in TeraFlowSDN) to be activated and data collection to
automatically start.
- The links to be added to the topology.

To run this step, you can do it from the WebUI by uploading the file `./ecoc22/tests/descriptors_emulated.json` that
contains the descriptors of the contexts, topologies, devices, and links, or by executing the
`./ecoc22/run_test_01_bootstrap.sh` script.

When the bootstrapping finishes, check in the Grafana L3-Monitoring Dashboard and you should see the monitoring data
being plotted and updated every 5 seconds (by default). Given that there is no service configured, you should see a
0-valued flat plot.

In the WebUI, select the "admin" Context. Then, in the "Devices" tab you should see that 5 different emulated devices
have been created and activated: 4 packet routers, and 1 optical line system controller. Besides, in the "Services" tab
you should see that there is no service created. Note here that the emulated devices produce synthetic
randomly-generated data and do not care about the services configured.


### 2.4.5.2. L3VPN Service creation

This step configures a new service emulating the request an OSM WIM would make by means of a Mock OSM instance.

To run this step, execute the `./ecoc22/run_test_02_create_service.sh` script.

When the script finishes, check the WebUI "Services" tab. You should see that two services have been created, one for
the optical layer and another for the packet layer. Besides, you can check the "Devices" tab to see the configuration
rules that have been configured in each device. In the Grafana Dashboard, given that there is now a service configured,
you should see the plots with the monitored data for the device. By default, device R1-EMU is selected.

### 2.4.5.3. L3VPN Service removal

This step deconfigures the previously created services emulating the request an OSM WIM would make by means of a Mock
OSM instance.

To run this step, execute the `./ecoc22/run_test_03_delete_service.sh` script, or delete the L3NM service from the WebUI.

When the script finishes, check the WebUI "Services" tab. You should see that the two services have been removed.
Besides, in the "Devices" tab you can see that the appropriate configuration rules have been deconfigured. In the
Grafana Dashboard, given that there is no service configured, you should see a 0-valued flat plot again.

### 2.4.5.4. Cleanup

This last step performs a cleanup of the scenario removing all the TeraFlowSDN entities for completeness.

To run this step, execute the `./ecoc22/run_test_04_cleanup.sh` script.

When the script finishes, check the WebUI "Devices" tab, you should see that the devices have been removed. Besides, in
the "Services" tab you can see that the "admin" Context has no services given that that context has been removed.
