# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from enum import Enum

# Default logging level
DEFAULT_LOG_LEVEL = logging.WARNING

# Default gRPC server settings
DEFAULT_GRPC_BIND_ADDRESS = '0.0.0.0'
DEFAULT_GRPC_MAX_WORKERS  = 10
DEFAULT_GRPC_GRACE_PERIOD = 60

# Default HTTP server settings
DEFAULT_HTTP_BIND_ADDRESS = '0.0.0.0'

# Default Prometheus settings
DEFAULT_METRICS_PORT = 9192

# Default context and topology UUIDs
DEFAULT_CONTEXT_UUID = 'admin'
DEFAULT_TOPOLOGY_UUID = 'admin'

# Default service names
class ServiceNameEnum(Enum):
    CONTEXT       = 'context'
    DEVICE        = 'device'
    SERVICE       = 'service'
    SLICE         = 'slice'
    AUTOMATION    = 'automation'
    POLICY        = 'policy'
    MONITORING    = 'monitoring'
    DLT           = 'dlt'
    COMPUTE       = 'compute'
    CYBERSECURITY = 'cybersecurity'
    INTERDOMAIN   = 'interdomain'
    PATHCOMP      = 'pathcomp'

# Default gRPC service ports
DEFAULT_SERVICE_GRPC_PORTS = {
    ServiceNameEnum.CONTEXT      .value :  1010,
    ServiceNameEnum.DEVICE       .value :  2020,
    ServiceNameEnum.SERVICE      .value :  3030,
    ServiceNameEnum.SLICE        .value :  4040,
    ServiceNameEnum.AUTOMATION   .value :  5050,
    ServiceNameEnum.POLICY       .value :  6060,
    ServiceNameEnum.MONITORING   .value :  7070,
    ServiceNameEnum.DLT          .value :  8080,
    ServiceNameEnum.COMPUTE      .value :  9090,
    ServiceNameEnum.CYBERSECURITY.value : 10000,
    ServiceNameEnum.INTERDOMAIN  .value : 10010,
    ServiceNameEnum.PATHCOMP     .value : 10020,
}

# Default HTTP/REST-API service ports
DEFAULT_SERVICE_HTTP_PORTS = {
    ServiceNameEnum.CONTEXT   .value : 8080,
    ServiceNameEnum.COMPUTE   .value : 8080,
}

# Default HTTP/REST-API service base URLs
DEFAULT_SERVICE_HTTP_BASEURLS = {
    ServiceNameEnum.CONTEXT   .value : '/api',
    ServiceNameEnum.COMPUTE   .value : '/restconf/data',
}
