import grpc, logging
from common.tools.RetryDecorator import retry, delay_exponential
from service.proto.context_pb2 import Empty
from service.proto.service_pb2 import ConnectionList, Service, ServiceId, ServiceList
from service.proto.service_pb2_grpc import ServiceServiceStub

LOGGER = logging.getLogger(__name__)
MAX_RETRIES = 15
DELAY_FUNCTION = delay_exponential(initial=0.01, increment=2.0, maximum=5.0)

class ServiceClient:
    def __init__(self, address, port):
        self.endpoint = '{}:{}'.format(address, port)
        LOGGER.debug('Creating channel to {}...'.format(self.endpoint))
        self.channel = None
        self.stub = None
        self.connect()
        LOGGER.debug('Channel created')

    def connect(self):
        self.channel = grpc.insecure_channel(self.endpoint)
        self.stub = ServiceServiceStub(self.channel)

    def close(self):
        if(self.channel is not None): self.channel.close()
        self.channel = None
        self.stub = None

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def GetServiceList(self, request : Empty) -> ServiceList:
        LOGGER.debug('GetServiceList request: {}'.format(request))
        response = self.stub.GetServiceList(request)
        LOGGER.debug('GetServiceList result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def CreateService(self, request : Service) -> ServiceId:
        LOGGER.debug('CreateService request: {}'.format(request))
        response = self.stub.CreateService(request)
        LOGGER.debug('CreateService result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def UpdateService(self, request : Service) -> ServiceId:
        LOGGER.debug('UpdateService request: {}'.format(request))
        response = self.stub.UpdateService(request)
        LOGGER.debug('UpdateService result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def DeleteService(self, request : ServiceId) -> Empty:
        LOGGER.debug('DeleteService request: {}'.format(request))
        response = self.stub.DeleteService(request)
        LOGGER.debug('DeleteService result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def GetServiceById(self, request : ServiceId) -> Service:
        LOGGER.debug('GetServiceById request: {}'.format(request))
        response = self.stub.GetServiceById(request)
        LOGGER.debug('GetServiceById result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def GetConnectionList(self, request : Empty) -> ConnectionList:
        LOGGER.debug('GetConnectionList request: {}'.format(request))
        response = self.stub.GetConnectionList(request)
        LOGGER.debug('GetConnectionList result: {}'.format(response))
        return response
