# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class client_svc(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/te-link-attributes/client-svc. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Attributes of the Link supporting CBR client signals.
  """
  __slots__ = ('_path_helper', '_extmethods', '__supported_client_signal',)

  _yang_name = 'client-svc'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__supported_client_signal = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},)), is_leaf=False, yang_name="supported-client-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'te-link-attributes', 'client-svc']

  def _get_supported_client_signal(self):
    """
    Getter method for supported_client_signal, mapped from YANG variable /networks/network/link/te/te_link_attributes/client_svc/supported_client_signal (identityref)

    YANG Description: List of client signal types supported by the Link.
    """
    return self.__supported_client_signal
      
  def _set_supported_client_signal(self, v, load=False):
    """
    Setter method for supported_client_signal, mapped from YANG variable /networks/network/link/te/te_link_attributes/client_svc/supported_client_signal (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_client_signal is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_client_signal() directly.

    YANG Description: List of client signal types supported by the Link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},)), is_leaf=False, yang_name="supported-client-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_client_signal must be of a type compatible with identityref""",
          'defined-type': "ietf-otn-topology:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},)), is_leaf=False, yang_name="supported-client-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)""",
        })

    self.__supported_client_signal = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_client_signal(self):
    self.__supported_client_signal = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-1Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-10Gb-LAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-10Gb-WAN': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-40Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ETH-100Gb': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-16': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-64': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:STM-256': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-12': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-48': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-192': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:OC-768': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-100': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-400': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-800': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-1200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-1600': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FC-3200': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FICON-4G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:FICON-8G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},)), is_leaf=False, yang_name="supported-client-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)

  supported_client_signal = __builtin__.property(_get_supported_client_signal, _set_supported_client_signal)


  _pyangbind_elements = OrderedDict([('supported_client_signal', supported_client_signal), ])


