/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb.controllers;

import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.TE_Information;
import eu.teraflow.tid.tedb.controllers.TEDUpdaterController;
import eu.teraflow.tid.tedb.elements.RouterInfoPM;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;

public class TEDUpdaterRYU
extends TEDUpdaterController {
    public static String controllerName = "RYU";
    private Hashtable<Integer, TEDUpdaterController.MyEdge> interDomainLinks = new Hashtable();
    private String topologyPathNodes = "/v1.0/topology/switches";
    private String topologyPathLinks = "/v1.0/topology/links";

    public TEDUpdaterRYU(String ip, String port, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log) {
        super(ip, port, topologyPathLinks, topologyPathNodes, ted, log);
    }

    public TEDUpdaterRYU(String ip, String port, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log, Lock lock) {
        super(ip, port, topologyPathLinks, topologyPathNodes, ted, log, lock);
    }

    public TEDUpdaterRYU(ArrayList<String> ips, ArrayList<String> ports, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log) {
        super(ips, ports, topologyPathLinks, topologyPathNodes, ted, log);
    }

    @Override
    public void run() {
        if (this.interDomainFile != null) {
            this.interDomainLinks = TEDUpdaterController.readInterDomainFile(this.interDomainFile);
        }
        String responseLinks = "";
        String responseNodes = "";
        try {
            Hashtable<String, RouterInfoPM> nodes = new Hashtable<String, RouterInfoPM>();
            int i = 0;
            while (i < this.ips.size()) {
                responseNodes = this.queryForNodes((String)this.ips.get(i), (String)this.ports.get(i));
                this.parseNodes(responseNodes, nodes, (String)this.ips.get(i), (String)this.ports.get(i));
                this.log.info("responseNodes:::" + responseNodes);
                ++i;
            }
            i = 0;
            while (i < this.ips.size()) {
                responseLinks = this.queryForLinks((String)this.ips.get(i), (String)this.ports.get(i));
                this.log.info("responseLinks:::" + responseLinks);
                this.lock();
                this.parseLinks(responseLinks, nodes);
                this.unlock();
                ++i;
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
    }

    private String RYUtoFloodlight(String RYUFormat) {
        String floodFormat = new String(RYUFormat);
        int i = 2;
        while (i < floodFormat.length()) {
            floodFormat = String.valueOf(floodFormat.substring(0, i)) + ":" + floodFormat.substring(i, floodFormat.length());
            i += 3;
        }
        this.log.info("RYUFormat--> " + RYUFormat + ", floodFormat-->" + floodFormat);
        return floodFormat;
    }

    private void parseNodes(String response, Hashtable<String, RouterInfoPM> routerInfoList, String ip, String port) {
        try {
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(response);
            JSONArray msg = (JSONArray)obj;
            for (JSONObject jsonObject : msg) {
                this.log.info("(String)jsonObject.get(dpid)::" + (String)jsonObject.get((Object)"dpid"));
                RouterInfoPM rInfo = new RouterInfoPM();
                rInfo.setRouterID(this.RYUtoFloodlight((String)jsonObject.get((Object)"dpid")));
                rInfo.setConfigurationMode("Openflow");
                rInfo.setControllerType(controllerName);
                rInfo.setControllerIdentifier(ip, port);
                rInfo.setControllerIP(ip);
                rInfo.setControllerPort(port);
                routerInfoList.put(rInfo.getRouterID(), rInfo);
                this.TEDB.getNetworkGraph().addVertex((Object)rInfo);
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
    }

    private void parseLinks(String links, Hashtable<String, RouterInfoPM> nodes) {
        try {
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(links);
            JSONArray msg = (JSONArray)obj;
            for (JSONObject jsonObject : msg) {
                IntraDomainEdge edge = new IntraDomainEdge();
                JSONObject jsonObject_src = (JSONObject)jsonObject.get((Object)"src");
                JSONObject jsonObject_dst = (JSONObject)jsonObject.get((Object)"dst");
                RouterInfoPM source = nodes.get(this.RYUtoFloodlight((String)jsonObject_src.get((Object)"dpid")));
                RouterInfoPM dest = nodes.get(this.RYUtoFloodlight((String)jsonObject_dst.get((Object)"dpid")));
                this.log.info("Adding Vertex->" + source + " hashcode:" + source.hashCode());
                this.log.info("Adding Vertex->" + dest + " hashcode:" + dest.hashCode());
                edge.setSrc_if_id(Long.parseLong((String)jsonObject_src.get((Object)"port_no")));
                edge.setDst_if_id(Long.parseLong((String)jsonObject_dst.get((Object)"port_no")));
                TE_Information tE_info = new TE_Information();
                tE_info.setNumberWLANs(15);
                tE_info.initWLANs();
                if (this.interDomainFile != null) {
                    this.completeTE_Information(tE_info, source.getRouterID(), dest.getRouterID());
                }
                edge.setTE_info(tE_info);
                String isBidirectional = (String)jsonObject.get((Object)"direction");
                isBidirectional = "bidirectional";
                TE_Information tE_infoOtherWay = new TE_Information();
                tE_infoOtherWay.setNumberWLANs(15);
                tE_infoOtherWay.initWLANs();
                IntraDomainEdge edgeOtherWay = new IntraDomainEdge();
                edgeOtherWay.setSrc_if_id(Long.parseLong((String)jsonObject_src.get((Object)"port_no")));
                edgeOtherWay.setDst_if_id(Long.parseLong((String)jsonObject_dst.get((Object)"port_no")));
                edgeOtherWay.setTE_info(tE_infoOtherWay);
                this.TEDB.getNetworkGraph().addEdge((Object)source, (Object)dest, (Object)edge);
                this.TEDB.getNetworkGraph().addEdge((Object)dest, (Object)source, (Object)edgeOtherWay);
                this.completeTE_Information(tE_info, dest.getRouterID(), source.getRouterID());
                this.log.info("source::" + source);
                this.log.info("dest::" + dest);
                this.log.info("edgeOtherWay::" + (Object)((Object)edgeOtherWay));
                this.log.info("edge::" + (Object)((Object)edge));
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
    }

    private void completeTE_Information(TE_Information tE_info, String source, String dest) {
        TEDUpdaterController.MyEdge auxEdge = new TEDUpdaterController.MyEdge(source, dest);
        TEDUpdaterController.MyEdge completEdge = this.interDomainLinks.get(auxEdge.hashCode());
        if (completEdge != null && completEdge.vlan != null) {
            tE_info.setVlanLink(true);
            tE_info.setVlan(completEdge.vlan);
            this.interDomainLinks.remove(completEdge.vlan);
        } else {
            tE_info.setVlanLink(false);
        }
    }

    private String queryForLinks(String ip, String port) {
        String response = "";
        try {
            String inputLine;
            URL topoplogyURL = new URL("http://" + ip + ":" + port + this.topologyPathLinks);
            this.log.info("URL::http://" + ip + ":" + port + this.topologyPathLinks);
            URLConnection yc = topoplogyURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response = String.valueOf(response) + inputLine;
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
        return response;
    }

    private String queryForNodes(String ip, String port) {
        String response = "";
        try {
            String inputLine;
            URL topoplogyURL = new URL("http://" + ip + ":" + port + this.topologyPathNodes);
            this.log.info("http://+port+topologyPathNodes:::http://" + ip + ":" + port + this.topologyPathNodes);
            URLConnection yc = topoplogyURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response = String.valueOf(response) + inputLine;
            }
            in.close();
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
        return response;
    }

    @Override
    public String getInterDomainFile() {
        return this.interDomainFile;
    }

    @Override
    public void setInterDomainFile(String interDomainFile) {
        this.interDomainFile = interDomainFile;
    }

    private void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    private void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }
}

