/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb.controllers;

import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.SimpleTEDB;
import eu.teraflow.tid.tedb.TE_Information;
import eu.teraflow.tid.tedb.controllers.TEDUpdaterController;
import eu.teraflow.tid.tedb.elements.RouterInfoPM;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TEDUpdaterODL
extends TEDUpdaterController {
    public static String controllerName = "ODL";
    private String topologyPathLinks = "/controller/nb/v2/topology/default";
    private String topologyPathNodes = "/controller/nb/v2/switchmanager/default/nodes";

    public TEDUpdaterODL(String ip, String port, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log) {
        this.ips = new ArrayList();
        this.ports = new ArrayList();
        this.ips.add(ip);
        this.ports.add(port);
        this.TEDB = (SimpleTEDB)ted;
        this.log = log;
    }

    public TEDUpdaterODL(String ip, String port, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log, Lock lock) {
        super(ip, port, topologyPathLinks, topologyPathNodes, ted, log, lock);
    }

    public TEDUpdaterODL(ArrayList<String> ips, ArrayList<String> ports, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log) {
        super(ips, ports, topologyPathLinks, topologyPathNodes, ted, log);
    }

    @Override
    public void run() {
        if (this.interDomainFile != null) {
            this.interDomainLinks = TEDUpdaterController.readInterDomainFile(this.interDomainFile);
        }
        String responseLinks = "";
        String responseNodes = "";
        try {
            Hashtable<String, RouterInfoPM> nodes = new Hashtable<String, RouterInfoPM>();
            this.log.info("ips.size():" + this.ips.size());
            this.log.info("ODL updates_______________________________________________________START____");
            int i = 0;
            while (i < this.ips.size()) {
                responseNodes = this.queryForNodes((String)this.ips.get(i), (String)this.ports.get(i));
                this.parseNodes(responseNodes, nodes, (String)this.ips.get(i), (String)this.ports.get(i));
                ++i;
            }
            i = 0;
            while (i < this.ips.size()) {
                responseLinks = this.queryForLinks((String)this.ips.get(i), (String)this.ports.get(i));
                this.lock();
                this.parseLinks(responseLinks, nodes);
                this.unlock();
                ++i;
            }
            this.log.info("ODL updates_______________________________________________________END____");
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
    }

    private void parseNodes(String response, Hashtable<String, RouterInfoPM> routerInfoList, String ip, String port) {
        try {
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(response);
            JSONArray msg = (JSONArray)((JSONObject)obj).get((Object)"nodeProperties");
            for (JSONObject jsonObject : msg) {
                RouterInfoPM rInfo = new RouterInfoPM();
                String dpid = (String)((JSONObject)jsonObject.get((Object)"node")).get((Object)"id");
                rInfo.setRouterID(dpid);
                rInfo.setConfigurationMode("Openflow");
                rInfo.setControllerType(controllerName);
                rInfo.setControllerIdentifier(ip, port);
                rInfo.setControllerIP(ip);
                rInfo.setControllerPort(port);
                routerInfoList.put(rInfo.getRouterID(), rInfo);
                this.log.info("Adding Vertex::" + rInfo);
                this.TEDB.getNetworkGraph().addVertex((Object)rInfo);
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
    }

    private void parseLinks(String links, Hashtable<String, RouterInfoPM> nodes) {
        try {
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(links);
            JSONArray msg = (JSONArray)((JSONObject)obj).get((Object)"edgeProperties");
            Iterator iterator = msg.iterator();
            while (iterator.hasNext()) {
                JSONObject jsonObject = (JSONObject)((JSONObject)iterator.next()).get((Object)"edge");
                JSONObject jSrc = (JSONObject)jsonObject.get((Object)"headNodeConnector");
                JSONObject jDst = (JSONObject)jsonObject.get((Object)"tailNodeConnector");
                IntraDomainEdge edge = new IntraDomainEdge();
                RouterInfoPM source = nodes.get(((JSONObject)jSrc.get((Object)"node")).get((Object)"id"));
                RouterInfoPM dest = nodes.get(((JSONObject)jDst.get((Object)"node")).get((Object)"id"));
                edge.setSrc_if_id(Long.parseLong((String)jSrc.get((Object)"id")));
                edge.setDst_if_id(Long.parseLong((String)jDst.get((Object)"id")));
                TE_Information tE_info = new TE_Information();
                tE_info.setNumberWLANs(15);
                tE_info.initWLANs();
                if (this.interDomainFile != null) {
                    this.completeTE_Information(tE_info, source.getRouterID(), dest.getRouterID());
                }
                edge.setTE_info(tE_info);
                String isBidirectional = (String)jsonObject.get((Object)"direction");
                TE_Information tE_infoOtherWay = new TE_Information();
                tE_infoOtherWay.setNumberWLANs(15);
                tE_infoOtherWay.initWLANs();
                IntraDomainEdge edgeOtherWay = new IntraDomainEdge();
                edgeOtherWay.setSrc_if_id(Long.parseLong((String)jDst.get((Object)"id")));
                edgeOtherWay.setDst_if_id(Long.parseLong((String)jSrc.get((Object)"id")));
                edgeOtherWay.setTE_info(tE_infoOtherWay);
                this.TEDB.getNetworkGraph().addEdge((Object)source, (Object)dest, (Object)edge);
                this.TEDB.getNetworkGraph().addEdge((Object)dest, (Object)source, (Object)edgeOtherWay);
                this.completeTE_Information(tE_info, dest.getRouterID(), source.getRouterID());
                this.log.info("________EDGE_____");
                this.log.info("source::" + source);
                this.log.info("dest::" + dest);
                this.log.info("edgeOtherWay::" + (Object)((Object)edgeOtherWay));
                this.log.info("edge::" + (Object)((Object)edge));
                this.log.info("--------EDGE-----");
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
    }

    private void completeTE_Information(TE_Information tE_info, String source, String dest) {
        TEDUpdaterController.MyEdge auxEdge = new TEDUpdaterController.MyEdge(this, source, dest);
        TEDUpdaterController.MyEdge completEdge = (TEDUpdaterController.MyEdge)this.interDomainLinks.get(auxEdge.hashCode());
        if (completEdge != null && completEdge.vlan != null) {
            tE_info.setVlanLink(true);
            tE_info.setVlan(completEdge.vlan);
            this.interDomainLinks.remove(completEdge.vlan);
        } else {
            tE_info.setVlanLink(false);
        }
    }

    private String queryForLinks(String ip, String port) {
        return this.query("http://" + ip + ":" + port + this.topologyPathLinks);
    }

    private String queryForNodes(String ip, String port) {
        return this.query("http://" + ip + ":" + port + this.topologyPathNodes);
    }

    private String query(String url) {
        this.log.info("Attempting to curl: " + url);
        String response = "";
        try {
            String inputLine;
            String credentials = "admin:admin";
            String credentialsEncoded = "YWRtaW46YWRtaW4=";
            URL topoplogyURL = new URL(url);
            URLConnection yc = topoplogyURL.openConnection();
            HttpURLConnection httpcon = (HttpURLConnection)yc;
            httpcon.setDoOutput(true);
            httpcon.setRequestProperty("Content-Type", "application/json");
            httpcon.setRequestProperty("Authorization", "Basic " + credentialsEncoded);
            BufferedReader in = new BufferedReader(new InputStreamReader(httpcon.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response = String.valueOf(response) + inputLine;
            }
            in.close();
            return response;
        }
        catch (Exception e) {
            this.log.info(e.toString());
            return "";
        }
    }

    private void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    private void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    private String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }
}

