/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb.controllers;

import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.TE_Information;
import eu.teraflow.tid.tedb.controllers.TEDUpdaterController;
import eu.teraflow.tid.tedb.elements.RouterInfoPM;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;

public class TEDUpdaterNOX
extends TEDUpdaterController {
    public static String controllerName = "NOX";
    private Hashtable<Integer, TEDUpdaterController.MyEdge> interDomainLinks = new Hashtable();
    private String topologyPathNodes = "/get_vtopology/";
    private String topologyPathLinks = "/get_graph/";

    public TEDUpdaterNOX(String ip, String port, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log) {
        super(ip, port, topologyPathLinks, topologyPathNodes, ted, log);
    }

    public TEDUpdaterNOX(String ip, String port, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log, Lock lock) {
        super(ip, port, topologyPathLinks, topologyPathNodes, ted, log, lock);
    }

    public TEDUpdaterNOX(ArrayList<String> ips, ArrayList<String> ports, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log) {
        super(ips, ports, topologyPathLinks, topologyPathNodes, ted, log);
    }

    @Override
    public void run() {
        if (this.interDomainFile != null) {
            this.interDomainLinks = TEDUpdaterController.readInterDomainFile(this.interDomainFile);
        }
        String responseLinks = "";
        String responseNodes = "";
        try {
            Hashtable<String, RouterInfoPM> nodes = new Hashtable<String, RouterInfoPM>();
            int i = 0;
            while (i < this.ips.size()) {
                responseNodes = this.queryForNodes((String)this.ips.get(i), (String)this.ports.get(i));
                this.parseNodes(responseNodes, nodes, (String)this.ips.get(i), (String)this.ports.get(i));
                this.log.info("responseNodes:::" + responseNodes);
                ++i;
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
    }

    private String BristoltoFloodlight(String BristolFormat) {
        String floodFormat = new String(BristolFormat);
        int i = 2;
        while (i < floodFormat.length()) {
            floodFormat = String.valueOf(floodFormat.substring(0, i)) + ":" + floodFormat.substring(i, floodFormat.length());
            i += 3;
        }
        this.log.info("BristolFormat--> " + BristolFormat + ", floodFormat-->" + floodFormat);
        return floodFormat;
    }

    private void parseNodes(String response, Hashtable<String, RouterInfoPM> routerInfoList, String ip, String port) {
        try {
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(response);
            JSONObject jsonaux = (JSONObject)obj;
            Iterator iterkeys = jsonaux.keySet().iterator();
            Hashtable<String, RouterInfoPM> nodes = new Hashtable<String, RouterInfoPM>();
            while (iterkeys.hasNext()) {
                String dpid = (String)iterkeys.next();
                System.out.println("Key: " + dpid.replace("-", ":"));
                RouterInfoPM rInfo = new RouterInfoPM();
                rInfo.setRouterID(dpid.replace("-", ":"));
                rInfo.setConfigurationMode("Openflow");
                rInfo.setControllerType(controllerName);
                rInfo.setControllerIdentifier(ip, port);
                rInfo.setControllerIP(ip);
                rInfo.setControllerPort(port);
                routerInfoList.put(rInfo.getRouterID(), rInfo);
                nodes.put(dpid.replace("-", ":"), rInfo);
                this.TEDB.getNetworkGraph().addVertex((Object)rInfo);
            }
            for (String node : nodes.keySet()) {
                this.parseLinks(node, jsonaux.get((Object)node.replace(":", "-")).toString(), nodes);
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
    }

    private void parseLinks(String dpid, String links, Hashtable<String, RouterInfoPM> nodes) {
        try {
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(links);
            JSONArray msg = (JSONArray)obj;
            for (JSONObject jsonObject : msg) {
                IntraDomainEdge edge = new IntraDomainEdge();
                String labels = (String)jsonObject.get((Object)"labels");
                String destnode = ((String)jsonObject.get((Object)"peer_node")).replace("-", ":");
                String type = (String)jsonObject.get((Object)"port_type");
                RouterInfoPM source = nodes.get(dpid);
                RouterInfoPM dest = nodes.get(destnode);
                System.out.println("Srcnode: " + dpid);
                System.out.println("Dstnode: " + destnode);
                System.out.println("Srcport: " + jsonObject.get((Object)"port_id"));
                System.out.println("Dstport: " + jsonObject.get((Object)"peer_port"));
                if (dest != null && source != null) {
                    edge.setSrc_if_id(Long.parseLong((String)jsonObject.get((Object)"port_id")));
                    edge.setDst_if_id(Long.parseLong((String)jsonObject.get((Object)"peer_port")));
                    edge.setType(type);
                    TE_Information tE_info = new TE_Information();
                    System.out.println("Labels: Original (" + labels + ") and Parsed (" + labels.substring(labels.indexOf(",") + 1, labels.indexOf("]")) + ")");
                    tE_info.setNumberWLANs(Integer.parseInt(labels.substring(labels.indexOf(",") + 1, labels.indexOf("]"))));
                    tE_info.initWLANs();
                    if (this.interDomainFile != null) {
                        this.completeTE_Information(tE_info, source.getRouterID(), dest.getRouterID());
                    }
                    edge.setTE_info(tE_info);
                    edge.setDirectional(true);
                    this.TEDB.getNetworkGraph().addEdge((Object)source, (Object)dest, (Object)edge);
                    continue;
                }
                System.out.println("Link with an unknown node. Ingnoring...");
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
    }

    private void completeTE_Information(TE_Information tE_info, String source, String dest) {
        TEDUpdaterController.MyEdge auxEdge = new TEDUpdaterController.MyEdge(this, source, dest);
        TEDUpdaterController.MyEdge completEdge = this.interDomainLinks.get(auxEdge.hashCode());
        if (completEdge != null && completEdge.vlan != null) {
            tE_info.setVlanLink(true);
            tE_info.setVlan(completEdge.vlan);
            this.interDomainLinks.remove(completEdge.vlan);
        } else {
            tE_info.setVlanLink(false);
        }
    }

    private String queryForLinks(String ip, String port) {
        String response = "";
        try {
            String inputLine;
            URL topoplogyURL = new URL("http://" + ip + ":" + port + this.topologyPathLinks);
            this.log.info("URL::http://" + ip + ":" + port + this.topologyPathLinks);
            URLConnection yc = topoplogyURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response = String.valueOf(response) + inputLine;
            }
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
        return response;
    }

    private String queryForNodes(String ip, String port) {
        String response = "";
        try {
            String inputLine;
            URL topoplogyURL = new URL("http://" + ip + ":" + port + this.topologyPathNodes);
            this.log.info("http://+port+topologyPathNodes:::http://" + ip + ":" + port + this.topologyPathNodes);
            URLConnection yc = topoplogyURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response = String.valueOf(response) + inputLine;
            }
            in.close();
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
        return response;
    }

    @Override
    public String getInterDomainFile() {
        return this.interDomainFile;
    }

    @Override
    public void setInterDomainFile(String interDomainFile) {
        this.interDomainFile = interDomainFile;
    }

    private void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    private void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }
}

