/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb.controllers;

import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.SimpleTEDB;
import eu.teraflow.tid.tedb.TE_Information;
import eu.teraflow.tid.tedb.elements.RouterInfoPM;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEDUpdaterController
extends Thread {
    protected Hashtable<Integer, MyEdge> interDomainLinks = new Hashtable();
    protected ArrayList<String> ips = null;
    protected ArrayList<String> ports = null;
    protected String topologyPathNodes = "";
    protected String topologyPathLinks = "";
    protected SimpleTEDB TEDB;
    protected Logger log;
    protected Lock lock = null;
    protected String interDomainFile = null;

    public TEDUpdaterController() {
    }

    public TEDUpdaterController(String ip, String port, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log) {
        this.ips = new ArrayList();
        this.ports = new ArrayList();
        this.ips.add(ip);
        this.ports.add(port);
        this.topologyPathLinks = topologyPathLinks;
        this.topologyPathNodes = topologyPathNodes;
        this.TEDB = (SimpleTEDB)ted;
        this.log = log;
    }

    public TEDUpdaterController(String ip, String port, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log, Lock lock) {
        this.ips = new ArrayList();
        this.ports = new ArrayList();
        this.ips.add(ip);
        this.ports.add(port);
        this.topologyPathLinks = topologyPathLinks;
        this.topologyPathNodes = topologyPathNodes;
        this.TEDB = (SimpleTEDB)ted;
        this.log = log;
        this.lock = lock;
    }

    public TEDUpdaterController(ArrayList<String> ips, ArrayList<String> ports, String topologyPathLinks, String topologyPathNodes, DomainTEDB ted, Logger log) {
        this.ips = ips;
        this.ports = ports;
        this.topologyPathLinks = topologyPathLinks;
        this.topologyPathNodes = topologyPathNodes;
        this.TEDB = (SimpleTEDB)ted;
        this.log = log;
    }

    public static void parseRemainingLinksFromXML(DomainTEDB TEDB2, String interDomainFile) {
        Hashtable<Integer, MyEdge> interDomainLinks;
        Hashtable<Integer, MyEdge> map = interDomainLinks = TEDUpdaterController.readInterDomainFile(interDomainFile);
        for (Map.Entry entry : map.entrySet()) {
            MyEdge edgeAux = (MyEdge)entry.getValue();
            IntraDomainEdge edge = new IntraDomainEdge();
            edge.setSrc_if_id(new Long(edgeAux.source_port.intValue()));
            edge.setDst_if_id(new Long(edgeAux.dest_port.intValue()));
            TE_Information tE_info = new TE_Information();
            tE_info.setNumberWLANs(15);
            tE_info.initWLANs();
            tE_info.setVlanLink(true);
            tE_info.setVlan(edgeAux.vlan);
            edge.setTE_info(tE_info);
            System.out.println("Adding InterDomain Edge!!::Vlan::" + edgeAux.vlan);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> sdwg = ((SimpleTEDB)TEDB2).getNetworkGraph();
            if (!sdwg.containsVertex((Object)new RouterInfoPM(edgeAux.source))) {
                sdwg.addVertex((Object)new RouterInfoPM(edgeAux.source));
            }
            if (!sdwg.containsVertex((Object)new RouterInfoPM(edgeAux.dest))) {
                sdwg.addVertex((Object)new RouterInfoPM(edgeAux.dest));
            }
            ((SimpleTEDB)TEDB2).getNetworkGraph().addEdge((Object)new RouterInfoPM(edgeAux.source), (Object)new RouterInfoPM(edgeAux.dest), (Object)edge);
        }
    }

    public static Hashtable<Integer, MyEdge> readInterDomainFile(String interDomainFile) {
        System.out.println("Parsing intradomain File");
        Hashtable<Integer, MyEdge> interDomainLinks = new Hashtable<Integer, MyEdge>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            File confFile = new File(interDomainFile);
            Document doc = builder.parse(confFile);
            NodeList list_nodes_Edges = doc.getElementsByTagName("edge");
            System.out.println("num edges: " + list_nodes_Edges.getLength());
            int i = 0;
            while (i < list_nodes_Edges.getLength()) {
                Element nodes_servers = (Element)list_nodes_Edges.item(i);
                String source = TEDUpdaterController.getCharacterDataFromElement((Element)nodes_servers.getElementsByTagName("source").item(0));
                String dest = TEDUpdaterController.getCharacterDataFromElement((Element)nodes_servers.getElementsByTagName("dest").item(0));
                Integer vlan = Integer.parseInt(TEDUpdaterController.getCharacterDataFromElement((Element)nodes_servers.getElementsByTagName("vlan").item(0)));
                String direction = TEDUpdaterController.getCharacterDataFromElement((Element)nodes_servers.getElementsByTagName("direction").item(0));
                int source_port = Integer.parseInt(TEDUpdaterController.getCharacterDataFromElement((Element)nodes_servers.getElementsByTagName("source_port").item(0)));
                int dest_port = Integer.parseInt(TEDUpdaterController.getCharacterDataFromElement((Element)nodes_servers.getElementsByTagName("dest_port").item(0)));
                System.out.println("Adding IntraDomain Link! source: " + source + ", dest: " + dest + ", source_port: " + source_port + ", dest_port: " + dest_port);
                TEDUpdaterController tEDUpdaterController = new TEDUpdaterController();
                tEDUpdaterController.getClass();
                MyEdge auxEdge = tEDUpdaterController.new MyEdge(source, dest, vlan, source_port, dest_port);
                interDomainLinks.put(auxEdge.hashCode(), auxEdge);
                if (direction.equals("bidirectional")) {
                    TEDUpdaterController tEDUpdaterController2 = new TEDUpdaterController();
                    tEDUpdaterController2.getClass();
                    MyEdge reverseEdge = tEDUpdaterController2.new MyEdge(dest, source, vlan, source_port, dest_port);
                    interDomainLinks.put(reverseEdge.hashCode(), reverseEdge);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return interDomainLinks;
    }

    private static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }

    public String getInterDomainFile() {
        return this.interDomainFile;
    }

    public void setInterDomainFile(String interDomainFile) {
        this.interDomainFile = interDomainFile;
    }

    public class MyEdge {
        String source;
        String dest;
        Integer source_port;
        Integer dest_port;
        Integer vlan;

        MyEdge(String source, String dest) {
            this.source = source;
            this.dest = dest;
        }

        MyEdge(String source, String dest, Integer vlan, Integer source_port, Integer dest_port) {
            this.source = source;
            this.dest = dest;
            this.source_port = source_port;
            this.dest_port = dest_port;
            this.vlan = vlan;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dest == null ? 0 : this.dest.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MyEdge other = (MyEdge)obj;
            if (this.dest == null ? other.dest != null : !this.dest.equals(other.dest)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }
    }
}

