/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb;

import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.DefaultTEMetricLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IPv4RouterIDLocalNodeLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IPv4RouterIDRemoteNodeLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.LinkProtectionTypeLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MF_OTPAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MetricLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.TransceiverClassAndAppAttribTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.MinMaxUndirectionalLinkDelayDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalAvailableBandwidthDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalDelayVariationDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalLinkDelayDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalLinkLossDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalResidualBandwidthDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalUtilizedBandwidthDescriptorSubTLV;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AdministrativeGroup;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AvailableLabels;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.IPv4RemoteASBRID;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.InterfaceSwitchingCapabilityDescriptor;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LinkLocalRemoteIdentifiers;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LinkProtectionType;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MaximumBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MaximumReservableBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.RemoteASNumber;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.SharedRiskLinkGroup;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.TrafficEngineeringMetric;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.UnreservedBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;

public class TE_Information {
    private TrafficEngineeringMetric trafficEngineeringMetric;
    private DefaultTEMetricLinkAttribTLV defaultTEMetric;
    private MaximumBandwidth maximumBandwidth;
    private MaximumReservableBandwidth maximumReservableBandwidth;
    private UnreservedBandwidth unreservedBandwidth;
    private AdministrativeGroup administrativeGroup;
    private LinkLocalRemoteIdentifiers linkLocalRemoteIdentifiers;
    private LinkProtectionType linkProtectionType;
    private LinkProtectionTypeLinkAttribTLV linkProtectionBGPLS;
    private InterfaceSwitchingCapabilityDescriptor interfaceSwitchingCapabilityDescriptor;
    private SharedRiskLinkGroup sharedRiskLinkGroup;
    private RemoteASNumber remoteASNumber;
    private IPv4RemoteASBRID iPv4RemoteASBRID;
    private IPv4RouterIDLocalNodeLinkAttribTLV iPv4LocalNode;
    private IPv4RouterIDRemoteNodeLinkAttribTLV iPv4RemoteNode;
    private UndirectionalLinkDelayDescriptorSubTLV undirLinkDelay;
    private MinMaxUndirectionalLinkDelayDescriptorSubTLV minMaxUndirLinkDelay;
    private UndirectionalDelayVariationDescriptorSubTLV undirDelayVar;
    private UndirectionalLinkLossDescriptorSubTLV undirLinkLoss;
    private UndirectionalResidualBandwidthDescriptorSubTLV undirResidualBw;
    private UndirectionalAvailableBandwidthDescriptorSubTLV undirAvailableBw;
    private UndirectionalUtilizedBandwidthDescriptorSubTLV undirUtilizedBw;
    private MetricLinkAttribTLV metric;
    private AvailableLabels availableLabels;
    private MF_OTPAttribTLV mfOTF;
    private TransceiverClassAndAppAttribTLV trans;
    private int NumberWLANs = 15;
    private boolean withWLANs = false;
    private boolean[] occupiedWLANs;
    private boolean[] reservedWLANs;
    private boolean vlanLink = false;
    private int vlan;

    public AvailableLabels getAvailableLabels() {
        return this.availableLabels;
    }

    public void setAvailableLabels(AvailableLabels availableLabels) {
        this.availableLabels = availableLabels;
    }

    public TrafficEngineeringMetric getTrafficEngineeringMetric() {
        return this.trafficEngineeringMetric;
    }

    public void setTrafficEngineeringMetric(TrafficEngineeringMetric trafficEngineeringMetric) {
        this.trafficEngineeringMetric = trafficEngineeringMetric;
    }

    public MaximumBandwidth getMaximumBandwidth() {
        return this.maximumBandwidth;
    }

    public void setMaximumBandwidth(MaximumBandwidth maximumBandwidth) {
        this.maximumBandwidth = maximumBandwidth;
    }

    public MaximumReservableBandwidth getMaximumReservableBandwidth() {
        return this.maximumReservableBandwidth;
    }

    public IPv4RouterIDRemoteNodeLinkAttribTLV getiPv4RemoteNode() {
        return this.iPv4RemoteNode;
    }

    public void setiPv4RemoteNode(IPv4RouterIDRemoteNodeLinkAttribTLV iPv4RemoteNode) {
        this.iPv4RemoteNode = iPv4RemoteNode;
    }

    public void setMaximumReservableBandwidth(MaximumReservableBandwidth maximumReservableBandwidth) {
        this.maximumReservableBandwidth = maximumReservableBandwidth;
    }

    public UnreservedBandwidth getUnreservedBandwidth() {
        return this.unreservedBandwidth;
    }

    public void setUnreservedBandwidth(UnreservedBandwidth unreservedBandwidth) {
        this.unreservedBandwidth = unreservedBandwidth;
    }

    public UndirectionalLinkDelayDescriptorSubTLV getUndirLinkDelay() {
        return this.undirLinkDelay;
    }

    public void setUndirLinkDelay(UndirectionalLinkDelayDescriptorSubTLV undirLinkDelay) {
        this.undirLinkDelay = undirLinkDelay;
    }

    public MinMaxUndirectionalLinkDelayDescriptorSubTLV getMinMaxUndirLinkDelay() {
        return this.minMaxUndirLinkDelay;
    }

    public void setMinMaxUndirLinkDelay(MinMaxUndirectionalLinkDelayDescriptorSubTLV minMaxUndirLinkDelay) {
        this.minMaxUndirLinkDelay = minMaxUndirLinkDelay;
    }

    public UndirectionalDelayVariationDescriptorSubTLV getUndirDelayVar() {
        return this.undirDelayVar;
    }

    public void setUndirDelayVar(UndirectionalDelayVariationDescriptorSubTLV undirDelayVar) {
        this.undirDelayVar = undirDelayVar;
    }

    public UndirectionalLinkLossDescriptorSubTLV getUndirLinkLoss() {
        return this.undirLinkLoss;
    }

    public void setUndirLinkLoss(UndirectionalLinkLossDescriptorSubTLV undirLinkLoss) {
        this.undirLinkLoss = undirLinkLoss;
    }

    public UndirectionalResidualBandwidthDescriptorSubTLV getUndirResidualBw() {
        return this.undirResidualBw;
    }

    public void setUndirResidualBw(UndirectionalResidualBandwidthDescriptorSubTLV undirResidualBw) {
        this.undirResidualBw = undirResidualBw;
    }

    public UndirectionalAvailableBandwidthDescriptorSubTLV getUndirAvailableBw() {
        return this.undirAvailableBw;
    }

    public void setUndirAvailableBw(UndirectionalAvailableBandwidthDescriptorSubTLV undirAvailableBw) {
        this.undirAvailableBw = undirAvailableBw;
    }

    public UndirectionalUtilizedBandwidthDescriptorSubTLV getUndirUtilizedBw() {
        return this.undirUtilizedBw;
    }

    public void setUndirUtilizedBw(UndirectionalUtilizedBandwidthDescriptorSubTLV undirUtilizedBw) {
        this.undirUtilizedBw = undirUtilizedBw;
    }

    public AdministrativeGroup getAdministrativeGroup() {
        return this.administrativeGroup;
    }

    public void setAdministrativeGroup(AdministrativeGroup administrativeGroup) {
        this.administrativeGroup = administrativeGroup;
    }

    public LinkLocalRemoteIdentifiers getLinkLocalRemoteIdentifiers() {
        return this.linkLocalRemoteIdentifiers;
    }

    public void setLinkLocalRemoteIdentifiers(LinkLocalRemoteIdentifiers linkLocalRemoteIdentifiers) {
        this.linkLocalRemoteIdentifiers = linkLocalRemoteIdentifiers;
    }

    public LinkProtectionType getLinkProtectionType() {
        return this.linkProtectionType;
    }

    public void setLinkProtectionType(LinkProtectionType linkProtectionType) {
        this.linkProtectionType = linkProtectionType;
    }

    public InterfaceSwitchingCapabilityDescriptor getInterfaceSwitchingCapabilityDescriptor() {
        return this.interfaceSwitchingCapabilityDescriptor;
    }

    public void setInterfaceSwitchingCapabilityDescriptor(InterfaceSwitchingCapabilityDescriptor interfaceSwitchingCapabilityDescriptor) {
        this.interfaceSwitchingCapabilityDescriptor = interfaceSwitchingCapabilityDescriptor;
    }

    public SharedRiskLinkGroup getSharedRiskLinkGroup() {
        return this.sharedRiskLinkGroup;
    }

    public void setSharedRiskLinkGroup(SharedRiskLinkGroup sharedRiskLinkGroup) {
        this.sharedRiskLinkGroup = sharedRiskLinkGroup;
    }

    public RemoteASNumber getRemoteASNumber() {
        return this.remoteASNumber;
    }

    public void setRemoteASNumber(RemoteASNumber remoteASNumber) {
        this.remoteASNumber = remoteASNumber;
    }

    public IPv4RemoteASBRID getiPv4RemoteASBRID() {
        return this.iPv4RemoteASBRID;
    }

    public void setiPv4RemoteASBRID(IPv4RemoteASBRID iPv4RemoteASBRID) {
        this.iPv4RemoteASBRID = iPv4RemoteASBRID;
    }

    public int getNumberWLANs() {
        return this.NumberWLANs;
    }

    public void setNumberWLANs(int numberWLANs) {
        this.NumberWLANs = numberWLANs;
    }

    public boolean isWLANFree() {
        return true;
    }

    public Integer getFreeWLAN() {
        int i = 0;
        while (i < this.reservedWLANs.length) {
            if (!this.reservedWLANs[i]) {
                return i;
            }
            ++i;
        }
        return null;
    }

    public void initWLANs() {
        this.withWLANs = true;
        this.occupiedWLANs = new boolean[this.NumberWLANs];
        this.reservedWLANs = new boolean[this.NumberWLANs];
        int i = 0;
        while (i < this.NumberWLANs) {
            this.occupiedWLANs[i] = false;
            this.reservedWLANs[i] = false;
            ++i;
        }
    }

    public void createBitmapLabelSet(int numLabels, int grid, int cs, int n) {
        this.createBitmapLabelSet(numLabels, grid, cs, n, 0, numLabels);
    }

    public void createBitmapLabelSet(int numLabels, int grid, int cs, int n, int lambdaIni, int lambdaEnd) {
        BitmapLabelSet bitmapLabelSet = new BitmapLabelSet();
        DWDMWavelengthLabel dwdmWavelengthLabel = new DWDMWavelengthLabel();
        dwdmWavelengthLabel.setGrid(grid);
        dwdmWavelengthLabel.setChannelSpacing(cs);
        dwdmWavelengthLabel.setN(n);
        bitmapLabelSet.setDwdmWavelengthLabel(dwdmWavelengthLabel);
        int numberBytes = this.getNumberBytes(numLabels);
        byte[] bytesBitMap = new byte[numberBytes];
        int i = 0;
        while (i < numberBytes) {
            bytesBitMap[i] = 0;
            ++i;
        }
        bitmapLabelSet.setBytesBitmap(bytesBitMap);
        byte[] bytesBitMapRes = new byte[numberBytes];
        int i2 = 0;
        while (i2 < numberBytes) {
            bytesBitMapRes[i2] = 0;
            ++i2;
        }
        int numberBytesLambdaIni = this.getNumberBytes(lambdaIni);
        int numberBytesLambdaEnd = this.getNumberBytes(lambdaEnd);
        int i3 = 0;
        while (i3 < numberBytesLambdaIni) {
            bytesBitMapRes[i3] = -1;
            bytesBitMap[i3] = -1;
            ++i3;
        }
        i3 = numberBytesLambdaEnd;
        while (i3 < numberBytes) {
            bytesBitMapRes[i3] = -1;
            bytesBitMap[i3] = -1;
            ++i3;
        }
        System.out.println("Setting Bytes:\n\rBytes: " + numberBytes + "\n\rLambdaIni: " + numberBytesLambdaIni + "\n\rLambdaEnd: " + numberBytesLambdaEnd);
        bitmapLabelSet.setBytesBitmapReserved(bytesBitMapRes);
        bitmapLabelSet.setNumLabels(numLabels);
        this.availableLabels = new AvailableLabels();
        this.availableLabels.setLabelSet(bitmapLabelSet);
    }

    private int getNumberBytes(int numBits) {
        int numberBytes = numBits / 8;
        if (numberBytes * 8 < numBits) {
            ++numberBytes;
        }
        return numberBytes;
    }

    public boolean[] getCopyUnreservedWLANs() {
        boolean[] ret = new boolean[this.NumberWLANs];
        System.arraycopy(this.reservedWLANs, 0, ret, 0, ret.length);
        return ret;
    }

    public void setFreeWLANS(boolean[] orig) {
        this.reservedWLANs = orig;
    }

    public void setWavelengthOccupied(int num_wavelength) {
        if (this.withWLANs) {
            this.occupiedWLANs[num_wavelength] = true;
        } else {
            int num_byte = num_wavelength / 8;
            ((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitMap()[num_byte] = (byte)(((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitMap()[num_byte] | 128 >>> num_wavelength % 8);
        }
    }

    public void setWavelengthFree(int num_wavelength) {
        if (this.withWLANs) {
            this.occupiedWLANs[num_wavelength] = false;
            this.reservedWLANs[num_wavelength] = false;
        } else {
            int num_byte = num_wavelength / 8;
            ((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitMap()[num_byte] = (byte)(((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitMap()[num_byte] & 0xFFFF7F >>> num_wavelength % 8);
        }
    }

    public void setWavelengthReserved(int num_wavelength) {
        if (this.withWLANs) {
            this.reservedWLANs[num_wavelength] = true;
        } else {
            int num_byte = num_wavelength / 8;
            ((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitmapReserved()[num_byte] = (byte)(((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitmapReserved()[num_byte] | 128 >>> num_wavelength % 8);
        }
    }

    public void setWavelengthUnReserved(int num_wavelength) {
        if (this.withWLANs) {
            this.reservedWLANs[num_wavelength] = false;
        } else {
            int num_byte = num_wavelength / 8;
            ((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitmapReserved()[num_byte] = (byte)(((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitmapReserved()[num_byte] & 0xFFFF7F >>> num_wavelength % 8);
        }
    }

    public void setAllWavelengtshUnReserved() {
        if (this.withWLANs) {
            int i = 0;
            while (i < this.reservedWLANs.length) {
                this.reservedWLANs[i] = false;
                ++i;
            }
        } else {
            int num_bytes = ((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitmapReserved().length;
            int i = 0;
            while (i < num_bytes) {
                ((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitmapReserved()[i] = 0;
                ++i;
            }
        }
    }

    public boolean isWavelengthFree(int num_wavelength) {
        if (this.withWLANs) {
            return !this.occupiedWLANs[num_wavelength];
        }
        int num_byte = num_wavelength / 8;
        return (((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitMap()[num_byte] & 128 >>> num_wavelength % 8) == 0;
    }

    public boolean isWavelengthUnreserved(int num_wavelength) {
        if (this.withWLANs) {
            return !this.reservedWLANs[num_wavelength];
        }
        int num_byte = num_wavelength / 8;
        if (((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitmapReserved() == null) {
            return false;
        }
        return (((BitmapLabelSet)this.getAvailableLabels().getLabelSet()).getBytesBitmapReserved()[num_byte] & 128 >>> num_wavelength % 8) == 0;
    }

    public String toString() {
        String ret = "";
        if (this.maximumBandwidth != null) {
            ret = String.valueOf(ret) + this.maximumBandwidth.toStringShort() + "\t";
        }
        if (this.maximumReservableBandwidth != null) {
            ret = String.valueOf(ret) + this.maximumReservableBandwidth.toString() + "\t";
        }
        if (this.unreservedBandwidth != null) {
            ret = String.valueOf(ret) + this.unreservedBandwidth.toStringShort() + "\t";
        }
        if (this.administrativeGroup != null) {
            ret = String.valueOf(ret) + this.administrativeGroup.toString() + "\t";
        }
        if (this.remoteASNumber != null) {
            ret = String.valueOf(ret) + this.remoteASNumber.toString() + "\t";
        }
        if (this.iPv4RemoteASBRID != null) {
            ret = String.valueOf(ret) + this.iPv4RemoteASBRID.toString() + "\t";
        }
        if (this.availableLabels != null) {
            ret = String.valueOf(ret) + this.availableLabels.toString() + "\r\n";
        }
        if (this.iPv4LocalNode != null) {
            ret = String.valueOf(ret) + this.iPv4LocalNode.toString() + "\r\n";
        }
        if (this.iPv4RemoteNode != null) {
            ret = String.valueOf(ret) + this.iPv4RemoteNode.toString() + "\r\n";
        }
        if (this.linkProtectionBGPLS != null) {
            ret = String.valueOf(ret) + this.linkProtectionBGPLS.toString() + "\r\n";
        }
        if (this.trafficEngineeringMetric != null) {
            ret = String.valueOf(ret) + this.trafficEngineeringMetric.toString() + "\r\n";
        }
        if (this.metric != null) {
            ret = String.valueOf(ret) + this.metric.toString() + "\r\n";
        }
        if (this.defaultTEMetric != null) {
            ret = String.valueOf(ret) + this.defaultTEMetric.toString() + "\r\n";
        }
        if (this.mfOTF != null) {
            ret = String.valueOf(ret) + this.mfOTF.toString() + "\r\n";
        }
        if (this.trans != null) {
            ret = String.valueOf(ret) + this.trans.toString() + "\r\n";
        }
        if (this.undirLinkDelay != null) {
            ret = String.valueOf(ret) + this.undirLinkDelay.toString() + "\r\n";
        }
        if (this.minMaxUndirLinkDelay != null) {
            ret = String.valueOf(ret) + this.minMaxUndirLinkDelay.toString() + "\r\n";
        }
        if (this.undirDelayVar != null) {
            ret = String.valueOf(ret) + this.undirDelayVar.toString() + "\r\n";
        }
        if (this.undirLinkLoss != null) {
            ret = String.valueOf(ret) + this.undirLinkLoss.toString() + "\r\n";
        }
        if (this.undirResidualBw != null) {
            ret = String.valueOf(ret) + this.undirResidualBw.toString() + "\r\n";
        }
        if (this.undirAvailableBw != null) {
            ret = String.valueOf(ret) + this.undirAvailableBw.toString() + "\r\n";
        }
        if (this.undirUtilizedBw != null) {
            ret = String.valueOf(ret) + this.undirUtilizedBw.toString() + "\r\n";
        }
        return ret;
    }

    public boolean isVlanLink() {
        return this.vlanLink;
    }

    public void setVlanLink(boolean vlanLink) {
        this.vlanLink = vlanLink;
    }

    public int getVlan() {
        return this.vlan;
    }

    public void setVlan(int vlan) {
        this.vlan = vlan;
    }

    public void setiPv4LocalNode(IPv4RouterIDLocalNodeLinkAttribTLV iPv4RouterIDLocalNode) {
        this.iPv4LocalNode = iPv4RouterIDLocalNode;
    }

    public IPv4RouterIDLocalNodeLinkAttribTLV getiPv4LocalNode() {
        return this.iPv4LocalNode;
    }

    public MetricLinkAttribTLV getMetric() {
        return this.metric;
    }

    public void setMetric(MetricLinkAttribTLV metric) {
        this.metric = metric;
    }

    public LinkProtectionTypeLinkAttribTLV getLinkProtectionBGPLS() {
        return this.linkProtectionBGPLS;
    }

    public void setLinkProtectionBGPLS(LinkProtectionTypeLinkAttribTLV linkProtectionBGPLS) {
        this.linkProtectionBGPLS = linkProtectionBGPLS;
    }

    public DefaultTEMetricLinkAttribTLV getDefaultTEMetric() {
        return this.defaultTEMetric;
    }

    public void setDefaultTEMetric(DefaultTEMetricLinkAttribTLV defaultTEMetric) {
        this.defaultTEMetric = defaultTEMetric;
    }

    public MF_OTPAttribTLV getMfOTF() {
        return this.mfOTF;
    }

    public void setMfOTF(MF_OTPAttribTLV mfOTF) {
        this.mfOTF = mfOTF;
    }

    public TransceiverClassAndAppAttribTLV getTrans() {
        return this.trans;
    }

    public void setTrans(TransceiverClassAndAppAttribTLV trans) {
        this.trans = trans;
    }
}

