/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb;

import es.tid.of.DataPathID;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.FileTEDBUpdater;
import eu.teraflow.tid.tedb.IT_Resources;
import eu.teraflow.tid.tedb.InterDomainEdge;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.Node_Info;
import eu.teraflow.tid.tedb.ReachabilityEntry;
import eu.teraflow.tid.tedb.SSONInformation;
import eu.teraflow.tid.tedb.SSONListener;
import eu.teraflow.tid.tedb.TEDListener;
import eu.teraflow.tid.tedb.TE_Information;
import eu.teraflow.tid.tedb.WSONInformation;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTEDB
implements DomainTEDB {
    private Inet4Address domainID;
    private IT_Resources itResources;
    private ArrayList<TEDListener> registeredAlgorithms;
    private ArrayList<SSONListener> registeredAlgorithmssson;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph;
    private LinkedList<InterDomainEdge> interDomainLinks = new LinkedList();
    private LinkedList<IntraDomainEdge> intraDomainEdges = new LinkedList();
    private ReachabilityEntry reachabilityEntry;
    private WSONInformation WSONinfo = null;
    private SSONInformation SSONinfo = null;
    private Lock TEDBlock;
    private Hashtable<Object, Node_Info> NodeTable;
    private boolean multidomain = false;
    Logger log = LoggerFactory.getLogger((String)"TEDBParser");

    public SimpleTEDB() {
        this.registeredAlgorithms = new ArrayList();
        this.registeredAlgorithmssson = new ArrayList();
        this.TEDBlock = new ReentrantLock();
        this.NodeTable = new Hashtable();
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getDuplicatedNetworkGraph() {
        SimpleDirectedWeightedGraph graphCopy;
        this.TEDBlock.lock();
        try {
            graphCopy = (SimpleDirectedWeightedGraph)this.networkGraph.clone();
        }
        finally {
            this.TEDBlock.unlock();
        }
        return graphCopy;
    }

    @Override
    public void createGraph() {
        this.networkGraph = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
        this.reachabilityEntry = new ReachabilityEntry();
    }

    @Override
    public void initializeFromFile(String file) {
        this.initializeFromFile(file, null, false, 0, Integer.MAX_VALUE, false, false);
    }

    @Override
    public void initializeFromFile(String file, String layer) {
        this.initializeFromFile(file, layer, false, 0, Integer.MAX_VALUE, false, false);
    }

    public void initializeFromFile(String file, String layer, boolean multidomain) {
        this.initializeFromFile(file, layer, multidomain, 0, Integer.MAX_VALUE, false, false);
    }

    public void initializeFromFile(String file, String layer, boolean multidomain, boolean isSSON) {
        this.initializeFromFile(file, layer, multidomain, 0, Integer.MAX_VALUE, isSSON, false);
    }

    public void initializeFromFile(String file, String layer, boolean multidomain, int lambdaIni, int lambdaEnd) {
        this.initializeFromFile(file, layer, multidomain, 0, Integer.MAX_VALUE, false, false);
    }

    public void initializeFromFile(String file, String layer, boolean multidomain, int lambdaIni, int lambdaEnd, boolean isSSON, boolean readOnlyInterDomainLinks) {
        this.initializeFromFile(file, layer, multidomain, lambdaIni, lambdaEnd, isSSON, readOnlyInterDomainLinks, false);
    }

    public void initializeFromFile(String file, String layer, boolean multidomain, int lambdaIni, int lambdaEnd, boolean isSSON, boolean readOnlyInterDomainLinks, boolean isWLAN) {
        Node_Info destination;
        Node_Info origin;
        block19: {
            block17: {
                block18: {
                    this.domainID = FileTEDBUpdater.getDomainIDfromSimpleDomain(file);
                    if (!readOnlyInterDomainLinks) break block17;
                    this.log.info("Read Only Inter Domain Links");
                    this.networkGraph = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
                    if (!multidomain) {
                        this.interDomainLinks = FileTEDBUpdater.readInterDomainLinks(file);
                    }
                    this.reachabilityEntry = new ReachabilityEntry();
                    if (!multidomain) {
                        FileTEDBUpdater.getDomainReachabilityFromFile(file, this.reachabilityEntry);
                    }
                    if (!(isSSON & !isWLAN)) break block18;
                    this.SSONinfo = FileTEDBUpdater.getSSONInformation(file);
                    break block19;
                }
                if (isWLAN) break block19;
                this.WSONinfo = FileTEDBUpdater.getWSONInformation(file);
                break block19;
            }
            if (isSSON && !isWLAN) {
                this.networkGraph = FileTEDBUpdater.readNetwork(file, layer, multidomain, lambdaIni, lambdaEnd, isSSON);
                this.SSONinfo = FileTEDBUpdater.getSSONInformation(file);
            } else if (isWLAN) {
                this.networkGraph = FileTEDBUpdater.readNetwork(file, layer, multidomain, lambdaIni, lambdaEnd, isSSON);
            } else {
                this.networkGraph = FileTEDBUpdater.readNetwork(file, layer, multidomain, lambdaIni, lambdaEnd);
                this.WSONinfo = FileTEDBUpdater.getWSONInformation(file);
            }
            for (Object address : this.networkGraph.vertexSet()) {
                Node_Info ni = new Node_Info();
                if (address instanceof Inet4Address) {
                    ni.setIpv4AddressLocalNode((Inet4Address)address);
                    ni.setIpv4Address((Inet4Address)address);
                } else if (address instanceof DataPathID) {
                    ni.setDataPathLocalNode((DataPathID)address);
                }
                ni.setLearntFrom("Fom XML");
                ni.setAs_number(this.domainID);
                this.NodeTable.put(address, ni);
            }
            for (IntraDomainEdge id : this.networkGraph.edgeSet()) {
                try {
                    Inet4Address ipSource = (Inet4Address)id.getSource();
                    Inet4Address ipDest = (Inet4Address)id.getTarget();
                    id.setLearntFrom("From XML");
                    origin = new Node_Info();
                    destination = new Node_Info();
                    origin.setIpv4AddressLocalNode(ipSource);
                    origin.setAs_number(this.domainID);
                    origin.setLearntFrom("FromXML");
                    destination.setIpv4AddressLocalNode(ipDest);
                    destination.setAs_number(this.domainID);
                    destination.setLearntFrom("FromXML");
                    id.setLocal_Node_Info(origin);
                    id.setRemote_Node_Info(destination);
                    this.NodeTable.get(ipSource).setSID(id.getSrc_sid());
                    this.NodeTable.get(ipDest).setSID(id.getDst_sid());
                }
                catch (Exception e1) {
                    DataPathID dpSource = (DataPathID)id.getSource();
                    DataPathID dpDest = (DataPathID)id.getTarget();
                    id.setLearntFrom("From XML");
                    Node_Info origin2 = new Node_Info();
                    Node_Info destination2 = new Node_Info();
                    origin2.setDataPathLocalNode(dpSource);
                    origin2.setAs_number(this.domainID);
                    origin2.setLearntFrom("FromXML");
                    destination2.setDataPathLocalNode(dpDest);
                    destination2.setAs_number(this.domainID);
                    destination2.setLearntFrom("FromXML");
                    id.setLocal_Node_Info(origin2);
                    id.setRemote_Node_Info(destination2);
                }
            }
        }
        this.interDomainLinks = !multidomain ? FileTEDBUpdater.readInterDomainLinks(file) : new LinkedList();
        this.reachabilityEntry = new ReachabilityEntry();
        if (!multidomain) {
            FileTEDBUpdater.getDomainReachabilityFromFile(file, this.reachabilityEntry);
        }
        for (InterDomainEdge id : this.interDomainLinks) {
            try {
                Inet4Address ipSource = (Inet4Address)id.src_router_id;
                Inet4Address ipDest = (Inet4Address)id.dst_router_id;
                id.setLearntFrom("From XML");
                Node_Info origin3 = new Node_Info();
                Node_Info destination3 = new Node_Info();
                origin3.setIpv4AddressLocalNode(ipSource);
                origin3.setAs_number(this.domainID);
                origin3.setLearntFrom("FromXML");
                destination3.setIpv4AddressLocalNode(ipDest);
                destination3.setAs_number((Inet4Address)id.domain_dst_router);
                destination3.setLearntFrom("FromXML");
                id.setLocal_Node_Info(origin3);
                id.setRemote_Node_Info(destination3);
            }
            catch (Exception e) {
                DataPathID dpSource = (DataPathID)id.src_router_id;
                DataPathID dpDest = (DataPathID)id.dst_router_id;
                id.setLearntFrom("From XML");
                origin = new Node_Info();
                destination = new Node_Info();
                origin.setDataPathLocalNode(dpSource);
                origin.setAs_number(this.domainID);
                origin.setLearntFrom("FromXML");
                destination.setDataPathLocalNode(dpDest);
                destination.setAs_number((Inet4Address)id.domain_dst_router);
                destination.setLearntFrom("FromXML");
                id.setLocal_Node_Info(origin);
                id.setRemote_Node_Info(destination);
            }
        }
    }

    public void notifyAlgorithms(int lambdaIni, int lambdaEnd) {
        LinkedList<Object> ipListScr = new LinkedList<Object>();
        LinkedList<Object> ipListDst = new LinkedList<Object>();
        Set it = this.networkGraph.edgeSet();
        int numLabels = 0;
        for (IntraDomainEdge edge : it) {
            int j;
            numLabels = edge.TE_info.getAvailableLabels().getLabelSet().getNumLabels();
            int i = 0;
            while (i < lambdaIni) {
                ipListScr.add(edge.getSource());
                ipListDst.add(edge.getTarget());
                j = 0;
                while (j < this.registeredAlgorithms.size()) {
                    this.registeredAlgorithms.get(j).notifyWavelengthReservation(ipListScr, ipListDst, i);
                    ++j;
                }
                j = 0;
                while (j < this.registeredAlgorithmssson.size()) {
                    this.registeredAlgorithmssson.get(j).notifyWavelengthReservation(ipListScr, ipListDst, i);
                    ++j;
                }
                this.notifyWavelengthReservation(ipListScr, ipListDst, i, false);
                ipListScr.remove();
                ipListDst.remove();
                ++i;
            }
            i = lambdaEnd;
            while (i < numLabels) {
                ipListScr.add(edge.getSource());
                ipListDst.add(edge.getTarget());
                j = 0;
                while (j < this.registeredAlgorithms.size()) {
                    this.registeredAlgorithms.get(j).notifyWavelengthReservation(ipListScr, ipListDst, i);
                    ++j;
                }
                j = 0;
                while (j < this.registeredAlgorithmssson.size()) {
                    this.registeredAlgorithmssson.get(j).notifyWavelengthReservation(ipListScr, ipListDst, i);
                    ++j;
                }
                this.notifyWavelengthReservation(ipListScr, ipListDst, i, false);
                ipListScr.remove();
                ipListDst.remove();
                ++i;
            }
        }
    }

    @Override
    public boolean belongsToDomain(Object addr) {
        byte[] addrbytes = ((Inet4Address)addr).getAddress();
        int i = 0;
        while (i < 4) {
            addrbytes[i] = (byte)(addrbytes[i] & this.reachabilityEntry.getMask()[i]);
            ++i;
        }
        this.log.info("Belongs to domain retunrs: " + Arrays.equals(addrbytes, this.reachabilityEntry.getAggregatedIPRange().getAddress()));
        return Arrays.equals(addrbytes, this.reachabilityEntry.getAggregatedIPRange().getAddress());
    }

    public LinkedList<IntraDomainEdge> getIntraDomainEdges() {
        return this.intraDomainEdges;
    }

    public void setIntraDomainEdges(LinkedList<IntraDomainEdge> intraDomainEdges) {
        this.intraDomainEdges = intraDomainEdges;
    }

    @Override
    public ReachabilityEntry getReachabilityEntry() {
        return this.reachabilityEntry;
    }

    public void setReachabilityEntry(ReachabilityEntry reachabilityEntry) {
        this.reachabilityEntry = reachabilityEntry;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getNetworkGraph() {
        return this.networkGraph;
    }

    public void setNetworkGraph(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph) {
        this.networkGraph = networkGraph;
    }

    @Override
    public LinkedList<InterDomainEdge> getInterDomainLinks() {
        return this.interDomainLinks;
    }

    public void setInterDomainLinks(LinkedList<InterDomainEdge> interDomainLinks) {
        this.interDomainLinks = interDomainLinks;
    }

    public InterDomainEdge getInterdomainLink(Object src, Object dst) {
        int size = this.interDomainLinks.size();
        InterDomainEdge edge = new InterDomainEdge(src, dst);
        int i = 0;
        while (i < size) {
            InterDomainEdge edge_i = this.interDomainLinks.get(i);
            if (edge_i.equals((Object)edge)) {
                return edge_i;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String printTopology() {
        Set vetexSet = this.networkGraph.vertexSet();
        Iterator vertexIterator = vetexSet.iterator();
        String topoString = "Nodes: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = String.valueOf(topoString) + "\t" + vertex.toString() + "\r\n";
        }
        topoString = String.valueOf(topoString) + "Node Information Table::: \r\n" + this.NodeTable.toString() + "\r\n";
        Set edgeSet = this.networkGraph.edgeSet();
        if (edgeSet != null) {
            Iterator edgeIterator = edgeSet.iterator();
            topoString = String.valueOf(topoString) + "Intradomain Link list: \r\n";
            while (edgeIterator.hasNext()) {
                IntraDomainEdge edge = (IntraDomainEdge)((Object)edgeIterator.next());
                topoString = String.valueOf(topoString) + "\t" + edge.toString() + "\n";
            }
        }
        if (this.interDomainLinks != null) {
            topoString = String.valueOf(topoString) + this.printInterDomainLinks();
        }
        return topoString;
    }

    @Override
    public String printInterDomainLinks() {
        String topoString = "";
        int size = this.interDomainLinks.size();
        this.log.info("Size of InterDomainLinks: " + size);
        topoString = "Interdomain Link list: \r\n";
        int i = 0;
        while (i < size) {
            InterDomainEdge edge = this.interDomainLinks.get(i);
            topoString = String.valueOf(topoString) + "\t" + edge.toString() + "\r\n";
            ++i;
        }
        return topoString;
    }

    @Override
    public boolean isITtedb() {
        return false;
    }

    @Override
    public void notifyWavelengthReservationWLAN(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, LinkedList<Integer> wlans, boolean bidirectional) {
        int i;
        this.TEDBlock.lock();
        try {
            i = 0;
            while (i < sourceVertexList.size()) {
                IntraDomainEdge edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i)));
                edge.getTE_info().setWavelengthReserved(wlans.get(i));
                this.log.info("Reservo: " + sourceVertexList.get(i).toString() + "-" + targetVertexList.get(i).toString() + " wavelength: " + wlans.get(i) + " bidirectional" + bidirectional);
                if (bidirectional) {
                    edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(targetVertexList.get(i), sourceVertexList.get(i)));
                    edge.getTE_info().setWavelengthReserved(wlans.get(i));
                }
                ++i;
            }
        }
        finally {
            this.TEDBlock.unlock();
        }
        i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyWavelengthReservation(sourceVertexList, targetVertexList, wlans.get(i));
            if (bidirectional) {
                this.registeredAlgorithms.get(i).notifyWavelengthReservation(targetVertexList, sourceVertexList, wlans.get(i));
            }
            ++i;
        }
    }

    @Override
    public void notifyWavelengthReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, boolean bidirectional) {
        int i;
        this.TEDBlock.lock();
        try {
            i = 0;
            while (i < sourceVertexList.size()) {
                IntraDomainEdge edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i)));
                edge.getTE_info().setWavelengthReserved(wavelength);
                this.log.info("Reservo: " + sourceVertexList.get(i).toString() + "-" + targetVertexList.get(i).toString() + " wavelength: " + wavelength + " bidirectional" + bidirectional);
                if (bidirectional) {
                    edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(targetVertexList.get(i), sourceVertexList.get(i)));
                    edge.getTE_info().setWavelengthReserved(wavelength);
                }
                ++i;
            }
        }
        finally {
            this.TEDBlock.unlock();
        }
        i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyWavelengthReservation(sourceVertexList, targetVertexList, wavelength);
            if (bidirectional) {
                this.registeredAlgorithms.get(i).notifyWavelengthReservation(targetVertexList, sourceVertexList, wavelength);
            }
            ++i;
        }
    }

    @Override
    public void notifyWavelengthReservationSSON(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, boolean bidirectional, int m) {
        this.TEDBlock.lock();
        try {
            int j = 0;
            while (j < 2 * m) {
                int i = 0;
                while (i < sourceVertexList.size()) {
                    IntraDomainEdge edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i)));
                    edge.getTE_info().setWavelengthReserved(wavelength - m + j);
                    if (bidirectional) {
                        edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(targetVertexList.get(i), sourceVertexList.get(i)));
                        edge.getTE_info().setWavelengthReserved(wavelength - m + j);
                    }
                    ++i;
                }
                ++j;
            }
        }
        finally {
            this.TEDBlock.unlock();
        }
        int i = 0;
        while (i < this.registeredAlgorithmssson.size()) {
            this.registeredAlgorithmssson.get(i).notifyWavelengthReservationSSON(sourceVertexList, targetVertexList, wavelength, m);
            if (bidirectional) {
                this.registeredAlgorithmssson.get(i).notifyWavelengthReservationSSON(targetVertexList, sourceVertexList, wavelength, m);
            }
            ++i;
        }
    }

    @Override
    public void notifyWavelengthEndReservationSSON(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, boolean bidirectional, int m) {
        this.TEDBlock.lock();
        try {
            int j = 0;
            while (j < 2 * m) {
                int i = 0;
                while (i < sourceVertexList.size()) {
                    IntraDomainEdge edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i)));
                    edge.getTE_info().setWavelengthUnReserved(wavelength - m + j);
                    if (bidirectional) {
                        edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(targetVertexList.get(i), sourceVertexList.get(i)));
                        edge.getTE_info().setWavelengthUnReserved(wavelength - m + j);
                    }
                    ++i;
                }
                ++j;
            }
        }
        finally {
            this.TEDBlock.unlock();
        }
        int i = 0;
        while (i < this.registeredAlgorithmssson.size()) {
            this.registeredAlgorithmssson.get(i).notifyWavelengthEndReservationSSON(sourceVertexList, targetVertexList, wavelength, m);
            if (bidirectional) {
                this.registeredAlgorithmssson.get(i).notifyWavelengthEndReservationSSON(targetVertexList, sourceVertexList, wavelength, m);
            }
            ++i;
        }
    }

    @Override
    public void notifyWavelengthEndReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, boolean bidirectional) {
        int i;
        this.TEDBlock.lock();
        try {
            i = 0;
            while (i < sourceVertexList.size()) {
                IntraDomainEdge edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i)));
                edge.getTE_info().setWavelengthUnReserved(wavelength);
                if (bidirectional) {
                    edge = (IntraDomainEdge)((Object)this.networkGraph.getEdge(targetVertexList.get(i), sourceVertexList.get(i)));
                    edge.getTE_info().setWavelengthUnReserved(wavelength);
                }
                ++i;
            }
        }
        finally {
            this.TEDBlock.unlock();
        }
        i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyWavelengthEndReservation(sourceVertexList, targetVertexList, wavelength);
            if (bidirectional) {
                this.registeredAlgorithms.get(i).notifyWavelengthEndReservation(targetVertexList, sourceVertexList, wavelength);
            }
            ++i;
        }
    }

    @Override
    public boolean containsVertex(Object vertex) {
        return this.networkGraph.containsVertex(vertex);
    }

    @Override
    public Hashtable<Object, Node_Info> getNodeTable() {
        return this.NodeTable;
    }

    public void setNodeTable(Hashtable<Object, Node_Info> nodeTable) {
        this.NodeTable = nodeTable;
    }

    public boolean isMultidomain() {
        return this.multidomain;
    }

    public void setMultidomain(boolean multidomain) {
        this.multidomain = multidomain;
    }

    @Override
    public void registerSSON(SSONListener algo) {
        this.registeredAlgorithmssson.add(algo);
    }

    @Override
    public void register(TEDListener algo) {
        this.registeredAlgorithms.add(algo);
    }

    @Override
    public void notifyWavelengthChange(Object localInterfaceIPAddress, Object remoteInterfaceIPAddress, BitmapLabelSet previousBitmapLabelSet, BitmapLabelSet newBitmapLabelSet) {
        int i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyWavelengthStatusChange(localInterfaceIPAddress, remoteInterfaceIPAddress, previousBitmapLabelSet, newBitmapLabelSet);
            ++i;
        }
        if (this.registeredAlgorithms.isEmpty()) {
            i = 0;
            while (i < this.registeredAlgorithmssson.size()) {
                this.registeredAlgorithmssson.get(i).notifyWavelengthStatusChange(localInterfaceIPAddress, remoteInterfaceIPAddress, previousBitmapLabelSet, newBitmapLabelSet);
                ++i;
            }
        }
    }

    @Override
    public void notifyNewVertex(Object vertex) {
        int i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyNewVertex(vertex);
            ++i;
        }
        i = 0;
        while (i < this.registeredAlgorithmssson.size()) {
            this.registeredAlgorithmssson.get(i).notifyNewVertex(vertex);
            ++i;
        }
    }

    @Override
    public void notifyNewEdge(Object source, Object destination) {
        int i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyNewEdge(source, destination);
            ++i;
        }
        i = 0;
        while (i < this.registeredAlgorithmssson.size()) {
            this.registeredAlgorithmssson.get(i).notifyNewEdge(source, destination);
            ++i;
        }
    }

    @Override
    public WSONInformation getWSONinfo() {
        return this.WSONinfo;
    }

    @Override
    public SSONInformation getSSONinfo() {
        return this.SSONinfo;
    }

    @Override
    public void clearAllReservations() {
        if (this.WSONinfo != null) {
            this.TEDBlock.lock();
            try {
                Set edgeSet = this.networkGraph.edgeSet();
                for (IntraDomainEdge edge : edgeSet) {
                    edge.TE_info.setAllWavelengtshUnReserved();
                }
            }
            finally {
                this.TEDBlock.unlock();
            }
            int i = 0;
            while (i < this.registeredAlgorithms.size()) {
                this.registeredAlgorithms.get(i).notifyTEDBFullUpdate();
                ++i;
            }
        }
    }

    public Lock getTEDBlock() {
        return this.TEDBlock;
    }

    public void setTEDBlock(Lock tEDBlock) {
        this.TEDBlock = tEDBlock;
    }

    @Override
    public void notifyNewEdgeIP(Object source, Object destination, TE_Information informationTEDB) {
    }

    @Override
    public void setWSONinfo(WSONInformation wSONinfo) {
        this.WSONinfo = wSONinfo;
    }

    @Override
    public void setSSONinfo(SSONInformation sSONinfo) {
        this.SSONinfo = sSONinfo;
    }

    public String printBaseTopology() {
        Set vetexSet = this.networkGraph.vertexSet();
        Iterator vertexIterator = vetexSet.iterator();
        String topoString = "NodesFEO: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = String.valueOf(topoString) + "\t" + vertex.toString() + "\r\n";
        }
        topoString = String.valueOf(topoString) + "Intradomain Link list: \r\n";
        Set edgeSet = this.networkGraph.edgeSet();
        for (IntraDomainEdge edge : edgeSet) {
            topoString = String.valueOf(topoString) + "\t" + edge.toString() + "\r\n";
        }
        return topoString;
    }

    @Override
    public Inet4Address getDomainID() {
        return this.domainID;
    }

    public void setDomainID(Inet4Address domainID) {
        this.domainID = domainID;
    }

    @Override
    public Set<IntraDomainEdge> getIntraDomainLinks() {
        return this.getNetworkGraph().edgeSet();
    }

    @Override
    public Set<Object> getIntraDomainLinksvertexSet() {
        return this.getNetworkGraph().vertexSet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domainID == null ? 0 : this.domainID.hashCode());
        result = 31 * result + (this.intraDomainEdges == null ? 0 : this.intraDomainEdges.hashCode());
        result = 31 * result + (this.networkGraph == null ? 0 : this.networkGraph.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean flagEqual;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTEDB other = (SimpleTEDB)obj;
        if (this.intraDomainEdges == null ? other.intraDomainEdges != null : !this.intraDomainEdges.equals(other.intraDomainEdges)) {
            return false;
        }
        if (this.networkGraph == null && other.networkGraph != null) {
            return false;
        }
        for (Object v : this.networkGraph.vertexSet()) {
            if (other.networkGraph.containsVertex(v)) continue;
            return false;
        }
        for (IntraDomainEdge e : this.networkGraph.edgeSet()) {
            flagEqual = false;
            for (IntraDomainEdge otherE : other.networkGraph.edgeSet()) {
                if (!e.toString().equals(otherE.toString())) continue;
                flagEqual = true;
            }
            if (flagEqual) continue;
            return false;
        }
        for (IntraDomainEdge e : other.networkGraph.edgeSet()) {
            flagEqual = false;
            for (IntraDomainEdge otherE : this.networkGraph.edgeSet()) {
                if (!e.toString().equals(otherE.toString())) continue;
                flagEqual = true;
            }
            if (flagEqual) continue;
            return false;
        }
        return true;
    }

    @Override
    public IT_Resources getItResources() {
        return this.itResources;
    }

    @Override
    public void setItResources(IT_Resources itResources) {
        this.itResources = itResources;
    }
}

