/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb;

import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import eu.teraflow.tid.tedb.ReachabilityEntry;
import java.net.Inet4Address;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReachabilityManager {
    LinkedList<ReachabilityEntry> reachability;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");

    public ReachabilityManager() {
        this.reachability = new LinkedList();
    }

    public Inet4Address getDomain(Inet4Address endpointAddress) {
        for (ReachabilityEntry ra : this.reachability) {
            if (!this.belongsToDomain(endpointAddress, ra.mask, ra.aggregatedIPRange)) continue;
            return ra.domainId;
        }
        return null;
    }

    public boolean belongsToDomain(Inet4Address nodeAddress, byte[] mask, Inet4Address aggregatedIPRange) {
        byte[] bytesAggregatedIPRange = aggregatedIPRange.getAddress();
        byte[] bytesNodeAddress = nodeAddress.getAddress();
        boolean found = true;
        int i = 0;
        while (i < 4) {
            if ((byte)(bytesAggregatedIPRange[i] & mask[i] & 0xFF) != (byte)(bytesNodeAddress[i] & mask[i] & 0xFF)) {
                found = false;
                return found;
            }
            ++i;
        }
        return found;
    }

    public void addEROSubobject(Inet4Address domainId, EROSubobject eroso) {
        if (eroso.getType() == 1) {
            this.log.info("Adding IPv4 ERO Subobject to the Reachability Database");
            IPv4prefixEROSubobject ipv4eroso = (IPv4prefixEROSubobject)eroso;
            this.log.info("prefix " + ipv4eroso.getPrefix());
            long resta = (1L << ipv4eroso.getPrefix()) - 1L;
            long maskLong = resta << 32 - ipv4eroso.getPrefix();
            byte[] mask = new byte[]{(byte)(maskLong >>> 24 & 0xFFL), (byte)(maskLong >>> 16 & 0xFFL), (byte)(maskLong >>> 8 & 0xFFL), (byte)(maskLong & 0xFFL)};
            this.log.info("mask: " + (mask[0] & 0xFF) + "." + (mask[1] & 0xFF) + "." + (mask[2] & 0xFF) + "." + (mask[3] & 0xFF));
            this.log.info("Domain ID: " + domainId + " mask " + mask + " IPv4 Address: " + ipv4eroso.getIpv4address());
            this.addIPv4Entry(domainId, mask, ipv4eroso.getIpv4address(), ipv4eroso.getPrefix());
        }
    }

    private void addIPv4Entry(Inet4Address domainId, byte[] mask, Inet4Address aggregatedIPRange, int prefix) {
        ReachabilityEntry ra = new ReachabilityEntry();
        ra.aggregatedIPRange = aggregatedIPRange;
        ra.mask = mask;
        ra.domainId = domainId;
        ra.prefix = prefix;
        if (!this.reachability.contains(ra)) {
            this.reachability.add(ra);
        }
    }

    public String printReachability() {
        Iterator reachabIterator = this.reachability.iterator();
        String reachabilityString = "Reachability entries: \r\n";
        while (reachabIterator.hasNext()) {
            ReachabilityEntry entry = (ReachabilityEntry)reachabIterator.next();
            reachabilityString = String.valueOf(reachabilityString) + "\t" + entry.toString() + "\r\n";
        }
        return reachabilityString;
    }

    public LinkedList<ReachabilityEntry> getReachability() {
        return this.reachability;
    }
}

