/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.FileTEDBUpdater;
import eu.teraflow.tid.tedb.IT_Resources;
import eu.teraflow.tid.tedb.InterDomainEdge;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.Node_Info;
import eu.teraflow.tid.tedb.ReachabilityEntry;
import eu.teraflow.tid.tedb.SSONInformation;
import eu.teraflow.tid.tedb.SSONListener;
import eu.teraflow.tid.tedb.TEDListener;
import eu.teraflow.tid.tedb.TE_Information;
import eu.teraflow.tid.tedb.WSONInformation;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;

public class MultiLayerTEDB
implements DomainTEDB {
    private ArrayList<TEDListener> registeredAlgorithms = new ArrayList();
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> upperLayerGraph;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> lowerLayerGraph;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> interLayerGraph;
    private ReachabilityEntry reachabilityEntry;
    private WSONInformation WSONinfo = null;
    private Lock TEDBlock = new ReentrantLock();
    private LinkedList<InterDomainEdge> interDomainLinks;
    private Hashtable<Object, Object> RelationNodesInterlayer;

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getUpperLayerGraph() {
        return this.upperLayerGraph;
    }

    public void setUpperLayerGraph(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> upperLayerGraph) {
        this.upperLayerGraph = upperLayerGraph;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getLowerLayerGraph() {
        return this.lowerLayerGraph;
    }

    public void setLowerLayerGraph(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> lowerLayerGraph) {
        this.lowerLayerGraph = lowerLayerGraph;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getInterLayerGraph() {
        return this.interLayerGraph;
    }

    public void setInterLayerGraph(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> interLayerGraph) {
        this.interLayerGraph = interLayerGraph;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getDuplicatedUpperLayerkGraph() {
        SimpleDirectedWeightedGraph graphCopy;
        this.TEDBlock.lock();
        try {
            graphCopy = (SimpleDirectedWeightedGraph)this.upperLayerGraph.clone();
        }
        finally {
            this.TEDBlock.unlock();
        }
        return graphCopy;
    }

    public Hashtable<Object, Object> getRelationNodesInterlayer() {
        return this.RelationNodesInterlayer;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getDuplicatedLowerLayerkGraph() {
        SimpleDirectedWeightedGraph graphCopy;
        this.TEDBlock.lock();
        try {
            graphCopy = (SimpleDirectedWeightedGraph)this.lowerLayerGraph.clone();
        }
        finally {
            this.TEDBlock.unlock();
        }
        return graphCopy;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getDuplicatedInterLayerGraph() {
        SimpleDirectedWeightedGraph graphCopy;
        this.TEDBlock.lock();
        try {
            graphCopy = (SimpleDirectedWeightedGraph)this.interLayerGraph.clone();
        }
        finally {
            this.TEDBlock.unlock();
        }
        return graphCopy;
    }

    @Override
    public void initializeFromFile(String file) {
        this.upperLayerGraph = FileTEDBUpdater.readNetwork(file, "mpls");
        this.lowerLayerGraph = FileTEDBUpdater.readNetwork(file, "wson");
        this.interLayerGraph = FileTEDBUpdater.readNetwork(file, "interlayer");
        this.WSONinfo = FileTEDBUpdater.getWSONInformation(file, "wson");
        this.interDomainLinks = FileTEDBUpdater.readInterDomainLinks(file);
        this.reachabilityEntry = new ReachabilityEntry();
        FileTEDBUpdater.getDomainReachabilityFromFile(file, this.reachabilityEntry, "mpls");
    }

    @Override
    public void initializeFromFile(String file, String learnFrom) {
    }

    @Override
    public boolean isITtedb() {
        return false;
    }

    @Override
    public String printTopology() {
        Set vetexSet = this.upperLayerGraph.vertexSet();
        Iterator vertexIterator = vetexSet.iterator();
        String topoString = "MPLS Nodes: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = String.valueOf(topoString) + "\t" + vertex.toString() + "\r\n";
        }
        topoString = String.valueOf(topoString) + "MPLS Link list: \r\n";
        Set edgeSet = this.upperLayerGraph.edgeSet();
        for (IntraDomainEdge edge : edgeSet) {
            topoString = String.valueOf(topoString) + "\t" + edge.toString() + "\r\n";
        }
        vetexSet = this.lowerLayerGraph.vertexSet();
        vertexIterator = vetexSet.iterator();
        topoString = "GMPLS Nodes: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = String.valueOf(topoString) + "\t" + vertex.toString() + "\r\n";
        }
        topoString = String.valueOf(topoString) + "gmpls Link list: \r\n";
        edgeSet = this.lowerLayerGraph.edgeSet();
        for (IntraDomainEdge edge : edgeSet) {
            topoString = String.valueOf(topoString) + "\t" + edge.toString() + "\r\n";
        }
        topoString = String.valueOf(topoString) + "InterLayer list: \r\n";
        edgeSet = this.interLayerGraph.edgeSet();
        for (IntraDomainEdge edge : edgeSet) {
            topoString = String.valueOf(topoString) + "\t" + edge.toString() + "\r\n";
        }
        topoString = String.valueOf(topoString) + this.printInterDomainLinks();
        return topoString;
    }

    @Override
    public boolean belongsToDomain(Object addr) {
        byte[] addrbytes = ((Inet4Address)addr).getAddress();
        int i = 0;
        while (i < 4) {
            addrbytes[i] = (byte)(addrbytes[i] & this.reachabilityEntry.getMask()[i]);
            ++i;
        }
        return Arrays.equals(addrbytes, this.reachabilityEntry.getAggregatedIPRange().getAddress());
    }

    @Override
    public ReachabilityEntry getReachabilityEntry() {
        return this.reachabilityEntry;
    }

    @Override
    public LinkedList<InterDomainEdge> getInterDomainLinks() {
        return this.interDomainLinks;
    }

    @Override
    public String printInterDomainLinks() {
        String topoString = "";
        int size = this.interDomainLinks.size();
        topoString = "Interdomain Link list: \r\n";
        int i = 0;
        while (i < size) {
            InterDomainEdge edge = this.interDomainLinks.get(i);
            topoString = String.valueOf(topoString) + "\t" + edge.toString() + "\r\n";
            ++i;
        }
        return topoString;
    }

    @Override
    public boolean containsVertex(Object vertex) {
        return this.upperLayerGraph.containsVertex(vertex);
    }

    @Override
    public WSONInformation getWSONinfo() {
        return this.WSONinfo;
    }

    @Override
    public void notifyWavelengthReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, boolean bidirectional) {
        int i;
        this.TEDBlock.lock();
        try {
            i = 0;
            while (i < sourceVertexList.size()) {
                IntraDomainEdge edge = (IntraDomainEdge)((Object)this.lowerLayerGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i)));
                edge.getTE_info().setWavelengthReserved(wavelength);
                if (bidirectional) {
                    edge = (IntraDomainEdge)((Object)this.lowerLayerGraph.getEdge(targetVertexList.get(i), sourceVertexList.get(i)));
                    edge.getTE_info().setWavelengthReserved(wavelength);
                }
                ++i;
            }
        }
        finally {
            this.TEDBlock.unlock();
        }
        i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyWavelengthReservation(sourceVertexList, targetVertexList, wavelength);
            if (bidirectional) {
                this.registeredAlgorithms.get(i).notifyWavelengthReservation(targetVertexList, sourceVertexList, wavelength);
            }
            ++i;
        }
    }

    @Override
    public void notifyWavelengthEndReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, boolean bidirectional) {
        int i;
        this.TEDBlock.lock();
        try {
            i = 0;
            while (i < sourceVertexList.size()) {
                IntraDomainEdge edge = (IntraDomainEdge)((Object)this.lowerLayerGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i)));
                edge.getTE_info().setWavelengthUnReserved(wavelength);
                if (bidirectional) {
                    edge = (IntraDomainEdge)((Object)this.lowerLayerGraph.getEdge(targetVertexList.get(i), sourceVertexList.get(i)));
                    edge.getTE_info().setWavelengthUnReserved(wavelength);
                }
                ++i;
            }
        }
        finally {
            this.TEDBlock.unlock();
        }
        i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyWavelengthEndReservation(sourceVertexList, targetVertexList, wavelength);
            if (bidirectional) {
                this.registeredAlgorithms.get(i).notifyWavelengthEndReservation(targetVertexList, sourceVertexList, wavelength);
            }
            ++i;
        }
    }

    @Override
    public void notifyWavelengthChange(Object localInterfaceIPAddress, Object remoteInterfaceIPAddress, BitmapLabelSet previousBitmapLabelSet, BitmapLabelSet newBitmapLabelSet) {
        int i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyWavelengthStatusChange(localInterfaceIPAddress, remoteInterfaceIPAddress, previousBitmapLabelSet, newBitmapLabelSet);
            ++i;
        }
    }

    @Override
    public void register(TEDListener compAlgPreComp) {
        this.registeredAlgorithms.add(compAlgPreComp);
    }

    @Override
    public void notifyNewVertex(Object vertex) {
        int i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyNewVertex(vertex);
            ++i;
        }
    }

    @Override
    public void notifyNewEdge(Object source, Object destination) {
        int i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyNewEdge(source, destination);
            ++i;
        }
    }

    @Override
    public void clearAllReservations() {
        if (this.WSONinfo != null) {
            this.TEDBlock.lock();
            try {
                Set edgeSet = this.lowerLayerGraph.edgeSet();
                for (IntraDomainEdge edge : edgeSet) {
                    edge.TE_info.setAllWavelengtshUnReserved();
                }
            }
            finally {
                this.TEDBlock.unlock();
            }
            int i = 0;
            while (i < this.registeredAlgorithms.size()) {
                this.registeredAlgorithms.get(i).notifyTEDBFullUpdate();
                ++i;
            }
        }
    }

    @Override
    public void notifyNewEdgeIP(Object source, Object destination, TE_Information informationTEDB) {
        int i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notifyNewEdgeIP(source, destination, informationTEDB);
            ++i;
        }
    }

    public void notificationEdgeIP_AuxGraph(Object src, Object dst, TE_Information informationTEDB) {
        int i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notificationEdgeIP_AuxGraph(src, dst, informationTEDB);
            ++i;
        }
    }

    public void notificationEdgeOPTICAL_AuxGraph(Object src, Object dst, int lambda) {
        int i = 0;
        while (i < this.registeredAlgorithms.size()) {
            this.registeredAlgorithms.get(i).notificationEdgeOPTICAL_AuxGraph(src, dst, lambda);
            ++i;
        }
    }

    @Override
    public void notifyWavelengthEndReservationSSON(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, boolean bidirectional, int m) {
    }

    @Override
    public void notifyWavelengthReservationSSON(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, boolean bidirectional, int m) {
    }

    @Override
    public SSONInformation getSSONinfo() {
        return null;
    }

    @Override
    public Set<IntraDomainEdge> getIntraDomainLinks() {
        return null;
    }

    @Override
    public void notifyWavelengthReservationWLAN(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, LinkedList<Integer> wlans, boolean bidirectional) {
    }

    @Override
    public void registerSSON(SSONListener compAlgPreComp) {
    }

    @Override
    public Inet4Address getDomainID() {
        return null;
    }

    @Override
    public void setWSONinfo(WSONInformation wSONinfo) {
    }

    @Override
    public void setSSONinfo(SSONInformation sSONinfo) {
    }

    @Override
    public void createGraph() {
    }

    @Override
    public Set<Object> getIntraDomainLinksvertexSet() {
        return null;
    }

    @Override
    public Hashtable<Object, Node_Info> getNodeTable() {
        return null;
    }

    @Override
    public IT_Resources getItResources() {
        return null;
    }

    @Override
    public void setItResources(IT_Resources itResources) {
    }
}

