/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb;

import eu.teraflow.tid.tedb.FileTEDBUpdater;
import eu.teraflow.tid.tedb.InterDomainEdge;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.MultiDomainTEDB;
import eu.teraflow.tid.tedb.ReachabilityEntry;
import eu.teraflow.tid.tedb.SimpleTEDB;
import eu.teraflow.tid.tedb.TE_Information;
import java.net.Inet4Address;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDTEDB
implements MultiDomainTEDB {
    private long graphId;
    private DirectedWeightedMultigraph<Object, InterDomainEdge> networkDomainGraph;
    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph;
    public SimpleTEDB simple_ted;
    private Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
    private boolean addBidirectional = true;
    LinkedList<ReachabilityEntry> reachability;

    public MDTEDB() {
        this.networkDomainGraph = new DirectedWeightedMultigraph(InterDomainEdge.class);
        this.reachability = new LinkedList();
    }

    public DirectedWeightedMultigraph<Object, InterDomainEdge> getDuplicatedMDNetworkGraph() {
        DirectedWeightedMultigraph graphCopy = (DirectedWeightedMultigraph)this.networkDomainGraph.clone();
        return graphCopy;
    }

    public DirectedWeightedMultigraph<Object, InterDomainEdge> getNetworkDomainGraph() {
        return this.networkDomainGraph;
    }

    public void setNetworkDomainGraph(DirectedWeightedMultigraph<Object, InterDomainEdge> networkDomainGraph) {
        this.networkDomainGraph = networkDomainGraph;
    }

    @Override
    public void initializeFromFile(String file) {
        this.networkDomainGraph = FileTEDBUpdater.readMDNetwork(file);
    }

    @Override
    public void initializeFromFile(String file, String learntFrom) {
        this.networkDomainGraph = FileTEDBUpdater.readMDNetwork(file, learntFrom);
    }

    public void initializeFromFileInterDomainLinks(String file) {
    }

    public void initializeFullTEDFromFile(String file) {
        this.networkGraph = FileTEDBUpdater.readNetwork(file);
    }

    public long getGraphId() {
        return this.graphId;
    }

    public void setGraphId(long graphId) {
        this.graphId = graphId;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getDuplicatedNetworkGraph() {
        return this.networkGraph;
    }

    @Override
    public synchronized void addInterdomainLink(Object localDomainID, Object localRouterASBR, long localRouterASBRIf, Object remoteDomainID, Object remoteRouterASBR, long remoteRouterASBRIf, TE_Information te_info) {
        if (!this.networkDomainGraph.containsVertex(localDomainID)) {
            this.networkDomainGraph.addVertex(localDomainID);
            this.log.debug("Vertex (domain) " + localDomainID + " added");
        }
        if (!this.networkDomainGraph.containsVertex(remoteDomainID)) {
            this.networkDomainGraph.addVertex(remoteDomainID);
            this.log.debug("Vertex (domain) " + remoteDomainID + " added");
        }
        this.log.debug("Looking to add " + localRouterASBR + ":" + localRouterASBRIf + " (" + localDomainID + ") -->" + remoteRouterASBR + ":" + remoteRouterASBRIf + " (" + remoteDomainID + ")");
        Set edgeset = this.networkDomainGraph.edgesOf(localDomainID);
        Iterator iterador = edgeset.iterator();
        boolean edgeFound = false;
        InterDomainEdge interDomainEdgeFound = null;
        if (edgeset.size() == 0) {
            this.log.debug("Edge set size = 0");
        }
        while (iterador.hasNext()) {
            InterDomainEdge interDomainEdge = (InterDomainEdge)((Object)iterador.next());
            this.log.debug("existing edge: " + interDomainEdge.toString());
            if (interDomainEdge.getSrc_router_id().equals(localRouterASBR)) {
                this.log.debug("Local router is the same!!!");
                if (interDomainEdge.getDst_router_id().equals(remoteRouterASBR)) {
                    this.log.debug("Destination router is the same!!!");
                    edgeFound = true;
                    interDomainEdgeFound = interDomainEdge;
                    continue;
                }
                this.log.debug("Destination router is NOT the same!!!");
                continue;
            }
            this.log.debug("Local router is NOT the same!!!");
        }
        if (!edgeFound) {
            InterDomainEdge newInterDomainEdge = new InterDomainEdge();
            newInterDomainEdge.setSrc_router_id(localRouterASBR);
            newInterDomainEdge.setDst_router_id(remoteRouterASBR);
            newInterDomainEdge.setSrc_if_id(localRouterASBRIf);
            newInterDomainEdge.setDst_if_id(remoteRouterASBRIf);
            newInterDomainEdge.setDomain_dst_router(remoteDomainID);
            newInterDomainEdge.setDomain_src_router(localDomainID);
            if (te_info != null) {
                newInterDomainEdge.setTE_info(te_info);
            }
            this.networkDomainGraph.addEdge(localDomainID, remoteDomainID, (Object)newInterDomainEdge);
            this.log.info("New interdomain edge between " + localDomainID + " and " + remoteDomainID + " received");
        } else if (te_info != null) {
            this.log.debug("TE_info updated");
            interDomainEdgeFound.setTE_info(te_info);
        }
    }

    @Override
    public void addReachabilityIPv4(Inet4Address domainId, Inet4Address aggregatedIPRange, int prefix) {
        ReachabilityEntry ra = new ReachabilityEntry();
        ra.setAggregatedIPRange(aggregatedIPRange);
        long resta = (1L << prefix) - 1L;
        long maskLong = resta << 32 - prefix;
        byte[] mask = new byte[]{(byte)(maskLong >>> 24 & 0xFFL), (byte)(maskLong >>> 16 & 0xFFL), (byte)(maskLong >>> 8 & 0xFFL), (byte)(maskLong & 0xFFL)};
        ra.setMask(mask);
        ra.setDomainId(domainId);
        ra.setPrefix(prefix);
        if (!this.reachability.contains(ra)) {
            this.reachability.add(ra);
        }
    }

    public String printMDTopology() {
        Set vetexSet = this.networkDomainGraph.vertexSet();
        Iterator vertexIterator = vetexSet.iterator();
        String topoString = "Domains: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = String.valueOf(topoString) + "\t" + vertex.toString() + "\r\n";
        }
        topoString = String.valueOf(topoString) + "Interdomain list: \r\n";
        Set edgeSet = this.networkDomainGraph.edgeSet();
        for (InterDomainEdge edge : edgeSet) {
            topoString = String.valueOf(topoString) + "\t" + edge.toString() + "\r\n";
        }
        return topoString;
    }

    public boolean CheckLocalResources(long ifID, Object ip) {
        for (InterDomainEdge link : this.networkDomainGraph.edgeSet()) {
            if (link.getSrc_if_id() != ifID) continue;
            this.log.info("InterDomain Link Found to " + link.getDst_router_id().toString());
            return true;
        }
        return false;
    }

    @Override
    public String printTopology() {
        return this.printMDTopology();
    }

    @Override
    public LinkedList<InterDomainEdge> getInterDomainLinks() {
        return new LinkedList<InterDomainEdge>(this.networkDomainGraph.edgeSet());
    }

    @Override
    public boolean isITtedb() {
        return false;
    }

    public SimpleTEDB getSimple_ted() {
        return this.simple_ted;
    }

    public void setSimple_ted(SimpleTEDB simple_ted) {
        this.simple_ted = simple_ted;
    }

    public LinkedList<ReachabilityEntry> getReachability() {
        return this.reachability;
    }

    public void setReachability(LinkedList<ReachabilityEntry> reachability) {
        this.reachability = reachability;
    }
}

