/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.DefaultTEMetricLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.MinMaxUndirectionalLinkDelayDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalAvailableBandwidthDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalDelayVariationDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalLinkDelayDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalLinkLossDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalResidualBandwidthDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalUtilizedBandwidthDescriptorSubTLV;
import es.tid.of.DataPathID;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AvailableLabels;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MaximumBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.UnreservedBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import eu.teraflow.tid.tedb.EdgeUtils;
import eu.teraflow.tid.tedb.IT_Resources;
import eu.teraflow.tid.tedb.InterDomainEdge;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.ReachabilityEntry;
import eu.teraflow.tid.tedb.ReachabilityManager;
import eu.teraflow.tid.tedb.SSONInformation;
import eu.teraflow.tid.tedb.SimpleTEDB;
import eu.teraflow.tid.tedb.TEDB;
import eu.teraflow.tid.tedb.TE_Information;
import eu.teraflow.tid.tedb.WSONInformation;
import java.io.File;
import java.net.Inet4Address;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileTEDBUpdater {
    public static SimpleDirectedWeightedGraph<Object, IntraDomainEdge> readNetwork(String fileName) {
        return FileTEDBUpdater.readNetwork(fileName, null, false, 0, Integer.MAX_VALUE);
    }

    public static SimpleDirectedWeightedGraph<Object, IntraDomainEdge> readNetwork(String fileName, String layer) {
        return FileTEDBUpdater.readNetwork(fileName, layer, false, 0, Integer.MAX_VALUE, false);
    }

    public static SimpleDirectedWeightedGraph<Object, IntraDomainEdge> readNetwork(String fileName, String layer, boolean allDomains) {
        return FileTEDBUpdater.readNetwork(fileName, layer, allDomains, 0, Integer.MAX_VALUE, false);
    }

    public static SimpleDirectedWeightedGraph<Object, IntraDomainEdge> readNetwork(String fileName, String layer, boolean allDomains, int lambdaIni, int lambdaEnd) {
        return FileTEDBUpdater.readNetwork(fileName, layer, allDomains, 0, Integer.MAX_VALUE, false);
    }

    public static SimpleDirectedWeightedGraph<Object, IntraDomainEdge> readNetwork(String fileName, String layer, boolean allDomains, int lambdaIni, int lambdaEnd, boolean isSSONnetwork) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        Object router_id_addr = null;
        Object s_router_id_addr = null;
        Object d_router_id_addr = null;
        Object src_Numif_id = null;
        Object dst_Numif_id = null;
        SimpleDirectedWeightedGraph graph = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
        log.debug("1. SimpleDirectedWeightedGraph");
        File file = new File(fileName);
        try {
            NodeList nodes_domain_id;
            Element element_domain;
            Element layer_type;
            NodeList domain_layer;
            Element element1;
            boolean readNetwork;
            String domain_id = "";
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            HashMap<Inet4Address, Integer> SIDS = new HashMap<Inet4Address, Integer>();
            HashMap<DataPathID, Integer> SIDSDP = new HashMap<DataPathID, Integer>();
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            if (layer != null) {
                log.debug("Reading topology, looking for layer " + layer);
            }
            int j = 0;
            while (j < nodes_domains.getLength()) {
                readNetwork = false;
                element1 = (Element)nodes_domains.item(j);
                if (layer != null) {
                    domain_layer = element1.getElementsByTagName("layer");
                    if (domain_layer.getLength() == 1) {
                        layer_type = (Element)domain_layer.item(0);
                        log.debug("Layer: " + layer_type.getAttributeNode("type").getValue());
                        log.debug("Reading network topology");
                        if (layer_type.getAttributeNode("type").getValue().equals(layer)) {
                            readNetwork = true;
                        }
                        if (layer.equals("interlayer")) {
                            readNetwork = true;
                        }
                    }
                } else {
                    readNetwork = true;
                }
                if (readNetwork) {
                    element_domain = (Element)nodes_domains.item(j);
                    nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                    int k = 0;
                    while (k < nodes_domain_id.getLength()) {
                        Element domain_id_e = (Element)nodes_domain_id.item(0);
                        domain_id = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                        log.debug("Loading nodes for domain: " + domain_id);
                        log.info("Loading topology from domain " + domain_id);
                        ++k;
                    }
                    NodeList nodes = element1.getElementsByTagName("node");
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element element = (Element)nodes.item(i);
                        NodeList router_id_node = element.getElementsByTagName("router_id");
                        Element router_id_e = (Element)router_id_node.item(0);
                        String router_id = FileTEDBUpdater.getCharacterDataFromElement(router_id_e);
                        log.info("Adding node " + router_id);
                        router_id_addr = EdgeUtils.getEdge(router_id);
                        graph.addVertex(router_id_addr);
                        log.debug("About to look for SID");
                        NodeList SID_aux = element.getElementsByTagName("sid");
                        Element SID_e = (Element)SID_aux.item(0);
                        if (SID_e != null) {
                            log.debug("SID exist");
                            int SID = Integer.parseInt(FileTEDBUpdater.getCharacterDataFromElement(SID_e));
                            try {
                                SIDS.put((Inet4Address)router_id_addr, SID);
                                log.debug("SID of node Inet4Address: " + SID);
                            }
                            catch (Exception e) {
                                SIDSDP.put((DataPathID)router_id_addr, SID);
                                log.debug("SID of node DataPathID: " + SID);
                            }
                        } else {
                            log.debug("SID not found");
                        }
                        ++i;
                    }
                }
                ++j;
            }
            j = 0;
            while (j < nodes_domains.getLength()) {
                readNetwork = false;
                element1 = (Element)nodes_domains.item(j);
                if (layer != null) {
                    domain_layer = element1.getElementsByTagName("layer");
                    if (domain_layer.getLength() == 1) {
                        layer_type = (Element)domain_layer.item(0);
                        log.debug("Layer: " + layer_type.getAttributeNode("type").getValue());
                        log.debug("Reading Topology");
                        if (layer_type.getAttributeNode("type").getValue().equals(layer)) {
                            readNetwork = true;
                        }
                    }
                } else {
                    readNetwork = true;
                }
                log.debug("Read network = " + readNetwork);
                if (readNetwork) {
                    element_domain = (Element)nodes_domains.item(j);
                    nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                    int k = 0;
                    while (k < nodes_domain_id.getLength()) {
                        Element domain_id_e = (Element)nodes_domain_id.item(0);
                        domain_id = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                        log.debug("Looking for links in domain: " + domain_id);
                        ++k;
                    }
                    int numLabels = 0;
                    Boolean commonBitmapLabelSet = false;
                    NodeList edgeCommon = doc.getElementsByTagName("edgeCommon");
                    int grid = 0;
                    int cs = 0;
                    int n = 0;
                    int i = 0;
                    while (i < edgeCommon.getLength()) {
                        Element edgeCommonElement = (Element)edgeCommon.item(i);
                        NodeList availableLabels_node = edgeCommonElement.getElementsByTagName("AvailableLabels");
                        int k2 = 0;
                        while (k2 < availableLabels_node.getLength()) {
                            Element availableLabels_e = (Element)availableLabels_node.item(k2);
                            NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                            Element labelSetField_el = (Element)labelSetField_node.item(0);
                            if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                                NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                                Element numbLabels_e = (Element)numbLabels_node.item(0);
                                String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                                numLabels = Integer.parseInt(numbLabels_s);
                                NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                                Element baseLabel_e = (Element)baseLabel_node.item(0);
                                grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                                cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                                boolean n_frequency_included = false;
                                if (baseLabel_e.getAttributeNode("n") != null) {
                                    n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                                    n_frequency_included = true;
                                } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                                    String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                                    float min_frequency = Float.parseFloat(s_min_frequency);
                                    n = ((int)min_frequency - 1471) / 20;
                                    n_frequency_included = true;
                                }
                                if (n_frequency_included) {
                                    commonBitmapLabelSet = true;
                                } else {
                                    log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                                }
                            }
                            ++k2;
                        }
                        ++i;
                    }
                    NodeList edges = element_domain.getElementsByTagName("edge");
                    int i2 = 0;
                    while (i2 < edges.getLength()) {
                        String type;
                        log.info("New Edge");
                        Element element = (Element)edges.item(i2);
                        Attr attr_type = element.getAttributeNode("type");
                        if (attr_type == null) {
                            type = "intradomain";
                        } else {
                            type = attr_type.getValue();
                            if (allDomains) {
                                if (type.equals("interdomain")) {
                                    type = "intradomain";
                                }
                            } else if (type.equals("interlayer") && layer.equals("interlayer")) {
                                type = "intradomain";
                            }
                        }
                        log.debug("type::" + type);
                        if (type.equals("intradomain")) {
                            NodeList availableLabels_node;
                            NodeList maximum_wlans_nl;
                            int num_u_b;
                            NodeList unreserved_bandwidth_nl;
                            NodeList defaultmetric;
                            Element metric_aux;
                            NodeList maximum_bandwidth_nl;
                            IntraDomainEdge edge = new IntraDomainEdge();
                            log.info("New Intradomain Edge");
                            NodeList source = element.getElementsByTagName("source");
                            Element source_router_el = (Element)source.item(0);
                            NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                            Element source_router_id_el = (Element)source_router_id.item(0);
                            String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                            s_router_id_addr = EdgeUtils.getEdge(s_r_id);
                            NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                            Element source_if_id_el = (Element)source_if_id_nl.item(0);
                            int src_if_id = -1;
                            if (source_if_id_el != null) {
                                String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                                src_if_id = Integer.parseInt(s_source_if_id);
                            }
                            if (src_if_id != -1) {
                                log.debug("SRC if id: " + src_if_id);
                            }
                            NodeList source_Numif_id_nl = source_router_el.getElementsByTagName("NumIf_id");
                            Element source_Numif_id_el = (Element)source_Numif_id_nl.item(0);
                            String s_source_Numif_id = null;
                            if (source_Numif_id_el != null) {
                                s_source_Numif_id = FileTEDBUpdater.getCharacterDataFromElement(source_Numif_id_el);
                                try {
                                    src_Numif_id = (Inet4Address)Inet4Address.getByName(s_source_Numif_id);
                                }
                                catch (Exception e) {
                                    src_Numif_id = DataPathID.getByName(s_source_Numif_id);
                                }
                            }
                            if (s_source_Numif_id != null) {
                                log.debug("NumIf_id id: " + src_Numif_id);
                            }
                            NodeList dest_nl = element.getElementsByTagName("destination");
                            Element dest_el = (Element)dest_nl.item(0);
                            NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                            Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                            String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                            d_router_id_addr = EdgeUtils.getEdge(d_r_id);
                            if (SIDS.get(s_router_id_addr) != null && SIDS.get(d_router_id_addr) != null) {
                                log.debug("setting SIDS src: " + SIDS.get(s_router_id_addr) + " dst: " + SIDS.get(d_router_id_addr));
                                edge.setSrc_sid((Integer)SIDS.get(s_router_id_addr));
                                edge.setDst_sid((Integer)SIDS.get(d_router_id_addr));
                                log.debug("edge.getSrc_sid(): " + edge.getSrc_sid());
                                log.debug("edge.getDst_sid(): " + edge.getDst_sid());
                            } else if (SIDSDP.get(s_router_id_addr) != null && SIDSDP.get(d_router_id_addr) != null) {
                                log.debug("setting SIDSDP src: " + SIDSDP.get(s_router_id_addr) + " dst: " + SIDSDP.get(d_router_id_addr));
                                edge.setSrc_sid((Integer)SIDSDP.get(s_router_id_addr));
                                edge.setDst_sid((Integer)SIDSDP.get(d_router_id_addr));
                                log.debug("edge.getSrc_sid(): " + edge.getSrc_sid());
                                log.debug("edge.getDst_sid(): " + edge.getDst_sid());
                            }
                            NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                            Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                            int dst_if_id = -1;
                            if (dest_if_id_el != null) {
                                String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                                dst_if_id = Integer.parseInt(s_dest_if_id);
                            }
                            if (dst_if_id != -1) {
                                log.debug("DST if id: " + dst_if_id);
                            }
                            NodeList dest_Numif_id_nl = dest_el.getElementsByTagName("NumIf_id");
                            Element dest_Numif_id_el = (Element)dest_Numif_id_nl.item(0);
                            String s_dest_Numif_id = null;
                            if (source_Numif_id_el != null) {
                                s_dest_Numif_id = FileTEDBUpdater.getCharacterDataFromElement(dest_Numif_id_el);
                                try {
                                    dst_Numif_id = (Inet4Address)Inet4Address.getByName(s_dest_Numif_id);
                                }
                                catch (Exception e) {
                                    dst_Numif_id = DataPathID.getByName(s_dest_Numif_id);
                                }
                            }
                            if (s_dest_Numif_id != null) {
                                log.debug("DST NumIf_id id: " + dst_Numif_id);
                            }
                            if (src_Numif_id != null) {
                                edge.setSrc_Numif_id(src_Numif_id);
                            }
                            if (dst_Numif_id != null) {
                                edge.setDst_Numif_id(dst_Numif_id);
                            } else {
                                if (src_if_id != -1) {
                                    edge.setSrc_if_id(src_if_id);
                                }
                                if (dst_if_id != -1) {
                                    edge.setDst_if_id(dst_if_id);
                                }
                            }
                            NodeList delay_ms_nl = element.getElementsByTagName("delay");
                            if (delay_ms_nl.getLength() > 0) {
                                Element delay_ms_el = (Element)delay_ms_nl.item(0);
                                String s_delay_ms = FileTEDBUpdater.getCharacterDataFromElement(delay_ms_el);
                                double delay_ms = Double.parseDouble(s_delay_ms);
                                edge.setDelay_ms(delay_ms);
                            }
                            if ((maximum_bandwidth_nl = element.getElementsByTagName("maximum_bandwidth")) != null && maximum_bandwidth_nl.getLength() > 0) {
                                if (edge.getTE_info() == null) {
                                    TE_Information tE_info = new TE_Information();
                                    if (commonBitmapLabelSet.booleanValue()) {
                                        if (lambdaEnd != Integer.MAX_VALUE) {
                                            tE_info.createBitmapLabelSet(numLabels, grid, cs, n, lambdaIni, lambdaEnd);
                                        } else {
                                            tE_info.createBitmapLabelSet(numLabels, grid, cs, n);
                                        }
                                    }
                                    edge.setTE_info(tE_info);
                                } else {
                                    TE_Information te_info = edge.getTE_info();
                                    if (commonBitmapLabelSet.booleanValue()) {
                                        te_info.createBitmapLabelSet(numLabels, grid, cs, n);
                                    }
                                    edge.setTE_info(te_info);
                                }
                                Element maximum_bandwidth_el = (Element)maximum_bandwidth_nl.item(0);
                                String s_maximum_bandwidth = FileTEDBUpdater.getCharacterDataFromElement(maximum_bandwidth_el);
                                float maximum_bandwidth = Float.parseFloat(s_maximum_bandwidth);
                                MaximumBandwidth maximumBandwidth = new MaximumBandwidth();
                                maximumBandwidth.setMaximumBandwidth(maximum_bandwidth);
                                edge.getTE_info().setMaximumBandwidth(maximumBandwidth);
                            }
                            if ((metric_aux = (Element)(defaultmetric = element.getElementsByTagName("default_te_metric")).item(0)) != null) {
                                String s_metric_aux = FileTEDBUpdater.getCharacterDataFromElement(metric_aux);
                                int metric = Integer.parseInt(s_metric_aux);
                                DefaultTEMetricLinkAttribTLV defaultTeMetric = new DefaultTEMetricLinkAttribTLV();
                                TE_Information tE_info = edge.getTE_info() == null ? new TE_Information() : edge.getTE_info();
                                defaultTeMetric.setLinkMetric(metric);
                                tE_info.setDefaultTEMetric(defaultTeMetric);
                                edge.setTE_info(tE_info);
                            }
                            if ((unreserved_bandwidth_nl = element.getElementsByTagName("unreserved_bandwidth")) != null && (num_u_b = unreserved_bandwidth_nl.getLength()) > 0) {
                                if (edge.getTE_info() == null) {
                                    TE_Information tE_info = new TE_Information();
                                    if (commonBitmapLabelSet.booleanValue()) {
                                        if (lambdaEnd != Integer.MAX_VALUE) {
                                            tE_info.createBitmapLabelSet(numLabels, grid, cs, n, lambdaIni, lambdaEnd);
                                        } else {
                                            tE_info.createBitmapLabelSet(numLabels, grid, cs, n);
                                        }
                                    }
                                    edge.setTE_info(tE_info);
                                }
                                UnreservedBandwidth unreservedBandwidth = new UnreservedBandwidth();
                                edge.getTE_info().setUnreservedBandwidth(unreservedBandwidth);
                                int k3 = 0;
                                while (k3 < num_u_b) {
                                    float unreserved_bandwidth;
                                    Element unreserved_bandwidth_el = (Element)unreserved_bandwidth_nl.item(k3);
                                    String s_unreserved_bandwidth = FileTEDBUpdater.getCharacterDataFromElement(unreserved_bandwidth_el);
                                    String s_priority = unreserved_bandwidth_el.getAttributeNode("priority").getValue();
                                    Integer priority = Integer.valueOf(s_priority);
                                    unreservedBandwidth.getUnreservedBandwidth()[priority.intValue()] = unreserved_bandwidth = Float.parseFloat(s_unreserved_bandwidth);
                                    ++k3;
                                }
                            }
                            if ((maximum_wlans_nl = element.getElementsByTagName("number_wlans")) != null && maximum_wlans_nl.getLength() > 0) {
                                if (edge.getTE_info() == null) {
                                    TE_Information tE_info = new TE_Information();
                                    if (commonBitmapLabelSet.booleanValue()) {
                                        if (lambdaEnd != Integer.MAX_VALUE) {
                                            tE_info.createBitmapLabelSet(numLabels, grid, cs, n, lambdaIni, lambdaEnd);
                                        } else {
                                            tE_info.createBitmapLabelSet(numLabels, grid, cs, n);
                                        }
                                    }
                                    edge.setTE_info(tE_info);
                                }
                                Element number_wlan_el = (Element)maximum_wlans_nl.item(0);
                                String s_number_wlans = FileTEDBUpdater.getCharacterDataFromElement(number_wlan_el);
                                int number_wlans = Integer.parseInt(s_number_wlans.replace("\n", "").replaceAll("\\s", ""));
                                edge.getTE_info().setNumberWLANs(number_wlans);
                                edge.getTE_info().initWLANs();
                            }
                            if (edge.getTE_info() == null) {
                                TE_Information tE_info = new TE_Information();
                                edge.setTE_info(tE_info);
                            }
                            if (commonBitmapLabelSet.booleanValue()) {
                                if (lambdaEnd != Integer.MAX_VALUE) {
                                    edge.getTE_info().createBitmapLabelSet(numLabels, grid, cs, n, lambdaIni, lambdaEnd);
                                } else {
                                    edge.getTE_info().createBitmapLabelSet(numLabels, grid, cs, n);
                                }
                            }
                            if ((availableLabels_node = element.getElementsByTagName("AvailableLabels")) != null) {
                                int k4 = 0;
                                while (k4 < availableLabels_node.getLength()) {
                                    Element availableLabels_e = (Element)availableLabels_node.item(k4);
                                    NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                                    Element labelSetField_el = (Element)labelSetField_node.item(0);
                                    if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                                        NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                                        Element numbLabels_e = (Element)numbLabels_node.item(0);
                                        String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                                        numLabels = Integer.parseInt(numbLabels_s);
                                        NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                                        Element baseLabel_e = (Element)baseLabel_node.item(0);
                                        byte[] bitmap = new byte[1];
                                        NodeList bitmap_node = labelSetField_el.getElementsByTagName("bitmap");
                                        int result = 0;
                                        Element bitmap_e = (Element)bitmap_node.item(0);
                                        if (bitmap_e != null) {
                                            String bitmap_string = FileTEDBUpdater.getCharacterDataFromElement(bitmap_e);
                                            log.debug("Bitmap read: " + bitmap_string);
                                            int p = 0;
                                            while (p < bitmap_string.length()) {
                                                result = (int)((double)result + Math.pow(2.0, bitmap_string.length() - p - 1) * (double)(bitmap_string.charAt(p) - 48));
                                                ++p;
                                            }
                                            bitmap[0] = (byte)result;
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).setBytesBitmap(bitmap);
                                        }
                                        grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                                        cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                                        boolean n_frequency_included = false;
                                        if (baseLabel_e.getAttributeNode("n") != null) {
                                            n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                                            n_frequency_included = true;
                                        } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                                            String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                                            float min_frequency = Float.parseFloat(s_min_frequency);
                                            n = ((int)min_frequency - 1471) / 20;
                                            n_frequency_included = true;
                                        }
                                        if (n_frequency_included) {
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).setNumLabels(numLabels);
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().setGrid(grid);
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().setChannelSpacing(cs);
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().setN(n);
                                        } else {
                                            log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                                        }
                                    }
                                    ++k4;
                                }
                            }
                            log.debug("Preparing to add edge");
                            try {
                                if (graph.containsEdge(s_router_id_addr, d_router_id_addr)) {
                                    ((IntraDomainEdge)((Object)graph.getEdge(s_router_id_addr, d_router_id_addr))).setNumberFibers(((IntraDomainEdge)((Object)graph.getEdge(s_router_id_addr, d_router_id_addr))).getNumberFibers() + 1);
                                } else {
                                    log.debug("s_router_id_addr: " + s_router_id_addr.toString() + "; d_router_id_addr: " + d_router_id_addr.toString() + "; edge: " + (Object)((Object)edge));
                                    graph.addEdge(s_router_id_addr, d_router_id_addr, (Object)edge);
                                    ((IntraDomainEdge)((Object)graph.getEdge(s_router_id_addr, d_router_id_addr))).setNumberFibers(1);
                                }
                                log.info("Adding edge from " + s_router_id_addr.toString() + " to " + d_router_id_addr.toString() + "; \n " + (Object)((Object)edge));
                            }
                            catch (Exception e) {
                                log.error("Problem with source " + s_router_id_addr + " destination " + d_router_id_addr);
                                e.printStackTrace();
                                System.exit(-1);
                            }
                        }
                        ++i2;
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug("Info graph edge :: " + graph.edgeSet());
        return graph;
    }

    public static Hashtable<String, TEDB> readMultipleDomainSimpleNetworks(String fileName, String layer, boolean allDomains, int lambdaIni, int lambdaEnd, boolean isSSONnetwork) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        Object router_id_addr = null;
        Object s_router_id_addr = null;
        Object d_router_id_addr = null;
        Object src_Numif_id = null;
        Object dst_Numif_id = null;
        Hashtable<String, TEDB> TEDBs = new Hashtable<String, TEDB>();
        log.debug("1. SimpleDirectedWeightedGraph");
        File file = new File(fileName);
        try {
            String domain_id = "";
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            HashMap<Inet4Address, Integer> SIDS = new HashMap<Inet4Address, Integer>();
            HashMap<DataPathID, Integer> SIDSDP = new HashMap<DataPathID, Integer>();
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            if (layer != null) {
                log.debug("Reading topology, looking for layer " + layer);
            }
            int j = 0;
            while (j < nodes_domains.getLength()) {
                boolean readNetwork = false;
                Element element1 = (Element)nodes_domains.item(j);
                SimpleTEDB tedb = new SimpleTEDB();
                SimpleDirectedWeightedGraph graph = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
                if (layer != null) {
                    NodeList domain_layer = element1.getElementsByTagName("layer");
                    if (domain_layer.getLength() == 1) {
                        Element layer_type = (Element)domain_layer.item(0);
                        log.debug("Layer: " + layer_type.getAttributeNode("type").getValue());
                        log.debug("Reading network topology");
                        if (layer_type.getAttributeNode("type").getValue().equals(layer)) {
                            readNetwork = true;
                        }
                        if (layer.equals("interlayer")) {
                            readNetwork = true;
                        }
                    }
                } else {
                    readNetwork = true;
                }
                if (readNetwork) {
                    Element element_domain = (Element)nodes_domains.item(j);
                    NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                    int k = 0;
                    while (k < nodes_domain_id.getLength()) {
                        Element domain_id_e = (Element)nodes_domain_id.item(0);
                        domain_id = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                        log.debug("Looking for nodes in domain: " + domain_id);
                        log.info("Loading topology from domain " + domain_id);
                        ++k;
                    }
                    NodeList itResourcesElement = element1.getElementsByTagName("it_resources");
                    int i = 0;
                    while (i < itResourcesElement.getLength()) {
                        Element element = (Element)itResourcesElement.item(i);
                        NodeList itResourcesControllerITList = element.getElementsByTagName("controller_it");
                        Element itResourcesControllerITElement = (Element)itResourcesControllerITList.item(0);
                        String itResourcesControllerIT = FileTEDBUpdater.getCharacterDataFromElement(itResourcesControllerITElement);
                        NodeList itResourcesCpuList = element.getElementsByTagName("cpu");
                        Element itResourcesCpuElement = (Element)itResourcesCpuList.item(0);
                        String itResourcesCpu = FileTEDBUpdater.getCharacterDataFromElement(itResourcesCpuElement);
                        NodeList itResourcesMemList = element.getElementsByTagName("mem");
                        Element itResourcesMemElement = (Element)itResourcesMemList.item(0);
                        String itResourcesMem = FileTEDBUpdater.getCharacterDataFromElement(itResourcesMemElement);
                        NodeList itResourcesStorageList = element.getElementsByTagName("storage");
                        Element itResourcesStorageElement = (Element)itResourcesStorageList.item(0);
                        String itResourcesStorage = FileTEDBUpdater.getCharacterDataFromElement(itResourcesStorageElement);
                        IT_Resources itResources = new IT_Resources();
                        if (itResourcesControllerIT != null) {
                            itResources.setControllerIT(itResourcesControllerIT);
                        }
                        if (itResourcesCpu != null) {
                            itResources.setCpu(itResourcesCpu);
                        }
                        if (itResourcesMem != null) {
                            itResources.setMem(itResourcesMem);
                        }
                        if (itResourcesStorage != null) {
                            itResources.setStorage(itResourcesStorage);
                        }
                        tedb.setItResources(itResources);
                        ++i;
                    }
                    NodeList nodes = element1.getElementsByTagName("node");
                    int i2 = 0;
                    while (i2 < nodes.getLength()) {
                        Element element = (Element)nodes.item(i2);
                        NodeList router_id_node = element.getElementsByTagName("router_id");
                        Element router_id_e = (Element)router_id_node.item(0);
                        String router_id = FileTEDBUpdater.getCharacterDataFromElement(router_id_e);
                        log.info("Adding node " + router_id);
                        router_id_addr = EdgeUtils.getEdge(router_id);
                        graph.addVertex(router_id_addr);
                        log.debug("About to look for SID");
                        NodeList SID_aux = element.getElementsByTagName("sid");
                        Element SID_e = (Element)SID_aux.item(0);
                        if (SID_e != null) {
                            log.debug("SID exist");
                            int SID = Integer.parseInt(FileTEDBUpdater.getCharacterDataFromElement(SID_e));
                            try {
                                SIDS.put((Inet4Address)router_id_addr, SID);
                                log.debug("SID of node Inet4Address: " + SID);
                            }
                            catch (Exception e) {
                                SIDSDP.put((DataPathID)router_id_addr, SID);
                                log.debug("SID of node DataPathID: " + SID);
                            }
                        } else {
                            log.debug("SID not found");
                        }
                        ++i2;
                    }
                }
                tedb.setNetworkGraph((SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)graph);
                tedb.setDomainID((Inet4Address)Inet4Address.getByName(domain_id));
                TEDBs.put(domain_id, tedb);
                ++j;
            }
            j = 0;
            while (j < nodes_domains.getLength()) {
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph = null;
                boolean readNetwork = false;
                Element element1 = (Element)nodes_domains.item(j);
                if (layer != null) {
                    NodeList domain_layer = element1.getElementsByTagName("layer");
                    if (domain_layer.getLength() == 1) {
                        Element layer_type = (Element)domain_layer.item(0);
                        log.debug("Layer: " + layer_type.getAttributeNode("type").getValue());
                        log.debug("Reading Topology");
                        if (layer_type.getAttributeNode("type").getValue().equals(layer)) {
                            readNetwork = true;
                        }
                    }
                } else {
                    readNetwork = true;
                }
                log.debug("Read network = " + readNetwork);
                if (readNetwork) {
                    Element element_domain = (Element)nodes_domains.item(j);
                    NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                    int k = 0;
                    while (k < nodes_domain_id.getLength()) {
                        Element domain_id_e = (Element)nodes_domain_id.item(0);
                        domain_id = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                        log.debug("Looking for links in domain: " + domain_id);
                        ++k;
                    }
                    SimpleTEDB domainTEDB = (SimpleTEDB)TEDBs.get(domain_id);
                    graph = domainTEDB.getNetworkGraph();
                    int numLabels = 0;
                    TE_Information tE_info_common = null;
                    Boolean commonBitmapLabelSet = false;
                    NodeList edgeCommon = element1.getElementsByTagName("edgeCommon");
                    int grid = 0;
                    int cs = 0;
                    int n = 0;
                    int i = 0;
                    while (i < edgeCommon.getLength()) {
                        Element edgeCommonElement = (Element)edgeCommon.item(i);
                        tE_info_common = FileTEDBUpdater.readTE_INFOfromXml(tE_info_common, edgeCommonElement, false, numLabels, grid, cs, n, 0, Integer.MAX_VALUE);
                        NodeList availableLabels_node = edgeCommonElement.getElementsByTagName("AvailableLabels");
                        int k2 = 0;
                        while (k2 < availableLabels_node.getLength()) {
                            Element availableLabels_e = (Element)availableLabels_node.item(k2);
                            NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                            Element labelSetField_el = (Element)labelSetField_node.item(0);
                            if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                                NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                                Element numbLabels_e = (Element)numbLabels_node.item(0);
                                String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                                numLabels = Integer.parseInt(numbLabels_s);
                                NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                                Element baseLabel_e = (Element)baseLabel_node.item(0);
                                grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                                cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                                boolean n_frequency_included = false;
                                if (baseLabel_e.getAttributeNode("n") != null) {
                                    n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                                    n_frequency_included = true;
                                } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                                    String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                                    float min_frequency = Float.parseFloat(s_min_frequency);
                                    n = ((int)min_frequency - 1471) / 20;
                                    n_frequency_included = true;
                                }
                                if (n_frequency_included) {
                                    commonBitmapLabelSet = true;
                                } else {
                                    log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                                }
                            }
                            ++k2;
                        }
                        ++i;
                    }
                    NodeList edges = element_domain.getElementsByTagName("edge");
                    int i3 = 0;
                    while (i3 < edges.getLength()) {
                        DefaultWeightedEdge edge;
                        String type;
                        log.debug("New Link");
                        Element element = (Element)edges.item(i3);
                        Attr attr_type = element.getAttributeNode("type");
                        if (attr_type == null) {
                            type = "intradomain";
                        } else {
                            type = attr_type.getValue();
                            if (layer != null && layer.equals("interlayer")) {
                                type = "intradomain";
                            }
                        }
                        log.debug("type::" + type);
                        if (type.equals("intradomain")) {
                            edge = new IntraDomainEdge();
                            NodeList source = element.getElementsByTagName("source");
                            Element source_router_el = (Element)source.item(0);
                            NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                            Element source_router_id_el = (Element)source_router_id.item(0);
                            String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                            s_router_id_addr = EdgeUtils.getEdge(s_r_id);
                            NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                            Element source_if_id_el = (Element)source_if_id_nl.item(0);
                            int src_if_id = -1;
                            if (source_if_id_el != null) {
                                String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                                src_if_id = Integer.parseInt(s_source_if_id);
                            }
                            log.debug("SRC if id: " + src_if_id);
                            NodeList source_Numif_id_nl = source_router_el.getElementsByTagName("NumIf_id");
                            Element source_Numif_id_el = (Element)source_Numif_id_nl.item(0);
                            if (source_Numif_id_el != null) {
                                String s_source_Numif_id = FileTEDBUpdater.getCharacterDataFromElement(source_Numif_id_el);
                                try {
                                    src_Numif_id = (Inet4Address)Inet4Address.getByName(s_source_Numif_id);
                                }
                                catch (Exception e) {
                                    src_Numif_id = DataPathID.getByName(s_source_Numif_id);
                                }
                            }
                            NodeList dest_nl = element.getElementsByTagName("destination");
                            Element dest_el = (Element)dest_nl.item(0);
                            NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                            Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                            String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                            d_router_id_addr = EdgeUtils.getEdge(d_r_id);
                            if (SIDS.get(s_router_id_addr) != null && SIDS.get(d_router_id_addr) != null) {
                                log.debug("setting SIDS src: " + SIDS.get(s_router_id_addr) + " dst: " + SIDS.get(d_router_id_addr));
                                edge.setSrc_sid((Integer)SIDS.get(s_router_id_addr));
                                edge.setDst_sid((Integer)SIDS.get(d_router_id_addr));
                                log.debug("edge.getSrc_sid(): " + edge.getSrc_sid());
                                log.debug("edge.getDst_sid(): " + edge.getDst_sid());
                            } else if (SIDSDP.get(s_router_id_addr) != null && SIDSDP.get(d_router_id_addr) != null) {
                                log.debug("setting SIDSDP src: " + SIDSDP.get(s_router_id_addr) + " dst: " + SIDSDP.get(d_router_id_addr));
                                edge.setSrc_sid((Integer)SIDSDP.get(s_router_id_addr));
                                edge.setDst_sid((Integer)SIDSDP.get(d_router_id_addr));
                                log.debug("edge.getSrc_sid(): " + edge.getSrc_sid());
                                log.debug("edge.getDst_sid(): " + edge.getDst_sid());
                            }
                            NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                            Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                            int dst_if_id = -1;
                            if (dest_if_id_el != null) {
                                String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                                dst_if_id = Integer.parseInt(s_dest_if_id);
                            }
                            log.debug("DST if id: " + dst_if_id);
                            NodeList dest_Numif_id_nl = dest_el.getElementsByTagName("NumIf_id");
                            Element dest_Numif_id_el = (Element)dest_Numif_id_nl.item(0);
                            if (source_Numif_id_el != null) {
                                String s_dest_Numif_id = FileTEDBUpdater.getCharacterDataFromElement(dest_Numif_id_el);
                                try {
                                    dst_Numif_id = (Inet4Address)Inet4Address.getByName(s_dest_Numif_id);
                                }
                                catch (Exception e) {
                                    dst_Numif_id = DataPathID.getByName(s_dest_Numif_id);
                                }
                            }
                            if (src_Numif_id != null) {
                                edge.setSrc_Numif_id(src_Numif_id);
                            }
                            if (dst_Numif_id != null) {
                                edge.setDst_Numif_id(dst_Numif_id);
                            } else {
                                if (src_if_id != -1) {
                                    edge.setSrc_if_id(src_if_id);
                                }
                                if (dst_if_id != -1) {
                                    edge.setDst_if_id(dst_if_id);
                                }
                            }
                            NodeList delay_ms_nl = element.getElementsByTagName("delay");
                            if (delay_ms_nl.getLength() > 0) {
                                Element delay_ms_el = (Element)delay_ms_nl.item(0);
                                String s_delay_ms = FileTEDBUpdater.getCharacterDataFromElement(delay_ms_el);
                                double delay_ms = Double.parseDouble(s_delay_ms);
                                edge.setDelay_ms(delay_ms);
                            }
                            edge.setTE_info(FileTEDBUpdater.readTE_INFOfromXml(tE_info_common, element, commonBitmapLabelSet, numLabels, grid, cs, n, lambdaIni, lambdaEnd));
                            NodeList availableLabels_node = element.getElementsByTagName("AvailableLabels");
                            if (availableLabels_node != null) {
                                int k3 = 0;
                                while (k3 < availableLabels_node.getLength()) {
                                    Element availableLabels_e = (Element)availableLabels_node.item(k3);
                                    NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                                    Element labelSetField_el = (Element)labelSetField_node.item(0);
                                    if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                                        NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                                        Element numbLabels_e = (Element)numbLabels_node.item(0);
                                        String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                                        numLabels = Integer.parseInt(numbLabels_s);
                                        NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                                        Element baseLabel_e = (Element)baseLabel_node.item(0);
                                        byte[] bitmap = new byte[1];
                                        NodeList bitmap_node = labelSetField_el.getElementsByTagName("bitmap");
                                        int result = 0;
                                        Element bitmap_e = (Element)bitmap_node.item(0);
                                        if (bitmap_e != null) {
                                            String bitmap_string = FileTEDBUpdater.getCharacterDataFromElement(bitmap_e);
                                            System.out.println("Bitmap read: " + bitmap_string);
                                            int p = 0;
                                            while (p < bitmap_string.length()) {
                                                result = (int)((double)result + Math.pow(2.0, bitmap_string.length() - p - 1) * (double)(bitmap_string.charAt(p) - 48));
                                                ++p;
                                            }
                                            bitmap[0] = (byte)result;
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).setBytesBitmap(bitmap);
                                        }
                                        grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                                        cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                                        boolean n_frequency_included = false;
                                        if (baseLabel_e.getAttributeNode("n") != null) {
                                            n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                                            n_frequency_included = true;
                                        } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                                            String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                                            float min_frequency = Float.parseFloat(s_min_frequency);
                                            n = ((int)min_frequency - 1471) / 20;
                                            n_frequency_included = true;
                                        }
                                        if (n_frequency_included) {
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).setNumLabels(numLabels);
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().setGrid(grid);
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().setChannelSpacing(cs);
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().setN(n);
                                        } else {
                                            log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                                        }
                                    }
                                    ++k3;
                                }
                            }
                            log.debug("Preparing to add edge");
                            log.debug("NODES IN GRAPH:: " + graph.vertexSet());
                            try {
                                if (graph.containsEdge(s_router_id_addr, d_router_id_addr)) {
                                    log.debug("New Intradomain Edge");
                                    ((IntraDomainEdge)((Object)graph.getEdge(s_router_id_addr, d_router_id_addr))).setNumberFibers(((IntraDomainEdge)((Object)graph.getEdge(s_router_id_addr, d_router_id_addr))).getNumberFibers() + 1);
                                    log.debug("s_router_id_addr: " + s_router_id_addr.toString() + "; d_router_id_addr: " + d_router_id_addr.toString() + "; edge: " + edge);
                                    log.info("New intradomain link: " + s_router_id_addr.toString() + " --> " + d_router_id_addr.toString());
                                } else {
                                    log.debug("s_router_id_addr: " + s_router_id_addr.toString() + "; d_router_id_addr: " + d_router_id_addr.toString() + "; edge: " + edge);
                                    if (!graph.containsVertex(d_router_id_addr)) {
                                        type = "interdomain";
                                    } else {
                                        graph.addEdge(s_router_id_addr, d_router_id_addr, (Object)edge);
                                        ((IntraDomainEdge)((Object)graph.getEdge(s_router_id_addr, d_router_id_addr))).setNumberFibers(1);
                                        log.debug("New Intradomain Edge");
                                        log.info("New intradomain link: " + s_router_id_addr.toString() + " --> " + d_router_id_addr.toString());
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("Problem with source " + s_router_id_addr + " destination " + d_router_id_addr);
                                e.printStackTrace();
                                System.exit(-1);
                            }
                        }
                        if (type.equals("interdomain")) {
                            log.debug("New Interdomain Edge");
                            edge = new InterDomainEdge();
                            TE_Information tE_info = FileTEDBUpdater.readTE_INFOfromXml(tE_info_common, element, false, numLabels, grid, cs, n, 0, Integer.MAX_VALUE);
                            edge.setTE_info(tE_info);
                            NodeList source = element.getElementsByTagName("source");
                            Element source_router_el = (Element)source.item(0);
                            NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                            Element source_router_id_el = (Element)source_router_id.item(0);
                            String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                            log.debug("Edge Source router_id: " + s_r_id);
                            try {
                                s_router_id_addr = (Inet4Address)Inet4Address.getByName(s_r_id);
                            }
                            catch (Exception e) {
                                s_router_id_addr = DataPathID.getByName(s_r_id);
                            }
                            Inet4Address source_domain_id = (Inet4Address)Inet4Address.getByName(domain_id);
                            log.debug("Edge Source domain_id: " + source_domain_id);
                            NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                            Element source_if_id_el = (Element)source_if_id_nl.item(0);
                            String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                            log.debug("Edge Source if_id: " + s_source_if_id);
                            int src_if_id = Integer.parseInt(s_source_if_id);
                            NodeList dest_nl = element.getElementsByTagName("destination");
                            Element dest_el = (Element)dest_nl.item(0);
                            NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                            Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                            String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                            log.debug("Edge Destination router_id: " + d_r_id);
                            try {
                                d_router_id_addr = (Inet4Address)Inet4Address.getByName(d_r_id);
                            }
                            catch (Exception e) {
                                d_router_id_addr = DataPathID.getByName(d_r_id);
                            }
                            log.debug("Destination domain_id: <Unknown>");
                            NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                            Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                            String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                            log.debug("Edge Dest if_id: " + s_dest_if_id);
                            int dst_if_id = Integer.parseInt(s_dest_if_id);
                            edge.setSrc_if_id(src_if_id);
                            edge.setDst_if_id(dst_if_id);
                            edge.setDomain_src_router(source_domain_id);
                            edge.setSrc_router_id(s_router_id_addr);
                            edge.setDst_router_id(d_router_id_addr);
                            if (domainTEDB.getInterDomainLinks() == null) {
                                LinkedList<InterDomainEdge> interDomainLinks = new LinkedList<InterDomainEdge>();
                                interDomainLinks.add((InterDomainEdge)edge);
                                domainTEDB.setInterDomainLinks(interDomainLinks);
                                log.info("New interdomain link: " + s_router_id_addr.toString() + " --> " + d_router_id_addr.toString());
                            } else {
                                domainTEDB.getInterDomainLinks().add((InterDomainEdge)edge);
                                log.info("New interdomain link: " + s_router_id_addr.toString() + " --> " + d_router_id_addr.toString());
                            }
                        }
                        ++i3;
                    }
                }
                log.debug("Info graph edge :: " + graph.edgeSet());
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return TEDBs;
    }

    public static Hashtable<String, TEDB> readMultipleDomainSimpleNetworks(String fileName, String layer, boolean allDomains, int lambdaIni, int lambdaEnd, boolean isSSONnetwork, String learntFrom) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        Object router_id_addr = null;
        Object s_router_id_addr = null;
        Object d_router_id_addr = null;
        Object src_Numif_id = null;
        Object dst_Numif_id = null;
        Hashtable<String, TEDB> TEDBs = new Hashtable<String, TEDB>();
        log.debug("1. SimpleDirectedWeightedGraph");
        File file = new File(fileName);
        try {
            String domain_id = "";
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            HashMap<Inet4Address, Integer> SIDS = new HashMap<Inet4Address, Integer>();
            HashMap<DataPathID, Integer> SIDSDP = new HashMap<DataPathID, Integer>();
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            if (layer != null) {
                log.debug("Reading topology, looking for layer " + layer);
            }
            int j = 0;
            while (j < nodes_domains.getLength()) {
                boolean readNetwork = false;
                Element element1 = (Element)nodes_domains.item(j);
                SimpleTEDB tedb = new SimpleTEDB();
                SimpleDirectedWeightedGraph graph = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
                if (layer != null) {
                    NodeList domain_layer = element1.getElementsByTagName("layer");
                    if (domain_layer.getLength() == 1) {
                        Element layer_type = (Element)domain_layer.item(0);
                        log.debug("Layer: " + layer_type.getAttributeNode("type").getValue());
                        log.debug("Reading network topology");
                        if (layer_type.getAttributeNode("type").getValue().equals(layer)) {
                            readNetwork = true;
                        }
                        if (layer.equals("interlayer")) {
                            readNetwork = true;
                        }
                    }
                } else {
                    readNetwork = true;
                }
                if (readNetwork) {
                    Element element_domain = (Element)nodes_domains.item(j);
                    NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                    int k = 0;
                    while (k < nodes_domain_id.getLength()) {
                        Element domain_id_e = (Element)nodes_domain_id.item(0);
                        domain_id = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                        log.debug("Looking for nodes in domain: " + domain_id);
                        log.info("Loading topology from domain " + domain_id);
                        ++k;
                    }
                    NodeList itResourcesElement = element1.getElementsByTagName("it_resources");
                    int i = 0;
                    while (i < itResourcesElement.getLength()) {
                        Element element = (Element)itResourcesElement.item(i);
                        NodeList itResourcesControllerITList = element.getElementsByTagName("controller_it");
                        Element itResourcesControllerITElement = (Element)itResourcesControllerITList.item(0);
                        String itResourcesControllerIT = FileTEDBUpdater.getCharacterDataFromElement(itResourcesControllerITElement);
                        NodeList itResourcesCpuList = element.getElementsByTagName("cpu");
                        Element itResourcesCpuElement = (Element)itResourcesCpuList.item(0);
                        String itResourcesCpu = FileTEDBUpdater.getCharacterDataFromElement(itResourcesCpuElement);
                        NodeList itResourcesMemList = element.getElementsByTagName("mem");
                        Element itResourcesMemElement = (Element)itResourcesMemList.item(0);
                        String itResourcesMem = FileTEDBUpdater.getCharacterDataFromElement(itResourcesMemElement);
                        NodeList itResourcesStorageList = element.getElementsByTagName("storage");
                        Element itResourcesStorageElement = (Element)itResourcesStorageList.item(0);
                        String itResourcesStorage = FileTEDBUpdater.getCharacterDataFromElement(itResourcesStorageElement);
                        IT_Resources itResources = new IT_Resources();
                        if (itResourcesControllerIT != null) {
                            itResources.setControllerIT(itResourcesControllerIT);
                            itResources.setLearntFrom(learntFrom);
                        }
                        if (itResourcesCpu != null) {
                            itResources.setCpu(itResourcesCpu);
                        }
                        if (itResourcesMem != null) {
                            itResources.setMem(itResourcesMem);
                        }
                        if (itResourcesStorage != null) {
                            itResources.setStorage(itResourcesStorage);
                            log.info("set learn from for it resources " + itResources.toString());
                        }
                        tedb.setItResources(itResources);
                        ++i;
                    }
                    NodeList nodes = element1.getElementsByTagName("node");
                    int i2 = 0;
                    while (i2 < nodes.getLength()) {
                        Element element = (Element)nodes.item(i2);
                        NodeList router_id_node = element.getElementsByTagName("router_id");
                        Element router_id_e = (Element)router_id_node.item(0);
                        String router_id = FileTEDBUpdater.getCharacterDataFromElement(router_id_e);
                        log.info("Adding node " + router_id);
                        router_id_addr = EdgeUtils.getEdge(router_id);
                        graph.addVertex(router_id_addr);
                        log.debug("About to look for SID");
                        NodeList SID_aux = element.getElementsByTagName("sid");
                        Element SID_e = (Element)SID_aux.item(0);
                        if (SID_e != null) {
                            log.debug("SID exist");
                            int SID = Integer.parseInt(FileTEDBUpdater.getCharacterDataFromElement(SID_e));
                            try {
                                SIDS.put((Inet4Address)router_id_addr, SID);
                                log.debug("SID of node Inet4Address: " + SID);
                            }
                            catch (Exception e) {
                                SIDSDP.put((DataPathID)router_id_addr, SID);
                                log.debug("SID of node DataPathID: " + SID);
                            }
                        } else {
                            log.debug("SID not found");
                        }
                        ++i2;
                    }
                }
                tedb.setNetworkGraph((SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)graph);
                tedb.setDomainID((Inet4Address)Inet4Address.getByName(domain_id));
                TEDBs.put(domain_id, tedb);
                ++j;
            }
            j = 0;
            while (j < nodes_domains.getLength()) {
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph = null;
                boolean readNetwork = false;
                Element element1 = (Element)nodes_domains.item(j);
                if (layer != null) {
                    NodeList domain_layer = element1.getElementsByTagName("layer");
                    if (domain_layer.getLength() == 1) {
                        Element layer_type = (Element)domain_layer.item(0);
                        log.debug("Layer: " + layer_type.getAttributeNode("type").getValue());
                        log.debug("Reading Topology");
                        if (layer_type.getAttributeNode("type").getValue().equals(layer)) {
                            readNetwork = true;
                        }
                    }
                } else {
                    readNetwork = true;
                }
                log.debug("Read network = " + readNetwork);
                if (readNetwork) {
                    Element element_domain = (Element)nodes_domains.item(j);
                    NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                    int k = 0;
                    while (k < nodes_domain_id.getLength()) {
                        Element domain_id_e = (Element)nodes_domain_id.item(0);
                        domain_id = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                        log.debug("Looking for links in domain: " + domain_id);
                        ++k;
                    }
                    SimpleTEDB domainTEDB = (SimpleTEDB)TEDBs.get(domain_id);
                    graph = domainTEDB.getNetworkGraph();
                    int numLabels = 0;
                    TE_Information tE_info_common = null;
                    Boolean commonBitmapLabelSet = false;
                    NodeList edgeCommon = element1.getElementsByTagName("edgeCommon");
                    int grid = 0;
                    int cs = 0;
                    int n = 0;
                    int i = 0;
                    while (i < edgeCommon.getLength()) {
                        Element edgeCommonElement = (Element)edgeCommon.item(i);
                        tE_info_common = FileTEDBUpdater.readTE_INFOfromXml(tE_info_common, edgeCommonElement, false, numLabels, grid, cs, n, 0, Integer.MAX_VALUE);
                        NodeList availableLabels_node = edgeCommonElement.getElementsByTagName("AvailableLabels");
                        int k2 = 0;
                        while (k2 < availableLabels_node.getLength()) {
                            Element availableLabels_e = (Element)availableLabels_node.item(k2);
                            NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                            Element labelSetField_el = (Element)labelSetField_node.item(0);
                            if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                                NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                                Element numbLabels_e = (Element)numbLabels_node.item(0);
                                String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                                numLabels = Integer.parseInt(numbLabels_s);
                                NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                                Element baseLabel_e = (Element)baseLabel_node.item(0);
                                grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                                cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                                boolean n_frequency_included = false;
                                if (baseLabel_e.getAttributeNode("n") != null) {
                                    n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                                    n_frequency_included = true;
                                } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                                    String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                                    float min_frequency = Float.parseFloat(s_min_frequency);
                                    n = ((int)min_frequency - 1471) / 20;
                                    n_frequency_included = true;
                                }
                                if (n_frequency_included) {
                                    commonBitmapLabelSet = true;
                                } else {
                                    log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                                }
                            }
                            ++k2;
                        }
                        ++i;
                    }
                    NodeList edges = element_domain.getElementsByTagName("edge");
                    int i3 = 0;
                    while (i3 < edges.getLength()) {
                        DefaultWeightedEdge edge;
                        String type;
                        log.debug("New Link");
                        Element element = (Element)edges.item(i3);
                        Attr attr_type = element.getAttributeNode("type");
                        if (attr_type == null) {
                            type = "intradomain";
                        } else {
                            type = attr_type.getValue();
                            if (layer != null && layer.equals("interlayer")) {
                                type = "intradomain";
                            }
                        }
                        log.debug("type::" + type);
                        if (type.equals("intradomain")) {
                            edge = new IntraDomainEdge();
                            NodeList source = element.getElementsByTagName("source");
                            Element source_router_el = (Element)source.item(0);
                            edge.setLearntFrom(learntFrom);
                            NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                            Element source_router_id_el = (Element)source_router_id.item(0);
                            String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                            s_router_id_addr = EdgeUtils.getEdge(s_r_id);
                            NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                            Element source_if_id_el = (Element)source_if_id_nl.item(0);
                            int src_if_id = -1;
                            if (source_if_id_el != null) {
                                String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                                src_if_id = Integer.parseInt(s_source_if_id);
                            }
                            log.debug("SRC if id: " + src_if_id);
                            NodeList source_Numif_id_nl = source_router_el.getElementsByTagName("NumIf_id");
                            Element source_Numif_id_el = (Element)source_Numif_id_nl.item(0);
                            if (source_Numif_id_el != null) {
                                String s_source_Numif_id = FileTEDBUpdater.getCharacterDataFromElement(source_Numif_id_el);
                                try {
                                    src_Numif_id = (Inet4Address)Inet4Address.getByName(s_source_Numif_id);
                                }
                                catch (Exception e) {
                                    src_Numif_id = DataPathID.getByName(s_source_Numif_id);
                                }
                            }
                            NodeList dest_nl = element.getElementsByTagName("destination");
                            Element dest_el = (Element)dest_nl.item(0);
                            NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                            Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                            String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                            d_router_id_addr = EdgeUtils.getEdge(d_r_id);
                            if (SIDS.get(s_router_id_addr) != null && SIDS.get(d_router_id_addr) != null) {
                                log.debug("setting SIDS src: " + SIDS.get(s_router_id_addr) + " dst: " + SIDS.get(d_router_id_addr));
                                edge.setSrc_sid((Integer)SIDS.get(s_router_id_addr));
                                edge.setDst_sid((Integer)SIDS.get(d_router_id_addr));
                                log.debug("edge.getSrc_sid(): " + edge.getSrc_sid());
                                log.debug("edge.getDst_sid(): " + edge.getDst_sid());
                            } else if (SIDSDP.get(s_router_id_addr) != null && SIDSDP.get(d_router_id_addr) != null) {
                                log.debug("setting SIDSDP src: " + SIDSDP.get(s_router_id_addr) + " dst: " + SIDSDP.get(d_router_id_addr));
                                edge.setSrc_sid((Integer)SIDSDP.get(s_router_id_addr));
                                edge.setDst_sid((Integer)SIDSDP.get(d_router_id_addr));
                                log.debug("edge.getSrc_sid(): " + edge.getSrc_sid());
                                log.debug("edge.getDst_sid(): " + edge.getDst_sid());
                            }
                            NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                            Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                            int dst_if_id = -1;
                            if (dest_if_id_el != null) {
                                String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                                dst_if_id = Integer.parseInt(s_dest_if_id);
                            }
                            log.debug("DST if id: " + dst_if_id);
                            NodeList dest_Numif_id_nl = dest_el.getElementsByTagName("NumIf_id");
                            Element dest_Numif_id_el = (Element)dest_Numif_id_nl.item(0);
                            if (source_Numif_id_el != null) {
                                String s_dest_Numif_id = FileTEDBUpdater.getCharacterDataFromElement(dest_Numif_id_el);
                                try {
                                    dst_Numif_id = (Inet4Address)Inet4Address.getByName(s_dest_Numif_id);
                                }
                                catch (Exception e) {
                                    dst_Numif_id = DataPathID.getByName(s_dest_Numif_id);
                                }
                            }
                            if (src_Numif_id != null) {
                                edge.setSrc_Numif_id(src_Numif_id);
                            }
                            if (dst_Numif_id != null) {
                                edge.setDst_Numif_id(dst_Numif_id);
                            } else {
                                if (src_if_id != -1) {
                                    edge.setSrc_if_id(src_if_id);
                                }
                                if (dst_if_id != -1) {
                                    edge.setDst_if_id(dst_if_id);
                                }
                            }
                            NodeList delay_ms_nl = element.getElementsByTagName("delay");
                            if (delay_ms_nl.getLength() > 0) {
                                Element delay_ms_el = (Element)delay_ms_nl.item(0);
                                String s_delay_ms = FileTEDBUpdater.getCharacterDataFromElement(delay_ms_el);
                                double delay_ms = Double.parseDouble(s_delay_ms);
                                edge.setDelay_ms(delay_ms);
                            }
                            edge.setTE_info(FileTEDBUpdater.readTE_INFOfromXml(tE_info_common, element, commonBitmapLabelSet, numLabels, grid, cs, n, lambdaIni, lambdaEnd));
                            NodeList availableLabels_node = element.getElementsByTagName("AvailableLabels");
                            if (availableLabels_node != null) {
                                int k3 = 0;
                                while (k3 < availableLabels_node.getLength()) {
                                    Element availableLabels_e = (Element)availableLabels_node.item(k3);
                                    NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                                    Element labelSetField_el = (Element)labelSetField_node.item(0);
                                    if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                                        NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                                        Element numbLabels_e = (Element)numbLabels_node.item(0);
                                        String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                                        numLabels = Integer.parseInt(numbLabels_s);
                                        NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                                        Element baseLabel_e = (Element)baseLabel_node.item(0);
                                        byte[] bitmap = new byte[1];
                                        NodeList bitmap_node = labelSetField_el.getElementsByTagName("bitmap");
                                        int result = 0;
                                        Element bitmap_e = (Element)bitmap_node.item(0);
                                        if (bitmap_e != null) {
                                            String bitmap_string = FileTEDBUpdater.getCharacterDataFromElement(bitmap_e);
                                            System.out.println("Bitmap read: " + bitmap_string);
                                            int p = 0;
                                            while (p < bitmap_string.length()) {
                                                result = (int)((double)result + Math.pow(2.0, bitmap_string.length() - p - 1) * (double)(bitmap_string.charAt(p) - 48));
                                                ++p;
                                            }
                                            bitmap[0] = (byte)result;
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).setBytesBitmap(bitmap);
                                        }
                                        grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                                        cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                                        boolean n_frequency_included = false;
                                        if (baseLabel_e.getAttributeNode("n") != null) {
                                            n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                                            n_frequency_included = true;
                                        } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                                            String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                                            float min_frequency = Float.parseFloat(s_min_frequency);
                                            n = ((int)min_frequency - 1471) / 20;
                                            n_frequency_included = true;
                                        }
                                        if (n_frequency_included) {
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).setNumLabels(numLabels);
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().setGrid(grid);
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().setChannelSpacing(cs);
                                            ((BitmapLabelSet)edge.getTE_info().getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().setN(n);
                                        } else {
                                            log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                                        }
                                    }
                                    ++k3;
                                }
                            }
                            log.debug("Preparing to add edge");
                            log.debug("NODES IN GRAPH:: " + graph.vertexSet());
                            try {
                                if (graph.containsEdge(s_router_id_addr, d_router_id_addr)) {
                                    log.debug("New Intradomain Edge");
                                    ((IntraDomainEdge)((Object)graph.getEdge(s_router_id_addr, d_router_id_addr))).setNumberFibers(((IntraDomainEdge)((Object)graph.getEdge(s_router_id_addr, d_router_id_addr))).getNumberFibers() + 1);
                                    log.debug("s_router_id_addr: " + s_router_id_addr.toString() + "; d_router_id_addr: " + d_router_id_addr.toString() + "; edge: " + edge);
                                    log.info("New intradomain link: " + s_router_id_addr.toString() + " --> " + d_router_id_addr.toString());
                                } else {
                                    log.debug("s_router_id_addr: " + s_router_id_addr.toString() + "; d_router_id_addr: " + d_router_id_addr.toString() + "; edge: " + edge);
                                    if (!graph.containsVertex(d_router_id_addr)) {
                                        type = "interdomain";
                                    } else {
                                        graph.addEdge(s_router_id_addr, d_router_id_addr, (Object)edge);
                                        ((IntraDomainEdge)((Object)graph.getEdge(s_router_id_addr, d_router_id_addr))).setNumberFibers(1);
                                        log.debug("New Intradomain Edge");
                                        log.info("New intradomain link: " + s_router_id_addr.toString() + " --> " + d_router_id_addr.toString() + " learnt " + edge.getLearntFrom());
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("Problem with source " + s_router_id_addr + " destination " + d_router_id_addr);
                                e.printStackTrace();
                                System.exit(-1);
                            }
                        }
                        if (type.equals("interdomain")) {
                            log.debug("New Interdomain Edge");
                            edge = new InterDomainEdge();
                            TE_Information tE_info = FileTEDBUpdater.readTE_INFOfromXml(tE_info_common, element, false, numLabels, grid, cs, n, 0, Integer.MAX_VALUE);
                            edge.setTE_info(tE_info);
                            edge.setLearntFrom(learntFrom);
                            NodeList source = element.getElementsByTagName("source");
                            Element source_router_el = (Element)source.item(0);
                            NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                            Element source_router_id_el = (Element)source_router_id.item(0);
                            String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                            log.debug("Edge Source router_id: " + s_r_id);
                            try {
                                s_router_id_addr = (Inet4Address)Inet4Address.getByName(s_r_id);
                            }
                            catch (Exception e) {
                                s_router_id_addr = DataPathID.getByName(s_r_id);
                            }
                            Inet4Address source_domain_id = (Inet4Address)Inet4Address.getByName(domain_id);
                            log.debug("Edge Source domain_id: " + source_domain_id);
                            NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                            Element source_if_id_el = (Element)source_if_id_nl.item(0);
                            String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                            log.debug("Edge Source if_id: " + s_source_if_id);
                            int src_if_id = Integer.parseInt(s_source_if_id);
                            NodeList dest_nl = element.getElementsByTagName("destination");
                            Element dest_el = (Element)dest_nl.item(0);
                            NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                            Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                            String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                            log.debug("Edge Destination router_id: " + d_r_id);
                            try {
                                d_router_id_addr = (Inet4Address)Inet4Address.getByName(d_r_id);
                            }
                            catch (Exception e) {
                                d_router_id_addr = DataPathID.getByName(d_r_id);
                            }
                            log.debug("Destination domain_id: <Unknown>");
                            NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                            Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                            String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                            log.debug("Edge Dest if_id: " + s_dest_if_id);
                            int dst_if_id = Integer.parseInt(s_dest_if_id);
                            edge.setSrc_if_id(src_if_id);
                            edge.setDst_if_id(dst_if_id);
                            edge.setDomain_src_router(source_domain_id);
                            edge.setSrc_router_id(s_router_id_addr);
                            edge.setDst_router_id(d_router_id_addr);
                            if (domainTEDB.getInterDomainLinks() == null) {
                                LinkedList<InterDomainEdge> interDomainLinks = new LinkedList<InterDomainEdge>();
                                interDomainLinks.add((InterDomainEdge)edge);
                                domainTEDB.setInterDomainLinks(interDomainLinks);
                                log.info("New interdomain link: " + s_router_id_addr.toString() + " --> " + d_router_id_addr.toString() + " learnt " + edge.getLearntFrom());
                            } else {
                                domainTEDB.getInterDomainLinks().add((InterDomainEdge)edge);
                                log.info("New interdomain link: " + s_router_id_addr.toString() + " --> " + d_router_id_addr.toString() + " learnt " + edge.getLearntFrom());
                            }
                        }
                        ++i3;
                    }
                }
                log.debug("Info graph edge :: " + graph.edgeSet());
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return TEDBs;
    }

    private static TE_Information readTE_INFOfromXml(TE_Information tE_info_common, Element element, Boolean commonBitmapLabelSet, int numLabels, int grid, int cs, int n, int lambdaIni, int lambdaEnd) {
        BGP4TLVFormat uldSTLV;
        NodeList undirDelayLinks;
        Element undirDelayLink;
        NodeList maximum_wlans_nl;
        int num_u_b;
        NodeList defaultmetric;
        Element metric_aux;
        NodeList maximum_bandwidth_nl;
        TE_Information tE_info = new TE_Information();
        if (commonBitmapLabelSet.booleanValue()) {
            if (lambdaEnd != Integer.MAX_VALUE) {
                tE_info.createBitmapLabelSet(numLabels, grid, cs, n, lambdaIni, lambdaEnd);
            } else {
                tE_info.createBitmapLabelSet(numLabels, grid, cs, n);
            }
        }
        if ((maximum_bandwidth_nl = element.getElementsByTagName("maximum_bandwidth")) != null) {
            if (maximum_bandwidth_nl.getLength() > 0) {
                Element maximum_bandwidth_el = (Element)maximum_bandwidth_nl.item(0);
                String s_maximum_bandwidth = FileTEDBUpdater.getCharacterDataFromElement(maximum_bandwidth_el);
                float maximum_bandwidth = Float.parseFloat(s_maximum_bandwidth);
                MaximumBandwidth maximumBandwidth = new MaximumBandwidth();
                maximumBandwidth.setMaximumBandwidth(maximum_bandwidth);
                tE_info.setMaximumBandwidth(maximumBandwidth);
            }
        } else if (tE_info_common != null && tE_info_common.getMaximumBandwidth() != null) {
            MaximumBandwidth maximumBandwidth = new MaximumBandwidth();
            maximumBandwidth.setMaximumBandwidth(tE_info_common.getMaximumBandwidth().getMaximumBandwidth());
            tE_info.setMaximumBandwidth(maximumBandwidth);
        }
        if ((metric_aux = (Element)(defaultmetric = element.getElementsByTagName("default_te_metric")).item(0)) != null) {
            String s_metric_aux = FileTEDBUpdater.getCharacterDataFromElement(metric_aux);
            int metric = Integer.parseInt(s_metric_aux);
            DefaultTEMetricLinkAttribTLV defaultTeMetric = new DefaultTEMetricLinkAttribTLV();
            defaultTeMetric.setLinkMetric(metric);
            tE_info.setDefaultTEMetric(defaultTeMetric);
        } else if (tE_info_common != null && tE_info_common.getDefaultTEMetric() != null) {
            DefaultTEMetricLinkAttribTLV defaultTeMetric = new DefaultTEMetricLinkAttribTLV();
            defaultTeMetric.setLinkMetric(tE_info_common.getDefaultTEMetric().getLinkMetric());
            tE_info.setDefaultTEMetric(defaultTeMetric);
        }
        NodeList unreserved_bandwidth_nl = element.getElementsByTagName("unreserved_bandwidth");
        if (unreserved_bandwidth_nl != null && (num_u_b = unreserved_bandwidth_nl.getLength()) > 0) {
            UnreservedBandwidth unreservedBandwidth = new UnreservedBandwidth();
            tE_info.setUnreservedBandwidth(unreservedBandwidth);
            int k = 0;
            while (k < num_u_b) {
                float unreserved_bandwidth;
                Element unreserved_bandwidth_el = (Element)unreserved_bandwidth_nl.item(k);
                String s_unreserved_bandwidth = FileTEDBUpdater.getCharacterDataFromElement(unreserved_bandwidth_el);
                String s_priority = unreserved_bandwidth_el.getAttributeNode("priority").getValue();
                Integer priority = Integer.valueOf(s_priority);
                unreservedBandwidth.getUnreservedBandwidth()[priority.intValue()] = unreserved_bandwidth = Float.parseFloat(s_unreserved_bandwidth);
                ++k;
            }
        }
        if ((maximum_wlans_nl = element.getElementsByTagName("number_wlans")) != null && maximum_wlans_nl.getLength() > 0) {
            Element number_wlan_el = (Element)maximum_wlans_nl.item(0);
            String s_number_wlans = FileTEDBUpdater.getCharacterDataFromElement(number_wlan_el);
            int number_wlans = Integer.parseInt(s_number_wlans.replace("\n", "").replaceAll("\\s", ""));
            tE_info.setNumberWLANs(number_wlans);
            tE_info.initWLANs();
        }
        if ((undirDelayLink = (Element)(undirDelayLinks = element.getElementsByTagName("undir_delay_link")).item(0)) != null) {
            String s_undirDelayLink = FileTEDBUpdater.getCharacterDataFromElement(undirDelayLink);
            int undirDelayLinkValue = Integer.parseInt(s_undirDelayLink);
            uldSTLV = new UndirectionalLinkDelayDescriptorSubTLV();
            ((UndirectionalLinkDelayDescriptorSubTLV)uldSTLV).setDelay(undirDelayLinkValue);
            tE_info.setUndirLinkDelay((UndirectionalLinkDelayDescriptorSubTLV)uldSTLV);
        } else if (tE_info_common != null && tE_info_common.getUndirLinkDelay() != null) {
            UndirectionalLinkDelayDescriptorSubTLV uldSTLV2 = new UndirectionalLinkDelayDescriptorSubTLV();
            uldSTLV2.setDelay(tE_info_common.getUndirLinkDelay().getDelay());
            tE_info.setUndirLinkDelay(uldSTLV2);
        }
        NodeList undirDelayVars = element.getElementsByTagName("undir_delay_variation");
        Element undirDelayVar = (Element)undirDelayVars.item(0);
        if (undirDelayVar != null) {
            String s_undirDelayVar = FileTEDBUpdater.getCharacterDataFromElement(undirDelayVar);
            int undirDelayVarValue = Integer.parseInt(s_undirDelayVar);
            UndirectionalDelayVariationDescriptorSubTLV udvSTLV = new UndirectionalDelayVariationDescriptorSubTLV();
            udvSTLV.setDelayVar(undirDelayVarValue);
            tE_info.setUndirDelayVar(udvSTLV);
        } else if (tE_info_common != null && tE_info_common.getUndirDelayVar() != null) {
            uldSTLV = new UndirectionalDelayVariationDescriptorSubTLV();
            ((UndirectionalDelayVariationDescriptorSubTLV)uldSTLV).setDelayVar(tE_info_common.getUndirDelayVar().getDelayVar());
            tE_info.setUndirDelayVar((UndirectionalDelayVariationDescriptorSubTLV)uldSTLV);
        }
        NodeList undirLinkLosss = element.getElementsByTagName("undir_link_loss");
        Element undirLinkLoss = (Element)undirLinkLosss.item(0);
        if (undirLinkLoss != null) {
            String s_undirLinkLoss = FileTEDBUpdater.getCharacterDataFromElement(undirLinkLoss);
            int undirLinkLossValue = Integer.parseInt(s_undirLinkLoss);
            UndirectionalLinkLossDescriptorSubTLV uSTLV = new UndirectionalLinkLossDescriptorSubTLV();
            uSTLV.setLinkLoss(undirLinkLossValue);
            tE_info.setUndirLinkLoss(uSTLV);
        } else if (tE_info_common != null && tE_info_common.getUndirLinkLoss() != null) {
            UndirectionalLinkLossDescriptorSubTLV uldSTLV3 = new UndirectionalLinkLossDescriptorSubTLV();
            uldSTLV3.setLinkLoss(tE_info_common.getUndirLinkLoss().getLinkLoss());
            tE_info.setUndirLinkLoss(uldSTLV3);
        }
        NodeList undirReBws = element.getElementsByTagName("undir_residual_bandwidth");
        Element undirReBw = (Element)undirReBws.item(0);
        if (undirReBw != null) {
            String s_undirReBw = FileTEDBUpdater.getCharacterDataFromElement(undirReBw);
            int undirReBwValue = Integer.parseInt(s_undirReBw);
            UndirectionalResidualBandwidthDescriptorSubTLV uSTLV = new UndirectionalResidualBandwidthDescriptorSubTLV();
            uSTLV.setResidualBw(undirReBwValue);
            tE_info.setUndirResidualBw(uSTLV);
        } else if (tE_info_common != null && tE_info_common.getUndirResidualBw() != null) {
            UndirectionalResidualBandwidthDescriptorSubTLV uldSTLV4 = new UndirectionalResidualBandwidthDescriptorSubTLV();
            uldSTLV4.setResidualBw(tE_info_common.getUndirResidualBw().getResidualBw());
            tE_info.setUndirResidualBw(uldSTLV4);
        }
        NodeList undirAvalBws = element.getElementsByTagName("undir_available_bandwidth");
        Element undirAvalBw = (Element)undirAvalBws.item(0);
        if (undirAvalBw != null) {
            String s_undirAvalBw = FileTEDBUpdater.getCharacterDataFromElement(undirAvalBw);
            int undirAvalBwValue = Integer.parseInt(s_undirAvalBw);
            UndirectionalAvailableBandwidthDescriptorSubTLV uSTLV = new UndirectionalAvailableBandwidthDescriptorSubTLV();
            uSTLV.setAvailableBw(undirAvalBwValue);
            tE_info.setUndirAvailableBw(uSTLV);
        } else if (tE_info_common != null && tE_info_common.getUndirAvailableBw() != null) {
            UndirectionalAvailableBandwidthDescriptorSubTLV uldSTLV5 = new UndirectionalAvailableBandwidthDescriptorSubTLV();
            uldSTLV5.setAvailableBw(tE_info_common.getUndirAvailableBw().getAvailableBw());
            tE_info.setUndirAvailableBw(uldSTLV5);
        }
        NodeList undirUtilBws = element.getElementsByTagName("undir_utilized_bandwidth");
        Element undirUtilBw = (Element)undirUtilBws.item(0);
        if (undirUtilBw != null) {
            String s_undirUtilBw = FileTEDBUpdater.getCharacterDataFromElement(undirUtilBw);
            int undirUtilBwValue = Integer.parseInt(s_undirUtilBw);
            UndirectionalUtilizedBandwidthDescriptorSubTLV uSTLV = new UndirectionalUtilizedBandwidthDescriptorSubTLV();
            uSTLV.setUtilizedBw(undirUtilBwValue);
            tE_info.setUndirUtilizedBw(uSTLV);
        } else if (tE_info_common != null && tE_info_common.getUndirUtilizedBw() != null) {
            UndirectionalUtilizedBandwidthDescriptorSubTLV uldSTLV6 = new UndirectionalUtilizedBandwidthDescriptorSubTLV();
            uldSTLV6.setUtilizedBw(tE_info_common.getUndirUtilizedBw().getUtilizedBw());
            tE_info.setUndirUtilizedBw(uldSTLV6);
        }
        NodeList minMaxDelays = element.getElementsByTagName("undir_min_max_delay");
        Element minMaxDelay = (Element)minMaxDelays.item(0);
        if (minMaxDelay != null) {
            NodeList minDelays = minMaxDelay.getElementsByTagName("min");
            Element minDelay = (Element)minDelays.item(0);
            NodeList maxDelays = minMaxDelay.getElementsByTagName("max");
            Element maxDelay = (Element)maxDelays.item(0);
            if (minDelay != null && maxDelay != null) {
                String s_minDelay = FileTEDBUpdater.getCharacterDataFromElement(minDelay);
                String s_maxDelay = FileTEDBUpdater.getCharacterDataFromElement(maxDelay);
                int minDelayValue = Integer.parseInt(s_minDelay);
                int maxDelayValue = Integer.parseInt(s_maxDelay);
                MinMaxUndirectionalLinkDelayDescriptorSubTLV ummSTLV = new MinMaxUndirectionalLinkDelayDescriptorSubTLV();
                ummSTLV.setHighDelay(maxDelayValue);
                ummSTLV.setLowDelay(minDelayValue);
                tE_info.setMinMaxUndirLinkDelay(ummSTLV);
            }
        } else if (tE_info_common != null && tE_info_common.getMinMaxUndirLinkDelay() != null) {
            MinMaxUndirectionalLinkDelayDescriptorSubTLV uldSTLV7 = new MinMaxUndirectionalLinkDelayDescriptorSubTLV();
            uldSTLV7.setHighDelay(tE_info_common.getMinMaxUndirLinkDelay().getHighDelay());
            uldSTLV7.setLowDelay(tE_info_common.getMinMaxUndirLinkDelay().getLowDelay());
            tE_info.setMinMaxUndirLinkDelay(uldSTLV7);
        }
        return tE_info;
    }

    public static SimpleDirectedWeightedGraph<Object, IntraDomainEdge> readITNetwork(String fileName) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        SimpleDirectedWeightedGraph graph = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
        Object router_id_addr = null;
        Object it_site_id_addr = null;
        Object resource_addr = null;
        Object s_id_addr = null;
        Object d_id_addr = null;
        Object s_router_id_addr = null;
        Object d_router_id_addr = null;
        Object s_it_site_id_addr = null;
        Object d_it_site_id_addr = null;
        Object s_resource_id_addr = null;
        Object d_resource_id_addr = null;
        log.debug("2. SimpleDirectedWeightedGraph");
        File file = new File(fileName);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            HashMap<Inet4Address, Integer> SIDS = new HashMap<Inet4Address, Integer>();
            HashMap<DataPathID, Integer> SIDSDP = new HashMap<DataPathID, Integer>();
            int j = 0;
            while (j < nodes_domains.getLength()) {
                Element element_domain = (Element)nodes_domains.item(j);
                NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                int k = 0;
                while (k < nodes_domain_id.getLength()) {
                    Element domain_id_e = (Element)nodes_domain_id.item(0);
                    String domain_id = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                    log.debug("Network domain: " + domain_id);
                    ++k;
                }
                NodeList nodes = doc.getElementsByTagName("node");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element element = (Element)nodes.item(i);
                    NodeList router_id_node = element.getElementsByTagName("router_id");
                    Element router_id_e = (Element)router_id_node.item(0);
                    String router_id = FileTEDBUpdater.getCharacterDataFromElement(router_id_e);
                    log.debug("El router_id es " + router_id);
                    try {
                        router_id_addr = (Inet4Address)Inet4Address.getByName(router_id);
                    }
                    catch (Exception e) {
                        router_id_addr = DataPathID.getByName(router_id);
                    }
                    graph.addVertex(router_id_addr);
                    Element SID_e = (Element)((Object)element.getElementsByTagName("sid"));
                    if (SID_e != null) {
                        int SID = Integer.parseInt(FileTEDBUpdater.getCharacterDataFromElement(SID_e));
                        try {
                            SIDS.put((Inet4Address)router_id_addr, SID);
                        }
                        catch (Exception e) {
                            SIDSDP.put((DataPathID)router_id_addr, SID);
                        }
                    }
                    ++i;
                }
                NodeList it_sites = doc.getElementsByTagName("it_site");
                int i2 = 0;
                while (i2 < it_sites.getLength()) {
                    Element element = (Element)it_sites.item(i2);
                    NodeList it_site_id_node = element.getElementsByTagName("it_site_id");
                    Element it_site_id_e = (Element)it_site_id_node.item(0);
                    String it_site_id = FileTEDBUpdater.getCharacterDataFromElement(it_site_id_e);
                    log.debug("El IT_site_id es " + it_site_id);
                    try {
                        it_site_id_addr = (Inet4Address)Inet4Address.getByName(it_site_id);
                    }
                    catch (Exception e) {
                        it_site_id_addr = DataPathID.getByName(it_site_id);
                    }
                    graph.addVertex(it_site_id_addr);
                    ++i2;
                }
                NodeList storages = doc.getElementsByTagName("storage");
                int i3 = 0;
                while (i3 < storages.getLength()) {
                    Element element = (Element)storages.item(i3);
                    NodeList resource_id_node = element.getElementsByTagName("resource_id");
                    Element resource_id_e = (Element)resource_id_node.item(0);
                    String resource_id = FileTEDBUpdater.getCharacterDataFromElement(resource_id_e);
                    log.debug("El resource_id es " + resource_id);
                    try {
                        resource_addr = (Inet4Address)Inet4Address.getByName(resource_id);
                    }
                    catch (Exception e) {
                        resource_addr = DataPathID.getByName(resource_id);
                    }
                    graph.addVertex(resource_addr);
                    ++i3;
                }
                NodeList edges = doc.getElementsByTagName("edge");
                int i4 = 0;
                while (i4 < edges.getLength()) {
                    Element element = (Element)edges.item(i4);
                    if (element.getAttributeNode("type").getValue().equals("intradomain")) {
                        NodeList dest_resource_id_nl;
                        NodeList dest_it_site_id_nl;
                        NodeList source_resource_id;
                        NodeList source_it_site_id;
                        IntraDomainEdge edge = new IntraDomainEdge();
                        NodeList source = element.getElementsByTagName("source");
                        Element source_router_el = (Element)source.item(0);
                        NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                        if (source_router_id.getLength() > 0) {
                            Element source_router_id_el = (Element)source_router_id.item(0);
                            String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                            try {
                                s_router_id_addr = (Inet4Address)Inet4Address.getByName(s_r_id);
                            }
                            catch (Exception e) {
                                s_router_id_addr = DataPathID.getByName(s_r_id);
                            }
                            s_id_addr = s_router_id_addr;
                        }
                        if ((source_it_site_id = source_router_el.getElementsByTagName("it_site_id")).getLength() > 0) {
                            Element source_it_site_id_el = (Element)source_it_site_id.item(0);
                            String s_itsite_id = FileTEDBUpdater.getCharacterDataFromElement(source_it_site_id_el);
                            log.debug("Edge Source IT_site_id: " + s_itsite_id);
                            try {
                                s_it_site_id_addr = (Inet4Address)Inet4Address.getByName(s_itsite_id);
                            }
                            catch (Exception e) {
                                s_it_site_id_addr = DataPathID.getByName(s_itsite_id);
                            }
                            s_id_addr = s_it_site_id_addr;
                        }
                        if ((source_resource_id = source_router_el.getElementsByTagName("resource_id")).getLength() > 0) {
                            Element source_resource_id_el = (Element)source_resource_id.item(0);
                            String s_resource_id = FileTEDBUpdater.getCharacterDataFromElement(source_resource_id_el);
                            log.debug("Edge Source resource_id: " + s_resource_id);
                            try {
                                s_resource_id_addr = (Inet4Address)Inet4Address.getByName(s_resource_id);
                            }
                            catch (Exception e) {
                                s_resource_id_addr = DataPathID.getByName(s_resource_id);
                            }
                            s_id_addr = s_resource_id_addr;
                        }
                        NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                        Element source_if_id_el = (Element)source_if_id_nl.item(0);
                        String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                        log.debug("Edge Source if_id: " + s_source_if_id);
                        int src_if_id = Integer.parseInt(s_source_if_id);
                        NodeList dest_nl = element.getElementsByTagName("destination");
                        Element dest_el = (Element)dest_nl.item(0);
                        NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                        if (dest_router_id_nl.getLength() > 0) {
                            Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                            String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                            log.debug("Edge Destination router_id: " + d_r_id);
                            try {
                                d_router_id_addr = (Inet4Address)Inet4Address.getByName(d_r_id);
                            }
                            catch (Exception e) {
                                d_router_id_addr = DataPathID.getByName(d_r_id);
                            }
                            d_id_addr = d_router_id_addr;
                        }
                        if ((dest_it_site_id_nl = dest_el.getElementsByTagName("it_site_id")).getLength() > 0) {
                            Element dest_it_site_id_el = (Element)dest_it_site_id_nl.item(0);
                            String d_it_site_id = FileTEDBUpdater.getCharacterDataFromElement(dest_it_site_id_el);
                            log.debug("Edge Destination IT_site_id: " + d_it_site_id);
                            try {
                                d_it_site_id_addr = (Inet4Address)Inet4Address.getByName(d_it_site_id);
                            }
                            catch (Exception e) {
                                d_it_site_id_addr = DataPathID.getByName(d_it_site_id);
                            }
                            d_id_addr = d_it_site_id_addr;
                        }
                        if ((dest_resource_id_nl = dest_el.getElementsByTagName("resource_id")).getLength() > 0) {
                            Element dest_resource_id_el = (Element)dest_resource_id_nl.item(0);
                            String d_resource_id = FileTEDBUpdater.getCharacterDataFromElement(dest_resource_id_el);
                            log.debug("Edge Destination resource_id: " + d_resource_id);
                            try {
                                d_resource_id_addr = (Inet4Address)Inet4Address.getByName(d_resource_id);
                            }
                            catch (Exception e) {
                                d_resource_id_addr = DataPathID.getByName(d_resource_id);
                            }
                            d_id_addr = d_resource_id_addr;
                        }
                        NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                        Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                        String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                        log.debug("Edge Dest if_id: " + s_dest_if_id);
                        int dst_if_id = Integer.parseInt(s_dest_if_id);
                        edge.setSrc_if_id(src_if_id);
                        edge.setDst_if_id(dst_if_id);
                        if (SIDS.get(s_id_addr) != null && SIDS.get(d_id_addr) != null) {
                            edge.setSrc_sid((Integer)SIDS.get(s_id_addr));
                            edge.setSrc_sid((Integer)SIDS.get(d_id_addr));
                        }
                        graph.addEdge(s_id_addr, d_id_addr, (Object)edge);
                    }
                    ++i4;
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graph;
    }

    public static Inet4Address readNetworkDomain(String fileName) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        File file = new File(fileName);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            Element element_domain = (Element)nodes_domains.item(0);
            NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
            Element domain_id_e = (Element)nodes_domain_id.item(0);
            String domain_id = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
            log.info("Network domain: " + domain_id);
            Inet4Address domId = (Inet4Address)Inet4Address.getByName(domain_id);
            return domId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }

    public static DirectedWeightedMultigraph<Object, InterDomainEdge> readMDNetwork(String fileName) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        DirectedWeightedMultigraph graph = new DirectedWeightedMultigraph(InterDomainEdge.class);
        Hashtable<Object, Inet4Address> router_id_domain_ed = new Hashtable<Object, Inet4Address>();
        Hashtable router_id_domain_ed_dp = new Hashtable();
        HashMap<Inet4Address, Integer> SIDS = new HashMap<Inet4Address, Integer>();
        HashMap<DataPathID, Integer> SIDSDP = new HashMap<DataPathID, Integer>();
        Object router_id_addr = null;
        Object s_router_id_addr = null;
        Object d_router_id_addr = null;
        File file = new File(fileName);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            log.info("Multidomain Graph");
            int j = 0;
            while (j < nodes_domains.getLength()) {
                Element element_domain = (Element)nodes_domains.item(j);
                NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                Element domain_id_e = (Element)nodes_domain_id.item(0);
                String domain_id_str = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                Inet4Address domain_id = (Inet4Address)Inet4Address.getByName(domain_id_str);
                log.info("Adding Domain: " + domain_id);
                graph.addVertex((Object)domain_id);
                NodeList nodes = element_domain.getElementsByTagName("node");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element element = (Element)nodes.item(i);
                    NodeList router_id_node = element.getElementsByTagName("router_id");
                    Element router_id_e = (Element)router_id_node.item(0);
                    String router_id = FileTEDBUpdater.getCharacterDataFromElement(router_id_e);
                    log.debug("Router_id: " + router_id);
                    try {
                        router_id_addr = (Inet4Address)Inet4Address.getByName(router_id);
                    }
                    catch (Exception e) {
                        router_id_addr = DataPathID.getByName(router_id);
                    }
                    router_id_domain_ed.put(router_id_addr, domain_id);
                    NodeList nl_sid = element.getElementsByTagName("sid");
                    Element SID_e = (Element)nl_sid.item(0);
                    if (SID_e != null) {
                        int SID = Integer.parseInt(FileTEDBUpdater.getCharacterDataFromElement(SID_e));
                        try {
                            SIDS.put((Inet4Address)router_id_addr, SID);
                        }
                        catch (Exception e) {
                            SIDSDP.put((DataPathID)router_id_addr, SID);
                        }
                    }
                    ++i;
                }
                ++j;
            }
            log.debug("Domain_ids read");
            int numLabels = 0;
            Boolean commonBitmapLabelSet = false;
            NodeList edgeCommon = doc.getElementsByTagName("edgeCommon");
            int grid = 0;
            int cs = 0;
            int n = 0;
            int i = 0;
            while (i < edgeCommon.getLength()) {
                Element edgeCommonElement = (Element)edgeCommon.item(i);
                NodeList availableLabels_node = edgeCommonElement.getElementsByTagName("AvailableLabels");
                int k = 0;
                while (k < availableLabels_node.getLength()) {
                    Element availableLabels_e = (Element)availableLabels_node.item(k);
                    NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                    Element labelSetField_el = (Element)labelSetField_node.item(0);
                    if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                        NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                        Element numbLabels_e = (Element)numbLabels_node.item(0);
                        String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                        numLabels = Integer.parseInt(numbLabels_s);
                        NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                        Element baseLabel_e = (Element)baseLabel_node.item(0);
                        grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                        cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                        boolean n_frequency_included = false;
                        if (baseLabel_e.getAttributeNode("n") != null) {
                            n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                            n_frequency_included = true;
                        } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                            String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                            float min_frequency = Float.parseFloat(s_min_frequency);
                            n = ((int)min_frequency - 1471) / 20;
                            n_frequency_included = true;
                        }
                        if (n_frequency_included) {
                            commonBitmapLabelSet = true;
                        } else {
                            log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                        }
                    }
                    ++k;
                }
                ++i;
            }
            NodeList edges = doc.getElementsByTagName("edge");
            boolean a = true;
            int i2 = 0;
            while (i2 < edges.getLength()) {
                log.debug("Looking at edge");
                Element element = (Element)edges.item(i2);
                InterDomainEdge edge = new InterDomainEdge();
                TE_Information tE_info = FileTEDBUpdater.readTE_INFOfromXml(null, element, false, numLabels, grid, cs, n, 0, Integer.MAX_VALUE);
                edge.setTE_info(tE_info);
                NodeList source = element.getElementsByTagName("source");
                Element source_router_el = (Element)source.item(0);
                NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                Element source_router_id_el = (Element)source_router_id.item(0);
                String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                log.debug("Edge Source router_id: " + s_r_id);
                try {
                    s_router_id_addr = (Inet4Address)Inet4Address.getByName(s_r_id);
                }
                catch (Exception e) {
                    s_router_id_addr = DataPathID.getByName(s_r_id);
                }
                Inet4Address source_domain_id = (Inet4Address)router_id_domain_ed.get(s_router_id_addr);
                log.debug("Edge Source domain_id: " + source_domain_id);
                NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                Element source_if_id_el = (Element)source_if_id_nl.item(0);
                String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                log.debug("Edge Source if_id: " + s_source_if_id);
                int src_if_id = Integer.parseInt(s_source_if_id);
                NodeList dest_nl = element.getElementsByTagName("destination");
                Element dest_el = (Element)dest_nl.item(0);
                NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                log.debug("Edge Destination router_id: " + d_r_id);
                try {
                    d_router_id_addr = (Inet4Address)Inet4Address.getByName(d_r_id);
                }
                catch (Exception e) {
                    d_router_id_addr = DataPathID.getByName(d_r_id);
                }
                Inet4Address dest_domain_id = (Inet4Address)router_id_domain_ed.get(d_router_id_addr);
                log.debug("Destination domain_id: " + dest_domain_id);
                NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                log.debug("Edge Dest if_id: " + s_dest_if_id);
                int dst_if_id = Integer.parseInt(s_dest_if_id);
                edge.setSrc_if_id(src_if_id);
                edge.setDst_if_id(dst_if_id);
                edge.setDomain_src_router(source_domain_id);
                edge.setDomain_dst_router(dest_domain_id);
                edge.setSrc_router_id(s_router_id_addr);
                edge.setDst_router_id(d_router_id_addr);
                if (!source_domain_id.equals(dest_domain_id)) {
                    log.info("Adding interdomain link " + source_domain_id.toString() + "-->" + dest_domain_id.toString());
                    graph.addEdge((Object)source_domain_id, (Object)dest_domain_id, (Object)edge);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graph;
    }

    public static DirectedWeightedMultigraph<Object, InterDomainEdge> readMDNetwork(String fileName, String LearntFrom) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        DirectedWeightedMultigraph graph = new DirectedWeightedMultigraph(InterDomainEdge.class);
        Hashtable<Object, Inet4Address> router_id_domain_ed = new Hashtable<Object, Inet4Address>();
        Hashtable router_id_domain_ed_dp = new Hashtable();
        HashMap<Inet4Address, Integer> SIDS = new HashMap<Inet4Address, Integer>();
        HashMap<DataPathID, Integer> SIDSDP = new HashMap<DataPathID, Integer>();
        Object router_id_addr = null;
        Object s_router_id_addr = null;
        Object d_router_id_addr = null;
        File file = new File(fileName);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            log.info("Multidomain Graph");
            int j = 0;
            while (j < nodes_domains.getLength()) {
                Element element_domain = (Element)nodes_domains.item(j);
                NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                Element domain_id_e = (Element)nodes_domain_id.item(0);
                String domain_id_str = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                Inet4Address domain_id = (Inet4Address)Inet4Address.getByName(domain_id_str);
                log.info("Adding Domain: " + domain_id);
                graph.addVertex((Object)domain_id);
                NodeList nodes = element_domain.getElementsByTagName("node");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element element = (Element)nodes.item(i);
                    NodeList router_id_node = element.getElementsByTagName("router_id");
                    Element router_id_e = (Element)router_id_node.item(0);
                    String router_id = FileTEDBUpdater.getCharacterDataFromElement(router_id_e);
                    log.debug("Router_id: " + router_id);
                    try {
                        router_id_addr = (Inet4Address)Inet4Address.getByName(router_id);
                    }
                    catch (Exception e) {
                        router_id_addr = DataPathID.getByName(router_id);
                    }
                    router_id_domain_ed.put(router_id_addr, domain_id);
                    NodeList nl_sid = element.getElementsByTagName("sid");
                    Element SID_e = (Element)nl_sid.item(0);
                    if (SID_e != null) {
                        int SID = Integer.parseInt(FileTEDBUpdater.getCharacterDataFromElement(SID_e));
                        try {
                            SIDS.put((Inet4Address)router_id_addr, SID);
                        }
                        catch (Exception e) {
                            SIDSDP.put((DataPathID)router_id_addr, SID);
                        }
                    }
                    ++i;
                }
                ++j;
            }
            log.debug("Domain_ids read");
            int numLabels = 0;
            Boolean commonBitmapLabelSet = false;
            NodeList edgeCommon = doc.getElementsByTagName("edgeCommon");
            int grid = 0;
            int cs = 0;
            int n = 0;
            int i = 0;
            while (i < edgeCommon.getLength()) {
                Element edgeCommonElement = (Element)edgeCommon.item(i);
                NodeList availableLabels_node = edgeCommonElement.getElementsByTagName("AvailableLabels");
                int k = 0;
                while (k < availableLabels_node.getLength()) {
                    Element availableLabels_e = (Element)availableLabels_node.item(k);
                    NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                    Element labelSetField_el = (Element)labelSetField_node.item(0);
                    if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                        NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                        Element numbLabels_e = (Element)numbLabels_node.item(0);
                        String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                        numLabels = Integer.parseInt(numbLabels_s);
                        NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                        Element baseLabel_e = (Element)baseLabel_node.item(0);
                        grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                        cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                        boolean n_frequency_included = false;
                        if (baseLabel_e.getAttributeNode("n") != null) {
                            n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                            n_frequency_included = true;
                        } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                            String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                            float min_frequency = Float.parseFloat(s_min_frequency);
                            n = ((int)min_frequency - 1471) / 20;
                            n_frequency_included = true;
                        }
                        if (n_frequency_included) {
                            commonBitmapLabelSet = true;
                        } else {
                            log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                        }
                    }
                    ++k;
                }
                ++i;
            }
            NodeList edges = doc.getElementsByTagName("edge");
            boolean a = true;
            int i2 = 0;
            while (i2 < edges.getLength()) {
                log.debug("Looking at edge");
                Element element = (Element)edges.item(i2);
                InterDomainEdge edge = new InterDomainEdge();
                TE_Information tE_info = FileTEDBUpdater.readTE_INFOfromXml(null, element, false, numLabels, grid, cs, n, 0, Integer.MAX_VALUE);
                edge.setTE_info(tE_info);
                edge.setLearntFrom(LearntFrom);
                NodeList source = element.getElementsByTagName("source");
                Element source_router_el = (Element)source.item(0);
                NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                Element source_router_id_el = (Element)source_router_id.item(0);
                String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                log.debug("Edge Source router_id: " + s_r_id);
                try {
                    s_router_id_addr = (Inet4Address)Inet4Address.getByName(s_r_id);
                }
                catch (Exception e) {
                    s_router_id_addr = DataPathID.getByName(s_r_id);
                }
                Inet4Address source_domain_id = (Inet4Address)router_id_domain_ed.get(s_router_id_addr);
                log.debug("Edge Source domain_id: " + source_domain_id);
                NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                Element source_if_id_el = (Element)source_if_id_nl.item(0);
                String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                log.debug("Edge Source if_id: " + s_source_if_id);
                int src_if_id = Integer.parseInt(s_source_if_id);
                NodeList dest_nl = element.getElementsByTagName("destination");
                Element dest_el = (Element)dest_nl.item(0);
                NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                log.debug("Edge Destination router_id: " + d_r_id);
                try {
                    d_router_id_addr = (Inet4Address)Inet4Address.getByName(d_r_id);
                }
                catch (Exception e) {
                    d_router_id_addr = DataPathID.getByName(d_r_id);
                }
                Inet4Address dest_domain_id = (Inet4Address)router_id_domain_ed.get(d_router_id_addr);
                log.debug("Destination domain_id: " + dest_domain_id);
                NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                log.debug("Edge Dest if_id: " + s_dest_if_id);
                int dst_if_id = Integer.parseInt(s_dest_if_id);
                edge.setSrc_if_id(src_if_id);
                edge.setDst_if_id(dst_if_id);
                edge.setDomain_src_router(source_domain_id);
                edge.setDomain_dst_router(dest_domain_id);
                edge.setSrc_router_id(s_router_id_addr);
                edge.setDst_router_id(d_router_id_addr);
                if (!source_domain_id.equals(dest_domain_id)) {
                    log.info("Adding interdomain link " + source_domain_id.toString() + "-->" + dest_domain_id.toString() + " learnt " + edge.getLearntFrom());
                    graph.addEdge((Object)source_domain_id, (Object)dest_domain_id, (Object)edge);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graph;
    }

    public static void initializeReachabilityFromFile(String fileName, ReachabilityManager rm) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        log.debug("Initializing reachability from " + fileName);
        File file = new File(fileName);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            int j = 0;
            while (j < nodes_domains.getLength()) {
                Element element_domain = (Element)nodes_domains.item(j);
                NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                Element domain_id_e = (Element)nodes_domain_id.item(0);
                String domain_id_str = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                Inet4Address domain_id = (Inet4Address)Inet4Address.getByName(domain_id_str);
                log.debug("Network domain es: " + domain_id);
                NodeList nodes = element_domain.getElementsByTagName("reachability_entry");
                log.debug("HAY : " + nodes.getLength());
                int i = 0;
                while (i < nodes.getLength()) {
                    Element element = (Element)nodes.item(i);
                    NodeList ipv4_address_node = element.getElementsByTagName("ipv4_address");
                    Element ipv4_address_el = (Element)ipv4_address_node.item(0);
                    String ipv4_address_str = FileTEDBUpdater.getCharacterDataFromElement(ipv4_address_el);
                    log.debug("ipv4_address: " + ipv4_address_str);
                    Inet4Address ipv4_address = (Inet4Address)Inet4Address.getByName(ipv4_address_str);
                    IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
                    eroso.setIpv4address(ipv4_address);
                    NodeList prefix_node = element.getElementsByTagName("prefix");
                    Element prefix_el = (Element)prefix_node.item(0);
                    String prefix_str = FileTEDBUpdater.getCharacterDataFromElement(prefix_el);
                    int prefix = Integer.parseInt(prefix_str);
                    eroso.setPrefix(prefix);
                    rm.addEROSubobject(domain_id, eroso);
                    ++i;
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DirectedWeightedMultigraph<Object, InterDomainEdge> readITMDNetwork(String fileName) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        DirectedWeightedMultigraph graph = new DirectedWeightedMultigraph(InterDomainEdge.class);
        Hashtable<Inet4Address, Inet4Address> router_id_domain_ed = new Hashtable<Inet4Address, Inet4Address>();
        Hashtable<Inet4Address, Inet4Address> it_site_id_domain_ed2 = new Hashtable<Inet4Address, Inet4Address>();
        Hashtable<Inet4Address, Inet4Address> resource_id_domain_ed = new Hashtable<Inet4Address, Inet4Address>();
        File file = new File(fileName);
        try {
            Element element;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            int j = 0;
            while (j < nodes_domains.getLength()) {
                Element element_domain = (Element)nodes_domains.item(j);
                NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                Element domain_id_e = (Element)nodes_domain_id.item(0);
                String domain_id_str = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                Inet4Address domain_id = (Inet4Address)Inet4Address.getByName(domain_id_str);
                log.info("Network domain: " + domain_id);
                graph.addVertex((Object)domain_id);
                NodeList nodes = element_domain.getElementsByTagName("node");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element element2 = (Element)nodes.item(i);
                    NodeList router_id_node = element2.getElementsByTagName("router_id");
                    Element router_id_e = (Element)router_id_node.item(0);
                    String router_id = FileTEDBUpdater.getCharacterDataFromElement(router_id_e);
                    log.debug("El router_id es " + router_id);
                    Inet4Address router_id_addr = (Inet4Address)Inet4Address.getByName(router_id);
                    NodeList domain_id_node = element2.getElementsByTagName("domain_id");
                    router_id_domain_ed.put(router_id_addr, domain_id);
                    ++i;
                }
                NodeList ITsites = element_domain.getElementsByTagName("it_site");
                int i2 = 0;
                while (i2 < ITsites.getLength()) {
                    Element element3 = (Element)ITsites.item(i2);
                    NodeList it_site_id_node = element3.getElementsByTagName("it_site_id");
                    Element it_site_id_e = (Element)it_site_id_node.item(0);
                    String it_site_id = FileTEDBUpdater.getCharacterDataFromElement(it_site_id_e);
                    log.info("El it_site_id es " + it_site_id);
                    Inet4Address it_site_id_addr = (Inet4Address)Inet4Address.getByName(it_site_id);
                    NodeList domain_id_node = element3.getElementsByTagName("domain_id");
                    it_site_id_domain_ed2.put(it_site_id_addr, domain_id);
                    ++i2;
                }
                NodeList storages = element_domain.getElementsByTagName("storage");
                int i3 = 0;
                while (i3 < storages.getLength()) {
                    element = (Element)storages.item(i3);
                    NodeList resource_id_node = element.getElementsByTagName("resource_id");
                    Element resource_id_e = (Element)resource_id_node.item(0);
                    String resource_id = FileTEDBUpdater.getCharacterDataFromElement(resource_id_e);
                    log.info("El resource_id es " + resource_id);
                    Inet4Address resource_id_addr = (Inet4Address)Inet4Address.getByName(resource_id);
                    NodeList domain_id_node = element.getElementsByTagName("domain_id");
                    resource_id_domain_ed.put(resource_id_addr, domain_id);
                    ++i3;
                }
                ++j;
            }
            NodeList edges = doc.getElementsByTagName("edge");
            int i = 0;
            while (i < edges.getLength()) {
                NodeList dest_resource_id_nl;
                NodeList dest_it_site_id_nl;
                NodeList source_resource_id;
                NodeList source_it_site_id;
                log.info("New interdomain edge");
                Inet4Address s_router_id_addr = null;
                Inet4Address d_router_id_addr = null;
                Inet4Address s_itsite_id_addr = null;
                Inet4Address d_itsite_id_addr = null;
                Inet4Address s_resource_id_addr = null;
                Inet4Address d_resource_id_addr = null;
                Inet4Address source_domain_id = null;
                Inet4Address dest_domain_id = null;
                element = (Element)edges.item(i);
                InterDomainEdge edge = new InterDomainEdge();
                NodeList source = element.getElementsByTagName("source");
                Element source_router_el = (Element)source.item(0);
                NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                if (source_router_id.getLength() > 0) {
                    Element source_router_id_el = (Element)source_router_id.item(0);
                    String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                    log.info("Edge Source router_id: " + s_r_id);
                    s_router_id_addr = (Inet4Address)Inet4Address.getByName(s_r_id);
                    source_domain_id = (Inet4Address)router_id_domain_ed.get(s_router_id_addr);
                    log.info("Edge Source domain_id: " + source_domain_id);
                }
                if ((source_it_site_id = source_router_el.getElementsByTagName("it_site_id")).getLength() > 0) {
                    Element source_it_site_id_el = (Element)source_it_site_id.item(0);
                    String s_itsite_id = FileTEDBUpdater.getCharacterDataFromElement(source_it_site_id_el);
                    log.info("Edge Source it_site_id: " + s_itsite_id);
                    s_itsite_id_addr = (Inet4Address)Inet4Address.getByName(s_itsite_id);
                    source_domain_id = (Inet4Address)it_site_id_domain_ed2.get(s_itsite_id_addr);
                    log.info("Edge Source ITsite domain_id: " + source_domain_id);
                }
                if ((source_resource_id = source_router_el.getElementsByTagName("resource_id")).getLength() > 0) {
                    Element source_resource_id_el = (Element)source_resource_id.item(0);
                    String s_resource_id = FileTEDBUpdater.getCharacterDataFromElement(source_resource_id_el);
                    log.info("Edge Source resource_id: " + s_resource_id);
                    s_resource_id_addr = (Inet4Address)Inet4Address.getByName(s_resource_id);
                    source_domain_id = (Inet4Address)resource_id_domain_ed.get(s_resource_id_addr);
                    log.info("Edge Source ITsite domain_id: " + source_domain_id);
                }
                NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                Element source_if_id_el = (Element)source_if_id_nl.item(0);
                String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                log.info("Edge Source if_id: " + s_source_if_id);
                int src_if_id = Integer.parseInt(s_source_if_id);
                NodeList dest_nl = element.getElementsByTagName("destination");
                Element dest_el = (Element)dest_nl.item(0);
                NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                if (dest_router_id_nl.getLength() > 0) {
                    Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                    String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                    log.info("Edge Destination router_id: " + d_r_id);
                    d_router_id_addr = (Inet4Address)Inet4Address.getByName(d_r_id);
                    dest_domain_id = (Inet4Address)router_id_domain_ed.get(d_router_id_addr);
                    log.info("Destination domain_id: " + dest_domain_id);
                }
                if ((dest_it_site_id_nl = dest_el.getElementsByTagName("it_site_id")).getLength() > 0) {
                    Element dest_it_site_id_el = (Element)dest_it_site_id_nl.item(0);
                    String d_itsite_id = FileTEDBUpdater.getCharacterDataFromElement(dest_it_site_id_el);
                    log.info("Edge Destination it_site_id: " + d_itsite_id);
                    d_itsite_id_addr = (Inet4Address)Inet4Address.getByName(d_itsite_id);
                    dest_domain_id = (Inet4Address)it_site_id_domain_ed2.get(d_itsite_id_addr);
                    log.info("Destination ITsite domain_id: " + dest_domain_id);
                }
                if ((dest_resource_id_nl = dest_el.getElementsByTagName("resource_id")).getLength() > 0) {
                    Element dest_resource_id_el = (Element)dest_resource_id_nl.item(0);
                    String d_resource_id = FileTEDBUpdater.getCharacterDataFromElement(dest_resource_id_el);
                    log.info("Edge Destination resource_id: " + d_resource_id);
                    d_resource_id_addr = (Inet4Address)Inet4Address.getByName(d_resource_id);
                    dest_domain_id = (Inet4Address)resource_id_domain_ed.get(d_resource_id_addr);
                    log.info("Destination ITsite domain_id: " + dest_domain_id);
                }
                NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                log.info("Edge Dest if_id: " + s_dest_if_id);
                int dst_if_id = Integer.parseInt(s_dest_if_id);
                edge.setSrc_if_id(src_if_id);
                edge.setDst_if_id(dst_if_id);
                if (source_router_id.getLength() > 0) {
                    edge.setSrc_router_id(s_router_id_addr);
                } else if (source_it_site_id.getLength() > 0) {
                    edge.setSrc_router_id(s_itsite_id_addr);
                } else if (source_resource_id.getLength() > 0) {
                    edge.setSrc_router_id(s_resource_id_addr);
                }
                if (dest_router_id_nl.getLength() > 0) {
                    edge.setDst_router_id(d_router_id_addr);
                } else if (dest_it_site_id_nl.getLength() > 0) {
                    edge.setDst_router_id(d_itsite_id_addr);
                } else if (dest_resource_id_nl.getLength() > 0) {
                    edge.setDst_router_id(d_resource_id_addr);
                }
                graph.addEdge((Object)source_domain_id, (Object)dest_domain_id, (Object)edge);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graph;
    }

    public static WSONInformation getWSONInformation(String fileName) {
        return FileTEDBUpdater.getWSONInformation(fileName, null);
    }

    public static WSONInformation getWSONInformation(String fileName, String layer) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        File file = new File(fileName);
        AvailableLabels commonAvailableLabels = null;
        WSONInformation WSONinfo = null;
        int numLabels = 0;
        int grid = 0;
        int cs = 0;
        int n = 0;
        log.debug("FileName:::" + fileName);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList edgeCommon = doc.getElementsByTagName("edgeCommon");
            int i = 0;
            while (i < edgeCommon.getLength()) {
                Element edgeCommonElement = (Element)edgeCommon.item(i);
                NodeList availableLabels_node = edgeCommonElement.getElementsByTagName("AvailableLabels");
                int k = 0;
                while (k < availableLabels_node.getLength()) {
                    commonAvailableLabels = new AvailableLabels();
                    Element availableLabels_e = (Element)availableLabels_node.item(k);
                    NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                    Element labelSetField_el = (Element)labelSetField_node.item(0);
                    if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                        NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                        Element numbLabels_e = (Element)numbLabels_node.item(0);
                        String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                        numLabels = Integer.parseInt(numbLabels_s);
                        NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                        Element baseLabel_e = (Element)baseLabel_node.item(0);
                        grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                        cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                        boolean n_frequency_included = false;
                        if (baseLabel_e.getAttributeNode("n") != null) {
                            n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                            n_frequency_included = true;
                        } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                            String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                            float min_frequency = Float.parseFloat(s_min_frequency);
                            n = ((int)min_frequency - 1471) / 20;
                            n_frequency_included = true;
                        }
                        if (n_frequency_included) {
                            FileTEDBUpdater.createBitmapLabelSet(commonAvailableLabels, numLabels, grid, cs, n);
                        } else {
                            log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                        }
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.error(e.toString());
            e.printStackTrace();
        }
        if (commonAvailableLabels != null) {
            WSONinfo = new WSONInformation();
            WSONinfo.setCommonAvailableLabels(commonAvailableLabels);
            WSONinfo.setNumLambdas(numLabels);
            WSONinfo.setCs(cs);
            WSONinfo.setGrid(grid);
            WSONinfo.setnMin(n);
        }
        return WSONinfo;
    }

    public static SSONInformation getSSONInformation(String fileName) {
        return FileTEDBUpdater.getSSONInformation(fileName, null);
    }

    public static SSONInformation getSSONInformation(String fileName, String layer) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        File file = new File(fileName);
        AvailableLabels commonAvailableLabels = null;
        SSONInformation SSONinfo = null;
        int numLabels = 0;
        int grid = 0;
        int cs = 0;
        int n = 0;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList edgeCommon = doc.getElementsByTagName("edgeCommon");
            int i = 0;
            while (i < edgeCommon.getLength()) {
                Element edgeCommonElement = (Element)edgeCommon.item(i);
                NodeList availableLabels_node = edgeCommonElement.getElementsByTagName("AvailableLabels");
                int k = 0;
                while (k < availableLabels_node.getLength()) {
                    commonAvailableLabels = new AvailableLabels();
                    Element availableLabels_e = (Element)availableLabels_node.item(k);
                    NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                    Element labelSetField_el = (Element)labelSetField_node.item(0);
                    if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                        NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                        Element numbLabels_e = (Element)numbLabels_node.item(0);
                        String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                        numLabels = Integer.parseInt(numbLabels_s);
                        NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                        Element baseLabel_e = (Element)baseLabel_node.item(0);
                        grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                        cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                        boolean n_frequency_included = false;
                        if (baseLabel_e.getAttributeNode("n") != null) {
                            n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                            n_frequency_included = true;
                        } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                            String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                            float min_frequency = Float.parseFloat(s_min_frequency);
                            n = ((int)min_frequency - 1471) / 20;
                            n_frequency_included = true;
                        }
                        if (n_frequency_included) {
                            FileTEDBUpdater.createBitmapLabelSet(commonAvailableLabels, numLabels, grid, cs, n);
                        } else {
                            log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                        }
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (commonAvailableLabels != null) {
            SSONinfo = new SSONInformation();
            SSONinfo.setCommonAvailableLabels(commonAvailableLabels);
            SSONinfo.setNumLambdas(numLabels);
            SSONinfo.setCs(cs);
            SSONinfo.setGrid(grid);
            SSONinfo.setnMin(n);
        }
        return SSONinfo;
    }

    public static void createBitmapLabelSet(AvailableLabels availableLabels, int numLabels, int grid, int cs, int n) {
        BitmapLabelSet bitmapLabelSet = new BitmapLabelSet();
        DWDMWavelengthLabel dwdmWavelengthLabel = new DWDMWavelengthLabel();
        dwdmWavelengthLabel.setGrid(grid);
        dwdmWavelengthLabel.setChannelSpacing(cs);
        dwdmWavelengthLabel.setN(n);
        bitmapLabelSet.setDwdmWavelengthLabel(dwdmWavelengthLabel);
        int numberBytes = numLabels / 8;
        if (numberBytes * 8 < numLabels) {
            ++numberBytes;
        }
        byte[] bytesBitMap = new byte[numberBytes];
        int i = 0;
        while (i < numberBytes) {
            bytesBitMap[i] = 0;
            ++i;
        }
        bitmapLabelSet.setBytesBitmap(bytesBitMap);
        bitmapLabelSet.setNumLabels(numLabels);
        availableLabels.setLabelSet(bitmapLabelSet);
    }

    public static void getDomainReachabilityFromFile(String fileName, ReachabilityEntry reachabilityEntry) {
        FileTEDBUpdater.getDomainReachabilityFromFile(fileName, reachabilityEntry, null);
    }

    public static Inet4Address getDomainIDfromSimpleDomain(String fileName) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        log.debug("Initializng reachability from " + fileName);
        File file = new File(fileName);
        Inet4Address domain_id = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            Element element_domain = (Element)nodes_domains.item(0);
            NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
            Element domain_id_e = (Element)nodes_domain_id.item(0);
            String domain_id_str = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
            domain_id = (Inet4Address)Inet4Address.getByName(domain_id_str);
            log.debug("El dominio leido es: " + domain_id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domain_id;
    }

    public static void getDomainReachabilityFromFile(String fileName, ReachabilityEntry reachabilityEntry, String layer) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        log.debug("Initializng reachability from " + fileName);
        log.debug("probandoooo Initializng reachability from " + fileName);
        File file = new File(fileName);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            int j = 0;
            while (j < nodes_domains.getLength()) {
                boolean readNetwork = false;
                if (layer != null) {
                    NodeList nodes_layer = doc.getElementsByTagName("layer");
                    int i = 0;
                    while (i < nodes_layer.getLength()) {
                        Element element = (Element)nodes_layer.item(i);
                        String layer2 = FileTEDBUpdater.getCharacterDataFromElement(element);
                        if (layer2.equals(layer)) {
                            readNetwork = true;
                        }
                        ++i;
                    }
                } else {
                    readNetwork = true;
                }
                if (readNetwork) {
                    Element element_domain = (Element)nodes_domains.item(j);
                    NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                    Element domain_id_e = (Element)nodes_domain_id.item(0);
                    String domain_id_str = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                    Inet4Address domain_id = (Inet4Address)Inet4Address.getByName(domain_id_str);
                    reachabilityEntry.setDomainId(domain_id);
                    log.debug("Network domain es: " + domain_id);
                    NodeList nodes = element_domain.getElementsByTagName("reachability_entry");
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element element = (Element)nodes.item(i);
                        NodeList ipv4_address_node = element.getElementsByTagName("ipv4_address");
                        Element ipv4_address_el = (Element)ipv4_address_node.item(0);
                        String ipv4_address_str = FileTEDBUpdater.getCharacterDataFromElement(ipv4_address_el);
                        log.debug("ipv4_address: " + ipv4_address_str);
                        Inet4Address ipv4_address = (Inet4Address)Inet4Address.getByName(ipv4_address_str);
                        reachabilityEntry.setAggregatedIPRange(ipv4_address);
                        IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
                        NodeList prefix_node = element.getElementsByTagName("prefix");
                        Element prefix_el = (Element)prefix_node.item(0);
                        String prefix_str = FileTEDBUpdater.getCharacterDataFromElement(prefix_el);
                        int prefix = Integer.parseInt(prefix_str);
                        reachabilityEntry.setPrefix(prefix);
                        long resta = (1L << prefix) - 1L;
                        long maskLong = resta << 32 - prefix;
                        byte[] mask = new byte[]{(byte)(maskLong >>> 24 & 0xFFL), (byte)(maskLong >>> 16 & 0xFFL), (byte)(maskLong >>> 8 & 0xFFL), (byte)(maskLong & 0xFFL)};
                        reachabilityEntry.setMask(mask);
                        ++i;
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LinkedList<InterDomainEdge> readInterDomainLinks(String fileName) {
        LinkedList<InterDomainEdge> interDomainLinks = new LinkedList<InterDomainEdge>();
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        File file = new File(fileName);
        Inet4Address domain_id = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            if (nodes_domains != null && nodes_domains.getLength() >= 1) {
                int j = 0;
                while (j < nodes_domains.getLength()) {
                    Element element_domain = (Element)nodes_domains.item(j);
                    NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                    Element domain_id_e = (Element)nodes_domain_id.item(0);
                    String domain_id_str = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                    domain_id = (Inet4Address)Inet4Address.getByName(domain_id_str);
                    ++j;
                }
            }
            Boolean commonBitmapLabelSet = false;
            NodeList edgeCommon = doc.getElementsByTagName("edgeCommon");
            int grid = 0;
            int cs = 0;
            int n = 0;
            int numLabels = 0;
            int i = 0;
            while (i < edgeCommon.getLength()) {
                Element edgeCommonElement = (Element)edgeCommon.item(i);
                NodeList availableLabels_node = edgeCommonElement.getElementsByTagName("AvailableLabels");
                int k = 0;
                while (k < availableLabels_node.getLength()) {
                    Element availableLabels_e = (Element)availableLabels_node.item(k);
                    NodeList labelSetField_node = availableLabels_e.getElementsByTagName("LabelSetField");
                    Element labelSetField_el = (Element)labelSetField_node.item(0);
                    if (labelSetField_el.getAttributeNode("type").getValue().equals("4")) {
                        NodeList numbLabels_node = labelSetField_el.getElementsByTagName("numLabels");
                        Element numbLabels_e = (Element)numbLabels_node.item(0);
                        String numbLabels_s = FileTEDBUpdater.getCharacterDataFromElement(numbLabels_e);
                        numLabels = Integer.parseInt(numbLabels_s);
                        NodeList baseLabel_node = labelSetField_el.getElementsByTagName("baseLabel");
                        Element baseLabel_e = (Element)baseLabel_node.item(0);
                        grid = Integer.parseInt(baseLabel_e.getAttributeNode("grid").getValue());
                        cs = Integer.parseInt(baseLabel_e.getAttributeNode("cs").getValue());
                        boolean n_frequency_included = false;
                        if (baseLabel_e.getAttributeNode("n") != null) {
                            n = Integer.parseInt(baseLabel_e.getAttributeNode("n").getValue());
                            n_frequency_included = true;
                        } else if (baseLabel_e.getAttributeNode("min_frequency") != null) {
                            String s_min_frequency = labelSetField_el.getAttributeNode("min_frequency").getValue();
                            float min_frequency = Float.parseFloat(s_min_frequency);
                            n = ((int)min_frequency - 1471) / 20;
                            n_frequency_included = true;
                        }
                        if (n_frequency_included) {
                            commonBitmapLabelSet = true;
                        } else {
                            log.error("ERROR reading the xml file of the topology, you should enter <baseLabel grid=\"1\" cs=\"2\" n=\"-11\"></baseLabel> ");
                        }
                    }
                    ++k;
                }
                ++i;
            }
            NodeList edges = doc.getElementsByTagName("edge");
            int i2 = 0;
            while (i2 < edges.getLength()) {
                Element element = (Element)edges.item(i2);
                if (element.getAttributeNode("type") != null && element.getAttributeNode("type").getValue().equals("interdomain")) {
                    InterDomainEdge connection = new InterDomainEdge();
                    NodeList source = element.getElementsByTagName("source");
                    Element source_router_el = (Element)source.item(0);
                    NodeList source_router_id = source_router_el.getElementsByTagName("router_id");
                    Element source_router_id_el = (Element)source_router_id.item(0);
                    String s_r_id = FileTEDBUpdater.getCharacterDataFromElement(source_router_id_el);
                    Inet4Address s_router_id_addr = (Inet4Address)Inet4Address.getByName(s_r_id);
                    NodeList source_if_id_nl = source_router_el.getElementsByTagName("if_id");
                    Element source_if_id_el = (Element)source_if_id_nl.item(0);
                    String s_source_if_id = FileTEDBUpdater.getCharacterDataFromElement(source_if_id_el);
                    int src_if_id = Integer.parseInt(s_source_if_id);
                    NodeList src_domain_nl = source_router_el.getElementsByTagName("domain_id");
                    Inet4Address s_router_domain = null;
                    if (src_domain_nl != null) {
                        if (src_domain_nl.getLength() >= 1) {
                            Element domain_id_el = (Element)src_domain_nl.item(0);
                            String s_r_domain = FileTEDBUpdater.getCharacterDataFromElement(domain_id_el).trim();
                            s_router_domain = (Inet4Address)Inet4Address.getByName(s_r_domain);
                        } else {
                            s_router_domain = domain_id;
                        }
                    } else {
                        s_router_domain = domain_id;
                    }
                    NodeList dest_nl = element.getElementsByTagName("destination");
                    Element dest_el = (Element)dest_nl.item(0);
                    NodeList dest_router_id_nl = dest_el.getElementsByTagName("router_id");
                    Element dest_router_id_el = (Element)dest_router_id_nl.item(0);
                    String d_r_id = FileTEDBUpdater.getCharacterDataFromElement(dest_router_id_el);
                    log.info("Edge Destination router_id: " + d_r_id);
                    Inet4Address d_router_id_addr = (Inet4Address)Inet4Address.getByName(d_r_id);
                    NodeList dest_if_id_nl = dest_el.getElementsByTagName("if_id");
                    Element dest_if_id_el = (Element)dest_if_id_nl.item(0);
                    String s_dest_if_id = FileTEDBUpdater.getCharacterDataFromElement(dest_if_id_el);
                    log.info("Edge Dest if_id: " + s_dest_if_id);
                    int dst_if_id = Integer.parseInt(s_dest_if_id);
                    NodeList domain = dest_el.getElementsByTagName("domain_id");
                    Element domain_id_el = (Element)domain.item(0);
                    String d_r_domain = FileTEDBUpdater.getCharacterDataFromElement(domain_id_el);
                    log.info("Destination router domain: " + d_r_domain);
                    Inet4Address d_router_domain = (Inet4Address)Inet4Address.getByName(d_r_domain);
                    connection.setSrc_if_id(src_if_id);
                    connection.setSrc_router_id(s_router_id_addr);
                    connection.setDst_if_id(dst_if_id);
                    connection.setDst_router_id(d_router_id_addr);
                    connection.setDomain_src_router(s_router_domain);
                    connection.setDomain_dst_router(d_router_domain);
                    if (connection.getTE_info() == null) {
                        TE_Information tE_info = new TE_Information();
                        if (commonBitmapLabelSet.booleanValue()) {
                            tE_info.createBitmapLabelSet(numLabels, grid, cs, n);
                        }
                        connection.setTE_info(tE_info);
                    }
                    interDomainLinks.add(connection);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return interDomainLinks;
    }

    public static int readWSONLambdas(String fileName) {
        Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
        File file = new File(fileName);
        int num_wavelengths = 4;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes_domains = doc.getElementsByTagName("domain");
            int j = 0;
            while (j < nodes_domains.getLength()) {
                Element element_domain = (Element)nodes_domains.item(j);
                NodeList nodes_wl = element_domain.getElementsByTagName("num_wavelengths");
                int k = 0;
                while (k < nodes_wl.getLength()) {
                    Element nodes_wl_e = (Element)nodes_wl.item(0);
                    String num_wavelengths_id = FileTEDBUpdater.getCharacterDataFromElement(nodes_wl_e);
                    num_wavelengths = Integer.parseInt(num_wavelengths_id);
                    log.info("num_wavelength: " + num_wavelengths);
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num_wavelengths;
    }

    public static Hashtable<Object, Object> getITSites(String fileName) {
        Hashtable<Object, Object> it_site_id_domain_ed = new Hashtable<Object, Object>();
        File file2 = new File(fileName);
        try {
            DocumentBuilder builder2 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc2 = builder2.parse(file2);
            NodeList nodes_domains = doc2.getElementsByTagName("domain");
            int j = 0;
            while (j < nodes_domains.getLength()) {
                Element element_domain = (Element)nodes_domains.item(j);
                NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                Element domain_id_e = (Element)nodes_domain_id.item(0);
                String domain_id_str = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                Inet4Address domain_id = (Inet4Address)Inet4Address.getByName(domain_id_str);
                NodeList ITsites = element_domain.getElementsByTagName("it_site");
                int i = 0;
                while (i < ITsites.getLength()) {
                    Element element = (Element)ITsites.item(i);
                    NodeList it_site_id_node = element.getElementsByTagName("it_site_id");
                    Element it_site_id_e = (Element)it_site_id_node.item(0);
                    String it_site_id = FileTEDBUpdater.getCharacterDataFromElement(it_site_id_e);
                    Inet4Address it_site_id_addr = (Inet4Address)Inet4Address.getByName(it_site_id);
                    NodeList domain_id_node = element.getElementsByTagName("domain_id");
                    it_site_id_domain_ed.put(it_site_id_addr, domain_id);
                    ++i;
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return it_site_id_domain_ed;
    }

    public static Hashtable<Object, Object> getResource(String fileName) {
        Hashtable<Object, Object> resource_id_domain_ed = new Hashtable<Object, Object>();
        File file2 = new File(fileName);
        try {
            DocumentBuilder builder2 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc2 = builder2.parse(file2);
            NodeList nodes_domains = doc2.getElementsByTagName("domain");
            int j = 0;
            while (j < nodes_domains.getLength()) {
                Element element_domain = (Element)nodes_domains.item(j);
                NodeList nodes_domain_id = element_domain.getElementsByTagName("domain_id");
                Element domain_id_e = (Element)nodes_domain_id.item(0);
                String domain_id_str = FileTEDBUpdater.getCharacterDataFromElement(domain_id_e);
                Inet4Address domain_id = (Inet4Address)Inet4Address.getByName(domain_id_str);
                NodeList storages = element_domain.getElementsByTagName("storage");
                int i = 0;
                while (i < storages.getLength()) {
                    Element element = (Element)storages.item(i);
                    NodeList resource_id_node = element.getElementsByTagName("resource_id");
                    Element resource_id_e = (Element)resource_id_node.item(0);
                    String resource_id = FileTEDBUpdater.getCharacterDataFromElement(resource_id_e);
                    Inet4Address resource_id_addr = (Inet4Address)Inet4Address.getByName(resource_id);
                    NodeList domain_id_node = element.getElementsByTagName("domain_id");
                    resource_id_domain_ed.put(resource_id_addr, domain_id);
                    ++i;
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resource_id_domain_ed;
    }
}

