/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.tedb;

import com.google.gson.Gson;
import es.tid.ospf.ospfv2.lsa.OSPFTEv2LSA;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AvailableLabels;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import java.net.Inet4Address;

public class DatabaseControlSimplifiedLSA {
    public Inet4Address advertisingRouter;
    public Inet4Address linkId;
    public long linkLocalIdentifier;
    public long linkRemoteIdentifier;
    public String bitmapLabelSet;
    public float maximumBandwidth;
    public float unreservedBandwidth;
    public float maximumReservableBandwidth;

    public Inet4Address getAdvertisingRouter() {
        return this.advertisingRouter;
    }

    public void setAdvertisingRouter(Inet4Address advertisingRouter) {
        this.advertisingRouter = advertisingRouter;
    }

    public Inet4Address getLinkId() {
        return this.linkId;
    }

    public void setLinkId(Inet4Address linkId) {
        this.linkId = linkId;
    }

    public long getLinkLocalIdentifier() {
        return this.linkLocalIdentifier;
    }

    public void setLinkLocalIdentifier(long linkLocalIdentifier) {
        this.linkLocalIdentifier = linkLocalIdentifier;
    }

    public long getLinkRemoteIdentifier() {
        return this.linkRemoteIdentifier;
    }

    public void setLinkRemoteIdentifier(long linkRemoteIdentifier) {
        this.linkRemoteIdentifier = linkRemoteIdentifier;
    }

    public String getBitmapLabelSet() {
        return this.bitmapLabelSet;
    }

    public void setBitmapLabelSet(String bitmapLabelSet) {
        this.bitmapLabelSet = bitmapLabelSet;
    }

    public float getMaximumBandwidth() {
        return this.maximumBandwidth;
    }

    public void setMaximumBandwidth(float maximumBandwidth) {
        this.maximumBandwidth = maximumBandwidth;
    }

    public float getUnreservedBandwidth() {
        return this.unreservedBandwidth;
    }

    public void setUnreservedBandwidth(float unreservedBandwidth) {
        this.unreservedBandwidth = unreservedBandwidth;
    }

    public float getMaximumReservableBandwidth() {
        return this.maximumReservableBandwidth;
    }

    public void setMaximumReservableBandwidth(float maximumReservableBandwidth) {
        this.maximumReservableBandwidth = maximumReservableBandwidth;
    }

    public void fillBitmap(AvailableLabels availableLabels) {
        int num_wavelength = 0;
        this.bitmapLabelSet = "";
        while (num_wavelength < availableLabels.getLabelSet().getNumLabels()) {
            int num_byte = num_wavelength / 8;
            boolean isFree = (((BitmapLabelSet)availableLabels.getLabelSet()).getBytesBitMap()[num_byte] & 128 >>> num_wavelength % 8) == 0;
            this.bitmapLabelSet = isFree ? String.valueOf(this.bitmapLabelSet) + "0" : String.valueOf(this.bitmapLabelSet) + "1";
            ++num_wavelength;
        }
    }

    public void fillSimplifiedLsa(OSPFTEv2LSA lsa) {
        if (lsa.getAdvertisingRouter() != null) {
            this.setAdvertisingRouter(lsa.getAdvertisingRouter());
        }
        if (lsa.getLinkTLV().getLinkID().getLinkID() != null) {
            this.setLinkId(lsa.getLinkTLV().getLinkID().getLinkID());
        }
        if (lsa.getLinkTLV().getLinkLocalRemoteIdentifiers() != null) {
            this.setLinkLocalIdentifier(lsa.getLinkTLV().getLinkLocalRemoteIdentifiers().getLinkLocalIdentifier());
            this.setLinkRemoteIdentifier(lsa.getLinkTLV().getLinkLocalRemoteIdentifiers().getLinkRemoteIdentifier());
        }
        if (lsa.getLinkTLV().getMaximumBandwidth() != null) {
            this.setMaximumBandwidth(lsa.getLinkTLV().getMaximumBandwidth().getMaximumBandwidth());
        }
        if (lsa.getLinkTLV().getUnreservedBandwidth() != null) {
            this.setMaximumBandwidth(lsa.getLinkTLV().getUnreservedBandwidth().unreservedBandwidth[0]);
        }
        if (lsa.getLinkTLV().getMaximumReservableBandwidth() != null) {
            this.setMaximumReservableBandwidth(lsa.getLinkTLV().getMaximumReservableBandwidth().maximumReservableBandwidth);
        }
        if (lsa.getLinkTLV().getAvailableLabels() != null) {
            this.fillBitmap(lsa.getLinkTLV().getAvailableLabels());
        }
    }

    public String logJsonSimplifiedLSA() {
        Gson gson = new Gson();
        String json = gson.toJson((Object)this);
        return json;
    }
}

