/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.updateTEDB;

import es.tid.ospf.ospfv2.OSPFv2LinkStateUpdatePacket;
import es.tid.ospf.ospfv2.lsa.LSA;
import es.tid.ospf.ospfv2.lsa.OSPFTEv2LSA;
import eu.teraflow.tid.tedb.DatabaseControlSimplifiedLSA;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import redis.clients.jedis.Jedis;

public class UpdaterThreadRedisTED
extends Thread {
    private Jedis jedis;
    private String host = "localhost";
    private int port = 6379;
    private LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> redisOspfv2PacketQueue;

    public UpdaterThreadRedisTED(LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> redisOspfv2PacketQueue) {
        this.redisOspfv2PacketQueue = redisOspfv2PacketQueue;
        this.jedis = new Jedis(this.host, this.port);
    }

    @Override
    public void run() {
        this.jedis.connect();
        while (true) {
            try {
                block3: while (true) {
                    OSPFv2LinkStateUpdatePacket ospfv2Packet = this.redisOspfv2PacketQueue.take();
                    LinkedList<LSA> lsaList = ospfv2Packet.getLSAlist();
                    int i = 0;
                    while (true) {
                        if (i >= lsaList.size()) continue block3;
                        if (lsaList.get(i).getLStype() == 10) {
                            OSPFTEv2LSA lsa = (OSPFTEv2LSA)lsaList.get(i);
                            DatabaseControlSimplifiedLSA dcsl = new DatabaseControlSimplifiedLSA();
                            dcsl.fillSimplifiedLsa(lsa);
                            String jsonLSA = dcsl.logJsonSimplifiedLSA();
                            String key = "LSA:" + dcsl.getAdvertisingRouter().getHostAddress() + ":" + dcsl.getLinkId().getHostAddress();
                            String ret = this.jedis.set(key, jsonLSA);
                            this.jedis.sadd("TEDB", new String[]{key});
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

