/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.updateTEDB;

import es.tid.bgp.bgp4.messages.BGP4Update;
import es.tid.bgp.bgp4.update.fields.LinkNLRI;
import es.tid.bgp.bgp4.update.fields.LinkStateNLRI;
import es.tid.bgp.bgp4.update.fields.NodeNLRI;
import es.tid.bgp.bgp4.update.fields.PathAttribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.AS_Path_Attribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.AS_Path_Segment;
import es.tid.bgp.bgp4.update.fields.pathAttributes.BGP_LS_MP_Reach_Attribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.LinkStateAttribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.MP_Reach_Attribute;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.AdministrativeGroupLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.DefaultTEMetricLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IGPFlagBitsPrefixAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IPv4RouterIDLocalNodeLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IPv4RouterIDRemoteNodeLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IS_IS_AreaIdentifierNodeAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.LinkProtectionTypeLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MF_OTPAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MaxReservableBandwidthLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MaximumLinkBandwidthLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MetricLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.NodeFlagBitsNodeAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.NodeNameNodeAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.OSPFForwardingAddressPrefixAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.PrefixMetricPrefixAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.RouteTagPrefixAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.SidLabelNodeAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.TransceiverClassAndAppAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.UnreservedBandwidthLinkAttribTLV;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AvailableLabels;
import eu.teraflow.tid.bgp4Peer.grpc.grpcClient;
import eu.teraflow.tid.bgp4Peer.json.bgpMarshal;
import eu.teraflow.tid.bgp4Peer.models.LinkNLRIMsg;
import eu.teraflow.tid.bgp4Peer.models.NodeNLRIMsg;
import eu.teraflow.tid.bgp4Peer.models.PathAttributeMsg;
import eu.teraflow.tid.bgp4Peer.models.UpdateMsg;
import eu.teraflow.tid.bgp4Peer.models.UpdateMsgList;
import eu.teraflow.tid.bgp4Peer.updateTEDB.UpdateLink;
import eu.teraflow.tid.tedb.MultiDomainTEDB;
import eu.teraflow.tid.tedb.TEDB;
import eu.teraflow.tid.tedb.TE_Information;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProccesorThread
extends Thread {
    private boolean running = true;
    private LinkedBlockingQueue<BGP4Update> updateList;
    MaximumLinkBandwidthLinkAttribTLV maximumLinkBandwidthTLV;
    MaxReservableBandwidthLinkAttribTLV maxReservableBandwidthTLV;
    UnreservedBandwidthLinkAttribTLV unreservedBandwidthTLV;
    AdministrativeGroupLinkAttribTLV administrativeGroupTLV;
    LinkProtectionTypeLinkAttribTLV linkProtectionTLV;
    MetricLinkAttribTLV metricTLV;
    IPv4RouterIDLocalNodeLinkAttribTLV iPv4RouterIDLocalNodeLATLV;
    IPv4RouterIDRemoteNodeLinkAttribTLV iPv4RouterIDRemoteNodeLATLV;
    DefaultTEMetricLinkAttribTLV TEMetricTLV;
    TransceiverClassAndAppAttribTLV transceiverClassAndAppATLV;
    MF_OTPAttribTLV mF_OTP_ATLV;
    int linkDelay;
    int linkDelayVar;
    int minDelay;
    int maxDelay;
    int linkLoss;
    int residualBw;
    int availableBw;
    int utilizedBw;
    NodeFlagBitsNodeAttribTLV nodeFlagBitsTLV = new NodeFlagBitsNodeAttribTLV();
    NodeNameNodeAttribTLV nodeNameTLV = new NodeNameNodeAttribTLV();
    IS_IS_AreaIdentifierNodeAttribTLV areaIDTLV = new IS_IS_AreaIdentifierNodeAttribTLV();
    SidLabelNodeAttribTLV sidTLV = new SidLabelNodeAttribTLV();
    IGPFlagBitsPrefixAttribTLV igpFlagBitsTLV = new IGPFlagBitsPrefixAttribTLV();
    RouteTagPrefixAttribTLV routeTagTLV = new RouteTagPrefixAttribTLV();
    PrefixMetricPrefixAttribTLV prefixMetricTLV = new PrefixMetricPrefixAttribTLV();
    OSPFForwardingAddressPrefixAttribTLV OSPFForwardingAddrTLV = new OSPFForwardingAddressPrefixAttribTLV();
    private AvailableLabels availableLabels;
    private Logger log = LoggerFactory.getLogger((String)"BGP4Server");
    private MultiDomainTEDB multiTedb;
    private Hashtable<String, TEDB> intraTEDBs;
    private LinkedList<UpdateLink> updateLinks;
    private TE_Information te_info;

    public UpdateProccesorThread(LinkedBlockingQueue<BGP4Update> updateList, MultiDomainTEDB multiTedb, Hashtable<String, TEDB> intraTEDBs) {
        this.updateList = updateList;
        this.multiTedb = multiTedb;
        this.intraTEDBs = intraTEDBs;
        this.availableLabels = new AvailableLabels();
        this.updateLinks = new LinkedList();
    }

    @Override
    public void run() {
        UpdateMsgList updateMsgList = new UpdateMsgList();
        bgpMarshal m = new bgpMarshal();
        try {
            m.bgpMarshaller();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        boolean j = false;
        while (this.running) {
            try {
                this.clearAttributes();
                UpdateMsg update = new UpdateMsg();
                PathAttribute att_ls = null;
                PathAttribute att_mpreach = null;
                PathAttribute att = null;
                PathAttribute att_path = null;
                BGP4Update updateMsg = this.updateList.take();
                this.log.info("Update Procesor Thread Reading the message: \n" + updateMsg.toString());
                this.log.info("\n \n");
                this.log.debug("END string UPDATE msg");
                String learntFrom = updateMsg.getLearntFrom();
                this.log.info("Received from " + learntFrom);
                ArrayList<PathAttribute> pathAttributeList = updateMsg.getPathAttributes();
                ArrayList<PathAttribute> pathAttributeListUtil = new ArrayList<PathAttribute>();
                update.setLearntFrom(learntFrom);
                int i = 0;
                while (i < pathAttributeList.size()) {
                    att = pathAttributeList.get(i);
                    int typeCode = att.getTypeCode();
                    switch (typeCode) {
                        case 29: {
                            att_ls = att;
                            break;
                        }
                        case 14: {
                            att_mpreach = att;
                            break;
                        }
                        case 2: {
                            att_path = att;
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    ++i;
                }
                this.log.info("NLRI type: ");
                String currentName = null;
                if (att_ls != null) {
                    pathAttributeListUtil.add(att_ls);
                }
                if (att_mpreach != null) {
                    pathAttributeListUtil.add(att_mpreach);
                }
                if (att_path != null) {
                    List<AS_Path_Segment> as_path_segments = ((AS_Path_Attribute)att_path).getAsPathSegments();
                    if (att_path.getPathAttributeLength() != 0) {
                        AS_Path_Segment as_path_segment = as_path_segments.get(0);
                        int numberOfSeg = as_path_segment.getNumberOfSegments();
                        int as_path = as_path_segment.getSegments()[0];
                        update.setAsPathSegment(as_path);
                    }
                }
                if (pathAttributeListUtil != null) {
                    int i2 = 0;
                    while (i2 < pathAttributeListUtil.size()) {
                        att = (PathAttribute)pathAttributeListUtil.get(i2);
                        int typeCode = att.getTypeCode();
                        block9 : switch (typeCode) {
                            case 29: {
                                this.processAttributeLinkState((LinkStateAttribute)att);
                                PathAttributeMsg pathAtt = new PathAttributeMsg((LinkStateAttribute)att);
                                this.log.info("Path attributes: " + pathAtt.toString());
                                currentName = pathAtt.getNodeName();
                                updateMsgList.addpathToJson(pathAtt);
                                break;
                            }
                            case 14: {
                                int afi = ((MP_Reach_Attribute)att).getAddressFamilyIdentifier();
                                update.setAFI(afi);
                                InetAddress nextHop = ((MP_Reach_Attribute)att).getNextHop();
                                update.setNextHop(nextHop);
                                if (afi != 16388) break;
                                LinkStateNLRI nlri = ((BGP_LS_MP_Reach_Attribute)att).getLsNLRI();
                                int nlriType = nlri.getNLRIType();
                                switch (nlriType) {
                                    case 2: {
                                        this.log.info("Link_NLRI");
                                        LinkNLRIMsg LnlriMsg = new LinkNLRIMsg((LinkNLRI)nlri, learntFrom);
                                        this.log.info("Link info: " + LnlriMsg.toString());
                                        updateMsgList.addLinkToJson(LnlriMsg);
                                        update.setLink(LnlriMsg);
                                        break block9;
                                    }
                                    case 1: {
                                        NodeNLRIMsg NnlriMsg = new NodeNLRIMsg((NodeNLRI)nlri, learntFrom, currentName);
                                        this.log.info("Node_NLRI");
                                        this.log.info("Node info: " + NnlriMsg.toString());
                                        updateMsgList.addNodeToJson(NnlriMsg, currentName);
                                        update.setNode(NnlriMsg);
                                        currentName = null;
                                        break block9;
                                    }
                                    case 3: {
                                        this.log.info("Prefix_v4_NLRI");
                                        break block9;
                                    }
                                    case 5: {
                                        this.log.info("IT_Node_NLRI");
                                        break block9;
                                    }
                                }
                                this.log.debug("Attribute Code unknown");
                                break;
                            }
                            default: {
                                this.log.debug("Attribute Code unknown");
                            }
                        }
                        ++i2;
                    }
                    try {
                        m.writeFile(updateMsgList);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.log.warn("\n");
                grpcClient.sendGrpcUpdateMsg(update);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    private void processAttributeLinkState(LinkStateAttribute lsAtt) {
        if (lsAtt.getMaximumLinkBandwidthTLV() != null) {
            this.maximumLinkBandwidthTLV = lsAtt.getMaximumLinkBandwidthTLV();
        }
        if (lsAtt.getMaxReservableBandwidthTLV() != null) {
            this.maxReservableBandwidthTLV = lsAtt.getMaxReservableBandwidthTLV();
        }
        if (lsAtt.getUnreservedBandwidthTLV() != null) {
            this.unreservedBandwidthTLV = lsAtt.getUnreservedBandwidthTLV();
        }
        if (lsAtt.getAdministrativeGroupTLV() != null) {
            this.administrativeGroupTLV = lsAtt.getAdministrativeGroupTLV();
        }
        if (lsAtt.getLinkProtectionTLV() != null) {
            this.linkProtectionTLV = lsAtt.getLinkProtectionTLV();
        }
        if (lsAtt.getIPv4RouterIDLocalNodeLATLV() != null) {
            this.iPv4RouterIDLocalNodeLATLV = lsAtt.getIPv4RouterIDLocalNodeLATLV();
        }
        if (lsAtt.getIPv4RouterIDRemoteNodeLATLV() != null) {
            this.iPv4RouterIDRemoteNodeLATLV = lsAtt.getIPv4RouterIDRemoteNodeLATLV();
        }
        if (lsAtt.getMetricTLV() != null) {
            this.metricTLV = lsAtt.getMetricTLV();
        }
        if (lsAtt.getTEMetricTLV() != null) {
            this.TEMetricTLV = lsAtt.getTEMetricTLV();
        }
        if (lsAtt.getNodeFlagBitsTLV() != null) {
            this.nodeFlagBitsTLV = lsAtt.getNodeFlagBitsTLV();
        }
        if (lsAtt.getNodeNameTLV() != null) {
            this.nodeNameTLV = lsAtt.getNodeNameTLV();
        }
        if (lsAtt.getAreaIDTLV() != null) {
            this.areaIDTLV = lsAtt.getAreaIDTLV();
        }
        if (lsAtt.getIgpFlagBitsTLV() != null) {
            this.igpFlagBitsTLV = lsAtt.getIgpFlagBitsTLV();
        }
        if (lsAtt.getRouteTagTLV() != null) {
            this.routeTagTLV = lsAtt.getRouteTagTLV();
        }
        if (lsAtt.getOSPFForwardingAddrTLV() != null) {
            this.OSPFForwardingAddrTLV = lsAtt.getOSPFForwardingAddrTLV();
        }
        if (lsAtt.getSidLabelTLV() != null) {
            this.sidTLV = lsAtt.getSidLabelTLV();
        }
        if (lsAtt.getAvailableLabels() != null) {
            this.availableLabels = lsAtt.getAvailableLabels();
        }
        if (lsAtt.getMF_OTP_ATLV() != null) {
            this.mF_OTP_ATLV = lsAtt.getMF_OTP_ATLV();
        }
        if (lsAtt.getTransceiverClassAndAppATLV() != null) {
            this.transceiverClassAndAppATLV = lsAtt.getTransceiverClassAndAppATLV();
        }
    }

    private void clearAttributes() {
        this.maximumLinkBandwidthTLV = null;
        this.maxReservableBandwidthTLV = null;
        this.unreservedBandwidthTLV = null;
        this.administrativeGroupTLV = null;
        this.linkProtectionTLV = null;
        this.metricTLV = null;
        this.iPv4RouterIDLocalNodeLATLV = null;
        this.iPv4RouterIDRemoteNodeLATLV = null;
        this.TEMetricTLV = null;
        this.transceiverClassAndAppATLV = null;
        this.mF_OTP_ATLV = null;
        this.availableLabels = null;
        this.linkDelay = 0;
        this.linkDelayVar = 0;
        this.minDelay = 0;
        this.maxDelay = 0;
        this.linkLoss = 0;
        this.residualBw = 0;
        this.availableBw = 0;
        this.utilizedBw = 0;
    }
}

