/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.peer;

import es.tid.bgp.bgp4.messages.BGP4Update;
import es.tid.bgp.bgp4.update.fields.ITNodeNLRI;
import es.tid.bgp.bgp4.update.fields.LinkNLRI;
import es.tid.bgp.bgp4.update.fields.NodeNLRI;
import es.tid.bgp.bgp4.update.fields.PathAttribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.AS_Path_Attribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.AS_Path_Segment;
import es.tid.bgp.bgp4.update.fields.pathAttributes.BGP_LS_MP_Reach_Attribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.LinkStateAttribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.OriginAttribute;
import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import es.tid.bgp.bgp4.update.tlv.LocalNodeDescriptorsTLV;
import es.tid.bgp.bgp4.update.tlv.RemoteNodeDescriptorsTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.DefaultTEMetricLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MF_OTPAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MaxReservableBandwidthLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MaximumLinkBandwidthLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.SidLabelNodeAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.UnreservedBandwidthLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.AreaIDNodeDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.AutonomousSystemNodeDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.BGPLSIdentifierNodeDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.IGPRouterIDNodeDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.IPv4InterfaceAddressLinkDescriptorsSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.IPv4NeighborAddressLinkDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.LinkLocalRemoteIdentifiersLinkDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.MinMaxUndirectionalLinkDelayDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalAvailableBandwidthDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalDelayVariationDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalLinkDelayDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalLinkLossDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalResidualBandwidthDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalUtilizedBandwidthDescriptorSubTLV;
import es.tid.ospf.ospfv2.OSPFv2LinkStateUpdatePacket;
import es.tid.ospf.ospfv2.lsa.LSA;
import es.tid.ospf.ospfv2.lsa.OSPFTEv2LSA;
import es.tid.ospf.ospfv2.lsa.tlv.LinkTLV;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AvailableLabels;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LinkID;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LocalInterfaceIPAddress;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MaximumBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.RemoteInterfaceIPAddress;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.UnreservedBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionsInformation;
import eu.teraflow.tid.bgp4Peer.bgp4session.GenericBGP4Session;
import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.IT_Resources;
import eu.teraflow.tid.tedb.InterDomainEdge;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.MultiDomainTEDB;
import eu.teraflow.tid.tedb.Node_Info;
import eu.teraflow.tid.tedb.TEDB;
import eu.teraflow.tid.tedb.TE_Information;
import eu.teraflow.tid.tedb.elements.Node;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendTopology
implements Runnable {
    private int identifier = 1;
    private Hashtable<String, TEDB> intraTEDBs;
    private MultiDomainTEDB multiDomainTEDB;
    private boolean sendTopology;
    private boolean isTest = false;
    private BGP4SessionsInformation bgp4SessionsInformation;
    private Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
    private int instanceId = 1;
    private boolean sendIntraDomainLinks = false;
    private boolean send4AS = false;
    private Inet4Address localBGPLSIdentifer;
    private Inet4Address localAreaID;

    public void configure(Hashtable<String, TEDB> intraTEDBs, BGP4SessionsInformation bgp4SessionsInformation, boolean sendTopology, int instanceId, boolean sendIntraDomainLinks, MultiDomainTEDB multiTED) {
        this.intraTEDBs = intraTEDBs;
        this.bgp4SessionsInformation = bgp4SessionsInformation;
        this.sendTopology = sendTopology;
        this.instanceId = instanceId;
        this.sendIntraDomainLinks = sendIntraDomainLinks;
        this.multiDomainTEDB = multiTED;
        try {
            this.localAreaID = (Inet4Address)Inet4Address.getByName("0.0.0.0");
            this.localBGPLSIdentifer = (Inet4Address)Inet4Address.getByName("1.1.1.1");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public void configure(Hashtable<String, TEDB> intraTEDBs, BGP4SessionsInformation bgp4SessionsInformation, boolean sendTopology, int instanceId, boolean sendIntraDomainLinks, MultiDomainTEDB multiTED, boolean test) {
        this.intraTEDBs = intraTEDBs;
        this.bgp4SessionsInformation = bgp4SessionsInformation;
        this.sendTopology = sendTopology;
        this.instanceId = instanceId;
        this.sendIntraDomainLinks = sendIntraDomainLinks;
        this.multiDomainTEDB = multiTED;
        this.isTest = test;
        try {
            this.localAreaID = (Inet4Address)Inet4Address.getByName("0.0.0.0");
            this.localBGPLSIdentifer = (Inet4Address)Inet4Address.getByName("1.1.1.1");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            if (this.sendTopology && !this.bgp4SessionsInformation.getSessionList().isEmpty()) {
                Enumeration<Object> iter;
                if (this.multiDomainTEDB != null) {
                    this.log.debug("Sending Multi-Domain TEDB");
                    this.sendLinkNLRI(this.multiDomainTEDB.getInterDomainLinks());
                } else {
                    this.log.debug("Sending from TEDB");
                    iter = this.intraTEDBs.elements();
                    while (iter.hasMoreElements()) {
                        this.sendLinkNLRI(iter.nextElement().getInterDomainLinks());
                    }
                }
                if (this.sendIntraDomainLinks) {
                    this.log.debug("sendIntraDomainLinks activated");
                    iter = this.intraTEDBs.keys();
                    while (iter.hasMoreElements()) {
                        String domainID = (String)iter.nextElement();
                        this.log.debug("Sending TED from domain " + domainID);
                        TEDB ted = this.intraTEDBs.get(domainID);
                        if (!(ted instanceof DomainTEDB)) continue;
                        this.sendLinkNLRI(((DomainTEDB)ted).getIntraDomainLinks(), domainID);
                        this.sendNodeNLRI(((DomainTEDB)ted).getIntraDomainLinksvertexSet(), ((DomainTEDB)ted).getNodeTable());
                        if (((DomainTEDB)ted).getItResources() == null) continue;
                        this.sendITNodeNLRI(domainID, ((DomainTEDB)ted).getItResources());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("PROBLEM SENDING TOPOLOGY: " + e.toString());
        }
    }

    private void sendNodeNLRI(Set<Object> vertexSet, Hashtable<Object, Node_Info> NodeTable) {
        Iterator<Object> vertexIt = vertexSet.iterator();
        while (vertexIt.hasNext()) {
            Node_Info node_info;
            Inet4Address node = null;
            Object v = vertexIt.next();
            if (v instanceof Node) {
                try {
                    node = (Inet4Address)Inet4Address.getByName(((Node)v).getAddress().get(0));
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            } else {
                node = (Inet4Address)v;
            }
            if ((node_info = NodeTable.get(node)) != null) {
                this.log.debug("Sending node: (" + node + ")");
                BGP4Update update = this.createMsgUpdateNodeNLRI(node_info);
                this.sendMessage(update);
                continue;
            }
            this.log.debug("Node " + node + " HAS NO node_info in NodeTable");
        }
    }

    private void sendITNodeNLRI(String domainID, IT_Resources itResources) {
        this.log.debug("Sending IT REsources");
        BGP4Update update = this.createMsgUpdateITNodeNLRI(domainID, itResources);
        this.sendMessage(update);
    }

    private void sendLinkNLRI(LinkedList<InterDomainEdge> interdomainLinks) {
        int lanID = 1;
        ArrayList<Inet4Address> addressList = new ArrayList<Inet4Address>();
        for (InterDomainEdge edge : interdomainLinks) {
            Inet4Address source = (Inet4Address)edge.getSrc_router_id();
            Inet4Address dst = (Inet4Address)edge.getDst_router_id();
            this.log.debug("Sending ID edge: (" + source.toString() + ":" + edge.getSrc_if_id() + "," + dst.toString() + ")");
            addressList = new ArrayList();
            addressList.add(0, source);
            addressList.add(1, dst);
            ArrayList<Long> localRemoteIfList = null;
            localRemoteIfList = new ArrayList<Long>();
            localRemoteIfList.add(0, edge.getSrc_if_id());
            localRemoteIfList.add(1, edge.getDst_if_id());
            ArrayList<String> domainList = new ArrayList<String>(2);
            TE_Information te_info = edge.getTE_info();
            domainList.add(((Inet4Address)edge.getDomain_src_router()).getHostAddress().toString());
            domainList.add(((Inet4Address)edge.getDomain_dst_router()).getHostAddress().toString());
            this.log.debug("SRC Domain is " + (Inet4Address)edge.getDomain_dst_router());
            BGP4Update update = this.createMsgUpdateLinkNLRI(addressList, localRemoteIfList, lanID, domainList, false, te_info);
            update.setLearntFrom(edge.getLearntFrom());
            this.log.debug("Update message Created");
            this.sendMessage(update);
        }
    }

    private void sendLinkNLRI(Set<IntraDomainEdge> edgeSet, String domainID) {
        int lanID = 1;
        ArrayList<Inet4Address> addressList = new ArrayList<Inet4Address>();
        for (IntraDomainEdge edge : edgeSet) {
            Inet4Address source = null;
            if (edge.getSource() instanceof Node) {
                try {
                    source = (Inet4Address)Inet4Address.getByName(((Node)edge.getSource()).getAddress().get(0));
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            } else {
                source = (Inet4Address)edge.getSource();
            }
            Inet4Address dst = null;
            if (edge.getTarget() instanceof Node) {
                try {
                    dst = (Inet4Address)Inet4Address.getByName(((Node)edge.getTarget()).getAddress().get(0));
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            } else {
                dst = (Inet4Address)edge.getTarget();
            }
            this.log.debug("Sending: (" + source.toString() + "," + dst.toString() + ")");
            addressList = new ArrayList();
            addressList.add(0, source);
            addressList.add(1, dst);
            ArrayList<Long> localRemoteIfList = null;
            localRemoteIfList = new ArrayList<Long>();
            localRemoteIfList.add(0, edge.getSrc_if_id());
            localRemoteIfList.add(1, edge.getDst_if_id());
            float maximumBandwidth = 0.0f;
            Object unreservedBandwidth = null;
            float maximumReservableBandwidth = 0.0f;
            boolean undirLinkDelay = false;
            boolean metric = false;
            long te_metric = 0L;
            Object availableLabels = null;
            Object mfOTP = null;
            TE_Information te_info = edge.getTE_info();
            ArrayList<String> domainList = new ArrayList<String>(2);
            domainList.add(domainID);
            domainList.add(domainID);
            BGP4Update update = this.createMsgUpdateLinkNLRI(addressList, localRemoteIfList, lanID, domainList, true, te_info);
            update.setLearntFrom(edge.getLearntFrom());
            this.sendMessage(update);
        }
    }

    private void sendMessage(BGP4Update update) {
        Enumeration<GenericBGP4Session> sessions = this.bgp4SessionsInformation.getSessionList().elements();
        this.log.debug("Sending a BGP4 update message:" + update.toString());
        while (sessions.hasMoreElements()) {
            GenericBGP4Session session = sessions.nextElement();
            if (session == null) {
                this.log.error("SESSION NULL");
                continue;
            }
            if (!session.getSendTo().booleanValue()) continue;
            String destination = session.getRemotePeerIP().getHostAddress();
            this.log.debug("BGP4 Update learnt from:" + update.getLearntFrom());
            if (this.isTest) {
                this.log.debug("Sending BGP4 update to:" + destination + " with no check on the ID since it is test");
                session.sendBGP4Message(update);
                continue;
            }
            try {
                if (update.getLearntFrom() != null && update.getLearntFrom().contains("/")) {
                    if (!destination.equals(update.getLearntFrom().substring(1))) {
                        this.log.debug("Sending update to destination " + destination + " for info learnt from " + update.getLearntFrom().substring(1));
                        this.log.debug("Sending BGP4 update to:" + destination);
                        session.sendBGP4Message(update);
                        continue;
                    }
                    this.log.debug("destination " + destination + " and source of information " + update.getLearntFrom().substring(1) + " are equal");
                    continue;
                }
                if (!destination.equals(update.getLearntFrom())) {
                    this.log.debug("Sending update to destination " + destination + " for info learnt from " + update.getLearntFrom());
                    this.log.debug("Sending BGP4 update to:" + destination);
                    session.sendBGP4Message(update);
                    continue;
                }
                this.log.debug("destination " + destination + " and source of information " + update.getLearntFrom() + " are equal");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private BGP4Update createMsgUpdateNodeNLRI(Node_Info node_info) {
        try {
            Object[] segs;
            AS_Path_Segment as_path_seg;
            AS_Path_Attribute as_path;
            BGP4Update update = new BGP4Update();
            ArrayList<PathAttribute> pathAttributes = update.getPathAttributes();
            OriginAttribute or = new OriginAttribute();
            or.setValue(0);
            pathAttributes.add(or);
            if (this.send4AS) {
                as_path = new AS_Path_Attribute();
                as_path_seg = new AS_Path_Segment();
                segs = new long[]{65522L};
                as_path_seg.set4Segments((long[])segs);
                as_path.getAsPathSegments().add(as_path_seg);
                pathAttributes.add(as_path);
            } else {
                as_path = new AS_Path_Attribute();
                as_path_seg = new AS_Path_Segment();
                segs = new int[1];
                segs[0] = 65522;
                as_path_seg.setSegments((int[])segs);
                as_path.getAsPathSegments().add(as_path_seg);
                pathAttributes.add(as_path);
            }
            LinkStateAttribute linkStateAttribute = new LinkStateAttribute();
            boolean linkStateNeeded = false;
            if (node_info.getSid() != 0) {
                int sid = node_info.getSid();
                SidLabelNodeAttribTLV sidLabelTLV = new SidLabelNodeAttribTLV();
                sidLabelTLV.setSid(sid);
                linkStateAttribute.setSidLabelTLV(sidLabelTLV);
                linkStateNeeded = true;
            }
            if (linkStateNeeded) {
                this.log.debug("Node Attribute added....");
                pathAttributes.add(linkStateAttribute);
            }
            NodeNLRI nodeNLRI = new NodeNLRI();
            nodeNLRI.setProtocolID(0);
            nodeNLRI.setRoutingUniverseIdentifier(this.identifier);
            LocalNodeDescriptorsTLV localNodeDescriptors = new LocalNodeDescriptorsTLV();
            if (node_info.getIpv4Address() != null) {
                IGPRouterIDNodeDescriptorSubTLV igpRouterIDLNSubTLV = new IGPRouterIDNodeDescriptorSubTLV();
                igpRouterIDLNSubTLV.setIpv4AddressOSPF(node_info.getIpv4Address());
                igpRouterIDLNSubTLV.setIGP_router_id_type(3);
                localNodeDescriptors.setIGPRouterID(igpRouterIDLNSubTLV);
            }
            if (node_info.getAs_number() != null) {
                AutonomousSystemNodeDescriptorSubTLV asNodeDescrSubTLV = new AutonomousSystemNodeDescriptorSubTLV();
                asNodeDescrSubTLV.setAS_ID(node_info.getAs_number());
                localNodeDescriptors.setAutonomousSystemSubTLV(asNodeDescrSubTLV);
            }
            BGPLSIdentifierNodeDescriptorSubTLV bGPLSIDSubTLV = new BGPLSIdentifierNodeDescriptorSubTLV();
            bGPLSIDSubTLV.setBGPLS_ID(this.localBGPLSIdentifer);
            localNodeDescriptors.setBGPLSIDSubTLV(bGPLSIDSubTLV);
            AreaIDNodeDescriptorSubTLV areaID = new AreaIDNodeDescriptorSubTLV();
            areaID.setAREA_ID(this.localAreaID);
            localNodeDescriptors.setAreaID(areaID);
            nodeNLRI.setLocalNodeDescriptors(localNodeDescriptors);
            BGP_LS_MP_Reach_Attribute ra = new BGP_LS_MP_Reach_Attribute();
            ra.setLsNLRI(nodeNLRI);
            pathAttributes.add(ra);
            update.setLearntFrom(node_info.getLearntFrom());
            return update;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BGP4Update createMsgUpdateITNodeNLRI(String domainID, IT_Resources itResources) {
        try {
            Object[] segs;
            AS_Path_Segment as_path_seg;
            AS_Path_Attribute as_path;
            BGP4Update update = new BGP4Update();
            ArrayList<PathAttribute> pathAttributes = update.getPathAttributes();
            OriginAttribute or = new OriginAttribute();
            or.setValue(0);
            pathAttributes.add(or);
            if (this.send4AS) {
                as_path = new AS_Path_Attribute();
                as_path_seg = new AS_Path_Segment();
                segs = new long[]{65522L};
                as_path_seg.set4Segments((long[])segs);
                as_path.getAsPathSegments().add(as_path_seg);
                pathAttributes.add(as_path);
            } else {
                as_path = new AS_Path_Attribute();
                as_path_seg = new AS_Path_Segment();
                segs = new int[1];
                segs[0] = 65522;
                as_path_seg.setSegments((int[])segs);
                as_path.getAsPathSegments().add(as_path_seg);
                pathAttributes.add(as_path);
            }
            ITNodeNLRI itNodeNLRI = new ITNodeNLRI();
            itNodeNLRI.setNodeId(domainID);
            itNodeNLRI.setControllerIT(itResources.getControllerIT());
            itNodeNLRI.setCpu(itResources.getCpu());
            itNodeNLRI.setMem(itResources.getMem());
            itNodeNLRI.setStorage(itResources.getStorage());
            update.setLearntFrom(itResources.getLearntFrom());
            this.log.info("Creating IT Update related to domain " + domainID + " learnt from " + itResources.getLearntFrom());
            LocalNodeDescriptorsTLV localNodeDescriptors = new LocalNodeDescriptorsTLV();
            BGPLSIdentifierNodeDescriptorSubTLV bGPLSIDSubTLV = new BGPLSIdentifierNodeDescriptorSubTLV();
            bGPLSIDSubTLV.setBGPLS_ID(this.localBGPLSIdentifer);
            localNodeDescriptors.setBGPLSIDSubTLV(bGPLSIDSubTLV);
            AreaIDNodeDescriptorSubTLV areaID = new AreaIDNodeDescriptorSubTLV();
            areaID.setAREA_ID(this.localAreaID);
            localNodeDescriptors.setAreaID(areaID);
            BGP_LS_MP_Reach_Attribute ra = new BGP_LS_MP_Reach_Attribute();
            ra.setLsNLRI(itNodeNLRI);
            pathAttributes.add(ra);
            return update;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BGP4Update createMsgUpdateLinkNLRI(ArrayList<Inet4Address> addressList, ArrayList<Long> localRemoteIfList, int lanID, ArrayList<String> domainList, boolean intradomain, TE_Information te_info) {
        Object[] segs;
        AS_Path_Segment as_path_seg;
        AS_Path_Attribute as_path;
        BGP4Update update = new BGP4Update();
        ArrayList<PathAttribute> pathAttributes = update.getPathAttributes();
        OriginAttribute or = new OriginAttribute();
        if (intradomain) {
            or.setValue(0);
        } else {
            or.setValue(1);
        }
        pathAttributes.add(or);
        if (this.send4AS) {
            as_path = new AS_Path_Attribute();
            as_path_seg = new AS_Path_Segment();
            segs = new long[]{65522L};
            as_path_seg.set4Segments((long[])segs);
            as_path.getAsPathSegments().add(as_path_seg);
            pathAttributes.add(as_path);
        } else {
            as_path = new AS_Path_Attribute();
            as_path_seg = new AS_Path_Segment();
            segs = new int[1];
            segs[0] = 65522;
            as_path_seg.setSegments((int[])segs);
            as_path.getAsPathSegments().add(as_path_seg);
            pathAttributes.add(as_path);
        }
        float maximumBandwidth = 0.0f;
        float[] unreservedBandwidth = null;
        float maximumReservableBandwidth = 0.0f;
        AvailableLabels availableLabels = null;
        MF_OTPAttribTLV mfOTP = null;
        int metric = 0;
        int te_metric = 0;
        if (te_info != null) {
            te_info.getLinkLocalRemoteIdentifiers();
            if (te_info.getMaximumBandwidth() != null) {
                maximumBandwidth = te_info.getMaximumBandwidth().getMaximumBandwidth();
            }
            if (te_info.getUnreservedBandwidth() != null) {
                unreservedBandwidth = te_info.getUnreservedBandwidth().getUnreservedBandwidth();
            }
            if (te_info.getMaximumReservableBandwidth() != null) {
                maximumReservableBandwidth = te_info.getMaximumReservableBandwidth().getMaximumReservableBandwidth();
            }
            if (te_info.getAvailableLabels() != null) {
                availableLabels = te_info.getAvailableLabels();
            }
            if (te_info.getDefaultTEMetric() != null) {
                metric = (int)te_info.getDefaultTEMetric().getLinkMetric();
                this.log.debug("Metric en el metodo sendLinkNLRI es: " + metric);
            }
            if (te_info.getTrafficEngineeringMetric() != null) {
                te_metric = (int)te_info.getTrafficEngineeringMetric().getLinkMetric();
                this.log.debug("Metric en el metodo sendLinkNLRI es: " + metric);
            }
            if (te_info.getMfOTF() != null) {
                mfOTP = te_info.getMfOTF();
            }
        } else {
            this.log.debug("TE_Info es null");
        }
        boolean linkStateNeeded = false;
        LinkStateAttribute linkStateAttribute = new LinkStateAttribute();
        if (maximumReservableBandwidth != 0.0f) {
            MaxReservableBandwidthLinkAttribTLV maxReservableBandwidthTLV = new MaxReservableBandwidthLinkAttribTLV();
            maxReservableBandwidthTLV.setMaximumReservableBandwidth(maximumReservableBandwidth);
            linkStateAttribute.setMaxReservableBandwidthTLV(maxReservableBandwidthTLV);
            linkStateNeeded = true;
        }
        if (maximumBandwidth != 0.0f) {
            MaximumLinkBandwidthLinkAttribTLV maximumLinkBandwidthTLV = new MaximumLinkBandwidthLinkAttribTLV();
            maximumLinkBandwidthTLV.setMaximumBandwidth(maximumBandwidth);
            linkStateAttribute.setMaximumLinkBandwidthTLV(maximumLinkBandwidthTLV);
            linkStateNeeded = true;
        }
        if (unreservedBandwidth != null) {
            UnreservedBandwidthLinkAttribTLV unreservedBandwidthTLV = new UnreservedBandwidthLinkAttribTLV();
            unreservedBandwidthTLV.setUnreservedBandwidth(unreservedBandwidth);
            linkStateAttribute.setUnreservedBandwidthTLV(unreservedBandwidthTLV);
            linkStateNeeded = true;
        }
        if (availableLabels != null) {
            this.log.debug("Available labels fields: " + availableLabels.getLabelSet().getNumLabels());
            AvailableLabels al = new AvailableLabels();
            BitmapLabelSet bl = new BitmapLabelSet();
            bl.setBytesBitmap(((BitmapLabelSet)availableLabels.getLabelSet()).getBytesBitMap());
            bl.setNumLabels(availableLabels.getLabelSet().getNumLabels());
            bl.setDwdmWavelengthLabel(((BitmapLabelSet)availableLabels.getLabelSet()).getDwdmWavelengthLabel());
            bl.setBytesBitmapReserved(((BitmapLabelSet)availableLabels.getLabelSet()).getBytesBitmapReserved());
            al.setLabelSet(bl);
            this.log.debug("Campo BytesBitmap: " + Integer.toHexString(bl.getBytesBitMap()[0] & 0xFF));
            this.log.debug("Campo DwdmWavelengthLabel: " + bl.getDwdmWavelengthLabel());
            if (bl.getBytesBitmapReserved() != null) {
                this.log.debug("Campo BytesBitmapReserved: " + bl.getBytesBitmapReserved()[0]);
            }
            linkStateAttribute.setAvailableLabels(al);
            linkStateNeeded = true;
        }
        if (te_metric != 0) {
            DefaultTEMetricLinkAttribTLV defaultMetric = new DefaultTEMetricLinkAttribTLV();
            defaultMetric.setLinkMetric(te_metric);
            this.log.debug("Metric en el metodo createMsgUpdateLinkNLRI es: " + te_metric);
            linkStateAttribute.setTEMetricTLV(defaultMetric);
            linkStateNeeded = true;
        }
        if (mfOTP != null) {
            MF_OTPAttribTLV mfOTPTLV = mfOTP.duplicate();
            this.log.debug("SENDING MFOTP OSCAR");
            linkStateAttribute.setMF_OTP_ATLV(mfOTPTLV);
            linkStateNeeded = true;
        }
        if (linkStateNeeded) {
            pathAttributes.add(linkStateAttribute);
        }
        LinkNLRI linkNLRI = new LinkNLRI();
        linkNLRI.setProtocolID(0);
        linkNLRI.setIdentifier(this.instanceId);
        LocalNodeDescriptorsTLV localNodeDescriptors = new LocalNodeDescriptorsTLV();
        RemoteNodeDescriptorsTLV remoteNodeDescriptors = new RemoteNodeDescriptorsTLV();
        IGPRouterIDNodeDescriptorSubTLV igpRouterIDLNSubTLV = new IGPRouterIDNodeDescriptorSubTLV();
        igpRouterIDLNSubTLV.setIpv4AddressOSPF(addressList.get(0));
        igpRouterIDLNSubTLV.setIGP_router_id_type(3);
        localNodeDescriptors.setIGPRouterID(igpRouterIDLNSubTLV);
        BGPLSIdentifierNodeDescriptorSubTLV bGPLSIDSubTLV = new BGPLSIdentifierNodeDescriptorSubTLV();
        bGPLSIDSubTLV.setBGPLS_ID(this.localBGPLSIdentifer);
        localNodeDescriptors.setBGPLSIDSubTLV(bGPLSIDSubTLV);
        AreaIDNodeDescriptorSubTLV areaID = new AreaIDNodeDescriptorSubTLV();
        areaID.setAREA_ID(this.localAreaID);
        localNodeDescriptors.setAreaID(areaID);
        IGPRouterIDNodeDescriptorSubTLV igpRouterIDDNSubTLV = new IGPRouterIDNodeDescriptorSubTLV();
        igpRouterIDDNSubTLV.setIpv4AddressOSPF(addressList.get(1));
        igpRouterIDDNSubTLV.setIGP_router_id_type(3);
        remoteNodeDescriptors.setIGPRouterID(igpRouterIDDNSubTLV);
        if (domainList != null) {
            AutonomousSystemNodeDescriptorSubTLV as_local = new AutonomousSystemNodeDescriptorSubTLV();
            try {
                as_local.setAS_ID((Inet4Address)Inet4Address.getByName(domainList.get(0)));
                localNodeDescriptors.setAutonomousSystemSubTLV(as_local);
                AutonomousSystemNodeDescriptorSubTLV as_remote = new AutonomousSystemNodeDescriptorSubTLV();
                as_remote.setAS_ID((Inet4Address)Inet4Address.getByName(domainList.get(1)));
                remoteNodeDescriptors.setAutonomousSystemSubTLV(as_remote);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        remoteNodeDescriptors.setBGPLSIDSubTLV(bGPLSIDSubTLV);
        remoteNodeDescriptors.setAreaID(areaID);
        linkNLRI.setLocalNodeDescriptors(localNodeDescriptors);
        linkNLRI.setRemoteNodeDescriptorsTLV(remoteNodeDescriptors);
        IPv4InterfaceAddressLinkDescriptorsSubTLV ipv4InterfaceAddressTLV = new IPv4InterfaceAddressLinkDescriptorsSubTLV();
        IPv4NeighborAddressLinkDescriptorSubTLV ipv4NeighborAddressTLV = new IPv4NeighborAddressLinkDescriptorSubTLV();
        ipv4InterfaceAddressTLV.setIpv4Address(addressList.get(0));
        ipv4NeighborAddressTLV.setIpv4Address(addressList.get(1));
        linkNLRI.setIpv4InterfaceAddressTLV(ipv4InterfaceAddressTLV);
        linkNLRI.setIpv4NeighborAddressTLV(ipv4NeighborAddressTLV);
        if (localRemoteIfList != null) {
            LinkLocalRemoteIdentifiersLinkDescriptorSubTLV linkIdentifiersTLV = new LinkLocalRemoteIdentifiersLinkDescriptorSubTLV();
            linkIdentifiersTLV.setLinkLocalIdentifier(localRemoteIfList.get(0));
            linkIdentifiersTLV.setLinkRemoteIdentifier(localRemoteIfList.get(1));
            linkNLRI.setLinkIdentifiersTLV(linkIdentifiersTLV);
        }
        if (te_info != null) {
            BGP4TLVFormat uSTLV;
            if (te_info.getUndirLinkDelay() != null) {
                int undirLinkDelay = te_info.getUndirLinkDelay().getDelay();
                uSTLV = new UndirectionalLinkDelayDescriptorSubTLV();
                ((UndirectionalLinkDelayDescriptorSubTLV)uSTLV).setDelay(undirLinkDelay);
                linkNLRI.setUndirectionalLinkDelayTLV((UndirectionalLinkDelayDescriptorSubTLV)uSTLV);
            }
            if (te_info.getUndirDelayVar() != null) {
                int undirDelayVar = te_info.getUndirDelayVar().getDelayVar();
                uSTLV = new UndirectionalDelayVariationDescriptorSubTLV();
                ((UndirectionalDelayVariationDescriptorSubTLV)uSTLV).setDelayVar(undirDelayVar);
                linkNLRI.setUndirectionalDelayVariationTLV((UndirectionalDelayVariationDescriptorSubTLV)uSTLV);
            }
            if (te_info.getMinMaxUndirLinkDelay() != null) {
                int minDelay = te_info.getMinMaxUndirLinkDelay().getLowDelay();
                int maxDelay = te_info.getMinMaxUndirLinkDelay().getHighDelay();
                MinMaxUndirectionalLinkDelayDescriptorSubTLV uSTLV2 = new MinMaxUndirectionalLinkDelayDescriptorSubTLV();
                uSTLV2.setHighDelay(maxDelay);
                uSTLV2.setLowDelay(minDelay);
                linkNLRI.setMinMaxUndirectionalLinkDelayTLV(uSTLV2);
            }
            if (te_info.getUndirLinkLoss() != null) {
                int linkLoss = te_info.getUndirLinkLoss().getLinkLoss();
                UndirectionalLinkLossDescriptorSubTLV uSTLV3 = new UndirectionalLinkLossDescriptorSubTLV();
                uSTLV3.setLinkLoss(linkLoss);
                linkNLRI.setUndirectionalLinkLossTLV(uSTLV3);
            }
            if (te_info.getUndirResidualBw() != null) {
                int resBw = te_info.getUndirResidualBw().getResidualBw();
                UndirectionalResidualBandwidthDescriptorSubTLV uSTLV4 = new UndirectionalResidualBandwidthDescriptorSubTLV();
                uSTLV4.setResidualBw(resBw);
                linkNLRI.setUndirectionalResidualBwTLV(uSTLV4);
            }
            if (te_info.getUndirAvailableBw() != null) {
                int availableBw = te_info.getUndirAvailableBw().getAvailableBw();
                UndirectionalAvailableBandwidthDescriptorSubTLV uSTLV5 = new UndirectionalAvailableBandwidthDescriptorSubTLV();
                uSTLV5.setAvailableBw(availableBw);
                linkNLRI.setUndirectionalAvailableBwTLV(uSTLV5);
            }
            if (te_info.getUndirUtilizedBw() != null) {
                int utilizedBw = te_info.getUndirUtilizedBw().getUtilizedBw();
                UndirectionalUtilizedBandwidthDescriptorSubTLV uSTLV6 = new UndirectionalUtilizedBandwidthDescriptorSubTLV();
                uSTLV6.setUtilizedBw(utilizedBw);
                linkNLRI.setUndirectionalUtilizedBwTLV(uSTLV6);
            }
        }
        linkNLRI.setIdentifier(this.identifier);
        BGP_LS_MP_Reach_Attribute ra = new BGP_LS_MP_Reach_Attribute();
        ra.setLsNLRI(linkNLRI);
        pathAttributes.add(ra);
        return update;
    }

    public static OSPFv2LinkStateUpdatePacket createMsgOSPF() {
        Inet4Address src = null;
        Inet4Address dst = null;
        MaximumBandwidth maximumBandwidth = new MaximumBandwidth();
        maximumBandwidth.setMaximumBandwidth(100.0f);
        UnreservedBandwidth unreservedBandwidth = new UnreservedBandwidth();
        float[] unReservedB = new float[8];
        unReservedB[0] = 18309.0f;
        unReservedB[1] = 130.0f;
        unreservedBandwidth.setUnreservedBandwidth(unReservedB);
        try {
            src = (Inet4Address)Inet4Address.getByName("179.123.123.123");
            dst = (Inet4Address)Inet4Address.getByName("179.123.123.111");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        OSPFv2LinkStateUpdatePacket ospfv2Packet = new OSPFv2LinkStateUpdatePacket();
        ospfv2Packet.setRouterID(src);
        LinkedList<LSA> lsaList = new LinkedList<LSA>();
        OSPFTEv2LSA lsa = new OSPFTEv2LSA();
        LinkTLV linkTLV = new LinkTLV();
        lsa.setLinkTLV(linkTLV);
        linkTLV.setMaximumBandwidth(maximumBandwidth);
        linkTLV.setUnreservedBandwidth(unreservedBandwidth);
        LocalInterfaceIPAddress localInterfaceIPAddress = new LocalInterfaceIPAddress();
        LinkedList<Inet4Address> lista = localInterfaceIPAddress.getLocalInterfaceIPAddressList();
        lista.add(src);
        linkTLV.setLocalInterfaceIPAddress(localInterfaceIPAddress);
        RemoteInterfaceIPAddress remoteInterfaceIPAddress = new RemoteInterfaceIPAddress();
        LinkedList<Inet4Address> listar = remoteInterfaceIPAddress.getRemoteInterfaceIPAddressList();
        listar.add(dst);
        linkTLV.setRemoteInterfaceIPAddress(remoteInterfaceIPAddress);
        LinkID linkID = new LinkID();
        linkID.setLinkID(dst);
        linkTLV.setLinkID(linkID);
        lsaList.add(lsa);
        ospfv2Packet.setLSAlist(lsaList);
        return ospfv2Packet;
    }

    public BGP4Update decodificarMsgOSPF(OSPFv2LinkStateUpdatePacket ospfv2Packet) {
        boolean intradomain = true;
        Inet4Address localIPAddress = ospfv2Packet.getRouterID();
        Inet4Address remoteIPAddress = null;
        long localInterfaceIPAddress = -1L;
        long remoteInterfaceIPAddress = -1L;
        Inet4Address remoteASNumber = null;
        AvailableLabels al = null;
        float maxBandwidth = 0.0f;
        float[] unBandwidth = null;
        float maximumReservableBandwidth = 0.0f;
        LinkedList<LSA> lsaList = ospfv2Packet.getLSAlist();
        int i = 0;
        while (i < lsaList.size()) {
            if (lsaList.get(i).getLStype() == 10) {
                OSPFTEv2LSA lsa = (OSPFTEv2LSA)lsaList.get(i);
                this.log.debug("Starting to process LSA");
                LinkTLV linkTLV = lsa.getLinkTLV();
                if (linkTLV != null) {
                    remoteIPAddress = linkTLV.getLinkID().getLinkID();
                    this.log.debug("Remote IP Address: " + remoteIPAddress);
                    localInterfaceIPAddress = linkTLV.getLinkLocalRemoteIdentifiers().getLinkLocalIdentifier();
                    this.log.debug("Local Interface: " + localInterfaceIPAddress);
                    remoteInterfaceIPAddress = linkTLV.getLinkLocalRemoteIdentifiers().getLinkRemoteIdentifier();
                    this.log.debug("Remote Interface: " + remoteInterfaceIPAddress);
                    if (linkTLV.getMaximumBandwidth() != null) {
                        maxBandwidth = linkTLV.getMaximumBandwidth().getMaximumBandwidth();
                    }
                    if (linkTLV.getUnreservedBandwidth() != null) {
                        unBandwidth = linkTLV.getUnreservedBandwidth().getUnreservedBandwidth();
                    }
                    if (linkTLV.getMaximumReservableBandwidth() != null) {
                        maximumReservableBandwidth = linkTLV.getMaximumReservableBandwidth().getMaximumReservableBandwidth();
                    }
                    al = linkTLV.getAvailableLabels();
                    if (linkTLV.getRemoteASNumber() != null) {
                        remoteASNumber = linkTLV.getRemoteASNumber().getRemoteASNumber();
                    }
                }
            }
            ++i;
        }
        ArrayList<Inet4Address> addressList = new ArrayList<Inet4Address>();
        addressList.add(localIPAddress);
        addressList.add(remoteIPAddress);
        ArrayList<Long> localRemoteIfList = new ArrayList<Long>();
        localRemoteIfList.add(localInterfaceIPAddress);
        localRemoteIfList.add(remoteInterfaceIPAddress);
        ArrayList domainList = new ArrayList(2);
        return null;
    }

    public boolean isSendTopology() {
        return this.sendTopology;
    }

    public void setSendTopology(boolean sendTopology) {
        this.sendTopology = sendTopology;
    }

    public void setisTest(boolean test) {
        this.isTest = test;
    }

    public boolean getisTest() {
        return this.isTest;
    }

    public BGP4SessionsInformation getBgp4SessionsInformation() {
        return this.bgp4SessionsInformation;
    }

    public void setBgp4SessionsInformation(BGP4SessionsInformation bgp4SessionsInformation) {
        this.bgp4SessionsInformation = bgp4SessionsInformation;
    }

    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }
}

