/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.peer;

import eu.teraflow.tid.tedb.DatabaseControlSimplifiedLSA;
import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.InterDomainEdge;
import eu.teraflow.tid.tedb.IntraDomainEdge;
import eu.teraflow.tid.tedb.MultiDomainTEDB;
import eu.teraflow.tid.tedb.TEDB;
import eu.teraflow.tid.tedb.TE_Information;
import java.net.Inet4Address;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class SaveTopologyinDB
implements Runnable {
    private Jedis jedis;
    private String host = "localhost";
    private int port = 6379;
    private Hashtable<String, TEDB> intraTEDBs;
    private MultiDomainTEDB multiDomainTEDB;
    private boolean writeTopology;
    private Logger log = LoggerFactory.getLogger((String)"BGP4Peer");

    public SaveTopologyinDB() {
        this.jedis = new Jedis(this.host, this.port);
    }

    public void configure(Hashtable<String, TEDB> intraTEDBs, MultiDomainTEDB multiTED, boolean writeTopology, String host, int port) {
        this.intraTEDBs = intraTEDBs;
        this.writeTopology = writeTopology;
        this.multiDomainTEDB = multiTED;
        if (writeTopology) {
            this.jedis = new Jedis(host, port);
            this.jedis.connect();
        }
    }

    @Override
    public void run() {
        try {
            if (this.writeTopology) {
                Enumeration<Object> iter;
                this.log.info("Going to save Topology in Redis DB");
                if (this.jedis == null) {
                    this.jedis = new Jedis(this.host, this.port);
                    this.jedis.connect();
                } else if (!this.jedis.isConnected()) {
                    this.jedis.connect();
                }
                if (this.multiDomainTEDB != null) {
                    this.log.info("save Multi-Domain TEDB");
                    this.writeLinkDBInter(this.multiDomainTEDB.getInterDomainLinks());
                } else {
                    this.log.info("save form TEDB");
                    iter = this.intraTEDBs.elements();
                    while (iter.hasMoreElements()) {
                        this.writeLinkDBInter(iter.nextElement().getInterDomainLinks());
                    }
                }
                this.log.info("sendIntraDomainLinks activated");
                iter = this.intraTEDBs.keys();
                while (iter.hasMoreElements()) {
                    String domainID = (String)iter.nextElement();
                    this.log.info("Sending TED from domain " + domainID);
                    DomainTEDB ted = (DomainTEDB)this.intraTEDBs.get(domainID);
                    this.writeLinkDB(ted.getIntraDomainLinks(), domainID);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("PROBLEM Writing TOPOLOGY: " + e.toString());
        }
    }

    private void writeLinkDB(Set<IntraDomainEdge> intradomainLinks, String domainID) {
        for (IntraDomainEdge edge : intradomainLinks) {
            DatabaseControlSimplifiedLSA dcsl = this.createSimplifiedLSA(edge);
            String jsonLSA = dcsl.logJsonSimplifiedLSA();
            if (this.jedis == null) {
                this.log.info("JEDIS IS NULL");
            }
            String string = this.jedis.set("LSA:" + dcsl.getAdvertisingRouter().getHostAddress() + ":" + dcsl.getLinkId().getHostAddress(), jsonLSA);
        }
    }

    private DatabaseControlSimplifiedLSA createSimplifiedLSA(IntraDomainEdge edge) {
        DatabaseControlSimplifiedLSA dcsl = new DatabaseControlSimplifiedLSA();
        Inet4Address source = (Inet4Address)edge.getSource();
        dcsl.setAdvertisingRouter(source);
        Inet4Address dst = (Inet4Address)edge.getTarget();
        dcsl.setLinkId(dst);
        TE_Information te_info = edge.getTE_info();
        if (te_info != null) {
            if (te_info.getLinkLocalRemoteIdentifiers() != null) {
                dcsl.linkLocalIdentifier = te_info.getLinkLocalRemoteIdentifiers().getLinkLocalIdentifier();
            }
            if (te_info.getLinkLocalRemoteIdentifiers() != null) {
                dcsl.linkRemoteIdentifier = te_info.getLinkLocalRemoteIdentifiers().getLinkRemoteIdentifier();
            }
            if (te_info.getMaximumBandwidth() != null) {
                dcsl.maximumBandwidth = te_info.getMaximumBandwidth().getMaximumBandwidth();
            }
            if (te_info.getUnreservedBandwidth() != null) {
                dcsl.unreservedBandwidth = te_info.getUnreservedBandwidth().getUnreservedBandwidth()[0];
            }
            if (te_info.getMaximumReservableBandwidth() != null) {
                dcsl.maximumReservableBandwidth = te_info.getMaximumReservableBandwidth().getMaximumReservableBandwidth();
            }
            String ret = "";
            if (te_info.getAvailableLabels() != null && te_info.getAvailableLabels().getLabelSet() != null) {
                ret = String.valueOf(ret) + " Bitmap: {";
                int i = 0;
                while (i < te_info.getAvailableLabels().getLabelSet().getNumLabels()) {
                    ret = String.valueOf(ret) + (te_info.isWavelengthFree(i) ? "0" : "1");
                    ++i;
                }
                ret = String.valueOf(ret) + "}";
                dcsl.setBitmapLabelSet(ret);
            }
        }
        return dcsl;
    }

    private void writeLinkDBInter(LinkedList<InterDomainEdge> interdomainLinks) {
        for (InterDomainEdge edge : interdomainLinks) {
            DatabaseControlSimplifiedLSA dcsl = this.createSimplifiedLSAInter(edge);
            String jsonLSA = dcsl.logJsonSimplifiedLSA();
            String string = this.jedis.set("LSA:" + dcsl.getAdvertisingRouter().getHostAddress() + ":" + dcsl.getLinkId().getHostAddress(), jsonLSA);
        }
    }

    private DatabaseControlSimplifiedLSA createSimplifiedLSAInter(InterDomainEdge edge) {
        DatabaseControlSimplifiedLSA dcsl = new DatabaseControlSimplifiedLSA();
        Inet4Address source = (Inet4Address)edge.getSource();
        dcsl.setAdvertisingRouter(source);
        Inet4Address dst = (Inet4Address)edge.getTarget();
        dcsl.setLinkId(dst);
        TE_Information te_info = edge.getTE_info();
        if (te_info != null) {
            if (te_info.getLinkLocalRemoteIdentifiers() != null) {
                dcsl.linkLocalIdentifier = te_info.getLinkLocalRemoteIdentifiers().getLinkLocalIdentifier();
            }
            if (te_info.getLinkLocalRemoteIdentifiers() != null) {
                dcsl.linkRemoteIdentifier = te_info.getLinkLocalRemoteIdentifiers().getLinkRemoteIdentifier();
            }
            if (te_info.getMaximumBandwidth() != null) {
                dcsl.maximumBandwidth = te_info.getMaximumBandwidth().getMaximumBandwidth();
            }
            if (te_info.getUnreservedBandwidth() != null) {
                dcsl.unreservedBandwidth = te_info.getUnreservedBandwidth().getUnreservedBandwidth()[0];
            }
            if (te_info.getMaximumReservableBandwidth() != null) {
                dcsl.maximumReservableBandwidth = te_info.getMaximumReservableBandwidth().getMaximumReservableBandwidth();
            }
            String ret = "";
            if (te_info.getAvailableLabels() != null && te_info.getAvailableLabels().getLabelSet() != null) {
                ret = String.valueOf(ret) + " Bitmap: {";
                int i = 0;
                while (i < te_info.getAvailableLabels().getLabelSet().getNumLabels()) {
                    ret = String.valueOf(ret) + (te_info.isWavelengthFree(i) ? "0" : "1");
                    ++i;
                }
                ret = String.valueOf(ret) + "}";
                dcsl.setBitmapLabelSet(ret);
            }
        }
        return dcsl;
    }

    public MultiDomainTEDB getMultiDomainTEDB() {
        return this.multiDomainTEDB;
    }

    public void setMultiDomainTEDB(MultiDomainTEDB multiDomainTEDB) {
        this.multiDomainTEDB = multiDomainTEDB;
    }
}

