/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.peer;

import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionsInformation;
import eu.teraflow.tid.bgp4Peer.management.BGP4ManagementServer;
import eu.teraflow.tid.bgp4Peer.peer.BGP4LSPeerInfo;
import eu.teraflow.tid.bgp4Peer.peer.BGP4Parameters;
import eu.teraflow.tid.bgp4Peer.peer.BGP4SessionClientManager;
import eu.teraflow.tid.bgp4Peer.peer.BGP4SessionServerManager;
import eu.teraflow.tid.bgp4Peer.peer.SaveTopologyinDB;
import eu.teraflow.tid.bgp4Peer.peer.SendTopology;
import eu.teraflow.tid.bgp4Peer.updateTEDB.UpdateDispatcher;
import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.FileTEDBUpdater;
import eu.teraflow.tid.tedb.MDTEDB;
import eu.teraflow.tid.tedb.MultiDomainTEDB;
import eu.teraflow.tid.tedb.SimpleTEDB;
import eu.teraflow.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BGPPeer {
    private BGP4SessionServerManager bgp4SessionServer;
    private BGP4SessionClientManager bgp4SessionClientManager;
    private BGP4Parameters params;
    private BGP4SessionsInformation bgp4SessionsInformation;
    private MultiDomainTEDB multiDomainTEDB;
    private Hashtable<String, TEDB> intraTEDBs;
    private SimpleTEDB fullTEDB;
    private boolean sendTopology;
    private SendTopology sendTopologyTask;
    private boolean saveTopology;
    private SaveTopologyinDB saveTopologyDB;
    private LinkedList<BGP4LSPeerInfo> peersToConnect;
    private Logger logParser;
    private Logger logClient;
    private Logger logServer;
    private UpdateDispatcher ud;
    private ScheduledThreadPoolExecutor executor;

    public void configure() {
        this.configure(null);
    }

    public void configure(String nameParametersFile) {
        this.configure(nameParametersFile, null, null);
    }

    public void configure(String nameParametersFile, MultiDomainTEDB multiTEDB, Hashtable<String, TEDB> iTEDBs) {
        this.params = nameParametersFile != null ? new BGP4Parameters(nameParametersFile) : new BGP4Parameters();
        this.params.initialize();
        this.peersToConnect = this.params.getPeersToConnect();
        this.sendTopology = this.params.isSendTopology();
        this.saveTopology = this.params.isSaveTopologyDB();
        this.logParser = LoggerFactory.getLogger((String)"BGP4Parser");
        this.logClient = LoggerFactory.getLogger((String)"BGP4Client");
        this.logServer = LoggerFactory.getLogger((String)"BGP4Peer");
        this.logServer.info("Inizializing BGP4 Peer");
        this.intraTEDBs = iTEDBs != null ? iTEDBs : new Hashtable();
        this.multiDomainTEDB = multiTEDB != null ? multiTEDB : new MDTEDB();
        if (this.params.getLearnTopology().equals("fromXML")) {
            this.logParser.info("BGPIdentifier: " + this.params.getBGPIdentifier());
            this.intraTEDBs = FileTEDBUpdater.readMultipleDomainSimpleNetworks(this.params.getTopologyFile(), null, false, 0, Integer.MAX_VALUE, false, this.params.getBGPIdentifier());
            this.multiDomainTEDB.initializeFromFile(this.params.getTopologyFile(), this.params.getBGPIdentifier());
        }
        this.executor = new ScheduledThreadPoolExecutor(20);
        this.bgp4SessionsInformation = this.params.isTest() ? new BGP4SessionsInformation(this.params.isTest()) : new BGP4SessionsInformation();
        this.sendTopologyTask = new SendTopology();
        this.saveTopologyDB = new SaveTopologyinDB();
        if (this.params.isSaveTopologyDB()) {
            this.saveTopologyDB.configure(this.intraTEDBs, this.multiDomainTEDB, this.params.isSaveTopologyDB(), this.params.getTopologyDBIP().getHostAddress(), this.params.getTopologyDBport());
        }
    }

    public void setWriteMultiTEDB(MultiDomainTEDB multiTEDB) {
        this.multiDomainTEDB = multiTEDB;
        this.saveTopologyDB.setMultiDomainTEDB(multiTEDB);
    }

    public void setReadDomainTEDB(DomainTEDB readDomainTEDB) {
        if (readDomainTEDB.getDomainID() == null) {
            this.intraTEDBs.put("default", readDomainTEDB);
        } else {
            this.intraTEDBs.put(readDomainTEDB.getDomainID().toString(), readDomainTEDB);
        }
    }

    public void createUpdateDispatcher() {
        this.ud = new UpdateDispatcher(this.multiDomainTEDB, this.intraTEDBs);
    }

    public void startManagementServer() {
        this.logServer.debug("Initializing Management Server");
        BGP4ManagementServer bms = new BGP4ManagementServer(this.params.getBGP4ManagementPort(), this.multiDomainTEDB, this.intraTEDBs, this.bgp4SessionsInformation, this.sendTopologyTask);
        bms.start();
    }

    public void startClient() {
        this.logClient.debug("Initializing Session Manager to connect as client");
        if (this.params.getBGPIdentifier() != null) {
            Inet4Address BGPIdentifier = null;
            try {
                BGPIdentifier = (Inet4Address)InetAddress.getByName(this.params.getBGPIdentifier());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return;
            }
            int i = 0;
            while (i < this.peersToConnect.size()) {
                this.bgp4SessionClientManager = new BGP4SessionClientManager(this.bgp4SessionsInformation, this.ud, this.peersToConnect.get(i), this.params.getBGP4Port(), this.params.getLocalBGPAddress(), this.params.getLocalBGPPort(), this.params.getHoldTime(), BGPIdentifier, this.params.getVersion(), this.params.getMyAutonomousSystem(), this.params.getKeepAliveTimer());
                this.executor.scheduleWithFixedDelay(this.bgp4SessionClientManager, 0L, this.params.getDelay(), TimeUnit.MILLISECONDS);
                ++i;
            }
        } else {
            this.logClient.error("ERROR: BGPIdentifier is not configured. To configure: XML file (BGP4Parameters.xml) <localBGPAddress>.");
            System.exit(1);
        }
    }

    public void startServer() {
        this.logServer.info("Initializing Session Manager to connect as server");
        Inet4Address localAddress = null;
        Inet4Address BGPIdentifier = null;
        if (this.params.getBGPIdentifier() != null) {
            try {
                localAddress = (Inet4Address)InetAddress.getByName(this.params.getLocalBGPAddress());
                BGPIdentifier = (Inet4Address)InetAddress.getByName(this.params.getBGPIdentifier());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return;
            }
            if (this.params.isTest()) {
                this.bgp4SessionServer = new BGP4SessionServerManager(this.bgp4SessionsInformation, this.multiDomainTEDB, this.ud, this.params.getBGP4Port(), this.params.getHoldTime(), BGPIdentifier, this.params.getVersion(), this.params.getMyAutonomousSystem(), this.params.isNodelay(), localAddress, this.params.getKeepAliveTimer(), this.peersToConnect, this.params.isTest());
                this.executor.execute(this.bgp4SessionServer);
            } else {
                this.bgp4SessionServer = new BGP4SessionServerManager(this.bgp4SessionsInformation, this.multiDomainTEDB, this.ud, this.params.getBGP4Port(), this.params.getHoldTime(), BGPIdentifier, this.params.getVersion(), this.params.getMyAutonomousSystem(), this.params.isNodelay(), localAddress, this.params.getKeepAliveTimer(), this.peersToConnect);
                this.executor.execute(this.bgp4SessionServer);
            }
        } else {
            this.logServer.error("ERROR: BGPIdentifier is not configured. To configure: XML file (BGP4Parameters.xml) <localBGPAddress>.");
            System.exit(1);
        }
    }

    public void startSendTopology() {
        if (this.params.isTest()) {
            this.sendTopologyTask.configure(this.intraTEDBs, this.bgp4SessionsInformation, this.sendTopology, this.params.getInstanceID(), this.params.isSendIntradomainLinks(), this.multiDomainTEDB, this.params.isTest());
        } else {
            this.sendTopologyTask.configure(this.intraTEDBs, this.bgp4SessionsInformation, this.sendTopology, this.params.getInstanceID(), this.params.isSendIntradomainLinks(), this.multiDomainTEDB);
        }
        this.executor.scheduleWithFixedDelay(this.sendTopologyTask, 0L, this.params.getSendTopoDelay(), TimeUnit.MILLISECONDS);
    }

    public void startSaveTopology() {
        this.executor.scheduleWithFixedDelay(this.saveTopologyDB, 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    public SaveTopologyinDB getSaveTopologyDB() {
        return this.saveTopologyDB;
    }

    public void setSaveTopologyDB(SaveTopologyinDB saveTopologyDB) {
        this.saveTopologyDB = saveTopologyDB;
    }

    public boolean isSaveTopology() {
        return this.saveTopology;
    }

    public void setSaveTopology(boolean saveTopology) {
        this.saveTopology = saveTopology;
    }

    public UpdateDispatcher getUd() {
        return this.ud;
    }

    public void setUd(UpdateDispatcher ud) {
        this.ud = ud;
    }

    public void addSimpleTEDB(SimpleTEDB simpleTEDB, String domainID) {
        this.intraTEDBs.put(domainID, simpleTEDB);
    }

    public void setSimpleTEDB(SimpleTEDB simpleTEDB) {
        if (simpleTEDB.getDomainID() == null) {
            this.intraTEDBs.put("default", simpleTEDB);
        } else {
            this.intraTEDBs.put(simpleTEDB.getDomainID().toString(), simpleTEDB);
        }
    }

    public void stopPeer() {
        this.executor.shutdown();
    }

    public MultiDomainTEDB getMultiDomainTEDB() {
        return this.multiDomainTEDB;
    }

    public Hashtable<String, TEDB> getIntraTEDBs() {
        return this.intraTEDBs;
    }

    public void setIntraTEDBs(Hashtable<String, TEDB> intraTEDBs) {
        this.intraTEDBs = intraTEDBs;
    }

    public void setMultiDomainTEDB(MultiDomainTEDB multiDomainTEDB) {
        this.multiDomainTEDB = multiDomainTEDB;
    }
}

