/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.peer;

import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4PeerInitiatedSession;
import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionsInformation;
import eu.teraflow.tid.bgp4Peer.peer.BGP4LSPeerInfo;
import eu.teraflow.tid.bgp4Peer.updateTEDB.UpdateDispatcher;
import eu.teraflow.tid.tedb.TEDB;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BGP4SessionServerManager
implements Runnable {
    private BGP4PeerInitiatedSession bgp4SessionServer;
    private Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
    BGP4SessionsInformation bgp4SessionsInformation;
    int bgp4Port;
    private int holdTime;
    private int keepAliveTimer;
    private Inet4Address BGPIdentifier;
    private int version = 4;
    private int myAutonomousSystem;
    private boolean noDelay;
    private boolean isTest = false;
    private TEDB tedb;
    private UpdateDispatcher ud;
    Inet4Address localBGP4Address;
    private Boolean updateFrom;
    private Boolean sendTo;
    private LinkedList<BGP4LSPeerInfo> peersToConnect;

    public BGP4SessionServerManager(BGP4SessionsInformation bgp4SessionInformation, TEDB tedb, UpdateDispatcher ud, int bgp4Port, int holdTime, Inet4Address BGPIdentifier, int version, int myAutonomousSystem, boolean noDelay, Inet4Address localAddress, int mykeepAliveTimer, LinkedList<BGP4LSPeerInfo> peersToConnect) {
        this.holdTime = holdTime;
        this.BGPIdentifier = BGPIdentifier;
        this.version = version;
        this.myAutonomousSystem = myAutonomousSystem;
        this.bgp4SessionsInformation = bgp4SessionInformation;
        this.bgp4Port = bgp4Port;
        this.noDelay = noDelay;
        this.tedb = tedb;
        this.ud = ud;
        this.localBGP4Address = localAddress;
        this.keepAliveTimer = mykeepAliveTimer;
        this.peersToConnect = peersToConnect;
    }

    public BGP4SessionServerManager(BGP4SessionsInformation bgp4SessionInformation, TEDB tedb, UpdateDispatcher ud, int bgp4Port, int holdTime, Inet4Address BGPIdentifier, int version, int myAutonomousSystem, boolean noDelay, Inet4Address localAddress, int mykeepAliveTimer, LinkedList<BGP4LSPeerInfo> peersToConnect, boolean test) {
        this.holdTime = holdTime;
        this.BGPIdentifier = BGPIdentifier;
        this.version = version;
        this.myAutonomousSystem = myAutonomousSystem;
        this.bgp4SessionsInformation = bgp4SessionInformation;
        this.bgp4Port = bgp4Port;
        this.noDelay = noDelay;
        this.tedb = tedb;
        this.ud = ud;
        this.localBGP4Address = localAddress;
        this.keepAliveTimer = mykeepAliveTimer;
        this.peersToConnect = peersToConnect;
        this.isTest = test;
    }

    public Boolean getSendTo() {
        return this.sendTo;
    }

    public void setSendTo(Boolean sendTo) {
        this.sendTo = sendTo;
    }

    public Boolean getUpdateFrom() {
        return this.updateFrom;
    }

    public void setUpdateFrom(Boolean updateFrom) {
        this.updateFrom = updateFrom;
    }

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        boolean listening = true;
        try {
            this.log.debug("SERVER Listening on port: " + this.bgp4Port);
            this.log.debug("SERVER Listening on address: " + this.localBGP4Address);
            serverSocket = new ServerSocket(this.bgp4Port, 0, this.localBGP4Address);
        }
        catch (IOException e) {
            this.log.error("Could not listen on port: " + this.bgp4Port);
            System.exit(-1);
        }
        while (listening) {
            try {
                Socket sock = serverSocket.accept();
                this.bgp4SessionServer = new BGP4PeerInitiatedSession(sock, this.bgp4SessionsInformation, this.ud, this.holdTime, this.BGPIdentifier, this.version, this.myAutonomousSystem, this.noDelay, this.keepAliveTimer);
                if (this.isTest) {
                    this.log.info("isTest");
                    this.bgp4SessionServer.setSendTo(true);
                    this.bgp4SessionServer.start();
                    continue;
                }
                this.log.info("Not Test");
                int i = 0;
                while (i < this.peersToConnect.size()) {
                    try {
                        Inet4Address add = this.peersToConnect.get(i).getPeerIP();
                        if (add == null) {
                            this.log.warn("peer IP address shouldn't be null");
                        } else if (add.equals(sock.getInetAddress())) {
                            this.log.debug("FOUND " + add);
                            this.bgp4SessionServer.setSendTo(this.peersToConnect.get(i).isSendToPeer());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                this.bgp4SessionServer.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.log.info("Closing the socket");
            serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

