/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.peer;

import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionClient;
import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionExistsException;
import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionsInformation;
import eu.teraflow.tid.bgp4Peer.peer.BGP4LSPeerInfo;
import eu.teraflow.tid.bgp4Peer.updateTEDB.UpdateDispatcher;
import java.net.Inet4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BGP4SessionClientManager
implements Runnable {
    private BGP4SessionClient bgp4SessionClient;
    private Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
    BGP4SessionsInformation bgp4SessionInformation;
    private BGP4LSPeerInfo peer;
    private Inet4Address peerIP;
    private String localBGP4Address;
    private int localBGP4Port;
    private int holdTime;
    private int keepAliveTimer;
    private Inet4Address BGPIdentifier;
    private int version = 4;
    private int myAutonomousSystem;
    private UpdateDispatcher ud;
    private Boolean updateFrom;
    private Boolean sendTo;

    public BGP4SessionClientManager(BGP4SessionsInformation bgp4SessionInformation, UpdateDispatcher ud, BGP4LSPeerInfo peer, int bgp4Port, String my_IPAddress, int my_bgp4Port, int holdTime, Inet4Address BGPIdentifier, int version, int myAutonomousSystem, int my_keepAliveTimer) {
        this.bgp4SessionInformation = bgp4SessionInformation;
        this.holdTime = holdTime;
        this.BGPIdentifier = BGPIdentifier;
        this.version = version;
        this.myAutonomousSystem = myAutonomousSystem;
        this.peer = peer;
        this.ud = ud;
        this.localBGP4Address = my_IPAddress;
        this.localBGP4Port = my_bgp4Port;
        this.keepAliveTimer = my_keepAliveTimer;
        this.peerIP = peer.getPeerIP();
        this.setSendTo(peer.isSendToPeer());
        this.setUpdateFrom(peer.isUpdateFromPeer());
    }

    @Override
    public void run() {
        if (this.bgp4SessionClient != null) {
            if (this.bgp4SessionClient.isAlive()) {
                if (this.bgp4SessionClient.isInterrupted()) {
                    this.log.debug("Thread alive... backup session dead");
                }
                this.log.debug("Session alive and not interrupted");
                return;
            }
            try {
                this.bgp4SessionInformation.notifySessionStart(this.peerIP);
                this.log.debug("Session with BGP-LS peer" + this.peer + " dead, trying to establish new session");
                this.bgp4SessionClient = new BGP4SessionClient(this.bgp4SessionInformation, this.ud, this.peer.getPeerIP(), this.peer.getPeerPort(), this.holdTime, this.BGPIdentifier, this.version, this.myAutonomousSystem, this.localBGP4Address, this.localBGP4Port, this.keepAliveTimer);
                this.bgp4SessionClient.setSendTo(this.sendTo);
                this.bgp4SessionClient.setUpdateFrom(this.updateFrom);
                this.bgp4SessionClient.start();
            }
            catch (BGP4SessionExistsException e) {
                this.log.debug("Checked that there is already a peer initiated session with " + this.peerIP);
            }
            return;
        }
        try {
            this.bgp4SessionInformation.notifySessionStart(this.peerIP);
            this.log.info("Trying to establish new session with peer " + this.peer.getPeerIP() + " on port " + this.peer.getPeerPort());
            this.bgp4SessionClient = new BGP4SessionClient(this.bgp4SessionInformation, this.ud, this.peer.getPeerIP(), this.peer.getPeerPort(), this.holdTime, this.BGPIdentifier, this.version, this.myAutonomousSystem, this.localBGP4Address, this.localBGP4Port, this.keepAliveTimer);
            this.bgp4SessionClient.setSendTo(this.sendTo);
            this.bgp4SessionClient.setUpdateFrom(this.updateFrom);
            this.bgp4SessionClient.start();
        }
        catch (BGP4SessionExistsException e) {
            this.log.debug("No need to start new connection with " + this.peerIP);
        }
    }

    public BGP4SessionClient getBgp4SessionClient() {
        return this.bgp4SessionClient;
    }

    public void setBgp4SessionClient(BGP4SessionClient bgp4SessionClient) {
        this.bgp4SessionClient = bgp4SessionClient;
    }

    public void killBGP4Session() {
        this.bgp4SessionClient.killSession();
    }

    public void closeBGP4Session() {
        this.log.info("Closing BGP4Session");
        if (this.bgp4SessionClient.isAlive()) {
            this.bgp4SessionClient.close();
        }
    }

    public Boolean getUpdateFrom() {
        return this.updateFrom;
    }

    public void setUpdateFrom(Boolean updateFrom) {
        this.updateFrom = updateFrom;
    }

    public Boolean getSendTo() {
        return this.sendTo;
    }

    public void setSendTo(Boolean sendTo) {
        this.sendTo = sendTo;
    }
}

