/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.peer;

import eu.teraflow.tid.bgp4Peer.peer.BGP4LSPeerInfo;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BGP4Parameters {
    private Logger log = LoggerFactory.getLogger((String)"BGP4Peer");
    private int BGP4Port = 179;
    private int BGP4ManagementPort = 1112;
    private String localBGPAddress = "127.0.0.1";
    private int localBGPPort = 0;
    private String BGP4LogFile = "BGP4Parser.log";
    private String BGP4LogFileClient = "BGP4Client.log";
    private String BGP4LogFileServer = "BGP4Server.log";
    private String confFile;
    private boolean nodelay = false;
    long delay = 6000L;
    private LinkedList<BGP4LSPeerInfo> peersToConnect;
    private boolean setTraces = true;
    int holdTime = 90;
    private boolean isTest = false;
    int keepAliveTimer = 30;
    long sendTopoDelay = 30000L;
    private boolean saveTopologyDB = false;
    private Inet4Address topologyDBIP;
    private int topologyDBport;
    String BGPIdentifier = null;
    int myAutonomousSystem = 1;
    int version = 4;
    private String learnTopology = "fromBGP";
    private String topologyFile;
    private int numberTriesToConnect = 3;
    private boolean sendTopology = false;
    private boolean sendIntradomainLinks = false;
    private int instanceID = 0;

    public int getKeepAliveTimer() {
        return this.keepAliveTimer;
    }

    public void setKeepAliveTimer(int keepAliveTimer) {
        this.keepAliveTimer = keepAliveTimer;
    }

    BGP4Parameters() {
        this.confFile = "BGP4Parameters.xml";
        this.peersToConnect = new LinkedList();
    }

    BGP4Parameters(String confFile) {
        this.peersToConnect = new LinkedList();
        if (confFile != null) {
            this.confFile = confFile;
        } else {
            confFile = "BGP4Parameters.xml";
        }
    }

    public void initialize() {
        try {
            System.out.println("Parsing Config File::" + this.confFile);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                boolean peer = false;
                boolean send = false;
                boolean receive = false;
                boolean peerPort = false;
                BGP4LSPeerInfo peerInfo = null;
                String tempVal;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("configPeer")) {
                        BGP4Parameters.this.log.debug("Found peer configuration");
                    } else if (qName.equalsIgnoreCase("peer")) {
                        this.peer = true;
                    } else if (qName.equalsIgnoreCase("export")) {
                        this.send = true;
                    } else if (qName.equalsIgnoreCase("import")) {
                        this.receive = true;
                    } else if (qName.equalsIgnoreCase("peerPort")) {
                        this.peerPort = true;
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equalsIgnoreCase("BGP4Port")) {
                        BGP4Parameters.this.BGP4Port = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("BGP4ManagementPort")) {
                        BGP4Parameters.this.BGP4ManagementPort = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("BGP4LogFile")) {
                        BGP4Parameters.this.BGP4LogFile = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("BGP4LogFileClient")) {
                        BGP4Parameters.this.BGP4LogFileClient = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("BGP4LogFileServer")) {
                        BGP4Parameters.this.BGP4LogFileServer = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("nodelay")) {
                        BGP4Parameters.this.nodelay = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("isTest")) {
                        BGP4Parameters.this.isTest = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("setTraces")) {
                        BGP4Parameters.this.setTraces = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("saveTopologyDB")) {
                        BGP4Parameters.this.saveTopologyDB = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("topologyDBIP")) {
                        try {
                            BGP4Parameters.this.topologyDBIP = (Inet4Address)Inet4Address.getByName(this.tempVal.trim());
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                        }
                    } else if (qName.equalsIgnoreCase("topologyDBport")) {
                        BGP4Parameters.this.topologyDBport = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("sendTopology")) {
                        BGP4Parameters.this.sendTopology = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("sendIntradomainLinks")) {
                        BGP4Parameters.this.sendIntradomainLinks = Boolean.parseBoolean(this.tempVal.trim());
                        BGP4Parameters.this.sendTopology = true;
                    } else if (qName.equalsIgnoreCase("holdTime")) {
                        BGP4Parameters.this.holdTime = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("keepAliveTimer")) {
                        BGP4Parameters.this.keepAliveTimer = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("version")) {
                        BGP4Parameters.this.version = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("myAutonomousSystem")) {
                        BGP4Parameters.this.myAutonomousSystem = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("localBGPAddress")) {
                        BGP4Parameters.this.localBGPAddress = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("BGPIdentifier")) {
                        BGP4Parameters.this.BGPIdentifier = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("delay")) {
                        BGP4Parameters.this.delay = Long.parseLong(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("sendTopoDelay")) {
                        BGP4Parameters.this.sendTopoDelay = Long.parseLong(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("TopologyFile")) {
                        BGP4Parameters.this.topologyFile = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("learnTopology")) {
                        BGP4Parameters.this.learnTopology = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("numberTriesToConnect")) {
                        BGP4Parameters.this.numberTriesToConnect = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("instanceID")) {
                        BGP4Parameters.this.instanceID = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("localBGPPort")) {
                        BGP4Parameters.this.localBGPPort = Integer.parseInt(this.tempVal.trim());
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.tempVal = new String(ch, start, length);
                    if (this.peer) {
                        this.peerInfo = new BGP4LSPeerInfo();
                        String peerBGP_IPaddress = new String(ch, start, length);
                        try {
                            Inet4Address peerBGPIP = (Inet4Address)Inet4Address.getByName(peerBGP_IPaddress.trim());
                            this.peerInfo.setPeerIP(peerBGPIP);
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                        }
                        BGP4Parameters.this.peersToConnect.add(this.peerInfo);
                        this.peer = false;
                    } else if (this.send) {
                        String sendInfo = new String(ch, start, length);
                        this.peerInfo.setSendToPeer(Boolean.parseBoolean(sendInfo.trim()));
                        this.send = false;
                    } else if (this.receive) {
                        String update_from = new String(ch, start, length);
                        this.peerInfo.setUpdateFromPeer(Boolean.parseBoolean(update_from.trim()));
                        this.receive = false;
                    } else if (this.peerPort) {
                        String peer_port = new String(ch, start, length);
                        this.peerInfo.setPeerPort(Integer.parseInt(peer_port.trim()));
                        this.peerPort = false;
                    }
                }
            };
            saxParser.parse(this.confFile, handler);
        }
        catch (Exception e) {
            this.log.error("Problems reading config");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public int getBGP4Port() {
        return this.BGP4Port;
    }

    public void setBGP4Port(int bGP4Port) {
        this.BGP4Port = bGP4Port;
    }

    public int getBGP4ManagementPort() {
        return this.BGP4ManagementPort;
    }

    public void setBGP4ManagementPort(int bGP4ManagementPort) {
        this.BGP4ManagementPort = bGP4ManagementPort;
    }

    public String getBGP4LogFile() {
        return this.BGP4LogFile;
    }

    public void setBGP4LogFile(String bGP4LogFile) {
        this.BGP4LogFile = bGP4LogFile;
    }

    public boolean isSetTraces() {
        return this.setTraces;
    }

    public void setSetTraces(boolean setTraces) {
        this.setTraces = setTraces;
    }

    public boolean isTest() {
        return this.isTest;
    }

    public void setisTest(boolean test) {
        this.isTest = test;
    }

    public String getConfFile() {
        return this.confFile;
    }

    public void setConfFile(String confFile) {
        this.confFile = confFile;
    }

    public boolean isNodelay() {
        return this.nodelay;
    }

    public void setNodelay(boolean nodelay) {
        this.nodelay = nodelay;
    }

    public int getHoldTime() {
        return this.holdTime;
    }

    public void setHoldTime(int holdTime) {
        this.holdTime = holdTime;
    }

    public String getBGPIdentifier() {
        return this.BGPIdentifier;
    }

    public void setBGPIdentifier(String bGPIdentifier) {
        this.BGPIdentifier = bGPIdentifier;
    }

    public int getMyAutonomousSystem() {
        return this.myAutonomousSystem;
    }

    public void setMyAutonomousSystem(int myAutonomousSystem) {
        this.myAutonomousSystem = myAutonomousSystem;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public LinkedList<BGP4LSPeerInfo> getPeersToConnect() {
        return this.peersToConnect;
    }

    public void setPeersToConnect(LinkedList<BGP4LSPeerInfo> peersToConnect) {
        this.peersToConnect = peersToConnect;
    }

    public String getLearnTopology() {
        return this.learnTopology;
    }

    public void setLearnTopology(String learnTopology) {
        this.learnTopology = learnTopology;
    }

    public String getTopologyFile() {
        return this.topologyFile;
    }

    public void setTopologyFile(String topologyFile) {
        this.topologyFile = topologyFile;
    }

    public int getNumberTriesToConnect() {
        return this.numberTriesToConnect;
    }

    public void setNumberTriesToConnect(int numberTriesToConnect) {
        this.numberTriesToConnect = numberTriesToConnect;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public boolean isSendTopology() {
        return this.sendTopology;
    }

    public void setSendTopology(boolean sendTopology) {
        this.sendTopology = sendTopology;
    }

    public String getBGP4LogFileClient() {
        return this.BGP4LogFileClient;
    }

    public void setBGP4LogFileClient(String bGP4LogFileClient) {
        this.BGP4LogFileClient = bGP4LogFileClient;
    }

    public String getBGP4LogFileServer() {
        return this.BGP4LogFileServer;
    }

    public void setBGP4LogFileServer(String bGP4LogFileServer) {
        this.BGP4LogFileServer = bGP4LogFileServer;
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    public void setInstanceID(int instanceID) {
        this.instanceID = instanceID;
    }

    public boolean isSendIntradomainLinks() {
        return this.sendIntradomainLinks;
    }

    public void setSendIntradomainLinks(boolean sendIntradomainLinks) {
        this.sendIntradomainLinks = sendIntradomainLinks;
    }

    public String getLocalBGPAddress() {
        return this.localBGPAddress;
    }

    public void setLocalBGPAddress(String localBGPAddress) {
        this.localBGPAddress = localBGPAddress;
    }

    public int getLocalBGPPort() {
        return this.localBGPPort;
    }

    public long getSendTopoDelay() {
        return this.sendTopoDelay;
    }

    public void setSendTopoDelay(long sendTopoDelay) {
        this.sendTopoDelay = sendTopoDelay;
    }

    public boolean isSaveTopologyDB() {
        return this.saveTopologyDB;
    }

    public void setSaveTopologyDB(boolean saveTopologyDB) {
        this.saveTopologyDB = saveTopologyDB;
    }

    public Inet4Address getTopologyDBIP() {
        return this.topologyDBIP;
    }

    public void setTopologyDBIP(Inet4Address topologyDBIP) {
        this.topologyDBIP = topologyDBIP;
    }

    public int getTopologyDBport() {
        return this.topologyDBport;
    }

    public void setTopologyDBport(int topologyDBport) {
        this.topologyDBport = topologyDBport;
    }
}

