/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.models;

import eu.teraflow.tid.bgp4Peer.models.LinkNLRIMsg;
import eu.teraflow.tid.bgp4Peer.models.NodeNLRIMsg;
import eu.teraflow.tid.bgp4Peer.models.PathAttributeMsg;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UpdateMsgList {
    List<NodeNLRIMsg> nodeList = new LinkedList<NodeNLRIMsg>();
    List<LinkNLRIMsg> linkList = new LinkedList<LinkNLRIMsg>();
    List<PathAttributeMsg> pathList = new LinkedList<PathAttributeMsg>();

    public String toString() {
        String out = "Update Message: ";
        if (this.nodeList != null) {
            out = String.valueOf(out) + this.nodeList.toString() + "\n";
        }
        if (this.linkList != null) {
            out = String.valueOf(out) + this.linkList.toString() + "\n";
        }
        if (this.pathList != null) {
            out = String.valueOf(out) + this.pathList.toString() + "\n";
        }
        return out;
    }

    public void addLinkToJson(LinkNLRIMsg link) {
        if (link == null) {
            return;
        }
        boolean exists = false;
        for (LinkNLRIMsg linkInList : this.linkList) {
            if (!link.equals(linkInList)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.linkList.add(link);
        }
    }

    public void addNodeToJson(NodeNLRIMsg node, String currentName) {
        if (node == null) {
            return;
        }
        boolean exists = false;
        for (NodeNLRIMsg nodeInList : this.nodeList) {
            if (!node.equals(nodeInList)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.nodeList.add(node);
        }
    }

    public void addpathToJson(PathAttributeMsg path) {
        boolean exists = false;
        if (path.getNodeName() == null) {
            return;
        }
        for (PathAttributeMsg pathInList : this.pathList) {
            if (!path.equals(pathInList)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.pathList.add(path);
        }
    }

    public List<NodeNLRIMsg> getNodeList() {
        return this.nodeList;
    }

    public List<LinkNLRIMsg> getLinkList() {
        return this.linkList;
    }

    public List<PathAttributeMsg> getPathList() {
        return this.pathList;
    }

    public void addNodeToList(NodeNLRIMsg node) {
        this.nodeList.add(node);
    }

    public void addLinkToList(LinkNLRIMsg link) {
        this.linkList.add(link);
    }

    public void addPathToList(PathAttributeMsg path) {
        this.pathList.add(path);
    }

    public UpdateMsgList id2Name() {
        UpdateMsgList update = new UpdateMsgList();
        update.nodeList = this.nodeList;
        update.pathList = this.pathList;
        LinkedList<LinkNLRIMsg> newLinkList = new LinkedList<LinkNLRIMsg>();
        Iterator<LinkNLRIMsg> iterator = this.linkList.iterator();
        while (iterator.hasNext()) {
            LinkNLRIMsg linkInList;
            LinkNLRIMsg link = linkInList = iterator.next();
            for (NodeNLRIMsg nodeInList : update.nodeList) {
                if (!linkInList.getLocalBgplsID().equals(nodeInList.getLocalBgplsID())) continue;
                link.setLocalBgplsID(nodeInList.getNodeName());
            }
            for (NodeNLRIMsg nodeInList : update.nodeList) {
                if (!linkInList.getRemoteBgplsID().equals(nodeInList.getLocalBgplsID())) continue;
                link.setRemoteBgplsID(nodeInList.getNodeName());
            }
            newLinkList.add(link);
        }
        update.linkList = newLinkList;
        return update;
    }
}

