/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.models;

import es.tid.bgp.bgp4.update.fields.pathAttributes.LinkStateAttribute;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.NodeNameNodeAttribTLV;
import java.net.Inet4Address;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PathAttributeMsg {
    private NodeNameNodeAttribTLV nodeNameTLV;
    private byte[] data;
    private String nodeName;
    private Inet4Address addrLocal;

    public PathAttributeMsg(LinkStateAttribute att) {
        if (att.getNodeNameTLV() != null) {
            this.nodeNameTLV = att.getNodeNameTLV();
            this.data = this.nodeNameTLV.getTlv_bytes();
            int b = this.nodeNameTLV.getTotalTLVLength();
            int c = this.nodeNameTLV.getTLVValueLength();
            byte[] fin = Arrays.copyOfRange(this.data, b - c, b);
            this.nodeName = new String(fin, StandardCharsets.UTF_8);
        }
        if (att.getIPv4RouterIDLocalNodeLATLV() != null) {
            this.addrLocal = att.getIPv4RouterIDLocalNodeLATLV().getIpv4Address();
        }
    }

    public String toString() {
        String out = "";
        if (this.nodeName != null) {
            out = String.valueOf(out) + "NODE name " + this.nodeName;
        }
        if (this.addrLocal != null) {
            out = String.valueOf(out) + "NODE IP " + this.addrLocal.toString();
        }
        return out;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.nodeName.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathAttributeMsg)) {
            return false;
        }
        PathAttributeMsg pathCk = (PathAttributeMsg)o;
        return pathCk.nodeName == this.nodeName;
    }

    public Inet4Address getAddrLocal() {
        return this.addrLocal;
    }
}

