/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.models;

import com.google.common.net.InetAddresses;
import es.tid.bgp.bgp4.update.fields.NodeNLRI;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.NodeDescriptorsSubTLV;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeNLRIMsg {
    private ArrayList<NodeDescriptorsSubTLV> nodeDescriptorsSubTLV;
    private Inet4Address localDomainID;
    private Inet4Address remoteDomainID;
    private Inet4Address areaID;
    private Inet4Address bgplsID;
    private Inet4Address LocalNodeBGPId;
    private Inet4Address iPv4RouterIDLocalNodeLATLV;
    private Inet4Address iPv4RouterIDNeighborNodeLATLV;
    private String localBgplsID;
    private int remoteBgplsID;
    private Inet4Address as_number;
    private int IGP_type;
    private Inet4Address IGPID = null;
    private Logger log = LoggerFactory.getLogger((String)"BGP4Server");
    private String nodeName;
    private String ISIS_ID_str;
    private String learntFrom;

    public NodeNLRIMsg(NodeNLRI nodeNLRI, String learntFrom, String nodeName) {
        this.learntFrom = learntFrom;
        if (nodeName != null) {
            this.nodeName = nodeName;
        }
        if (nodeNLRI.getLocalNodeDescriptors().getAutonomousSystemSubTLV() != null) {
            this.as_number = nodeNLRI.getLocalNodeDescriptors().getAutonomousSystemSubTLV().getAS_ID();
        }
        if (nodeNLRI.getLocalNodeDescriptors().getAreaID() != null) {
            this.areaID = nodeNLRI.getLocalNodeDescriptors().getAreaID().getAREA_ID();
        }
        if (nodeNLRI.getLocalNodeDescriptors().getBGPLSIDSubTLV() != null) {
            this.setBgplsID(nodeNLRI.getLocalNodeDescriptors().getBGPLSIDSubTLV().getBGPLS_ID());
        }
        if (nodeNLRI.getLocalNodeDescriptors().getIGPRouterID().getISIS_ISO_NODE_ID_str() != null) {
            this.ISIS_ID_str = nodeNLRI.getLocalNodeDescriptors().getIGPRouterID().getISIS_ISO_NODE_ID_str();
        }
        if (nodeNLRI.getLocalNodeDescriptors().getIGPRouterID() != null) {
            this.IGP_type = nodeNLRI.getLocalNodeDescriptors().getIGPRouterID().getIGP_router_id_type();
            switch (this.IGP_type) {
                case 3: {
                    this.IGPID = nodeNLRI.getLocalNodeDescriptors().getIGPRouterID().getIpv4AddressOSPF();
                    break;
                }
                default: {
                    this.log.info("a\u00f1adir este tipo de IGP Identifier por implementar ");
                }
            }
        }
        if (nodeNLRI.getLocalNodeDescriptors().getIGPRouterID().getISIS_ISO_NODE_ID() != 0) {
            this.localBgplsID = nodeNLRI.getLocalNodeDescriptors().getIGPRouterID().getISIS_ISO_NODE_ID_str();
        }
        if (nodeNLRI.getLocalNodeDescriptors().getBGPLSIDSubTLV() != null && nodeNLRI.getLocalNodeDescriptors().getBGPLSIDSubTLV().getBGPLS_ID() != null) {
            this.LocalNodeBGPId = nodeNLRI.getLocalNodeDescriptors().getBGPLSIDSubTLV().getBGPLS_ID();
        }
        this.log.info("End node processing");
    }

    public String toString() {
        String out = "";
        if (this.localBgplsID != null) {
            out = String.valueOf(out) + "ID: " + this.localBgplsID + " ";
        }
        if (this.iPv4RouterIDLocalNodeLATLV != null) {
            out = String.valueOf(out) + this.iPv4RouterIDLocalNodeLATLV.toString();
        }
        if (this.iPv4RouterIDNeighborNodeLATLV != null) {
            out = String.valueOf(out) + "---->" + this.iPv4RouterIDNeighborNodeLATLV.toString();
        }
        if (this.LocalNodeBGPId != null) {
            out = String.valueOf(out) + "BGP_ID: " + this.LocalNodeBGPId + " ";
        }
        if (this.as_number != null) {
            out = String.valueOf(out) + "AS_number: " + InetAddresses.coerceToInteger((InetAddress)this.as_number) + " ";
        }
        if (this.nodeName != null) {
            out = String.valueOf(out) + "Name node attribute: " + this.nodeName + " ";
        }
        if (this.ISIS_ID_str != null) {
            out = String.valueOf(out) + "ID node: " + this.ISIS_ID_str + " ";
        }
        if (this.as_number != null) {
            out = String.valueOf(out) + "AS number: " + this.as_number.toString() + " ";
        }
        return out;
    }

    public String getLearntFrom() {
        return this.learntFrom;
    }

    public void setLearntFrom(String learntFrom) {
        this.learntFrom = learntFrom;
    }

    public String getLocalBgplsID() {
        return this.localBgplsID;
    }

    public void setLocalBgplsID(String localBgplsID) {
        this.localBgplsID = localBgplsID;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Inet4Address getIGPID() {
        return this.IGPID;
    }

    public Inet4Address getBgplsID() {
        return this.bgplsID;
    }

    public void setBgplsID(Inet4Address bgplsID) {
        this.bgplsID = bgplsID;
    }

    public Inet4Address getAs_number() {
        return this.as_number;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.localBgplsID.hashCode();
        result = 31 * result + this.iPv4RouterIDLocalNodeLATLV.hashCode();
        result = 31 * result + this.iPv4RouterIDNeighborNodeLATLV.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeNLRIMsg)) {
            return false;
        }
        NodeNLRIMsg nodeCk = (NodeNLRIMsg)o;
        return nodeCk.localBgplsID == this.localBgplsID && nodeCk.iPv4RouterIDLocalNodeLATLV == this.iPv4RouterIDLocalNodeLATLV && nodeCk.localBgplsID == this.localBgplsID && nodeCk.iPv4RouterIDLocalNodeLATLV == this.iPv4RouterIDLocalNodeLATLV;
    }
}

