/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.models;

import es.tid.bgp.bgp4.update.fields.LinkNLRI;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.NodeDescriptorsSubTLV;
import java.net.Inet4Address;
import java.util.ArrayList;

public class LinkNLRIMsg {
    private ArrayList<NodeDescriptorsSubTLV> nodeDescriptorsSubTLV;
    private Inet4Address localDomainID;
    private Inet4Address remoteDomainID;
    private Inet4Address areaID;
    private Inet4Address bgplsID;
    private Inet4Address LocalNodeIGPId;
    private Inet4Address RemoteNodeIGPId;
    private int linkDelay;
    private int linkDelayVar;
    private int minDelay;
    private int maxDelay;
    private int linkLoss;
    private int residualBw;
    private int availableBw;
    private int utilizedBw;
    private Inet4Address iPv4RouterIDLocalNodeLATLV;
    private Inet4Address iPv4RouterIDNeighborNodeLATLV;
    private String localBgplsID;
    private String remoteBgplsID;
    private String learntFrom;

    public LinkNLRIMsg(LinkNLRI linkNLRI, String learntFrom) {
        this.learntFrom = learntFrom;
        if (linkNLRI.getLocalNodeDescriptors().getAutonomousSystemSubTLV() != null) {
            this.localDomainID = linkNLRI.getLocalNodeDescriptors().getAutonomousSystemSubTLV().getAS_ID();
        }
        if (linkNLRI.getLocalNodeDescriptors().getAreaID() != null) {
            this.areaID = linkNLRI.getLocalNodeDescriptors().getAreaID().getAREA_ID();
        }
        if (linkNLRI.getLocalNodeDescriptors().getBGPLSIDSubTLV() != null) {
            this.bgplsID = linkNLRI.getLocalNodeDescriptors().getBGPLSIDSubTLV().getBGPLS_ID();
        }
        if (linkNLRI.getLocalNodeDescriptors().getIGPRouterID() != null) {
            this.LocalNodeIGPId = linkNLRI.getLocalNodeDescriptors().getIGPRouterID().getIpv4AddressOSPF();
        }
        if (linkNLRI.getRemoteNodeDescriptorsTLV().getAutonomousSystemSubTLV() != null) {
            this.remoteDomainID = linkNLRI.getRemoteNodeDescriptorsTLV().getAutonomousSystemSubTLV().getAS_ID();
        }
        if (linkNLRI.getRemoteNodeDescriptorsTLV().getAreaID() != null) {
            this.areaID = linkNLRI.getRemoteNodeDescriptorsTLV().getAreaID().getAREA_ID();
        }
        if (linkNLRI.getRemoteNodeDescriptorsTLV().getBGPLSIDSubTLV() != null) {
            this.bgplsID = linkNLRI.getRemoteNodeDescriptorsTLV().getBGPLSIDSubTLV().getBGPLS_ID();
        }
        if (linkNLRI.getRemoteNodeDescriptorsTLV().getIGPRouterID() != null) {
            this.RemoteNodeIGPId = linkNLRI.getRemoteNodeDescriptorsTLV().getIGPRouterID().getIpv4AddressOSPF();
        }
        if (linkNLRI.getUndirectionalLinkDelayTLV() != null) {
            this.linkDelay = linkNLRI.getUndirectionalLinkDelayTLV().getDelay();
        }
        if (linkNLRI.getUndirectionalDelayVariationTLV() != null) {
            this.linkDelayVar = linkNLRI.getUndirectionalDelayVariationTLV().getDelayVar();
        }
        if (linkNLRI.getMinMaxUndirectionalLinkDelayTLV() != null) {
            this.maxDelay = linkNLRI.getMinMaxUndirectionalLinkDelayTLV().getHighDelay();
            this.minDelay = linkNLRI.getMinMaxUndirectionalLinkDelayTLV().getLowDelay();
        }
        if (linkNLRI.getUndirectionalLinkLossTLV() != null) {
            this.linkLoss = linkNLRI.getUndirectionalLinkLossTLV().getLinkLoss();
        }
        if (linkNLRI.getUndirectionalResidualBwTLV() != null) {
            this.residualBw = linkNLRI.getUndirectionalResidualBwTLV().getResidualBw();
        }
        if (linkNLRI.getUndirectionalAvailableBwTLV() != null) {
            this.availableBw = linkNLRI.getUndirectionalAvailableBwTLV().getAvailableBw();
        }
        if (linkNLRI.getUndirectionalUtilizedBwTLV() != null) {
            this.utilizedBw = linkNLRI.getUndirectionalUtilizedBwTLV().getUtilizedBw();
        }
        if (linkNLRI.getIpv4InterfaceAddressTLV() != null) {
            this.iPv4RouterIDLocalNodeLATLV = linkNLRI.getIpv4InterfaceAddressTLV().getIpv4Address();
        }
        if (linkNLRI.getIpv4NeighborAddressTLV() != null) {
            this.iPv4RouterIDNeighborNodeLATLV = linkNLRI.getIpv4NeighborAddressTLV().getIpv4Address();
        }
        if (linkNLRI.getLocalNodeDescriptors().getIGPRouterID().getISIS_ISO_NODE_ID() != 0) {
            this.localBgplsID = linkNLRI.getLocalNodeDescriptors().getIGPRouterID().getISIS_ISO_NODE_ID_str();
        }
        if (linkNLRI.getRemoteNodeDescriptorsTLV().getIGPRouterID().getISIS_ISO_NODE_ID() != 0) {
            this.remoteBgplsID = linkNLRI.getRemoteNodeDescriptorsTLV().getIGPRouterID().getISIS_ISO_NODE_ID_str();
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.localBgplsID.hashCode();
        result = 31 * result + this.iPv4RouterIDLocalNodeLATLV.hashCode();
        result = 31 * result + this.iPv4RouterIDNeighborNodeLATLV.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkNLRIMsg)) {
            return false;
        }
        LinkNLRIMsg linkCk = (LinkNLRIMsg)o;
        return linkCk.localBgplsID == this.localBgplsID && linkCk.iPv4RouterIDLocalNodeLATLV == this.iPv4RouterIDLocalNodeLATLV && linkCk.localBgplsID == this.localBgplsID && linkCk.iPv4RouterIDLocalNodeLATLV == this.iPv4RouterIDLocalNodeLATLV;
    }

    public String toString() {
        String out = "";
        if (this.localBgplsID != null) {
            out = String.valueOf(out) + "ID: " + this.localBgplsID + " ";
        }
        if (this.iPv4RouterIDLocalNodeLATLV != null) {
            out = String.valueOf(out) + this.iPv4RouterIDLocalNodeLATLV.toString();
        }
        if (this.iPv4RouterIDNeighborNodeLATLV != null) {
            out = String.valueOf(out) + "---->" + this.iPv4RouterIDNeighborNodeLATLV.toString();
        }
        if (this.remoteBgplsID != null) {
            out = String.valueOf(out) + "ID: " + this.remoteBgplsID + " ";
        }
        if (this.localDomainID != null) {
            out = String.valueOf(out) + "\n AS_ID local: " + this.localDomainID.toString() + " ";
        }
        if (this.remoteDomainID != null) {
            out = String.valueOf(out) + "\n AS_ID remote: " + this.remoteDomainID.toString() + " ";
        }
        if (this.availableBw != 0) {
            out = String.valueOf(out) + "\n availableBW: " + this.availableBw + " ";
        }
        if (this.residualBw != 0) {
            out = String.valueOf(out) + "\n residualBw: " + this.residualBw + " ";
        }
        if (this.linkDelay != 0) {
            out = String.valueOf(out) + "\n linkDelay: " + this.linkDelay + " ";
        }
        return out;
    }

    public String getLearntFrom() {
        return this.learntFrom;
    }

    public void setLearntFrom(String learntFrom) {
        this.learntFrom = learntFrom;
    }

    public String getiPv4RouterIDLocalNodeLATLV() {
        if (this.iPv4RouterIDLocalNodeLATLV != null) {
            return this.iPv4RouterIDLocalNodeLATLV.toString();
        }
        return null;
    }

    public void setiPv4RouterIDLocalNodeLATLV(Inet4Address iPv4RouterIDLocalNodeLATLV) {
        this.iPv4RouterIDLocalNodeLATLV = iPv4RouterIDLocalNodeLATLV;
    }

    public String getiPv4RouterIDNeighborNodeLATLV() {
        if (this.iPv4RouterIDNeighborNodeLATLV != null) {
            return this.iPv4RouterIDNeighborNodeLATLV.toString();
        }
        return null;
    }

    public void setiPv4RouterIDNeighborNodeLATLV(Inet4Address iPv4RouterIDNeighborNodeLATLV) {
        this.iPv4RouterIDNeighborNodeLATLV = iPv4RouterIDNeighborNodeLATLV;
    }

    public Inet4Address getLocalDomainID() {
        return this.localDomainID;
    }

    public Inet4Address getRemoteDomainID() {
        return this.remoteDomainID;
    }

    public String getLocalBgplsID() {
        return this.localBgplsID;
    }

    public void setLocalBgplsID(String localBgplsID) {
        this.localBgplsID = localBgplsID;
    }

    public String getRemoteBgplsID() {
        return this.remoteBgplsID;
    }

    public void setRemoteBgplsID(String remoteBgplsID) {
        this.remoteBgplsID = remoteBgplsID;
    }

    public Inet4Address getLocalNodeIGPId() {
        return this.LocalNodeIGPId;
    }

    public Inet4Address getRemoteNodeIGPId() {
        return this.RemoteNodeIGPId;
    }

    public int getLinkDelay() {
        return this.linkDelay;
    }

    public int getLinkDelayVar() {
        return this.linkDelayVar;
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public int getResidualBw() {
        return this.residualBw;
    }

    public int getAvailableBw() {
        return this.availableBw;
    }

    public int getUtilizedBw() {
        return this.utilizedBw;
    }
}

