/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.management;

import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionsInformation;
import eu.teraflow.tid.bgp4Peer.peer.SendTopology;
import eu.teraflow.tid.tedb.DomainTEDB;
import eu.teraflow.tid.tedb.MultiDomainTEDB;
import eu.teraflow.tid.tedb.TEDB;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BGP4ManagementSession
extends Thread {
    private Socket socket;
    private Logger log;
    private PrintStream out;
    private MultiDomainTEDB multiTEDB;
    private Hashtable<String, TEDB> intraTEDBs;
    private BGP4SessionsInformation bgp4SessionsInformation;
    private SendTopology sendTopology;

    public BGP4ManagementSession(Socket s, MultiDomainTEDB multiTEDB, Hashtable<String, TEDB> intraTEDBs, BGP4SessionsInformation bgp4SessionsInformation, SendTopology sendTopology) {
        this.socket = s;
        this.log = LoggerFactory.getLogger((String)"BGP4Server");
        this.multiTEDB = multiTEDB;
        this.intraTEDBs = intraTEDBs;
        this.bgp4SessionsInformation = bgp4SessionsInformation;
        this.sendTopology = sendTopology;
    }

    @Override
    public void run() {
        this.log.info("Starting Management session");
        boolean running = true;
        try {
            this.out = new PrintStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.log.warn("Management session cancelled: " + e.getMessage());
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            while (running) {
                Logger log3;
                Logger log2;
                this.out.print("Available commands:\r\n");
                this.out.print(" > show topology\r\n");
                this.out.print(" > show sessions\r\n");
                this.out.print(" > set traces on\r\n");
                this.out.print(" > set traces off\r\n");
                this.out.print(" > send topology on\r\n");
                this.out.print(" > send topology off\r\n");
                this.out.print(" > quit\r\n");
                String command = null;
                try {
                    command = br.readLine();
                }
                catch (IOException ioe) {
                    this.log.warn("IO error trying to read your command");
                    return;
                }
                if (command.equals("quit")) {
                    this.log.info("Ending Management Session");
                    this.out.println("bye!");
                    try {
                        this.out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (command.equals("show sessions")) {
                    this.out.print(this.bgp4SessionsInformation.toString());
                    continue;
                }
                if (command.equals("show topology")) {
                    if (this.multiTEDB != null) {
                        this.out.println(this.multiTEDB.printTopology());
                    }
                    Enumeration<String> domainTedbs = this.intraTEDBs.keys();
                    while (domainTedbs.hasMoreElements()) {
                        String domainID = domainTedbs.nextElement();
                        TEDB ted = this.intraTEDBs.get(domainID);
                        if (!(ted instanceof DomainTEDB)) continue;
                        this.out.println("Intradomain TEDB with ID " + domainID);
                        this.out.println(ted.printTopology());
                    }
                    continue;
                }
                if (command.equals("set traces on")) {
                    log2 = LoggerFactory.getLogger((String)"BGP4Parser");
                    log3 = LoggerFactory.getLogger((String)"BGP4Client");
                    this.out.print("traces on!\r\n");
                    continue;
                }
                if (command.equals("set traces off")) {
                    log2 = LoggerFactory.getLogger((String)"BGP4Parser");
                    log3 = LoggerFactory.getLogger((String)"BGP4Client");
                    this.out.print("traces off!\r\n");
                    continue;
                }
                if (command.equals("send topology on")) {
                    this.sendTopology.setSendTopology(true);
                    continue;
                }
                if (command.equals("send topology off")) {
                    this.sendTopology.setSendTopology(false);
                    continue;
                }
                this.out.print("invalid command\n");
                this.out.print("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

