/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.grpc;

import com.google.common.net.InetAddresses;
import eu.teraflow.tid.bgp4Peer.models.LinkNLRIMsg;
import eu.teraflow.tid.bgp4Peer.models.NodeNLRIMsg;
import eu.teraflow.tid.bgp4Peer.models.UpdateMsg;
import eu.teraflow.tid.bgp4Peer.models.UpdateMsgList;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import src.main.proto.GrpcService;
import src.main.proto.updateServiceGrpc;

public class grpcClient {
    private static Logger log;

    public static void sendGrpcUpdateMsg(UpdateMsg update) {
        log = LoggerFactory.getLogger((String)"BGP4Server");
        final ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"localhost:2021").usePlaintext().build();
        updateServiceGrpc.updateServiceStub stub = updateServiceGrpc.newStub((Channel)channel);
        if (update.getNode() == null && update.getLink() == null) {
            log.info("Case : Prefix_v4_NLRI or IT_Node_NLRI");
            return;
        }
        GrpcService.updateRequest request = null;
        GrpcService.nodeInfo n = null;
        GrpcService.linkInfo l = null;
        String nodeName = "-";
        String bgplsID = "-";
        if (update.getNode() != null) {
            if (update.getNode().getLocalBgplsID() == null) {
                log.info("Node empty----NOT SENDING");
                return;
            }
            if (update.getNode().getNodeName() != null) {
                nodeName = update.getNode().getNodeName();
            }
            if (update.getNode().getBgplsID() != null) {
                bgplsID = update.getNode().getBgplsID().toString();
            }
            n = GrpcService.nodeInfo.newBuilder().setNodeName(nodeName).setIgpID(update.getNode().getLocalBgplsID()).setBgplsID(bgplsID).setAsID(InetAddresses.coerceToInteger((InetAddress)update.getNode().getAs_number())).setLearntFrom(update.getNode().getLearntFrom()).buildPartial();
        }
        if (update.getLink() != null) {
            if (update.getLink().getLocalBgplsID() == null) {
                log.info("Link empty----NOT SENDING");
                return;
            }
            LinkNLRIMsg link = update.getLink();
            String strIgpR = link.getRemoteNodeIGPId() == null ? "-" : link.getRemoteNodeIGPId().toString();
            String strIgpL = link.getLocalNodeIGPId() == null ? "-" : link.getLocalNodeIGPId().toString();
            String ipv4R = link.getiPv4RouterIDNeighborNodeLATLV() == null ? "-" : link.getiPv4RouterIDNeighborNodeLATLV();
            String ipv4L = link.getiPv4RouterIDLocalNodeLATLV() == null ? "-" : link.getiPv4RouterIDLocalNodeLATLV();
            l = GrpcService.linkInfo.newBuilder().setLocalID(strIgpR).setLocalIPv4ID(ipv4L).setRemoteID(strIgpL).setRemoteIPv4ID(ipv4R).setLocal(GrpcService.NodeDescriptors.newBuilder().setAsNumber(link.getLocalDomainID().toString()).setBgplsID(link.getLocalBgplsID())).setRemote(GrpcService.NodeDescriptors.newBuilder().setAsNumber(link.getRemoteDomainID().toString()).setBgplsID(link.getRemoteBgplsID())).setAvailableBw(link.getAvailableBw()).setResidualBw(link.getResidualBw()).setUtilized(link.getUtilizedBw()).setMinLinkDelay(link.getMinDelay()).setMaxLinkDelay(link.getMaxDelay()).setDelayVariation(link.getLinkDelayVar()).setDelay(link.getLinkDelay()).setTEDefaultMetric(1).setAdjacencySid("0").setLearntFrom(link.getLearntFrom()).buildPartial();
        }
        request = n == null && l != null ? GrpcService.updateRequest.newBuilder().setNextHop(update.getNextHop().toString()).setAddressFamilyID(Integer.toString(update.getAFI())).setAsPathSegment(Integer.toString(update.getAsPathSegment())).addLink(l).build() : (l == null && n != null ? GrpcService.updateRequest.newBuilder().setNextHop(update.getNextHop().toString()).setAddressFamilyID(Integer.toString(update.getAFI())).setAsPathSegment(Integer.toString(update.getAsPathSegment())).addNode(n).build() : GrpcService.updateRequest.newBuilder().setNextHop("-" + update.getNextHop().toString()).setAddressFamilyID(Integer.toString(update.getAFI())).setAsPathSegment(Integer.toString(update.getAsPathSegment())).addNode(n).addLink(l).build());
        stub.update(request, new StreamObserver<GrpcService.updateResponse>(){

            public void onNext(GrpcService.updateResponse response) {
                System.out.println("respuesta del server: " + response);
            }

            public void onError(Throwable t) {
                System.out.println("error: " + t.getMessage());
            }

            public void onCompleted() {
                System.out.println("channel shutdown");
                channel.shutdownNow();
            }
        });
    }

    public static void sendGrpc(UpdateMsgList update) {
        final ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"localhost:2021").usePlaintext().build();
        updateServiceGrpc.updateServiceStub stub = updateServiceGrpc.newStub((Channel)channel);
        if (update.getNodeList().isEmpty() && update.getLinkList().isEmpty()) {
            return;
        }
        GrpcService.updateRequest request = null;
        GrpcService.nodeInfo n = null;
        GrpcService.linkInfo l = null;
        if (!update.getNodeList().isEmpty()) {
            for (NodeNLRIMsg node : update.getNodeList()) {
                n = GrpcService.nodeInfo.newBuilder().setNodeName(node.getNodeName()).setIgpID(node.getLocalBgplsID()).setBgplsID(node.getBgplsID().toString()).setAsID(InetAddresses.coerceToInteger((InetAddress)node.getAs_number())).buildPartial();
            }
        }
        if (!update.getLinkList().isEmpty()) {
            for (LinkNLRIMsg link : update.getLinkList()) {
                String strIPlocal = link.getiPv4RouterIDLocalNodeLATLV() == null ? "-" : link.getiPv4RouterIDLocalNodeLATLV();
                String strIPremote = link.getiPv4RouterIDNeighborNodeLATLV() == null ? "-" : link.getiPv4RouterIDNeighborNodeLATLV();
                String strIgpR = link.getRemoteNodeIGPId() == null ? "-" : link.getRemoteNodeIGPId().toString();
                String strIgpL = link.getLocalNodeIGPId() == null ? "-" : link.getLocalNodeIGPId().toString();
                String ipv4R = link.getiPv4RouterIDNeighborNodeLATLV() == null ? "-" : link.getiPv4RouterIDNeighborNodeLATLV();
                String ipv4L = link.getiPv4RouterIDLocalNodeLATLV() == null ? "-" : link.getiPv4RouterIDLocalNodeLATLV();
                l = GrpcService.linkInfo.newBuilder().setLocalID(strIgpR).setLocalIPv4ID(ipv4L).setRemoteID(strIgpL).setRemoteIPv4ID(ipv4R).setLocal(GrpcService.NodeDescriptors.newBuilder().setAsNumber(link.getLocalDomainID().toString()).setBgplsID(link.getLocalBgplsID())).setRemote(GrpcService.NodeDescriptors.newBuilder().setAsNumber(link.getRemoteDomainID().toString()).setBgplsID(link.getRemoteBgplsID())).setAvailableBw(link.getAvailableBw()).setResidualBw(link.getResidualBw()).setUtilized(link.getUtilizedBw()).setMinLinkDelay(link.getMinDelay()).setMaxLinkDelay(link.getMaxDelay()).setDelayVariation(link.getLinkDelayVar()).setDelay(link.getLinkDelay()).setTEDefaultMetric(1).setAdjacencySid("0").buildPartial();
            }
        }
        request = n == null ? GrpcService.updateRequest.newBuilder().addLink(l).build() : (l == null ? GrpcService.updateRequest.newBuilder().addNode(n).build() : GrpcService.updateRequest.newBuilder().addNode(n).addLink(l).build());
        stub.update(request, new StreamObserver<GrpcService.updateResponse>(){

            public void onNext(GrpcService.updateResponse response) {
                System.out.println("respuesta del server: " + response);
            }

            public void onError(Throwable t) {
                System.out.println("error: " + t.getMessage());
            }

            public void onCompleted() {
                System.out.println("channel shutdown");
                channel.shutdownNow();
            }
        });
    }

    public static void main(String[] args) throws Exception {
        final ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"localhost:50052").usePlaintext().build();
        updateServiceGrpc.updateServiceStub stub = updateServiceGrpc.newStub((Channel)channel);
        int a = 123;
        GrpcService.nodeInfo n = GrpcService.nodeInfo.newBuilder().setNodeName("router 3").setIgpID("1341234").buildPartial();
        GrpcService.updateRequest request = GrpcService.updateRequest.newBuilder().addNode(n).build();
        stub.update(request, new StreamObserver<GrpcService.updateResponse>(){

            public void onNext(GrpcService.updateResponse response) {
                System.out.println("respuesta del server: " + response);
            }

            public void onError(Throwable t) {
                System.out.println("error: " + t.getMessage());
            }

            public void onCompleted() {
                System.out.println("channel shutdown");
                channel.shutdownNow();
            }
        });
    }
}

