/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.bgp4session;

import es.tid.bgp.bgp4.messages.BGP4Keepalive;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveThread
extends Thread {
    private int keepAlive = 0;
    private boolean running;
    private Logger log;
    private DataOutputStream out = null;

    public KeepAliveThread(DataOutputStream out, int k) {
        this.keepAlive = k;
        this.out = out;
        this.log = LoggerFactory.getLogger((String)"BGP4Server");
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                if (this.keepAlive > 0) {
                    KeepAliveThread.sleep(this.keepAlive * 1000);
                    this.sendKeepAlive();
                    continue;
                }
                this.log.debug("Ending KEEPALIVE mechanism");
                return;
            }
            catch (InterruptedException e) {
                if (!this.running) {
                    this.log.debug("Ending KeepAliveThread");
                    return;
                }
                this.log.debug("Reseting Keepalive timer");
            }
        }
    }

    public void stopRunning() {
        this.running = false;
    }

    private void sendKeepAlive() {
        BGP4Keepalive p_ka = new BGP4Keepalive();
        p_ka.encode();
        try {
            this.log.debug("Sending Keepalive message");
            this.out.write(p_ka.getBytes());
            this.out.flush();
        }
        catch (IOException e) {
            this.log.warn("Error sending KEEPALIVE: " + e.getMessage());
        }
    }
}

