/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.bgp4session;

import es.tid.bgp.bgp4.messages.BGP4Keepalive;
import es.tid.bgp.bgp4.messages.BGP4Message;
import es.tid.bgp.bgp4.messages.BGP4Open;
import es.tid.bgp.bgp4.open.BGP4CapabilitiesOptionalParameter;
import es.tid.bgp.bgp4.open.BGP4OctetsASByteCapabilityAdvertisement;
import es.tid.bgp.bgp4.open.MultiprotocolExtensionCapabilityAdvertisement;
import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4Session;
import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionsInformation;
import eu.teraflow.tid.bgp4Peer.bgp4session.ConnectRetryTimer;
import eu.teraflow.tid.bgp4Peer.bgp4session.DeadTimerThread;
import eu.teraflow.tid.bgp4Peer.bgp4session.KeepAliveThread;
import eu.teraflow.tid.bgp4Peer.bgp4session.KeepWaitTimerTask;
import eu.teraflow.tid.bgp4Peer.bgp4session.OpenWaitTimerTask;
import eu.teraflow.tid.bgp4Peer.peer.BGP4Exception;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericBGP4Session
extends Thread
implements BGP4Session {
    protected BGP4SessionsInformation BGP4SessionsInformation;
    protected KeepAliveThread keepAliveT = null;
    protected int keepAliveLocal;
    protected int keepAlivePeer;
    protected DeadTimerThread deadTimerT = null;
    protected int deadTimerPeer;
    protected Socket socket = null;
    protected Inet4Address remotePeerIP = null;
    protected DataOutputStream out = null;
    protected DataInputStream in = null;
    protected Logger log = LoggerFactory.getLogger((String)"BGP4Parser");
    protected Timer timer;
    protected int FSMstate;
    protected Inet4Address remoteDomainId = null;
    private boolean remoteOK = false;
    private boolean localOK = false;
    private int openRetry = 0;
    protected byte[] msg = null;
    public static long sessionIdCounter = 0L;
    protected Boolean updateFrom;
    protected boolean sendTo;
    private long sessionId;
    private int ConnectRetryCounter = 0;
    private ConnectRetryTimer connectRetryTimer = null;
    private int connectRetryTime;
    protected int holdTime;
    protected int keepAliveTimer;
    protected Inet4Address BGPIdentifier;
    protected int myAutonomousSystem;
    protected int version;

    public GenericBGP4Session(BGP4SessionsInformation bgp4SessionsInformation, int holdTime, Inet4Address BGPIdentifier, int version, int myAutonomousSystem, int mykeepAliveTimer) {
        this.BGP4SessionsInformation = bgp4SessionsInformation;
        this.holdTime = holdTime;
        this.BGPIdentifier = BGPIdentifier;
        this.version = version;
        this.myAutonomousSystem = myAutonomousSystem;
        this.keepAliveTimer = mykeepAliveTimer;
        this.newSessionId();
    }

    protected byte[] readBGP4Msg(DataInputStream in) throws IOException {
        byte[] ret = null;
        byte[] hdr = new byte[BGP4Message.getBGPHeaderLength()];
        byte[] temp = null;
        boolean endHdr = false;
        int r = 0;
        int length = 0;
        boolean endMsg = false;
        int offset = 0;
        while (!endMsg) {
            try {
                r = endHdr ? in.read(temp, offset, 1) : in.read(hdr, offset, 1);
            }
            catch (IOException e) {
                this.log.warn("Error reading data: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.log.warn("readMsg Oops: " + e.getMessage());
                throw new IOException();
            }
            if (r > 0) {
                if (offset == BGP4Message.getBGPMarkerLength()) {
                    length = (hdr[offset] & 0xFF) << 8;
                }
                if (offset == BGP4Message.getBGPMarkerLength() + 1) {
                    temp = new byte[length |= hdr[offset] & 0xFF];
                    endHdr = true;
                    System.arraycopy(hdr, 0, temp, 0, BGP4Message.getBGPHeaderLength());
                }
                if (length > 0 && offset == length - 1) {
                    endMsg = true;
                }
                ++offset;
                continue;
            }
            if (r != -1) continue;
            this.log.debug("End of stream has been reached");
            throw new IOException();
        }
        if (length > 0) {
            ret = new byte[length];
            System.arraycopy(temp, 0, ret, 0, length);
        }
        return ret;
    }

    protected byte[] readMsgOptimized(DataInputStream in) throws IOException {
        byte[] ret = null;
        byte[] hdr = new byte[4];
        byte[] temp = null;
        boolean endHdr = false;
        int r = 0;
        int length = 0;
        boolean endMsg = false;
        int offset = 0;
        while (!endMsg) {
            try {
                if (endHdr) {
                    r = in.read(temp, offset, length - offset);
                    if (r > 0) {
                        if (offset + r >= length) {
                            endMsg = true;
                            continue;
                        }
                        offset += r;
                        continue;
                    }
                    if (r >= 0) continue;
                    this.log.error("End of stream has been reached reading data");
                    throw new IOException();
                }
                r = in.read(hdr, offset, 4 - offset);
                if (r < 0) {
                    this.log.error("End of stream has been reached reading header");
                    throw new IOException();
                }
                if (r <= 0) continue;
                if (offset + r >= 4) {
                    length = (hdr[offset + 2] & 0xFF) << 8 | hdr[offset + 3] & 0xFF;
                    offset = 4;
                    temp = new byte[length];
                    endHdr = true;
                    System.arraycopy(hdr, 0, temp, 0, 4);
                    if (length != 4) continue;
                    endMsg = true;
                    continue;
                }
                offset += r;
            }
            catch (IOException e) {
                this.log.error("Error reading data: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.log.error("readMsg Oops: " + e.getMessage());
                this.log.error("Failure reason : " + e.getStackTrace());
                throw new IOException();
            }
        }
        if (length > 0) {
            ret = new byte[length];
            System.arraycopy(temp, 0, ret, 0, length);
        }
        return ret;
    }

    public DataOutputStream getOut() {
        return this.out;
    }

    public void setOut(DataOutputStream out) {
        this.out = out;
    }

    protected void startDeadTimer() {
        this.deadTimerT.start();
    }

    protected void resetDeadTimer() {
        if (this.deadTimerT != null) {
            this.deadTimerT.interrupt();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    protected void cancelDeadTimer() {
        this.log.debug("Cancelling DeadTimer");
        if (this.deadTimerT != null) {
            this.deadTimerT.stopRunning();
            this.deadTimerT.interrupt();
            this.deadTimerT = null;
        }
    }

    public void startKeepAlive() {
        this.keepAliveT.start();
    }

    public void cancelKeepAlive() {
        this.log.debug("Cancelling KeepAliveTimer");
        if (this.keepAliveT != null) {
            this.keepAliveT.stopRunning();
            this.keepAliveT.interrupt();
            this.keepAliveT = null;
        }
    }

    protected void endConnections() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.log.warn("Closing socket");
                this.socket.close();
            }
        }
        catch (Exception e) {
            this.log.warn("Error closing connections: " + e.getMessage());
        }
    }

    public int getFSMstate() {
        return this.FSMstate;
    }

    protected void setFSMstate(int fSMstate) {
        this.FSMstate = fSMstate;
    }

    @Override
    public void killSession() {
        this.log.warn("Killing Session");
        this.timer.cancel();
        this.endConnections();
        this.cancelDeadTimer();
        this.cancelKeepAlive();
        this.endSession();
        this.BGP4SessionsInformation.deleteSession(this.sessionId);
        this.log.warn("Interrupting thread!!!!");
        this.interrupt();
    }

    protected abstract void endSession();

    protected void initializeBGP4Session() throws BGP4Exception {
        this.BGP4SessionsInformation.addSession(this.getSessionId(), this);
        byte[] msg = null;
        try {
            this.out = new DataOutputStream(this.socket.getOutputStream());
            this.in = new DataInputStream(this.socket.getInputStream());
        }
        catch (IOException e) {
            this.log.warn("Problem in the sockets, ending BGP4Session");
            this.killSession();
            return;
        }
        int initialValue = 1000;
        this.connectRetryTimer = new ConnectRetryTimer(initialValue);
        this.setFSMstate(2);
        this.log.debug("Entering BGP4_STATE_OPEN_WAIT, Scheduling Open Wait Timer");
        OpenWaitTimerTask owtt = new OpenWaitTimerTask(this);
        this.timer.schedule((TimerTask)owtt, 60000L);
        KeepWaitTimerTask kwtt = new KeepWaitTimerTask(this);
        BGP4Open open_msg = new BGP4Open();
        open_msg.setMyAutonomousSystem(this.myAutonomousSystem);
        open_msg.setBGPIdentifier(this.BGPIdentifier);
        open_msg.setHoldTime(this.holdTime);
        BGP4CapabilitiesOptionalParameter cop = new BGP4CapabilitiesOptionalParameter();
        open_msg.getParametersList().add(cop);
        MultiprotocolExtensionCapabilityAdvertisement multProtExtCapAdv = new MultiprotocolExtensionCapabilityAdvertisement();
        multProtExtCapAdv.setAFI(16388);
        multProtExtCapAdv.setSAFI(71);
        cop.getCapabilityList().add(multProtExtCapAdv);
        BGP4OctetsASByteCapabilityAdvertisement fouroctects = new BGP4OctetsASByteCapabilityAdvertisement();
        fouroctects.setAS(this.myAutonomousSystem);
        cop.getCapabilityList().add(fouroctects);
        this.sendBGP4Message(open_msg);
        block8: while (this.FSMstate != 4) {
            try {
                msg = this.readBGP4Msg(this.in);
            }
            catch (IOException e) {
                this.log.warn("Error reading message, ending session" + e.getMessage());
                this.killSession();
                return;
            }
            if (msg != null) {
                switch (BGP4Message.getMessageType(msg)) {
                    case 1: {
                        if (this.FSMstate == 2) {
                            this.log.debug("FSMstate = BGP4_STATE_OPEN_WAIT");
                            BGP4Open open_received = new BGP4Open(msg);
                            this.log.debug("**** Open received ****\n" + open_received.toString());
                            owtt.cancel();
                            if (this.openRetry == 1) {
                                boolean checkOK = true;
                                this.version = open_received.getVersion();
                                if (this.version != 4) {
                                    checkOK = false;
                                }
                                if (!checkOK) {
                                    this.log.debug("Dont accept");
                                    break;
                                }
                                this.BGPIdentifier = open_received.getBGPIdentifier();
                                this.myAutonomousSystem = open_received.getMyAutonomousSystem();
                                this.holdTime = open_received.getHoldTime();
                                this.log.debug("OPEN Accepted");
                                this.log.debug("Sending KA to confirm");
                                BGP4Keepalive ka_snd = new BGP4Keepalive();
                                this.log.debug("Sending Keepalive message");
                                this.sendBGP4Message(ka_snd);
                                this.remoteOK = true;
                                if (this.localOK) {
                                    this.log.debug("Entering STATE_SESSION_UP");
                                    this.setFSMstate(4);
                                    break;
                                }
                                this.log.debug("Entering STATE_KEEP_WAIT");
                                this.log.debug("Scheduling KeepwaitTimer");
                                this.timer.schedule((TimerTask)kwtt, 60000L);
                                this.setFSMstate(3);
                                break;
                            }
                            this.log.debug("Open retry is equal to 0");
                            boolean dtOK = true;
                            this.version = open_received.getVersion();
                            if (this.version != 4) {
                                dtOK = false;
                            }
                            if (!dtOK) {
                                this.log.debug("PEER  Open parameters are unaccpetable, but negotiable");
                                if (this.localOK) {
                                    owtt.cancel();
                                    owtt = new OpenWaitTimerTask(this);
                                    this.timer.schedule((TimerTask)owtt, 60000L);
                                    this.setFSMstate(2);
                                    break;
                                }
                                owtt.cancel();
                                this.setFSMstate(3);
                                this.timer.schedule((TimerTask)kwtt, 60000L);
                                break;
                            }
                            this.BGPIdentifier = open_received.getBGPIdentifier();
                            this.myAutonomousSystem = open_received.getMyAutonomousSystem();
                            this.holdTime = open_received.getHoldTime();
                            BGP4Keepalive p_ka = new BGP4Keepalive();
                            this.sendBGP4Message(p_ka);
                            this.remoteOK = true;
                            if (this.localOK) {
                                this.setFSMstate(4);
                                break;
                            }
                            this.timer.schedule((TimerTask)kwtt, 60000L);
                            this.setFSMstate(3);
                            break;
                        }
                        this.log.debug("Ignore OPEN message, already one received!!");
                        break;
                    }
                    case 4: {
                        this.localOK = true;
                        if (this.FSMstate != 3) continue block8;
                        if (this.remoteOK) {
                            kwtt.cancel();
                            this.setFSMstate(4);
                            break;
                        }
                        kwtt.cancel();
                        owtt = new OpenWaitTimerTask(this);
                        this.timer.schedule((TimerTask)owtt, 60000L);
                        this.setFSMstate(2);
                        break;
                    }
                    default: {
                        this.log.error("UNEXPECTED Message Received");
                        if (this.FSMstate != 2) {
                            this.log.debug("Ignore OPEN message, already one received!!");
                            break;
                        }
                        this.log.error("Unexpected message RECEIVED, closing");
                        break;
                    }
                }
                continue;
            }
            if (this.FSMstate != 2) {
                this.log.info("Ignore message, already one received!!");
                continue;
            }
            this.log.error("Unexpected message RECEIVED, closing");
        }
    }

    @Override
    public void sendBGP4Message(BGP4Message message) {
        message.encode();
        try {
            this.out.write(message.getBytes());
            this.out.flush();
        }
        catch (Exception e) {
            this.log.error("Problem writing message, finishing session " + e.getMessage());
            this.killSession();
        }
    }

    public Inet4Address getRemotePeerIP() {
        return this.remotePeerIP;
    }

    public Inet4Address getBGPIdentifier() {
        return this.BGPIdentifier;
    }

    public void setBGPIdentifier(Inet4Address bGPIdentifier) {
        this.BGPIdentifier = bGPIdentifier;
    }

    public Boolean getUpdateFrom() {
        return this.updateFrom;
    }

    public void setUpdateFrom(Boolean updateFrom) {
        this.updateFrom = updateFrom;
    }

    public Boolean getSendTo() {
        return this.sendTo;
    }

    public void setSendTo(boolean sendTo) {
        this.sendTo = sendTo;
    }

    public int getMyAutonomousSystem() {
        return this.myAutonomousSystem;
    }

    public void setMyAutonomousSystem(int myAutonomousSystem) {
        this.myAutonomousSystem = myAutonomousSystem;
    }

    public String shortInfo() {
        StringBuffer sb = new StringBuffer(1000);
        if (this.socket != null) {
            sb.append("remAddr: ");
            sb.append(this.socket.getRemoteSocketAddress());
            sb.append(" state: ");
            if (this.FSMstate == 2) {
                sb.append("OPEN_WAIT");
            } else if (this.FSMstate == 0) {
                sb.append("IDLE");
            } else if (this.FSMstate == 3) {
                sb.append("KEEP_WAIT");
            } else if (this.FSMstate == 4) {
                sb.append("SESSION_UP");
            } else if (this.FSMstate == 4) {
                sb.append("TCP_PENDING");
            } else {
                sb.append("UNKNOWN");
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("\t> Session ID: " + this.sessionId + "\n");
        sb.append("\t> BGP Remote Peer: " + this.remotePeerIP + "\n");
        sb.append("\t> BGPIdentifier: " + this.BGPIdentifier + "\n");
        if (this.socket != null) {
            sb.append("\t> remAddr: ");
            sb.append(this.socket.getRemoteSocketAddress() + "\n");
            sb.append("\t> state: ");
            if (this.FSMstate == 2) {
                sb.append("OPEN_WAIT\n");
            } else if (this.FSMstate == 0) {
                sb.append("IDLE\n");
            } else if (this.FSMstate == 3) {
                sb.append("KEEP_WAIT\n");
            } else if (this.FSMstate == 4) {
                sb.append("SESSION_UP\n");
            } else if (this.FSMstate == 4) {
                sb.append("TCP_PENDING\n");
            } else {
                sb.append("UNKNOWN");
            }
        }
        return sb.toString();
    }

    public synchronized void newSessionId() {
        this.sessionId = sessionIdCounter + 1L;
        ++sessionIdCounter;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public void close() {
    }

    public boolean equals(Object obj) {
        if (this.remotePeerIP != null) {
            if (this.remotePeerIP.equals(((GenericBGP4Session)obj).getBGPIdentifier())) {
                return true;
            }
        } else {
            this.log.info("TODO NUL!! en el equals!");
        }
        return false;
    }

    public Inet4Address getPeerIP() {
        return (Inet4Address)this.socket.getInetAddress();
    }
}

