/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.bgp4session;

import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionExistsException;
import eu.teraflow.tid.bgp4Peer.bgp4session.GenericBGP4Session;
import eu.teraflow.tid.bgp4Peer.peer.BGP4Exception;
import java.io.DataOutputStream;
import java.net.Inet4Address;
import java.util.Enumeration;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BGP4SessionsInformation {
    public Hashtable<Long, GenericBGP4Session> sessionList = new Hashtable();
    public Hashtable<Inet4Address, GenericBGP4Session> sessionListByPeerIP = new Hashtable();
    private boolean isTest = false;
    Logger log = LoggerFactory.getLogger((String)"BGP4Parser");
    DataOutputStream out;

    public BGP4SessionsInformation() {
    }

    public BGP4SessionsInformation(boolean test) {
        this.isTest = test;
    }

    public synchronized void notifySessionStart(Inet4Address addr) throws BGP4SessionExistsException {
        if (this.sessionListByPeerIP.containsKey(addr)) {
            throw new BGP4SessionExistsException();
        }
    }

    public synchronized void addSession(long sessionId, GenericBGP4Session session) throws BGP4Exception {
        Enumeration<GenericBGP4Session> sessions = this.sessionList.elements();
        this.log.debug("Looking to add session with id " + sessionId + " --> " + session.toString());
        GenericBGP4Session existingSession = this.sessionListByPeerIP.get(session.remotePeerIP);
        if (this.isTest) {
            this.sessionList.put(new Long(sessionId), session);
            this.sessionListByPeerIP.put(session.getPeerIP(), session);
            this.log.debug("Registering new session with Peer " + session.getPeerIP() + " with ID " + sessionId);
        } else {
            if (existingSession != null) {
                this.log.debug("Session with id " + existingSession.getSessionId() + " against " + session.remotePeerIP.getHostAddress() + " already exists");
                throw new BGP4Exception();
            }
            this.sessionList.put(new Long(sessionId), session);
            this.sessionListByPeerIP.put(session.getPeerIP(), session);
            this.log.debug("Registering new session with Peer " + session.getPeerIP() + " with ID " + sessionId);
        }
    }

    public synchronized void deleteSession(long sessionId) {
        GenericBGP4Session ses = this.sessionList.get(sessionId);
        if (ses != null) {
            Inet4Address ip = this.sessionList.get(sessionId).getPeerIP();
            this.sessionList.remove(new Long(sessionId));
            this.sessionListByPeerIP.remove(ses.getPeerIP());
            this.log.debug("Deleted Session with id " + sessionId + " with peer " + ses.getPeerIP().getHostAddress());
        } else {
            this.log.info("SESSION WAS NOT REGISTERED NULL");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(2000);
        int counter = 1;
        Enumeration<GenericBGP4Session> sessions = this.sessionList.elements();
        while (sessions.hasMoreElements()) {
            sb.append("Session number " + counter++ + "\n");
            sb.append(String.valueOf(sessions.nextElement().toString()) + "\n");
        }
        return sb.toString();
    }

    public String printSession(long sessionId) {
        GenericBGP4Session ses = this.sessionList.get(new Long(sessionId));
        if (ses != null) {
            return ses.toString();
        }
        return "session " + sessionId + " does not exist";
    }

    public DataOutputStream getOut() {
        return this.out;
    }

    public void setOut(DataOutputStream out) {
        this.out = out;
    }

    public Hashtable<Long, GenericBGP4Session> getSessionList() {
        return this.sessionList;
    }

    public void setSessionList(Hashtable<Long, GenericBGP4Session> sessionList) {
        this.sessionList = sessionList;
    }
}

