/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.bgp4session;

import es.tid.bgp.bgp4.messages.BGP4Message;
import es.tid.bgp.bgp4.messages.BGP4Update;
import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionsInformation;
import eu.teraflow.tid.bgp4Peer.bgp4session.GenericBGP4Session;
import eu.teraflow.tid.bgp4Peer.bgp4session.KeepAliveThread;
import eu.teraflow.tid.bgp4Peer.peer.BGP4Exception;
import eu.teraflow.tid.bgp4Peer.updateTEDB.UpdateDispatcher;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Timer;
import org.slf4j.LoggerFactory;

public class BGP4SessionClient
extends GenericBGP4Session {
    private int peerBGP_port;
    private boolean no_delay = true;
    private String localBGP4Address;
    private int localBGP4Port;
    private UpdateDispatcher updateDispatcher;

    public BGP4SessionClient(BGP4SessionsInformation bgp4SessionsInformation, UpdateDispatcher updateDispatcher, Inet4Address peerBGP_IPaddress, int peerBGP_port, int holdTime, Inet4Address BGPIdentifier, int version, int myAutonomousSystem, String localBGP4Address, int localBGP4Port, int keepAliveTimer) {
        super(bgp4SessionsInformation, holdTime, BGPIdentifier, version, myAutonomousSystem, keepAliveTimer);
        this.timer = new Timer();
        this.log = LoggerFactory.getLogger((String)"BGP4Client");
        this.peerBGP_port = peerBGP_port;
        this.updateDispatcher = updateDispatcher;
        this.localBGP4Address = localBGP4Address;
        this.localBGP4Port = localBGP4Port;
        this.remotePeerIP = peerBGP_IPaddress;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.log.info("Opening new BGP4 Session with host " + this.remotePeerIP.getHostAddress() + " on port " + this.peerBGP_port);
        this.log.debug("Do we want to update from peer?" + this.updateFrom);
        this.log.debug("Do we want to send to peer?" + this.sendTo);
        try {
            addr = (Inet4Address)Inet4Address.getByName(this.localBGP4Address);
            addrPeer = this.remotePeerIP;
            this.socket = new Socket(addrPeer, this.peerBGP_port, (InetAddress)addr, 0);
            if (this.no_delay) {
                this.socket.setTcpNoDelay(true);
                this.log.debug("No delay activated");
            }
        }
        catch (IOException e) {
            this.log.info("Connection refused trying to connect " + this.remotePeerIP.getHostAddress() + " on port " + this.peerBGP_port);
            return;
        }
        try {
            this.initializeBGP4Session();
            this.log.info("BGP4 Session established with peer " + this.remotePeerIP);
            this.keepAliveT = new KeepAliveThread(this.getOut(), this.keepAliveTimer);
            this.keepAliveT.start();
            if (true) ** GOTO lbl79
        }
        catch (BGP4Exception e2) {
            e2.printStackTrace();
            this.log.debug("Session with " + this.remotePeerIP + " already exists: " + e2.getMessage());
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.log.error("Problem closing socket " + e.getMessage());
            }
            return;
        }
        {
            do {
                try {
                    this.msg = this.readBGP4Msg(this.in);
                }
                catch (IOException e) {
                    this.cancelDeadTimer();
                    this.cancelKeepAlive();
                    this.timer.cancel();
                    try {
                        this.in.close();
                        this.out.close();
                    }
                    catch (Exception e1) {
                        this.log.warn("problem closing sockets");
                    }
                    this.log.debug("Finishing BGP4 Session abruptly!");
                    this.log.info("BGP4 session with peer " + this.remotePeerIP + " has been closed");
                    this.cancelDeadTimer();
                    this.cancelKeepAlive();
                    this.FSMstate = 0;
                    this.endSession();
                    return;
                }
                if (this.msg == null) continue;
                bgp4Msg = true;
                switch (BGP4Message.getMessageType(this.msg)) {
                    case 1: {
                        this.log.debug("BGP OPEN message received from " + this.remotePeerIP);
                        this.log.warn("OPEN message ignored");
                        break;
                    }
                    case 4: {
                        this.log.debug("BGP KEEPALIVE message received from " + this.remotePeerIP);
                        break;
                    }
                    case 3: {
                        this.log.debug("BGP NOTIFICATION message received from " + this.remotePeerIP);
                        break;
                    }
                    case 2: {
                        this.log.debug("BGP UPDATE message received from " + this.remotePeerIP);
                        if (this.getUpdateFrom().booleanValue()) {
                            bgp4Update = new BGP4Update(this.msg);
                            this.log.debug(bgp4Update.toString());
                            bgp4Update.setLearntFrom(this.remotePeerIP.getHostAddress());
                            this.updateDispatcher.dispatchRequests(bgp4Update);
                            break;
                        }
                        this.log.debug("Update message from " + this.remotePeerIP + " discarded");
                        break;
                    }
                    default: {
                        this.log.warn("ERROR: unexpected message received");
                        bgp4Msg = false;
                    }
                }
                if (!bgp4Msg) continue;
                this.resetDeadTimer();
lbl79:
                // 4 sources

            } while (this.FSMstate == 4);
        }
    }

    public int getPeerBGP_port() {
        return this.peerBGP_port;
    }

    public void setPeerBGP_port(int peerBGP_port) {
        this.peerBGP_port = peerBGP_port;
    }

    @Override
    public Boolean getUpdateFrom() {
        return this.updateFrom;
    }

    @Override
    public void setUpdateFrom(Boolean updateFrom) {
        this.updateFrom = updateFrom;
    }

    @Override
    public Boolean getSendTo() {
        return this.sendTo;
    }

    public void setSendTo(Boolean sendTo) {
        this.sendTo = sendTo;
    }

    public boolean isNo_delay() {
        return this.no_delay;
    }

    public void setNo_delay(boolean no_delay) {
        this.no_delay = no_delay;
    }

    @Override
    public void close() {
    }

    @Override
    protected void endSession() {
        this.log.debug("Ending session with id " + this.getSessionId());
        this.BGP4SessionsInformation.deleteSession(this.getSessionId());
    }
}

