/*
 * Decompiled with CFR 0.152.
 */
package eu.teraflow.tid.bgp4Peer.bgp4session;

import es.tid.bgp.bgp4.messages.BGP4Message;
import es.tid.bgp.bgp4.messages.BGP4Update;
import eu.teraflow.tid.bgp4Peer.bgp4session.BGP4SessionsInformation;
import eu.teraflow.tid.bgp4Peer.bgp4session.DeadTimerThread;
import eu.teraflow.tid.bgp4Peer.bgp4session.GenericBGP4Session;
import eu.teraflow.tid.bgp4Peer.bgp4session.KeepAliveThread;
import eu.teraflow.tid.bgp4Peer.peer.BGP4Exception;
import eu.teraflow.tid.bgp4Peer.updateTEDB.UpdateDispatcher;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Timer;
import org.slf4j.LoggerFactory;

public class BGP4PeerInitiatedSession
extends GenericBGP4Session {
    private UpdateDispatcher updateDispatcher;

    public BGP4PeerInitiatedSession(Socket s, BGP4SessionsInformation bgp4SessionsInformation, UpdateDispatcher updateDispatcher, int holdTime, Inet4Address BGPIdentifier, int version, int myAutonomousSystem, boolean noDelay, int keepAliveTimer) {
        super(bgp4SessionsInformation, holdTime, BGPIdentifier, version, myAutonomousSystem, keepAliveTimer);
        this.setFSMstate(0);
        this.log = LoggerFactory.getLogger((String)"BGP4Server");
        this.log.debug("New BGP4Session: " + s);
        this.socket = s;
        try {
            s.setTcpNoDelay(noDelay);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        this.newSessionId();
        this.remotePeerIP = (Inet4Address)((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress();
        this.timer = new Timer();
        this.updateDispatcher = updateDispatcher;
    }

    @Override
    public void run() {
        try {
            this.initializeBGP4Session();
        }
        catch (BGP4Exception e2) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        this.log.info("BGP4 Session established with peer " + this.remotePeerIP);
        this.deadTimerT = new DeadTimerThread(this, this.holdTime);
        this.startDeadTimer();
        this.keepAliveT = new KeepAliveThread(this.out, this.keepAliveTimer);
        this.startKeepAlive();
        try {
            while (this.FSMstate == 4) {
                try {
                    this.msg = this.readBGP4Msg(this.in);
                }
                catch (IOException e) {
                    this.cancelDeadTimer();
                    this.cancelKeepAlive();
                    this.timer.cancel();
                    try {
                        this.in.close();
                        this.out.close();
                    }
                    catch (Exception e1) {
                        this.log.warn("Exception Closing BGP4 Session with " + this.remotePeerIP);
                    }
                    this.log.debug("Finishing BGP4 Session with " + this.remotePeerIP);
                    this.log.error("BGP4 session with peer " + this.remotePeerIP + " has been closed");
                    this.cancelDeadTimer();
                    this.cancelKeepAlive();
                    this.FSMstate = 0;
                    this.endSession();
                    return;
                }
                if (this.msg == null) continue;
                boolean bgp4Msg = true;
                switch (BGP4Message.getMessageType(this.msg)) {
                    case 1: {
                        this.log.debug("OPEN message received");
                        this.log.warn("OPEN message ignored");
                        break;
                    }
                    case 4: {
                        this.log.debug("KEEPALIVE message received from " + this.remotePeerIP);
                        break;
                    }
                    case 3: {
                        this.log.info("NOTIFICATION message from " + this.remotePeerIP);
                        break;
                    }
                    case 2: {
                        this.log.debug("UPDATE message from " + this.remotePeerIP);
                        BGP4Update bgp4Update = new BGP4Update(this.msg);
                        this.log.debug(bgp4Update.toString());
                        bgp4Update.setLearntFrom(this.getRemotePeerIP().toString());
                        this.updateDispatcher.dispatchRequests(bgp4Update);
                        break;
                    }
                    default: {
                        this.log.warn("ERROR: unexpected message from " + this.remotePeerIP);
                        bgp4Msg = false;
                    }
                }
                if (!bgp4Msg) continue;
                this.resetDeadTimer();
            }
        }
        finally {
            this.log.error("BGP4 session with peer " + this.remotePeerIP + " has been closed");
            this.cancelDeadTimer();
            this.cancelKeepAlive();
            this.FSMstate = 0;
            this.endSession();
        }
    }

    @Override
    public void close() {
    }

    @Override
    protected void endSession() {
        this.log.debug("Ending session with id " + this.getSessionId() + " from peer " + this.remotePeerIP);
        this.BGP4SessionsInformation.deleteSession(this.getSessionId());
    }
}

