/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects.subtlvs;

import es.tid.rsvp.objects.subobjects.subtlvs.SubTLV;
import es.tid.rsvp.objects.subobjects.subtlvs.SubTransponderTLVFEC;
import es.tid.rsvp.objects.subobjects.subtlvs.SubTransponderTLVFS;
import es.tid.rsvp.objects.subobjects.subtlvs.SubTransponderTLVID;
import es.tid.rsvp.objects.subobjects.subtlvs.SubTransponderTLVModFormat;
import es.tid.rsvp.objects.subobjects.subtlvs.SubTransponderTLVTC;

public class SubTransponderTLV
extends SubTLV {
    private SubTransponderTLVModFormat ST_TLV_ModFormat;
    private SubTransponderTLVFEC ST_TLV_FEC;
    private SubTransponderTLVID ST_TLV_ID;
    private SubTransponderTLVFS ST_TLV_FS;
    private SubTransponderTLVTC ST_TLV_TC;

    public SubTransponderTLV() {
        this.setTLVType(1);
    }

    public SubTransponderTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        if (this.ST_TLV_ModFormat != null) {
            this.ST_TLV_ModFormat.encode();
            len += this.ST_TLV_ModFormat.getTotalTLVLength();
        }
        if (this.ST_TLV_FEC != null) {
            this.ST_TLV_FEC.encode();
            len += this.ST_TLV_FEC.getTotalTLVLength();
        }
        if (this.ST_TLV_ID != null) {
            this.ST_TLV_ID.encode();
            len += this.ST_TLV_ID.getTotalTLVLength();
        }
        if (this.ST_TLV_FS != null) {
            this.ST_TLV_FS.encode();
            len += this.ST_TLV_FS.getTotalTLVLength();
        }
        if (this.ST_TLV_TC != null) {
            this.ST_TLV_TC.encode();
            len += this.ST_TLV_TC.getTotalTLVLength();
        }
        this.setTotalTLVLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int offset = 4;
        if (this.ST_TLV_ModFormat != null) {
            System.arraycopy(this.ST_TLV_ModFormat.getTlv_bytes(), 0, this.tlv_bytes, offset, this.ST_TLV_ModFormat.getTotalTLVLength());
            offset += this.ST_TLV_ModFormat.getTotalTLVLength();
        }
        if (this.ST_TLV_FEC != null) {
            System.arraycopy(this.ST_TLV_FEC.getTlv_bytes(), 0, this.tlv_bytes, offset, this.ST_TLV_FEC.getTotalTLVLength());
            offset += this.ST_TLV_FEC.getTotalTLVLength();
        }
        if (this.ST_TLV_ID != null) {
            System.arraycopy(this.ST_TLV_ID.getTlv_bytes(), 0, this.tlv_bytes, offset, this.ST_TLV_ID.getTotalTLVLength());
            offset += this.ST_TLV_ID.getTotalTLVLength();
        }
        if (this.ST_TLV_FS != null) {
            System.arraycopy(this.ST_TLV_FS.getTlv_bytes(), 0, this.tlv_bytes, offset, this.ST_TLV_FS.getTotalTLVLength());
            offset += this.ST_TLV_FS.getTotalTLVLength();
        }
        if (this.ST_TLV_TC != null) {
            System.arraycopy(this.ST_TLV_TC.getTlv_bytes(), 0, this.tlv_bytes, offset, this.ST_TLV_TC.getTotalTLVLength());
            offset += this.ST_TLV_TC.getTotalTLVLength();
        }
    }

    @Override
    protected void decode() {
        boolean fin = false;
        int offset = 4;
        while (!fin) {
            int subtlvType = SubTLV.getType(this.tlv_bytes, offset);
            int subtlvLength = SubTLV.getTotalTLVLength(this.tlv_bytes, offset);
            switch (subtlvType) {
                case 5001: {
                    log.info("ERO_SUBTLV_SUBTRANSPONDER_MOD_FORMAT found");
                    this.ST_TLV_ModFormat = new SubTransponderTLVModFormat(this.tlv_bytes, offset);
                    break;
                }
                case 5002: {
                    log.info("ERO_SUBTLV_SUBTRANSPONDER_FEC found");
                    this.ST_TLV_FEC = new SubTransponderTLVFEC(this.tlv_bytes, offset);
                    break;
                }
                case 5005: {
                    log.info("ERO_SUBTLV_SUBTRANSPONDER_ID con length " + subtlvLength);
                    this.ST_TLV_ID = new SubTransponderTLVID(this.tlv_bytes, offset);
                    break;
                }
                case 5006: {
                    log.info("ERO_SUBTLV_SUBTRANSPONDER_FS");
                    this.ST_TLV_FS = new SubTransponderTLVFS(this.tlv_bytes, offset);
                    break;
                }
                case 5020: {
                    log.info("ERO_SUBTLV_SUBTRANSPONDER_TC");
                    this.ST_TLV_TC = new SubTransponderTLVTC(this.tlv_bytes, offset);
                    break;
                }
                default: {
                    log.info("TLVVVVV Unknown, " + subtlvType);
                }
            }
            if ((offset += subtlvLength) >= this.getTotalTLVLength()) {
                fin = true;
                continue;
            }
            log.info("sigo leyendo SubTransponderTLV ");
        }
    }

    public SubTransponderTLVModFormat getST_TLV_ModFormat() {
        return this.ST_TLV_ModFormat;
    }

    public void setST_TLV_ModFormat(SubTransponderTLVModFormat sT_TLV_ModFormat) {
        this.ST_TLV_ModFormat = sT_TLV_ModFormat;
    }

    public SubTransponderTLVFEC getST_TLV_FEC() {
        return this.ST_TLV_FEC;
    }

    public void setST_TLV_FEC(SubTransponderTLVFEC sT_TLV_FEC) {
        this.ST_TLV_FEC = sT_TLV_FEC;
    }

    public SubTransponderTLVID getST_TLV_ID() {
        return this.ST_TLV_ID;
    }

    public void setST_TLV_ID(SubTransponderTLVID sT_TLV_ID) {
        this.ST_TLV_ID = sT_TLV_ID;
    }

    public SubTransponderTLVFS getST_TLV_FS() {
        return this.ST_TLV_FS;
    }

    public void setST_TLV_FS(SubTransponderTLVFS sT_TLV_FS) {
        this.ST_TLV_FS = sT_TLV_FS;
    }

    public SubTransponderTLVTC getST_TLV_TC() {
        return this.ST_TLV_TC;
    }

    public void setST_TLV_TC(SubTransponderTLVTC sT_TLV_TC) {
        this.ST_TLV_TC = sT_TLV_TC;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        if (this.ST_TLV_ModFormat != null) {
            sb.append(" > " + this.ST_TLV_ModFormat.toString());
        }
        if (this.ST_TLV_FEC != null) {
            sb.append(" > " + this.ST_TLV_FEC.toString());
        }
        if (this.ST_TLV_ID != null) {
            sb.append(this.ST_TLV_ID.toString());
        }
        if (this.ST_TLV_FS != null) {
            sb.append(this.ST_TLV_FS.toString());
        }
        if (this.ST_TLV_TC != null) {
            sb.append(this.ST_TLV_TC.toString());
        }
        return sb.toString();
    }
}

