/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects.subtlvs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubTLV {
    protected int TLVType;
    protected int TotalTLVLength;
    protected byte[] tlv_bytes;
    protected static final Logger log = LoggerFactory.getLogger((String)"PCEPParser");

    public SubTLV() {
    }

    public SubTLV(byte[] bytes, int offset) {
        this.TLVType = (bytes[offset] & 0xFF) << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        this.TotalTLVLength = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        this.tlv_bytes = new byte[this.TotalTLVLength];
        System.arraycopy(bytes, offset, this.tlv_bytes, 0, this.TotalTLVLength);
    }

    protected void encodeHeader() {
        this.tlv_bytes[0] = (byte)(this.TLVType >>> 8 & 0xFF);
        this.tlv_bytes[1] = (byte)(this.TLVType & 0xFF);
        this.tlv_bytes[2] = (byte)(this.TotalTLVLength >>> 8 & 0xFF);
        this.tlv_bytes[3] = (byte)(this.TotalTLVLength & 0xFF);
    }

    public static int getTotalTLVLength(byte[] bytes, int offset) {
        int len = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        return len;
    }

    public static int getTLVLength(byte[] bytes, int offset) {
        int len = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        return len;
    }

    public static int getType(byte[] bytes, int offset) {
        int typ = (bytes[offset] & 0xFF) << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        return typ;
    }

    public int getTLVType() {
        return this.TLVType;
    }

    protected void setTLVType(int tLVType) {
        this.TLVType = tLVType;
    }

    public byte[] getTlv_bytes() {
        return this.tlv_bytes;
    }

    protected void setTlv_bytes(byte[] tlv_bytes) {
        this.tlv_bytes = tlv_bytes;
    }

    public abstract void encode();

    protected abstract void decode();

    public int getTotalTLVLength() {
        return this.TotalTLVLength;
    }

    public void setTotalTLVLength(int totalTLVLength) {
        this.TotalTLVLength = totalTLVLength;
    }
}

