/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.rsvp.objects.subobjects.EROSubobject;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class UnnumberIfIDEROSubobject
extends EROSubobject {
    public Inet4Address routerID;
    public long interfaceID;

    public UnnumberIfIDEROSubobject() {
        this.setType(4);
    }

    public UnnumberIfIDEROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.erosolength = 12;
        this.subobject_bytes = new byte[this.erosolength];
        this.encodeSoHeader();
        this.subobject_bytes[2] = 0;
        this.subobject_bytes[3] = 0;
        System.arraycopy(this.routerID.getAddress(), 0, this.subobject_bytes, 4, 4);
        this.subobject_bytes[8] = (byte)(this.interfaceID >>> 24);
        this.subobject_bytes[9] = (byte)(this.interfaceID >>> 16 & 0xFFL);
        this.subobject_bytes[10] = (byte)(this.interfaceID >>> 8 & 0xFFL);
        this.subobject_bytes[11] = (byte)(this.interfaceID & 0xFFL);
    }

    @Override
    public void decode() {
        this.decodeSoHeader();
        byte[] ipadd = new byte[4];
        System.arraycopy(this.subobject_bytes, 4, ipadd, 0, 4);
        try {
            this.routerID = (Inet4Address)Inet4Address.getByAddress(ipadd);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.interfaceID = 0L;
        int k = 0;
        while (k < 4) {
            this.interfaceID = this.interfaceID << 8 | (long)(this.subobject_bytes[k + 8] & 0xFF);
            ++k;
        }
    }

    public Inet4Address getRouterID() {
        return this.routerID;
    }

    public void setRouterID(Inet4Address routerID) {
        this.routerID = routerID;
    }

    public long getInterfaceID() {
        return this.interfaceID;
    }

    public void setInterfaceID(long interfaceID) {
        this.interfaceID = interfaceID;
    }

    public String toString() {
        return this.routerID.toString() + ":" + this.interfaceID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.interfaceID ^ this.interfaceID >>> 32);
        result = 31 * result + (this.routerID == null ? 0 : this.routerID.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnnumberIfIDEROSubobject other = (UnnumberIfIDEROSubobject)obj;
        if (this.interfaceID != other.interfaceID) {
            return false;
        }
        return !(this.routerID == null ? other.routerID != null : !this.routerID.equals(other.routerID));
    }
}

