/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.objects.subobjects.EROSubobject;

public class SwitchIDEROSubobject
extends EROSubobject {
    private byte[] SwitchID;
    private int source_int;
    private int dest_int;
    private byte[] associated_mac = null;
    private byte[] second_associated_mac = null;
    private Integer vlan;

    public SwitchIDEROSubobject() {
        this.erosolength = 38;
        this.setType(55);
    }

    public SwitchIDEROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.subobject_bytes = new byte[this.erosolength];
        this.encodeSoHeader();
        System.arraycopy(this.SwitchID, 0, this.subobject_bytes, 2, this.SwitchID.length > 8 ? 8 : this.SwitchID.length);
        int offset = 12;
        ByteHandler.IntToBuffer(0, offset * 8, 32, this.source_int, this.subobject_bytes);
        ByteHandler.IntToBuffer(0, (offset += 4) * 8, 32, this.dest_int, this.subobject_bytes);
        offset += 4;
        if (this.associated_mac != null) {
            System.arraycopy(this.associated_mac, 0, this.subobject_bytes, offset, 6);
        }
        offset += 6;
        if (this.second_associated_mac != null) {
            System.arraycopy(this.second_associated_mac, 0, this.subobject_bytes, offset, 6);
        }
        offset += 6;
        if (this.vlan != null) {
            ByteHandler.IntToBuffer(0, offset * 8, 32, this.vlan, this.subobject_bytes);
        } else {
            ByteHandler.IntToBuffer(0, offset * 8, 32, 0, this.subobject_bytes);
        }
    }

    @Override
    public void decode() {
        this.decodeSoHeader();
        this.SwitchID = new byte[8];
        System.arraycopy(this.subobject_bytes, 2, this.SwitchID, 0, 8);
        this.source_int = ByteHandler.easyCopy(0, 31, this.subobject_bytes[12], this.subobject_bytes[13], this.subobject_bytes[14], this.subobject_bytes[15]);
        this.dest_int = ByteHandler.easyCopy(0, 31, this.subobject_bytes[16], this.subobject_bytes[17], this.subobject_bytes[18], this.subobject_bytes[19]);
        int offset = 20;
        this.associated_mac = new byte[6];
        System.arraycopy(this.subobject_bytes, offset, this.associated_mac, 0, 6);
        this.second_associated_mac = new byte[6];
        System.arraycopy(this.subobject_bytes, offset += 6, this.second_associated_mac, 0, 6);
        this.vlan = ByteHandler.easyCopy(0, 31, this.subobject_bytes[offset += 6], this.subobject_bytes[offset + 1], this.subobject_bytes[offset + 2], this.subobject_bytes[offset + 3]);
    }

    public byte[] getSwitchID() {
        return this.SwitchID;
    }

    public void setSwitchID(byte[] mAC) {
        this.SwitchID = mAC;
    }

    public int getSource_int() {
        return this.source_int;
    }

    public void setSource_int(int source_int) {
        this.source_int = source_int;
    }

    public int getDest_int() {
        return this.dest_int;
    }

    public void setDest_int(int dest_int) {
        this.dest_int = dest_int;
    }

    public byte[] getAssociated_mac() {
        return this.associated_mac;
    }

    public void setAssociated_mac(byte[] associated_mac) {
        this.associated_mac = associated_mac;
    }

    public Integer getVlan() {
        return this.vlan;
    }

    public void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    public byte[] getSecond_associated_mac() {
        return this.second_associated_mac;
    }

    public void setSecond_associated_mac(byte[] second_associated_mac) {
        this.second_associated_mac = second_associated_mac;
    }
}

